/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.ui.Toolkit;
import processing.core.PApplet;
import processing.core.PConstants;

public class Preferences {
    static final String DEFAULTS_FILE = "defaults.txt";
    static final String PREFS_FILE = "preferences.txt";
    static Map<String, String> defaults;
    static Map<String, String> table;
    static File preferencesFile;
    private static boolean initialized;

    public static void init() {
        boolean firstRun;
        initialized = true;
        try {
            Preferences.load(Base.getLibStream(DEFAULTS_FILE));
        }
        catch (Exception e) {
            Messages.showError(null, "Could not read default settings.\nYou'll need to reinstall Processing.", e);
        }
        defaults = new HashMap<String, String>(table);
        Preferences.setColor("run.window.bgcolor", SystemColor.control);
        if (Language.useInputMethod()) {
            Preferences.setBoolean("editor.input_method_support", true);
        }
        boolean bl = firstRun = !(preferencesFile = Base.getSettingsFile(PREFS_FILE)).exists();
        if (!firstRun) {
            try {
                Preferences.load(new FileInputStream(preferencesFile));
            }
            catch (Exception ex) {
                Messages.showError("Error reading preferences", "Error reading the preferences file. Please delete (or move)\n" + preferencesFile.getAbsolutePath() + " and restart Processing.", ex);
            }
        }
        if (Preferences.checkSketchbookPref() || firstRun) {
            Preferences.save();
        }
        PApplet.useNativeSelect = Preferences.getBoolean("chooser.files.native");
        if (Preferences.get("proxy.system").equals("true")) {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        Preferences.handleProxy("http", "http.proxyHost", "http.proxyPort");
        Preferences.handleProxy("https", "https.proxyHost", "https.proxyPort");
        Preferences.handleProxy("socks", "socksProxyHost", "socksProxyPort");
    }

    public static void skipInit() {
        initialized = true;
    }

    static void handleProxy(String protocol, String hostProp, String portProp) {
        String proxyHost = Preferences.get("proxy." + protocol + ".host");
        String proxyPort = Preferences.get("proxy." + protocol + ".port");
        if (proxyHost != null && proxyHost.length() != 0 && proxyPort != null && proxyPort.length() != 0) {
            System.setProperty(hostProp, proxyHost);
            System.setProperty(portProp, proxyPort);
        }
    }

    public static String getPreferencesPath() {
        return preferencesFile.getAbsolutePath();
    }

    public static void load(InputStream input) throws IOException {
        HashMap<String, String> platformSpecific = new HashMap<String, String>();
        String[] lines = PApplet.loadStrings((InputStream)input);
        for (String line : lines) {
            String value;
            String key;
            int equals;
            if (line.length() == 0 || line.charAt(0) == '#' || (equals = line.indexOf(61)) == -1 || Preferences.isPlatformSpecific(key = line.substring(0, equals).trim(), value = line.substring(equals + 1).trim(), platformSpecific)) continue;
            table.put(key, value);
        }
        for (String key : platformSpecific.keySet()) {
            table.put(key, (String)platformSpecific.get(key));
        }
    }

    protected static boolean isPlatformSpecific(String key, String value, Map<String, String> specific) {
        for (String platform : PConstants.platformNames) {
            String ext = "." + platform;
            if (!key.endsWith(ext)) continue;
            String thisPlatform = PConstants.platformNames[PApplet.platform];
            if (platform.equals(thisPlatform)) {
                key = key.substring(0, key.lastIndexOf(ext));
                specific.put(key, value);
            }
            return true;
        }
        return false;
    }

    public static void save() {
        if (preferencesFile != null) {
            try {
                File dir = preferencesFile.getParentFile();
                File preferencesTemp = File.createTempFile("preferences", ".txt", dir);
                if (!preferencesTemp.setWritable(true, false)) {
                    throw new IOException("Could not set " + String.valueOf(preferencesTemp) + " writable");
                }
                PrintWriter writer = PApplet.createWriter((File)preferencesTemp);
                String[] keyList = table.keySet().toArray(new String[0]);
                for (String key : keyList = PApplet.sort((String[])keyList)) {
                    writer.println(key + "=" + table.get(key));
                }
                writer.flush();
                writer.close();
                File oldPreferences = new File(dir, "preferences.old");
                if (oldPreferences.exists() && !oldPreferences.delete()) {
                    throw new IOException("Could not delete preferences.old");
                }
                if (preferencesFile.exists() && !preferencesFile.renameTo(oldPreferences)) {
                    throw new IOException("Could not replace preferences.old");
                }
                if (!preferencesTemp.renameTo(preferencesFile)) {
                    throw new IOException("Could not move preferences file into place");
                }
            }
            catch (IOException e) {
                Messages.showWarning("Preferences", "Could not save the Preferences file.", e);
            }
        }
    }

    public static String get(String attribute) {
        if (!initialized) {
            throw new RuntimeException("Tried reading preferences prior to initialization.");
        }
        return table.get(attribute);
    }

    public static String getDefault(String attribute) {
        return defaults.get(attribute);
    }

    public static void set(String attribute, String value) {
        table.put(attribute, value);
    }

    public static void unset(String attribute) {
        table.remove(attribute);
    }

    public static boolean getBoolean(String attribute) {
        String value = Preferences.get(attribute);
        return Boolean.parseBoolean(value);
    }

    public static void setBoolean(String attribute, boolean value) {
        Preferences.set(attribute, value ? "true" : "false");
    }

    public static int getInteger(String attribute) {
        return Integer.parseInt(Preferences.get(attribute));
    }

    public static void setInteger(String key, int value) {
        Preferences.set(key, String.valueOf(value));
    }

    public static Color getColor(String name) {
        Color parsed = Color.GRAY;
        String s = Preferences.get(name);
        if (s != null && s.indexOf("#") == 0) {
            try {
                parsed = new Color(Integer.parseInt(s.substring(1), 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parsed;
    }

    public static void setColor(String attr, Color what) {
        Preferences.set(attr, "#" + PApplet.hex((int)(what.getRGB() & 0xFFFFFF), (int)6));
    }

    public static Font getFont(String familyAttr, String sizeAttr, int style) {
        int fontSize = Preferences.getInteger(sizeAttr);
        String fontFamily = Preferences.get(familyAttr);
        if ("processing.mono".equals(fontFamily) || Toolkit.getMonoFontName().equals(fontFamily)) {
            return Toolkit.getMonoFont(fontSize, style);
        }
        return new Font(fontFamily, style, fontSize);
    }

    protected static boolean checkSketchbookPref() {
        String threePath;
        if (Preferences.getSketchbookPath() == null && (threePath = Preferences.get("sketchbook.path.three")) != null) {
            Preferences.setSketchbookPath(threePath);
            return true;
        }
        return false;
    }

    public static String getOldSketchbookPath() {
        return Preferences.get("sketchbook.path.three");
    }

    public static String getSketchbookPath() {
        return Preferences.get("sketchbook.path.four");
    }

    protected static void setSketchbookPath(String path) {
        Preferences.set("sketchbook.path.four", path);
    }

    static {
        table = new HashMap<String, String>();
        initialized = false;
    }
}

