/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.sun.jna.platform.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.Util;
import processing.app.platform.DefaultPlatform;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.data.StringDict;

public class Platform {
    static DefaultPlatform inst;
    static Map<String, Integer> platformIndices;
    static int nativeBits;
    static StringDict supportedVariants;
    protected static File processingRoot;

    public static boolean isAvailable() {
        return inst != null;
    }

    public static void init() {
        try {
            String packageName = DefaultPlatform.class.getPackageName();
            Class<?> platformClass = Class.forName(packageName + ".DefaultPlatform");
            if (Platform.isMacOS()) {
                platformClass = Class.forName(packageName + ".MacPlatform");
            } else if (Platform.isWindows()) {
                platformClass = Class.forName(packageName + ".WindowsPlatform");
            } else if (Platform.isLinux()) {
                platformClass = Class.forName(packageName + ".LinuxPlatform");
            }
            inst = (DefaultPlatform)platformClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Messages.showError("Problem Setting the Platform", "An unknown error occurred while trying to load\nplatform-specific code for your machine.", e);
        }
        System.setProperty("java.home", Platform.getJavaHome().getAbsolutePath());
    }

    public static void initBase(Base base) throws Exception {
        inst.initBase(base);
    }

    public static void setLookAndFeel() throws Exception {
        inst.setLookAndFeel();
    }

    public static void setInterfaceZoom() throws Exception {
        inst.setInterfaceZoom();
    }

    public static float getSystemZoom() {
        return inst == null ? 1.0f : inst.getSystemZoom();
    }

    public static File getSettingsFolder() throws Exception {
        return inst.getSettingsFolder();
    }

    public static File getDefaultSketchbookFolder() throws Exception {
        return inst.getDefaultSketchbookFolder();
    }

    public static void saveLanguage(String languageCode) {
        inst.saveLanguage(languageCode);
    }

    public static void openURL(String url) {
        try {
            inst.openURL(url);
        }
        catch (Exception e) {
            Messages.showWarning("Problem Opening URL", "Could not open the URL\n" + url, e);
        }
    }

    public static boolean openFolderAvailable() {
        return inst.openFolderAvailable();
    }

    public static void openFolder(File file) {
        try {
            inst.openFolder(file);
        }
        catch (Exception e) {
            Messages.showWarning("Problem Opening Folder", "Could not open the folder\n" + file.getAbsolutePath(), e);
        }
    }

    public static String getNativeArch() {
        return System.getProperty("os.arch");
    }

    public static String getVariant() {
        return Platform.getName() + "-" + Platform.getNativeArch();
    }

    public static StringDict getSupportedVariants() {
        return supportedVariants;
    }

    public static String getName() {
        return PConstants.platformNames[PApplet.platform];
    }

    public static String getPrettyName() {
        return supportedVariants.get(Platform.getVariant());
    }

    public static int getIndex(String platformName) {
        int index = platformName.indexOf(45);
        if (index != -1) {
            platformName = platformName.substring(0, index);
        }
        return platformIndices.getOrDefault(platformName, -1);
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").contains("Mac");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").contains("Linux");
    }

    @Deprecated
    public static File getContentFile(String name) {
        if (processingRoot == null) {
            String decodedPath;
            File directory;
            String resourcesDir = System.getProperty("compose.application.resources.dir");
            if (resourcesDir != null && (directory = new File(resourcesDir)).exists()) {
                return new File(directory, name);
            }
            URL pathURL = Base.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                decodedPath = pathURL.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                Messages.showError("Missing File", "Could not access a required file:\n<b>" + name + "</b>\nYou may need to reinstall Processing.", e);
                return null;
            }
            if (decodedPath.contains("/app/bin")) {
                File build = new File(decodedPath, "../../build").getAbsoluteFile();
                if (Platform.isMacOS()) {
                    processingRoot = new File(build, "macos/work/Processing.app/Contents/Java");
                } else if (Platform.isWindows()) {
                    processingRoot = new File(build, "windows/work");
                } else if (Platform.isLinux()) {
                    processingRoot = new File(build, "linux/work");
                }
            } else {
                File jarFolder = new File(decodedPath).getParentFile();
                if (jarFolder.getName().equals("lib")) {
                    processingRoot = jarFolder.getParentFile();
                } else if (Platform.isMacOS()) {
                    processingRoot = jarFolder;
                }
                if (processingRoot == null || !processingRoot.exists()) {
                    System.err.println("Could not find lib folder via " + jarFolder.getAbsolutePath() + ", switching to user.dir");
                    processingRoot = new File("");
                }
            }
        }
        return new File(processingRoot, name);
    }

    public static File getJavaHome() {
        File jdkFolder;
        String resourcesDir = System.getProperty("compose.application.resources.dir");
        if (resourcesDir != null && (jdkFolder = new File(resourcesDir, "jdk")).exists()) {
            return jdkFolder;
        }
        String home2 = System.getProperty("java.home");
        if (home2 != null) {
            return new File(home2);
        }
        if (Platform.isMacOS()) {
            File[] plugins = Platform.getContentFile("../PlugIns").listFiles((dir, name) -> dir.isDirectory() && name.contains("jdk") && !name.startsWith("."));
            return new File(plugins[0], "Contents/Home");
        }
        return Platform.getContentFile("java");
    }

    public static String getJavaPath() {
        String javaPath = "bin/java" + (Platform.isWindows() ? ".exe" : "");
        File javaFile = new File(Platform.getJavaHome(), javaPath);
        try {
            return javaFile.getCanonicalPath();
        }
        catch (IOException e) {
            return javaFile.getAbsolutePath();
        }
    }

    protected static File getProcessingApp() {
        File appFile = Platform.isMacOS() ? Platform.getContentFile("../..") : (Platform.isWindows() ? Platform.getContentFile("processing.exe") : Platform.getContentFile("processing"));
        try {
            return appFile.getCanonicalFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void restartJavaApplication() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Platform.getJavaPath());
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : vmArguments) {
            if (arg.contains("-agentlib")) continue;
            cmd.add(arg);
        }
        cmd.add("-cp");
        cmd.add(System.getProperty("java.class.path"));
        String javaCommand = System.getProperty("sun.java.command");
        String[] splitCommand = PApplet.split((String)javaCommand, (char)' ');
        cmd.add(splitCommand[0]);
        ProcessBuilder builder = new ProcessBuilder(cmd);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                builder.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        System.exit(0);
    }

    public static boolean deleteFile(File file) throws IOException {
        try {
            FileUtils fu = FileUtils.getInstance();
            if (fu.hasTrash()) {
                fu.moveToTrash(new File[]{file});
                return true;
            }
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
        }
        if (file.isDirectory()) {
            Util.removeDir(file);
            return true;
        }
        return file.delete();
    }

    public static void setenv(String variable, String value) {
        Preferences.set(variable, value);
    }

    public static String getenv(String variable) {
        return Preferences.get(variable);
    }

    public static int unsetenv(String variable) {
        throw new RuntimeException("unsetenv() not yet implemented");
    }

    static {
        platformIndices = new HashMap<String, Integer>();
        platformIndices.put("windows", 1);
        platformIndices.put("macos", 2);
        platformIndices.put("linux", 3);
        nativeBits = 32;
        String bits = System.getProperty("sun.arch.data.model");
        if (bits != null) {
            if (bits.equals("64")) {
                nativeBits = 64;
            }
        } else if (System.getProperty("java.vm.name").contains("64")) {
            nativeBits = 64;
        }
        supportedVariants = new StringDict((String[][])new String[][]{{"macos-x86_64", "macOS (Intel 64-bit)"}, {"macos-aarch64", "macOS (Apple Silicon)"}, {"windows-amd64", "Windows (Intel 64-bit)"}, {"linux-amd64", "Linux (Intel 64-bit)"}, {"linux-arm", "Linux (Raspberry Pi 32-bit)"}, {"linux-aarch64", "Linux (Raspberry Pi 64-bit)"}});
    }
}

