/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import processing.app.Base;
import processing.app.MessagesKt;
import processing.app.Platform;
import processing.app.ui.Toolkit;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lprocessing/app/Messages;", "", "<init>", "()V", "Companion", "app"})
@StabilityInferred(parameters=1)
public final class Messages {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @JvmStatic
    public static final void showMessage(@NotNull String title, @NotNull String message) {
        Companion.showMessage(title, message);
    }

    @JvmStatic
    @JvmOverloads
    public static final void showWarning(@NotNull String title, @NotNull String message, @Nullable Throwable e) {
        Companion.showWarning(title, message, e);
    }

    @JvmStatic
    public static final void showWarningTiered(@NotNull String title, @NotNull String primary, @NotNull String secondary, @Nullable Throwable e) {
        Companion.showWarningTiered(title, primary, secondary, e);
    }

    @JvmStatic
    public static final void showError(@NotNull String title, @NotNull String message, @Nullable Throwable e) {
        Companion.showError(title, message, e);
    }

    @JvmStatic
    public static final void showTrace(@Nullable String title, @NotNull String message, @Nullable Throwable t, boolean fatal) {
        Companion.showTrace(title, message, t, fatal);
    }

    @JvmStatic
    public static final int showYesNoQuestion(@Nullable Frame editor, @Nullable String title, @Nullable String primary, @Nullable String secondary) {
        return Companion.showYesNoQuestion(editor, title, primary, secondary);
    }

    @JvmStatic
    public static final int showCustomQuestion(@Nullable Frame editor, @Nullable String title, @Nullable String primary, @Nullable String secondary, int highlight, String ... options) {
        return Companion.showCustomQuestion(editor, title, primary, secondary, highlight, options);
    }

    @JvmStatic
    @Deprecated(message="Use log() instead")
    public static final void log(@NotNull Object from, @NotNull String message) {
        Companion.log(from, message);
    }

    @JvmStatic
    public static final void log(@Nullable String message) {
        Companion.log(message);
    }

    @JvmStatic
    public static final void logf(@Nullable String message, Object ... args) {
        Companion.logf(message, args);
    }

    @JvmStatic
    @JvmOverloads
    public static final void err(@Nullable String message, @Nullable Throwable e) {
        Companion.err(message, e);
    }

    @JvmStatic
    @JvmOverloads
    public static final void showWarning(@NotNull String title, @NotNull String message) {
        Companion.showWarning(title, message);
    }

    @JvmStatic
    @JvmOverloads
    public static final void showWarning(@NotNull String message) {
        Companion.showWarning(message);
    }

    @JvmStatic
    @JvmOverloads
    public static final void err(@Nullable String message) {
        Companion.err(message);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J&\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J*\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J$\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J,\u0010\u0010\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J0\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0007JQ\u0010\u0018\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00152\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001b\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0012\u0010\u001d\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007J/\u0010\u001f\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001b\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u00a8\u0006#"}, d2={"Lprocessing/app/Messages$Companion;", "", "<init>", "()V", "showMessage", "", "title", "", "message", "showWarning", "e", "", "showWarningTiered", "primary", "secondary", "showError", "showTrace", "t", "fatal", "", "showYesNoQuestion", "", "editor", "Ljava/awt/Frame;", "showCustomQuestion", "highlight", "options", "", "(Ljava/awt/Frame;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I[Ljava/lang/String;)I", "log", "from", "logf", "args", "(Ljava/lang/String;[Ljava/lang/Object;)V", "err", "app"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void showMessage(@NotNull String title, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (Base.isCommandLine()) {
                System.out.println((Object)(title + ": " + message));
            } else {
                JOptionPane.showMessageDialog(new Frame(), message, title, 1);
            }
        }

        public static /* synthetic */ void showMessage$default(Companion companion, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = "Message";
            }
            companion.showMessage(string2, string3);
        }

        @JvmStatic
        @JvmOverloads
        public final void showWarning(@NotNull String title, @NotNull String message, @Nullable Throwable e) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (Base.isCommandLine()) {
                    System.out.println((Object)(title + ": " + message));
                } else {
                    JOptionPane.showMessageDialog(new Frame(), message, title, 2);
                }
                Throwable throwable = e;
                if (throwable == null) break block2;
                throwable.printStackTrace();
            }
        }

        public static /* synthetic */ void showWarning$default(Companion companion, String string2, String string3, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = "Warning";
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            companion.showWarning(string2, string3, throwable);
        }

        @JvmStatic
        public final void showWarningTiered(@NotNull String title, @NotNull String primary, @NotNull String secondary, @Nullable Throwable e) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
                Intrinsics.checkNotNullParameter((Object)secondary, (String)"secondary");
                if (Base.isCommandLine()) {
                    System.out.println((Object)(title + ": " + primary + "\n" + secondary));
                } else {
                    EventQueue.invokeLater(() -> Companion.showWarningTiered$lambda$0(primary, secondary, title));
                }
                Throwable throwable = e;
                if (throwable == null) break block2;
                throwable.printStackTrace();
            }
        }

        @JvmStatic
        public final void showError(@NotNull String title, @NotNull String message, @Nullable Throwable e) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (Base.isCommandLine()) {
                System.err.println(title + ": " + message);
            } else {
                JOptionPane.showMessageDialog(new Frame(), message, title, 0);
            }
            Throwable throwable = e;
            if (throwable != null) {
                throwable.printStackTrace();
            }
            System.exit(1);
        }

        public static /* synthetic */ void showError$default(Companion companion, String string2, String string3, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = "Error";
            }
            companion.showError(string2, string3, throwable);
        }

        @JvmStatic
        public final void showTrace(@Nullable String title, @NotNull String message, @Nullable Throwable t, boolean fatal) {
            String title2;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            String string2 = title;
            if (string2 == null) {
                string2 = title2 = fatal ? "Error" : "Warning";
            }
            if (Base.isCommandLine()) {
                System.err.println(title2 + ": " + message);
                Throwable throwable = t;
                if (throwable != null) {
                    throwable.printStackTrace();
                }
            } else {
                StringWriter sw = new StringWriter();
                Throwable throwable = t;
                Intrinsics.checkNotNull((Object)throwable);
                throwable.printStackTrace(new PrintWriter(sw));
                JOptionPane.showMessageDialog(new Frame(), Toolkit.formatMessage(message + "<br/><tt><br/>" + sw + "</tt>"), title2, fatal ? 0 : 2);
                if (fatal) {
                    System.exit(1);
                }
            }
        }

        @JvmStatic
        public final int showYesNoQuestion(@Nullable Frame editor, @Nullable String title, @Nullable String primary, @Nullable String secondary) {
            if (!Platform.isMacOS()) {
                return JOptionPane.showConfirmDialog(editor, Toolkit.formatMessage(primary, secondary), title, 0, 3);
            }
            String[] stringArray = new String[]{"Yes", "No"};
            int result = this.showCustomQuestion(editor, title, primary, secondary, 0, stringArray);
            return switch (result) {
                case 0 -> 0;
                case 1 -> 1;
                default -> -1;
            };
        }

        @JvmStatic
        public final int showCustomQuestion(@Nullable Frame editor, @Nullable String title, @Nullable String primary, @Nullable String secondary, int highlight, String ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Object result = null;
            if (!Platform.isMacOS()) {
                return JOptionPane.showOptionDialog(editor, Toolkit.formatMessage(primary, secondary), title, -1, 3, null, options, options[highlight]);
            }
            JOptionPane pane = new JOptionPane(Toolkit.formatMessage(primary, secondary), 3);
            pane.setOptions(options);
            pane.setInitialValue(options[highlight]);
            JDialog dialog = pane.createDialog(editor, null);
            dialog.setVisible(true);
            result = pane.getValue();
            int n = options.length;
            for (int i = 0; i < n; ++i) {
                if (result == null || !Intrinsics.areEqual((Object)result, (Object)options[i])) continue;
                return i;
            }
            return -1;
        }

        @JvmStatic
        @Deprecated(message="Use log() instead")
        public final void log(@NotNull Object from, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (Base.DEBUG) {
                String string2 = new Throwable().getStackTrace()[2].getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
                String callingClass = MessagesKt.formatClassName(string2);
                System.out.println((Object)(callingClass + ": " + message));
            }
        }

        @JvmStatic
        public final void log(@Nullable String message) {
            if (Base.DEBUG) {
                String string2 = new Throwable().getStackTrace()[2].getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
                String callingClass = MessagesKt.formatClassName(string2);
                System.out.println((Object)(callingClass + message));
            }
        }

        @JvmStatic
        public final void logf(@Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (Base.DEBUG) {
                String string2 = new Throwable().getStackTrace()[2].getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
                String callingClass = MessagesKt.formatClassName(string2);
                System.out.printf(callingClass + message, Arrays.copyOf(args, args.length));
            }
        }

        @JvmStatic
        @JvmOverloads
        public final void err(@Nullable String message, @Nullable Throwable e) {
            block2: {
                if (!Base.DEBUG) break block2;
                if (message != null) {
                    String string2 = new Throwable().getStackTrace()[4].getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
                    String callingClass = MessagesKt.formatClassName(string2);
                    System.err.println(callingClass + message);
                }
                Throwable throwable = e;
                if (throwable != null) {
                    throwable.printStackTrace();
                }
            }
        }

        public static /* synthetic */ void err$default(Companion companion, String string2, Throwable throwable, int n, Object object) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            companion.err(string2, throwable);
        }

        @JvmStatic
        @JvmOverloads
        public final void showWarning(@NotNull String title, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            processing.app.Messages$Companion.showWarning$default(this, title, message, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void showWarning(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            processing.app.Messages$Companion.showWarning$default(this, null, message, null, 5, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void err(@Nullable String message) {
            processing.app.Messages$Companion.err$default(this, message, null, 2, null);
        }

        private static final void showWarningTiered$lambda$0(String $primary, String $secondary, String $title) {
            JOptionPane.showMessageDialog(new JFrame(), Toolkit.formatMessage($primary, $secondary), $title, 2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

