/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LdDefaults {
    private static final List<String> GUI_OBJECTS = Arrays.asList("w32api/crt2.o", "head/guihead.o", "head/head.o");
    private static final List<String> CONSOLE_OBJECTS = Arrays.asList("w32api/crt2.o", "head/consolehead.o", "head/head.o");
    private static final List<String> JNI_GUI_32_OBJECTS = Arrays.asList("w32api_jni/crt2.o", "head_jni_BETA/jniguihead.o", "head_jni_BETA/head.o", "head_jni_BETA/jnihead.o");
    private static final List<String> JNI_CONSOLE_32_OBJECTS = Arrays.asList("w32api_jni/crt2.o", "head_jni_BETA/jniconsolehead.o", "head_jni_BETA/head.o", "head_jni_BETA/jnihead.o");
    private static final List<List<String>> HEADER_OBJECTS;
    private static final List<String> LIBS;

    public static List<String> getHeaderObjects(int headerTypeIndex) {
        if (headerTypeIndex < 0 || headerTypeIndex > 3) {
            throw new IllegalArgumentException("headerTypeIndex is out of range: " + headerTypeIndex);
        }
        return HEADER_OBJECTS.get(headerTypeIndex);
    }

    public static List<String> getLibs(String headerType) {
        if ("gui".equals(headerType) || "console".equals(headerType)) {
            return LIBS;
        }
        if ("jniGui32".equals(headerType) || "jniConsole32".equals(headerType)) {
            return LIBS;
        }
        throw new IllegalArgumentException("Unknown headerType: " + headerType);
    }

    static {
        LIBS = Arrays.asList("w32api/libmingw32.a", "w32api/libmingwex.a", "w32api/libgcc.a", "w32api/libmsvcrt.a", "w32api/libmoldname.a", "w32api/libkernel32.a", "w32api/libuser32.a", "w32api/libadvapi32.a", "w32api/libshell32.a");
        HEADER_OBJECTS = new ArrayList<List<String>>();
        HEADER_OBJECTS.add(GUI_OBJECTS);
        HEADER_OBJECTS.add(CONSOLE_OBJECTS);
        HEADER_OBJECTS.add(JNI_GUI_32_OBJECTS);
        HEADER_OBJECTS.add(JNI_CONSOLE_32_OBJECTS);
    }
}

