/*
 * Decompiled with CFR 0.152.
 */
package processing.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import processing.io.NativeInterface;

public class SPI {
    public static final int MODE0 = 0;
    public static final int MODE1 = 1;
    public static final int MODE2 = 2;
    public static final int MODE3 = 3;
    public static final int MSBFIRST = 0;
    public static final int LSBFIRST = 1;
    protected int dataOrder = 0;
    protected String dev;
    protected int handle;
    protected int maxSpeed = 500000;
    protected int mode = 0;
    protected static Map<String, String> settings = new HashMap<String, String>();

    public SPI(String string) {
        NativeInterface.loadLibrary();
        this.dev = string;
        if (NativeInterface.isSimulated()) {
            return;
        }
        this.handle = NativeInterface.openDevice("/dev/" + string);
        if (this.handle < 0) {
            throw new RuntimeException(NativeInterface.getError(this.handle));
        }
    }

    public void close() {
        if (NativeInterface.isSimulated()) {
            return;
        }
        NativeInterface.closeDevice(this.handle);
        this.handle = 0;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static String[] list() {
        if (NativeInterface.isSimulated()) {
            return new String[]{"spidev0.0", "spidev0.1"};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File("/dev");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().startsWith("spidev")) continue;
                arrayList.add(file2.getName());
            }
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void settings(int n, int n2, int n3) {
        this.maxSpeed = n;
        this.dataOrder = n2;
        this.mode = n3;
    }

    public byte[] transfer(byte[] byArray) {
        byte[] byArray2;
        int n;
        if (NativeInterface.isSimulated()) {
            return new byte[byArray.length];
        }
        String string = this.maxSpeed + "-" + this.dataOrder + "-" + this.mode;
        if (!string.equals(settings.get(this.dev))) {
            int n2 = NativeInterface.setSpiSettings(this.handle, this.maxSpeed, this.dataOrder, this.mode);
            if (n2 < 0) {
                System.err.println(NativeInterface.getError(this.handle));
                throw new RuntimeException("Error updating device configuration");
            }
            settings.put(this.dev, string);
        }
        if ((n = NativeInterface.transferSpi(this.handle, byArray, byArray2 = new byte[byArray.length])) < 0) {
            throw new RuntimeException(NativeInterface.getError(n));
        }
        if (n < byArray.length) {
            throw new RuntimeException("Fewer bytes transferred than requested: " + n);
        }
        return byArray2;
    }

    public byte[] transfer(String string) {
        return this.transfer(string.getBytes());
    }

    public byte[] transfer(int n) {
        if (n < -128 || 255 < n) {
            System.err.println("The transfer function can only operate on a single byte at a time. Call it with a value from 0 to 255, or -128 to 127.");
            throw new RuntimeException("Argument does not fit into a single byte");
        }
        byte[] byArray = new byte[]{(byte)n};
        return this.transfer(byArray);
    }

    public byte[] transfer(byte by) {
        return this.transfer(by & 0xFF);
    }
}

