/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import com.google.classpath.ClassPathFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Sketch;
import processing.app.Util;
import processing.mode.java.JavaMode;
import processing.mode.java.PreprocSketch;
import processing.mode.java.preproc.ImportStatement;
import processing.utils.SketchException;

public class RuntimePathBuilder {
    protected static final String[] STANDARD_MODULES = new String[]{"java.base.jmod", "java.compiler.jmod", "java.datatransfer.jmod", "java.desktop.jmod", "java.instrument.jmod", "java.logging.jmod", "java.management.jmod", "java.management.rmi.jmod", "java.naming.jmod", "java.net.http.jmod", "java.prefs.jmod", "java.rmi.jmod", "java.scripting.jmod", "java.se.jmod", "java.security.jgss.jmod", "java.security.sasl.jmod", "java.smartcardio.jmod", "java.sql.jmod", "java.sql.rowset.jmod", "java.transaction.xa.jmod", "java.xml.crypto.jmod", "java.xml.jmod", "jdk.accessibility.jmod", "jdk.aot.jmod", "jdk.attach.jmod", "jdk.charsets.jmod", "jdk.compiler.jmod", "jdk.crypto.cryptoki.jmod", "jdk.crypto.ec.jmod", "jdk.dynalink.jmod", "jdk.editpad.jmod", "jdk.hotspot.agent.jmod", "jdk.httpserver.jmod", "jdk.internal.ed.jmod", "jdk.internal.jvmstat.jmod", "jdk.internal.le.jmod", "jdk.internal.opt.jmod", "jdk.internal.vm.ci.jmod", "jdk.internal.vm.compiler.jmod", "jdk.internal.vm.compiler.management.jmod", "jdk.jartool.jmod", "jdk.javadoc.jmod", "jdk.jcmd.jmod", "jdk.jconsole.jmod", "jdk.jdeps.jmod", "jdk.jdi.jmod", "jdk.jdwp.agent.jmod", "jdk.jfr.jmod", "jdk.jlink.jmod", "jdk.jshell.jmod", "jdk.jsobject.jmod", "jdk.jstatd.jmod", "jdk.localedata.jmod", "jdk.management.agent.jmod", "jdk.management.jfr.jmod", "jdk.management.jmod", "jdk.naming.dns.jmod", "jdk.naming.rmi.jmod", "jdk.net.jmod", "jdk.pack.jmod", "jdk.rmic.jmod", "jdk.scripting.nashorn.jmod", "jdk.scripting.nashorn.shell.jmod", "jdk.sctp.jmod", "jdk.security.auth.jmod", "jdk.security.jgss.jmod", "jdk.unsupported.desktop.jmod", "jdk.unsupported.jmod", "jdk.xml.dom.jmod", "jdk.zipfs.jmod"};
    protected static final String[] JAVA_FX_JARS = new String[]{"javafx-swt.jar", "javafx.base.jar", "javafx.controls.jar", "javafx.fxml.jar", "javafx.graphics.jar", "javafx.media.jar", "javafx.swing.jar", "javafx.web.jar"};
    private final List<CachedRuntimePathFactory> libraryDependentCaches;
    private final List<CachedRuntimePathFactory> libraryImportsDependentCaches;
    private final List<CachedRuntimePathFactory> codeFolderDependentCaches;
    private final List<CachedRuntimePathFactory> sketchClassPathStrategies;
    private final List<CachedRuntimePathFactory> searchClassPathStrategies;
    private final ClassPathFactory classPathFactory = new ClassPathFactory();

    public RuntimePathBuilder() {
        CachedRuntimePathFactory javaRuntimePathFactory = new CachedRuntimePathFactory(this::buildJavaRuntimePath);
        CachedRuntimePathFactory javaFxRuntimePathFactory = new CachedRuntimePathFactory(this::buildJavaFxRuntimePath);
        CachedRuntimePathFactory modeSketchPathFactory = new CachedRuntimePathFactory(this::buildModeSketchPath);
        CachedRuntimePathFactory modeSearchPathFactory = new CachedRuntimePathFactory(this::buildModeSearchPath);
        CachedRuntimePathFactory librarySketchPathFactory = new CachedRuntimePathFactory(this::buildLibrarySketchPath);
        CachedRuntimePathFactory librarySearchPathFactory = new CachedRuntimePathFactory(this::buildLibrarySearchPath);
        CachedRuntimePathFactory coreLibraryPathFactory = new CachedRuntimePathFactory(this::buildCoreLibraryPath);
        CachedRuntimePathFactory codeFolderPathFactory = new CachedRuntimePathFactory(this::buildCodeFolderPath);
        this.sketchClassPathStrategies = new ArrayList<CachedRuntimePathFactory>();
        this.searchClassPathStrategies = new ArrayList<CachedRuntimePathFactory>();
        this.libraryDependentCaches = new ArrayList<CachedRuntimePathFactory>();
        this.libraryImportsDependentCaches = new ArrayList<CachedRuntimePathFactory>();
        this.codeFolderDependentCaches = new ArrayList<CachedRuntimePathFactory>();
        this.sketchClassPathStrategies.add(javaRuntimePathFactory);
        this.sketchClassPathStrategies.add(javaFxRuntimePathFactory);
        this.sketchClassPathStrategies.add(modeSketchPathFactory);
        this.sketchClassPathStrategies.add(librarySketchPathFactory);
        this.sketchClassPathStrategies.add(coreLibraryPathFactory);
        this.sketchClassPathStrategies.add(codeFolderPathFactory);
        this.searchClassPathStrategies.add(javaRuntimePathFactory);
        this.searchClassPathStrategies.add(javaFxRuntimePathFactory);
        this.searchClassPathStrategies.add(modeSearchPathFactory);
        this.searchClassPathStrategies.add(librarySearchPathFactory);
        this.searchClassPathStrategies.add(coreLibraryPathFactory);
        this.searchClassPathStrategies.add(codeFolderPathFactory);
        this.libraryDependentCaches.add(coreLibraryPathFactory);
        this.libraryImportsDependentCaches.add(librarySketchPathFactory);
        this.libraryImportsDependentCaches.add(librarySearchPathFactory);
        this.codeFolderDependentCaches.add(codeFolderPathFactory);
    }

    public void markLibrariesChanged() {
        RuntimePathBuilder.invalidateAll(this.libraryDependentCaches);
    }

    public void markLibraryImportsChanged() {
        RuntimePathBuilder.invalidateAll(this.libraryImportsDependentCaches);
    }

    public void markCodeFolderChanged() {
        RuntimePathBuilder.invalidateAll(this.codeFolderDependentCaches);
    }

    public void prepareClassPath(PreprocSketch.Builder result, JavaMode mode) {
        List<ImportStatement> programImports = result.programImports;
        Sketch sketch = result.sketch;
        this.prepareSketchClassPath(result, mode, programImports, sketch);
        this.prepareSearchClassPath(result, mode, programImports, sketch);
    }

    private static void invalidateAll(List<CachedRuntimePathFactory> caches) {
        for (CachedRuntimePathFactory cache : caches) {
            cache.invalidateCache();
        }
    }

    private void prepareSketchClassPath(PreprocSketch.Builder result, JavaMode mode, List<ImportStatement> programImports, Sketch sketch) {
        Stream sketchClassPath = this.sketchClassPathStrategies.stream().flatMap(x -> x.buildClasspath(mode, programImports, sketch).stream());
        String[] classPathArray = (String[])sketchClassPath.toArray(String[]::new);
        URL[] urlArray = (URL[])Arrays.stream(classPathArray).map(path -> {
            try {
                return Paths.get(path, new String[0]).toUri().toURL();
            }
            catch (MalformedURLException e) {
                Messages.err((String)"malformed URL when preparing sketch classloader", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
        result.classLoader = new URLClassLoader(urlArray, null);
        result.classPath = this.classPathFactory.createFromPaths(classPathArray);
        result.classPathArray = classPathArray;
    }

    private void prepareSearchClassPath(PreprocSketch.Builder result, JavaMode mode, List<ImportStatement> programImports, Sketch sketch) {
        Stream searchClassPath = this.searchClassPathStrategies.stream().flatMap(x -> x.buildClasspath(mode, programImports, sketch).stream());
        result.searchClassPathArray = (String[])searchClassPath.toArray(String[]::new);
    }

    protected List<String> buildJavaRuntimePath(JavaMode mode, List<ImportStatement> imports, Sketch sketch) {
        return Arrays.stream(STANDARD_MODULES).map(this::buildForModule).collect(Collectors.toList());
    }

    protected List<String> buildJavaFxRuntimePath(JavaMode mode, List<ImportStatement> imports, Sketch sketch) {
        return Arrays.stream(JAVA_FX_JARS).map(this::findFullyQualifiedJarName).collect(Collectors.toList());
    }

    protected List<String> buildCodeFolderPath(JavaMode mode, List<ImportStatement> imports, Sketch sketch) {
        StringBuilder classPath = new StringBuilder();
        if (sketch.hasCodeFolder()) {
            File codeFolder = sketch.getCodeFolder();
            String codeFolderClassPath = Util.contentsToClassPath((File)codeFolder);
            classPath.append(codeFolderClassPath);
        }
        return this.sanitizeClassPath(classPath.toString());
    }

    protected List<String> buildCoreLibraryPath(JavaMode mode, List<ImportStatement> imports, Sketch sketch) {
        StringBuilder classPath = new StringBuilder();
        for (Library lib : mode.coreLibraries) {
            classPath.append(File.pathSeparator).append(lib.getClassPath());
        }
        return this.sanitizeClassPath(classPath.toString());
    }

    protected List<String> buildLibrarySketchPath(JavaMode mode, List<ImportStatement> imports, Sketch sketch) {
        StringJoiner classPathBuilder = new StringJoiner(File.pathSeparator);
        imports.stream().map(ImportStatement::getPackageName).filter(pkg -> !this.isIgnorableForSketchPath((String)pkg)).map(pkg -> {
            try {
                return mode.getLibrary((String)pkg);
            }
            catch (SketchException e) {
                return null;
            }
        }).filter(Objects::nonNull).map(Library::getClassPath).forEach(classPathBuilder::add);
        return this.sanitizeClassPath(classPathBuilder.toString());
    }

    protected List<String> buildLibrarySearchPath(JavaMode mode, List<ImportStatement> imports, Sketch sketch) {
        StringJoiner classPathBuilder = new StringJoiner(File.pathSeparator);
        for (Library lib : mode.contribLibraries) {
            classPathBuilder.add(lib.getClassPath());
        }
        return this.sanitizeClassPath(classPathBuilder.toString());
    }

    protected List<String> buildModeSearchPath(JavaMode mode, List<ImportStatement> imports, Sketch sketch) {
        String searchClassPath = mode.getSearchPath();
        if (searchClassPath != null) {
            return this.sanitizeClassPath(searchClassPath);
        }
        return new ArrayList<String>();
    }

    protected List<String> buildModeSketchPath(JavaMode mode, List<ImportStatement> imports, Sketch sketch) {
        String coreClassPath;
        Library coreLibrary = mode.getCoreLibrary();
        String string = coreClassPath = coreLibrary != null ? coreLibrary.getClassPath() : mode.getSearchPath();
        if (coreClassPath != null) {
            return this.sanitizeClassPath(coreClassPath);
        }
        return new ArrayList<String>();
    }

    protected List<String> sanitizeClassPath(String classPathString) {
        return Arrays.stream(classPathString.split(File.pathSeparator)).filter(p -> p != null && !p.trim().isEmpty()).distinct().collect(Collectors.toList());
    }

    protected boolean isIgnorableForSketchPath(String packageName) {
        return packageName.startsWith("java.") || packageName.startsWith("javax.");
    }

    protected String findFullyQualifiedJarName(String jarName) {
        StringJoiner joiner = new StringJoiner(File.separator);
        joiner.add(Platform.getJavaHome().getAbsolutePath());
        joiner.add("lib");
        joiner.add(jarName);
        return joiner.toString();
    }

    protected String buildForModule(String moduleName) {
        StringJoiner jmodPathJoiner = new StringJoiner(File.separator);
        jmodPathJoiner.add(Platform.getJavaHome().getAbsolutePath());
        jmodPathJoiner.add("jmods");
        jmodPathJoiner.add(moduleName);
        return jmodPathJoiner.toString();
    }

    protected static class CachedRuntimePathFactory
    implements RuntimePathFactoryStrategy {
        private final AtomicReference<List<String>> cachedResult = new AtomicReference<Object>(null);
        private final RuntimePathFactoryStrategy innerStrategy;

        public CachedRuntimePathFactory(RuntimePathFactoryStrategy newInnerStrategy) {
            this.innerStrategy = newInnerStrategy;
        }

        public void invalidateCache() {
            this.cachedResult.set(null);
        }

        @Override
        public List<String> buildClasspath(JavaMode mode, List<ImportStatement> imports, Sketch sketch) {
            return this.cachedResult.updateAndGet(cachedValue -> cachedValue == null ? this.innerStrategy.buildClasspath(mode, imports, sketch) : cachedValue);
        }
    }

    protected static interface RuntimePathFactoryStrategy {
        public List<String> buildClasspath(JavaMode var1, List<ImportStatement> var2, Sketch var3);
    }
}

