/*
 * Decompiled with CFR 0.152.
 */
package processing.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import processing.core.PApplet;

public class Client
implements Runnable {
    protected static final int MAX_BUFFER_SIZE = 0x8000000;
    PApplet parent;
    Method clientEventMethod;
    Method disconnectEventMethod;
    volatile Thread thread;
    Socket socket;
    int port;
    String host;
    public InputStream input;
    public OutputStream output;
    final Object bufferLock = new Object[0];
    byte[] buffer = new byte[32768];
    int bufferIndex;
    int bufferLast;
    boolean disposeRegistered = false;

    public Client(PApplet pApplet, String string, int n) {
        this.parent = pApplet;
        this.host = string;
        this.port = n;
        try {
            this.socket = new Socket(this.host, this.port);
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
            this.thread = new Thread(this);
            this.thread.start();
            pApplet.registerMethod("dispose", (Object)this);
            this.disposeRegistered = true;
            try {
                this.clientEventMethod = pApplet.getClass().getMethod("clientEvent", Client.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.disconnectEventMethod = pApplet.getClass().getMethod("disconnectEvent", Client.class);
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.dispose();
        }
    }

    public Client(PApplet pApplet, Socket socket) throws IOException {
        this.parent = pApplet;
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.thread = new Thread(this);
        this.thread.start();
        try {
            this.clientEventMethod = pApplet.getClass().getMethod("clientEvent", Client.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.disconnectEventMethod = pApplet.getClass().getMethod("disconnectEvent", Client.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.disconnectEventMethod != null && this.thread != null) {
            try {
                this.disconnectEventMethod.invoke((Object)this.parent, this);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (exception instanceof InvocationTargetException && exception.getCause() != null) {
                    throwable = exception.getCause();
                }
                throwable.printStackTrace();
                this.disconnectEventMethod = null;
            }
        }
        if (this.disposeRegistered) {
            this.parent.unregisterMethod("dispose", (Object)this);
            this.disposeRegistered = false;
        }
        this.dispose();
    }

    public void dispose() {
        this.thread = null;
        try {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.output != null) {
                this.output.close();
                this.output = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 65536;
        try {
            n = this.socket.getReceiveBufferSize();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        byte[] byArray = new byte[n];
        block11: while (Thread.currentThread() == this.thread) {
            block12: while (true) {
                try {
                    while (this.input != null) {
                        int n2;
                        try {
                            n2 = this.input.read(byArray, 0, byArray.length);
                        }
                        catch (SocketException socketException) {
                            System.err.println("Client SocketException: " + socketException.getMessage());
                            this.stop();
                            return;
                        }
                        if (n2 == -1) {
                            System.err.println("Client got end-of-stream.");
                            this.stop();
                            return;
                        }
                        Object object = this.bufferLock;
                        synchronized (object) {
                            int n3 = this.buffer.length - this.bufferLast;
                            if (n2 > n3) {
                                int n4 = this.bufferLast - this.bufferIndex;
                                byte[] byArray2 = this.buffer;
                                if (n4 + n2 > this.buffer.length) {
                                    int n5 = Integer.highestOneBit(n4 + n2 - 1) << 1;
                                    if (n5 > 0x8000000) {
                                        System.err.println("Client: can't receive more data, buffer is full. Make sure you read the data from the client.");
                                        this.stop();
                                        return;
                                    }
                                    byArray2 = new byte[n5];
                                }
                                System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n4);
                                this.bufferLast -= this.bufferIndex;
                                this.bufferIndex = 0;
                                this.buffer = byArray2;
                            }
                            System.arraycopy(byArray, 0, this.buffer, this.bufferLast, n2);
                            this.bufferLast += n2;
                        }
                        if (this.clientEventMethod == null) continue;
                        try {
                            this.clientEventMethod.invoke((Object)this.parent, this);
                            continue block12;
                        }
                        catch (Exception exception) {
                            System.err.println("error, disabling clientEvent() for " + this.host);
                            Throwable throwable = exception;
                            if (exception instanceof InvocationTargetException && exception.getCause() != null) {
                                throwable = exception.getCause();
                            }
                            throwable.printStackTrace();
                            this.clientEventMethod = null;
                        }
                    }
                    continue block11;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue block11;
                }
            }
        }
    }

    public boolean active() {
        return this.thread != null;
    }

    public String ip() {
        if (this.socket != null) {
            return this.socket.getInetAddress().getHostAddress();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        Object object = this.bufferLock;
        synchronized (object) {
            return this.bufferLast - this.bufferIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.bufferLock;
        synchronized (object) {
            this.bufferLast = 0;
            this.bufferIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.bufferIndex == this.bufferLast) {
                return -1;
            }
            int n = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char readChar() {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.bufferIndex == this.bufferLast) {
                return '\uffff';
            }
            return (char)this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.bufferIndex == this.bufferLast) {
                return null;
            }
            int n = this.bufferLast - this.bufferIndex;
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int n) {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.bufferIndex == this.bufferLast) {
                return null;
            }
            int n2 = this.bufferLast - this.bufferIndex;
            if (n2 > n) {
                n2 = n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] byArray) {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.bufferIndex == this.bufferLast) {
                return 0;
            }
            int n = this.bufferLast - this.bufferIndex;
            if (n > byArray.length) {
                n = byArray.length;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n);
            this.bufferIndex += n;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int n) {
        byte by = (byte)n;
        Object object = this.bufferLock;
        synchronized (object) {
            int n2;
            if (this.bufferIndex == this.bufferLast) {
                return null;
            }
            int n3 = -1;
            for (n2 = this.bufferIndex; n2 < this.bufferLast; ++n2) {
                if (this.buffer[n2] != by) continue;
                n3 = n2;
                break;
            }
            if (n3 == -1) {
                return null;
            }
            n2 = n3 - this.bufferIndex + 1;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int n, byte[] byArray) {
        byte by = (byte)n;
        Object object = this.bufferLock;
        synchronized (object) {
            int n2;
            if (this.bufferIndex == this.bufferLast) {
                return 0;
            }
            int n3 = -1;
            for (n2 = this.bufferIndex; n2 < this.bufferLast; ++n2) {
                if (this.buffer[n2] != by) continue;
                n3 = n2;
                break;
            }
            if (n3 == -1) {
                return 0;
            }
            n2 = n3 - this.bufferIndex + 1;
            if (n2 > byArray.length) {
                System.err.println("readBytesUntil() byte buffer is too small for the " + n2 + " bytes up to and including char " + n);
                return -1;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            return n2;
        }
    }

    public String readString() {
        byte[] byArray = this.readBytes();
        if (byArray == null) {
            return null;
        }
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public String readStringUntil(int n) {
        byte[] byArray = this.readBytesUntil(n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public void write(int n) {
        try {
            this.output.write(n & 0xFF);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop();
        }
    }

    public void write(byte[] byArray) {
        try {
            this.output.write(byArray);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop();
        }
    }

    public void write(String string) {
        this.write(string.getBytes(StandardCharsets.UTF_8));
    }
}

