/*
 * Decompiled with CFR 0.152.
 */
package processing.svg;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Objects;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.w3c.dom.Element;
import processing.awt.PShapeJava2D;

public class GradientExtensionHandler
extends DefaultExtensionHandler {
    public SVGPaintDescriptor handlePaint(Paint paint, SVGGeneratorContext sVGGeneratorContext) {
        if (paint instanceof PShapeJava2D.LinearGradientPaint) {
            return this.getLgpDescriptor((PShapeJava2D.LinearGradientPaint)paint, sVGGeneratorContext);
        }
        if (paint instanceof PShapeJava2D.RadialGradientPaint) {
            return this.getRgpDescriptor((PShapeJava2D.RadialGradientPaint)paint, sVGGeneratorContext);
        }
        return super.handlePaint(paint, sVGGeneratorContext);
    }

    private SVGPaintDescriptor getLgpDescriptor(PShapeJava2D.LinearGradientPaint linearGradientPaint, SVGGeneratorContext sVGGeneratorContext) {
        Element element = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "linearGradient");
        String string = sVGGeneratorContext.getIDGenerator().generateID("gradient");
        element.setAttribute("id", string);
        Point2D point2D = linearGradientPaint.getStartPoint();
        element.setAttribute("x1", String.valueOf(point2D.getX()));
        element.setAttribute("y1", String.valueOf(point2D.getY()));
        Point2D point2D2 = linearGradientPaint.getEndPoint();
        element.setAttribute("x2", String.valueOf(point2D2.getX()));
        element.setAttribute("y2", String.valueOf(point2D2.getY()));
        this.addLgpAttributes(element, sVGGeneratorContext, linearGradientPaint);
        return new SVGPaintDescriptor("url(#" + string + ")", "1", element);
    }

    private SVGPaintDescriptor getRgpDescriptor(PShapeJava2D.RadialGradientPaint radialGradientPaint, SVGGeneratorContext sVGGeneratorContext) {
        Element element = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "radialGradient");
        String string = sVGGeneratorContext.getIDGenerator().generateID("gradient");
        element.setAttribute("id", string);
        Point2D point2D = radialGradientPaint.getCenterPoint();
        element.setAttribute("cx", String.valueOf(point2D.getX()));
        element.setAttribute("cy", String.valueOf(point2D.getY()));
        Point2D point2D2 = radialGradientPaint.getFocusPoint();
        element.setAttribute("fx", String.valueOf(point2D2.getX()));
        element.setAttribute("fy", String.valueOf(point2D2.getY()));
        element.setAttribute("r", String.valueOf(radialGradientPaint.getRadius()));
        this.addRgpAttributes(element, sVGGeneratorContext, radialGradientPaint);
        return new SVGPaintDescriptor("url(#" + string + ")", "1", element);
    }

    private void addLgpAttributes(Element element, SVGGeneratorContext sVGGeneratorContext, PShapeJava2D.LinearGradientPaint linearGradientPaint) {
        Object object;
        element.setAttribute("gradientUnits", "userSpaceOnUse");
        switch (linearGradientPaint.getCycleMethod()) {
            case REFLECT: {
                element.setAttribute("spreadMethod", "reflect");
                break;
            }
            case REPEAT: {
                element.setAttribute("spreadMethod", "repeat");
                break;
            }
            default: {
                element.setAttribute("spreadMethod", "pad");
            }
        }
        switch (linearGradientPaint.getColorSpace()) {
            case LINEAR_RGB: {
                element.setAttribute("color-interpolation", "linearRGB");
                break;
            }
            default: {
                element.setAttribute("color-interpolation", "sRGB");
            }
        }
        AffineTransform affineTransform = linearGradientPaint.getTransform();
        if (!Objects.isNull(affineTransform) && !affineTransform.isIdentity()) {
            object = "matrix(" + affineTransform.getScaleX() + " " + affineTransform.getShearX() + " " + affineTransform.getTranslateX() + " " + affineTransform.getScaleY() + " " + affineTransform.getShearY() + " " + affineTransform.getTranslateY() + ")";
            element.setAttribute("transform", (String)object);
        }
        object = linearGradientPaint.getColors();
        float[] fArray = linearGradientPaint.getFractions();
        for (int i = 0; i < ((Color[])object).length; ++i) {
            Element element2 = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "stop");
            SVGPaintDescriptor sVGPaintDescriptor = SVGColor.toSVG((Color)object[i], (SVGGeneratorContext)sVGGeneratorContext);
            element2.setAttribute("offset", (int)(fArray[i] * 100.0f) + "%");
            element2.setAttribute("stop-color", sVGPaintDescriptor.getPaintValue());
            if (object[i].getAlpha() != 255) {
                element2.setAttribute("stop-opacity", sVGPaintDescriptor.getOpacityValue());
            }
            element.appendChild(element2);
        }
    }

    private void addRgpAttributes(Element element, SVGGeneratorContext sVGGeneratorContext, PShapeJava2D.RadialGradientPaint radialGradientPaint) {
        Object object;
        element.setAttribute("gradientUnits", "userSpaceOnUse");
        switch (radialGradientPaint.getCycleMethod()) {
            case REFLECT: {
                element.setAttribute("spreadMethod", "reflect");
                break;
            }
            case REPEAT: {
                element.setAttribute("spreadMethod", "repeat");
                break;
            }
            default: {
                element.setAttribute("spreadMethod", "pad");
            }
        }
        switch (radialGradientPaint.getColorSpace()) {
            case LINEAR_RGB: {
                element.setAttribute("color-interpolation", "linearRGB");
                break;
            }
            default: {
                element.setAttribute("color-interpolation", "sRGB");
            }
        }
        AffineTransform affineTransform = radialGradientPaint.getTransform();
        if (!Objects.isNull(affineTransform) && !affineTransform.isIdentity()) {
            object = "matrix(" + affineTransform.getScaleX() + " " + affineTransform.getShearX() + " " + affineTransform.getTranslateX() + " " + affineTransform.getScaleY() + " " + affineTransform.getShearY() + " " + affineTransform.getTranslateY() + ")";
            element.setAttribute("transform", (String)object);
        }
        object = radialGradientPaint.getColors();
        float[] fArray = radialGradientPaint.getFractions();
        for (int i = 0; i < ((Color[])object).length; ++i) {
            Element element2 = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "stop");
            SVGPaintDescriptor sVGPaintDescriptor = SVGColor.toSVG((Color)object[i], (SVGGeneratorContext)sVGGeneratorContext);
            element2.setAttribute("offset", (int)(fArray[i] * 100.0f) + "%");
            element2.setAttribute("stop-color", sVGPaintDescriptor.getPaintValue());
            if (object[i].getAlpha() != 255) {
                element2.setAttribute("stop-opacity", sVGPaintDescriptor.getOpacityValue());
            }
            element.appendChild(element2);
        }
    }
}

