/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Util;
import processing.awt.PGraphicsJava2D;
import processing.awt.PShapeJava2D;
import processing.core.PApplet;
import processing.core.PShape;
import processing.data.StringDict;
import processing.data.StringList;
import processing.data.XML;

public class Toolkit {
    static final java.awt.Toolkit awtToolkit = java.awt.Toolkit.getDefaultToolkit();
    static final int SHORTCUT_KEY_MASK = awtToolkit.getMenuShortcutKeyMaskEx();
    static final int SHORTCUT_ALT_KEY_MASK = 8 | SHORTCUT_KEY_MASK;
    static final int SHORTCUT_SHIFT_KEY_MASK = 1 | SHORTCUT_KEY_MASK;
    public static final KeyStroke WINDOW_CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(87, SHORTCUT_KEY_MASK);
    static final String BAD_KEYSTROKE = "'%s' is not understood, please re-read the Java reference for KeyStroke";
    static List<Image> iconImages;
    static float zoom;
    static final StringList zoomOptions;
    static BasicStroke zoomStroke;
    static Boolean retinaProp;
    static Font monoFont;
    static Font monoBoldFont;
    static Font sansFont;
    static Font sansBoldFont;

    public static int getButtonWidth() {
        return Toolkit.zoom(Integer.parseInt(Language.text("preferences.button.width")));
    }

    public static KeyStroke getKeyStrokeExt(String base) {
        KeyStroke ks;
        String key = base + ".keystroke";
        String sequence = Preferences.get(key);
        if (sequence != null) {
            ks = KeyStroke.getKeyStroke(sequence);
            if (ks != null) {
                return ks;
            }
            System.err.format(BAD_KEYSTROKE, sequence);
        }
        if ((ks = KeyStroke.getKeyStroke(sequence = Language.text(key + "." + Platform.getName()))) == null) {
            System.err.format(BAD_KEYSTROKE, sequence);
        }
        return ks;
    }

    public static JMenuItem newJMenuItemExt(String base) {
        JMenuItem menuItem = new JMenuItem(Language.text(base));
        KeyStroke ks = Toolkit.getKeyStrokeExt(base);
        if (ks != null) {
            menuItem.setAccelerator(ks);
        }
        return menuItem;
    }

    public static JMenuItem newJMenuItem(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_KEY_MASK));
        return menuItem;
    }

    public static JMenuItem newJMenuItem(Action action, int what) {
        JMenuItem menuItem = new JMenuItem(action);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(what, SHORTCUT_KEY_MASK));
        return menuItem;
    }

    public static JMenuItem newJMenuItemShift(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_SHIFT_KEY_MASK));
        return menuItem;
    }

    public static JMenuItem newJMenuItemShift(Action action, int what) {
        JMenuItem menuItem = new JMenuItem(action);
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(what, SHORTCUT_SHIFT_KEY_MASK));
        return menuItem;
    }

    public static JMenuItem newJMenuItemAlt(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_ALT_KEY_MASK));
        return menuItem;
    }

    public static JCheckBoxMenuItem newJCheckBoxMenuItem(String title, int what) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_KEY_MASK));
        return menuItem;
    }

    public static void addDisabledItem(JMenu menu, String title) {
        JMenuItem item = new JMenuItem(title);
        item.setEnabled(false);
        menu.add(item);
    }

    public static void applyAction(Action action, JButton button) {
        button.setAction(action);
        String name = String.valueOf(action.hashCode());
        button.getActionMap().put(name, action);
        button.getInputMap(2).put((KeyStroke)action.getValue("AcceleratorKey"), name);
    }

    /*
     * WARNING - void declaration
     */
    public static void setMenuMnemonics(JMenuItem ... menu) {
        if (Platform.isMacOS()) {
            return;
        }
        if (menu.length == 0) {
            return;
        }
        String[] kdePreDefStrs = new String[]{"&file", "&new", "&open", "open&recent", "&save", "save&as", "saveacop&y", "saveas&template", "savea&ll", "reloa&d", "&print", "printpre&view", "&import", "e&xport", "&closefile", "clos&eallfiles", "&quit", "&edit", "&undo", "re&do", "cu&t", "&copy", "&paste", "&delete", "select&all", "dese&lect", "&find", "find&next", "findpre&vious", "&replace", "&gotoline", "&view", "&newview", "close&allviews", "&splitview", "&removeview", "splitter&orientation", "&horizontal", "&vertical", "view&mode", "&fullscreenmode", "&zoom", "zoom&in", "zoom&out", "zoomtopage&width", "zoomwhole&page", "zoom&factor", "&insert", "&format", "&go", "&up", "&back", "&forward", "&home", "&go", "&previouspage", "&nextpage", "&firstpage", "&lastpage", "read&updocument", "read&downdocument", "&back", "&forward", "&gotopage", "&bookmarks", "&addbookmark", "bookmark&tabsasfolder", "&editbookmarks", "&newbookmarksfolder", "&tools", "&settings", "&toolbars", "configure&shortcuts", "configuretool&bars", "&configure.*", "&help", ".+&handbook", "&whatsthis", "report&bug", "&aboutprocessing", "about&kde", "&beenden", "&suchen", "&preferncias", "&sair", "&rechercher"};
        Pattern[] kdePreDefPats = new Pattern[kdePreDefStrs.length];
        for (int i = 0; i < kdePreDefStrs.length; ++i) {
            kdePreDefPats[i] = Pattern.compile(kdePreDefStrs[i].replace("&", ""));
        }
        Pattern nonAAlpha = Pattern.compile("[^A-Za-z]");
        FontMetrics fmTmp = null;
        for (JMenuItem m : menu) {
            if (m == null) continue;
            fmTmp = m.getFontMetrics(m.getFont());
            break;
        }
        if (fmTmp == null) {
            return;
        }
        final FontMetrics fm = fmTmp;
        Comparator<Character> charComparator = new Comparator<Character>(){
            final char[] baddies = "qypgjaeiouQAEIOU".toCharArray();

            @Override
            public int compare(Character ch1, Character ch2) {
                float w1 = fm.charWidth(ch1.charValue());
                float w2 = fm.charWidth(ch2.charValue());
                for (char bad : this.baddies) {
                    if (bad == ch1.charValue()) {
                        w1 *= 0.66f;
                    }
                    if (bad != ch2.charValue()) continue;
                    w2 *= 0.66f;
                }
                return (int)Math.signum(w2 - w1);
            }
        };
        ArrayList<Character> taken = new ArrayList<Character>(menu.length);
        block2: for (JMenuItem jmi : menu) {
            if (jmi == null || jmi.getText() == null) continue;
            jmi.setMnemonic(0);
            String asciiName = nonAAlpha.matcher(jmi.getText()).replaceAll("");
            String lAsciiName = asciiName.toLowerCase();
            for (int i = 0; i < kdePreDefStrs.length; ++i) {
                if (!kdePreDefPats[i].matcher(lAsciiName).matches()) continue;
                char mnem = asciiName.charAt(kdePreDefStrs[i].indexOf("&"));
                jmi.setMnemonic(mnem);
                jmi.setDisplayedMnemonicIndex(jmi.getText().indexOf(mnem));
                taken.add(Character.valueOf((char)(mnem | 0x20)));
                continue block2;
            }
        }
        block4: for (JMenuItem jmi : menu) {
            void var17_28;
            char objectArray;
            void var17_23;
            if (jmi == null || jmi.getText() == null || jmi.getMnemonic() != 0) continue;
            String cleanString = jmi.getText();
            if (cleanString.startsWith("sketchbook \u2192 ")) {
                cleanString = cleanString.substring(13);
            }
            if (cleanString.length() == 0) continue;
            ArrayList<Character> banned = new ArrayList<Character>();
            boolean bl = false;
            while (var17_23 < cleanString.length()) {
                if (cleanString.charAt((int)var17_23) == '_') {
                    if (var17_23 > 0) {
                        banned.add(Character.valueOf(Character.toLowerCase(cleanString.charAt((int)(var17_23 - true)))));
                    }
                    if (var17_23 + true < cleanString.length()) {
                        banned.add(Character.valueOf(Character.toLowerCase(cleanString.charAt((int)(var17_23 + true)))));
                    }
                }
                ++var17_23;
            }
            for (String wd : cleanString.split("[^\\p{IsAlphabetic}]")) {
                char firstChar;
                if (wd.length() == 0 || taken.contains(Character.valueOf(Character.toLowerCase(firstChar = wd.charAt(0)))) || banned.contains(Character.valueOf(Character.toLowerCase(firstChar))) || 'A' > firstChar || firstChar > 'Z') continue;
                jmi.setMnemonic(firstChar);
                jmi.setDisplayedMnemonicIndex(jmi.getText().indexOf(firstChar));
                taken.add(Character.valueOf((char)(firstChar | 0x20)));
                continue block4;
            }
            for (String wd : cleanString.split("[^\\p{IsAlphabetic}]")) {
                char firstChar;
                if (wd.length() == 0 || taken.contains(Character.valueOf(Character.toLowerCase(firstChar = wd.charAt(0)))) || banned.contains(Character.valueOf(Character.toLowerCase(firstChar))) || 'a' > firstChar || firstChar > 'z') continue;
                jmi.setMnemonic(firstChar);
                jmi.setDisplayedMnemonicIndex(jmi.getText().indexOf(firstChar));
                taken.add(Character.valueOf(firstChar));
                continue block4;
            }
            cleanString = nonAAlpha.matcher(jmi.getText()).replaceAll("");
            if (cleanString.length() >= 2 && !taken.contains(Character.valueOf((char)((objectArray = cleanString.charAt(1)) | 0x20))) && !banned.contains(Character.valueOf((char)(objectArray | 0x20))) && fm.charWidth('A') <= 2 * fm.charWidth(objectArray)) {
                jmi.setMnemonic(objectArray);
                jmi.setDisplayedMnemonicIndex(jmi.getText().indexOf(objectArray));
                taken.add(Character.valueOf((char)(objectArray | 0x20)));
                continue;
            }
            char[] cleanChars = cleanString.toCharArray();
            Character[] cleanCharas = new Character[cleanChars.length];
            boolean bl2 = false;
            while (var17_28 < cleanChars.length) {
                cleanCharas[var17_28] = Character.valueOf(cleanChars[var17_28]);
                ++var17_28;
            }
            Arrays.sort(cleanCharas, charComparator);
            Character[] characterArray = cleanCharas;
            int n = characterArray.length;
            for (int i = 0; i < n; ++i) {
                char mnem = characterArray[i].charValue();
                if (taken.contains(Character.valueOf(Character.toLowerCase(mnem))) || banned.contains(Character.valueOf(Character.toLowerCase(mnem)))) continue;
                jmi.setMnemonic(mnem);
                jmi.setDisplayedMnemonicIndex(jmi.getText().indexOf(mnem));
                taken.add(Character.valueOf(Character.toLowerCase(mnem)));
                continue block4;
            }
            for (char digit : jmi.getText().replaceAll("[^0-9]", "").toCharArray()) {
                if (taken.contains(Character.valueOf(digit)) || banned.contains(Character.valueOf(digit))) continue;
                jmi.setMnemonic(48 + digit - 48);
                taken.add(Character.valueOf(digit));
                continue block4;
            }
        }
        for (JMenuItem jmi : menu) {
            if (!(jmi instanceof JMenu)) continue;
            Toolkit.setMenuMnemsInside((JMenu)jmi);
        }
    }

    public static void setMenuMnemonics(JMenuBar menubar) {
        JMenuItem[] items2 = new JMenuItem[menubar.getMenuCount()];
        for (int i = 0; i < items2.length; ++i) {
            items2[i] = menubar.getMenu(i);
        }
        Toolkit.setMenuMnemonics(items2);
    }

    public static void setMenuMnemonics(JPopupMenu menu) {
        ArrayList<JMenuItem> items2 = new ArrayList<JMenuItem>();
        for (Component c : menu.getComponents()) {
            if (!(c instanceof JMenuItem)) continue;
            items2.add((JMenuItem)c);
        }
        Toolkit.setMenuMnemonics(items2.toArray(new JMenuItem[0]));
    }

    public static void setMenuMnemsInside(JMenu menu) {
        JMenuItem[] items2 = new JMenuItem[menu.getItemCount()];
        for (int i = 0; i < items2.length; ++i) {
            items2[i] = menu.getItem(i);
        }
        Toolkit.setMenuMnemonics(items2);
    }

    public static int getMenuItemIndex(JMenu menu, JMenuItem item) {
        int index = 0;
        for (Component comp : menu.getMenuComponents()) {
            if (comp == item) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static Dimension getScreenSize() {
        return awtToolkit.getScreenSize();
    }

    public static Image getLibImage(String filename) {
        ImageIcon icon = Toolkit.getLibIcon(filename);
        return icon == null ? null : icon.getImage();
    }

    public static ImageIcon getLibIcon(String filename) {
        File file = Platform.getContentFile("lib/" + filename);
        if (file == null || !file.exists()) {
            Messages.err("does not exist: " + String.valueOf(file));
            return null;
        }
        return new ImageIcon(file.getAbsolutePath());
    }

    public static ImageIcon getIconX(File dir, String base) {
        return Toolkit.getIconX(dir, base, 0);
    }

    public static ImageIcon getIconX(File dir, String base, int size) {
        final int scale = Toolkit.highResImages() ? 2 : 1;
        String filename = size == 0 ? base + "-" + scale + "x.png" : base + "-" + size * scale + ".png";
        File file = new File(dir, filename);
        if (!file.exists()) {
            return null;
        }
        return new ImageIcon(file.getAbsolutePath()){

            @Override
            public int getIconWidth() {
                return Toolkit.zoom(super.getIconWidth()) / scale;
            }

            @Override
            public int getIconHeight() {
                return Toolkit.zoom(super.getIconHeight()) / scale;
            }

            @Override
            public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                ImageObserver imageObserver = this.getImageObserver();
                if (imageObserver == null) {
                    imageObserver = c;
                }
                g.drawImage(this.getImage(), x, y, this.getIconWidth(), this.getIconHeight(), imageObserver);
            }
        };
    }

    public static ImageIcon getLibIconX(String base) {
        return Toolkit.getLibIconX(base, 0);
    }

    public static ImageIcon getLibIconX(String base, int size) {
        return Toolkit.getIconX(Platform.getContentFile("lib"), base, size);
    }

    public static void setIcon(Frame frame) {
        Toolkit.setIcon((Window)frame);
    }

    public static void setIcon(Window window) {
        if (!Platform.isMacOS()) {
            if (iconImages == null) {
                int[] sizes;
                iconImages = new ArrayList<Image>();
                for (int sz : sizes = new int[]{16, 32, 48, 64, 128, 256, 512}) {
                    iconImages.add(Toolkit.getLibImage("icons/app-" + sz + ".png"));
                }
            }
            window.setIconImages(iconImages);
        }
    }

    public static ImageIcon renderIcon(String name, String color, int size) {
        return Toolkit.renderIcon(Platform.getContentFile("lib/" + name + ".svg"), color, size);
    }

    public static ImageIcon renderIcon(File file, String color, int size) {
        Image image = Toolkit.renderMonoImage(file, color, size);
        return image != null ? Toolkit.wrapIcon(image) : null;
    }

    public static ImageIcon wrapIcon(Image image) {
        final int scale = Toolkit.highResImages() ? 2 : 1;
        return new ImageIcon(image){

            @Override
            public int getIconWidth() {
                return Toolkit.zoom(super.getIconWidth()) / scale;
            }

            @Override
            public int getIconHeight() {
                return Toolkit.zoom(super.getIconHeight()) / scale;
            }

            @Override
            public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                ImageObserver imageObserver = this.getImageObserver();
                if (imageObserver == null) {
                    imageObserver = c;
                }
                g.drawImage(this.getImage(), x, y, this.getIconWidth(), this.getIconHeight(), imageObserver);
            }
        };
    }

    protected static Image renderMonoImage(File file, String color, int size) {
        String xmlOrig = Util.loadFile(file);
        if (xmlOrig != null) {
            StringDict replace = new StringDict((String[][])new String[][]{{"#9B9B9B", color}});
            return Toolkit.svgToImageMult(xmlOrig, size, size, replace);
        }
        return null;
    }

    public static Image svgToImageMult(String xmlStr, int wide, int high, StringDict replacements) {
        for (StringDict.Entry entry : replacements.entries()) {
            xmlStr = xmlStr.replace(entry.key, "$" + entry.key.hashCode() + "$");
        }
        for (StringDict.Entry entry : replacements.entries()) {
            xmlStr = xmlStr.replace("$" + entry.key.hashCode() + "$", entry.value);
        }
        return Toolkit.svgToImage(xmlStr, Toolkit.highResMultiply(wide), Toolkit.highResMultiply(high));
    }

    private static Image svgToImage(String xmlStr, int wide, int high) {
        PGraphicsJava2D pg = new PGraphicsJava2D();
        pg.setPrimary(false);
        pg.setSize(wide, high);
        pg.smooth();
        pg.beginDraw();
        try {
            XML xml = XML.parse((String)xmlStr);
            PShapeJava2D shape = new PShapeJava2D(xml);
            pg.shape((PShape)shape, 0.0f, 0.0f, (float)wide, (float)high);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pg.endDraw();
        return pg.image;
    }

    public static Shape createRoundRect(float x1, float y1, float x2, float y2, float tl, float tr, float br, float bl) {
        GeneralPath path = new GeneralPath();
        if (tr != 0.0f) {
            path.moveTo(x2 - tr, y1);
            path.quadTo(x2, y1, x2, y1 + tr);
        } else {
            path.moveTo(x2, y1);
        }
        if (br != 0.0f) {
            path.lineTo(x2, y2 - br);
            path.quadTo(x2, y2, x2 - br, y2);
        } else {
            path.lineTo(x2, y2);
        }
        if (bl != 0.0f) {
            path.lineTo(x1 + bl, y2);
            path.quadTo(x1, y2, x1, y2 - bl);
        } else {
            path.lineTo(x1, y2);
        }
        if (tl != 0.0f) {
            path.lineTo(x1, y1 + tl);
            path.quadTo(x1, y1, x1 + tl, y1);
        } else {
            path.lineTo(x1, y1);
        }
        path.closePath();
        return path;
    }

    public static void registerWindowCloseKeys(JRootPane root, ActionListener disposer) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        root.registerKeyboardAction(disposer, stroke, 2);
        stroke = KeyStroke.getKeyStroke(87, SHORTCUT_KEY_MASK);
        root.registerKeyboardAction(disposer, stroke, 2);
    }

    public static void beep() {
        awtToolkit.beep();
    }

    public static Clipboard getSystemClipboard() {
        return awtToolkit.getSystemClipboard();
    }

    public static Graphics2D prepareGraphics(Image image) {
        return Toolkit.prepareGraphics(image.getGraphics(), true);
    }

    public static Graphics2D prepareGraphics(Graphics g) {
        return Toolkit.prepareGraphics(g, false);
    }

    public static Graphics2D prepareGraphics(Graphics g, boolean scale) {
        Graphics2D g2 = (Graphics2D)g;
        if (scale && Toolkit.isRetina()) {
            g2.scale(2.0, 2.0);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (Toolkit.isRetina()) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        }
        if (scale) {
            Toolkit.zoomStroke(g2);
        }
        return g2;
    }

    public static int zoom(int pixels) {
        if (zoom == 0.0f) {
            zoom = Toolkit.parseZoom();
        }
        return (int)Math.ceil(zoom * (float)pixels);
    }

    public static Dimension zoom(int w, int h) {
        return new Dimension(Toolkit.zoom(w), Toolkit.zoom(h));
    }

    private static float parseZoom() {
        if (Preferences.getBoolean("editor.zoom.auto")) {
            float newZoom = Platform.getSystemZoom();
            String percentSel = (int)(newZoom * 100.0f) + "%";
            Preferences.set("editor.zoom", percentSel);
            return newZoom;
        }
        String zoomSel = Preferences.get("editor.zoom");
        if (zoomOptions.hasValue(zoomSel)) {
            zoomSel = zoomSel.substring(0, zoomSel.length() - 1);
            return (float)PApplet.parseInt((String)zoomSel, (int)100) / 100.0f;
        }
        Preferences.set("editor.zoom", "100%");
        return 1.0f;
    }

    private static void zoomStroke(Graphics2D g2) {
        if (zoom != 1.0f) {
            if (zoomStroke == null || zoomStroke.getLineWidth() != zoom) {
                zoomStroke = new BasicStroke(zoom);
            }
            g2.setStroke(zoomStroke);
        }
    }

    public static boolean highResImages() {
        return Toolkit.isRetina() || Platform.getSystemZoom() > 1.0f;
    }

    public static int highResMultiplier() {
        return Toolkit.highResImages() ? 2 : 1;
    }

    public static int highResMultiply(int amount) {
        return Toolkit.highResImages() ? 2 * amount : amount;
    }

    public static boolean isRetina() {
        if (retinaProp == null) {
            retinaProp = Toolkit.checkRetina();
        }
        return retinaProp;
    }

    private static boolean checkRetina() {
        AffineTransform tx = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
        return Math.round(tx.getScaleX()) == 2L;
    }

    private static List<Font> getMonoFontList() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        ArrayList<Font> outgoing = new ArrayList<Font>();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), Preferences.getBoolean("editor.antialias"), true);
        for (Font font2 : fonts) {
            double w;
            if (font2.getStyle() != 0 || !font2.canDisplay('i') || !font2.canDisplay('M') || !font2.canDisplay(' ') || !font2.canDisplay('.') || (w = font2.getStringBounds(" ", frc).getWidth()) != font2.getStringBounds("i", frc).getWidth() || w != font2.getStringBounds("M", frc).getWidth() || w != font2.getStringBounds(".", frc).getWidth()) continue;
            outgoing.add(font2);
        }
        return outgoing;
    }

    public static String[] getMonoFontFamilies() {
        StringList families = new StringList();
        for (Font font2 : Toolkit.getMonoFontList()) {
            families.appendUnique(font2.getFamily());
        }
        families.sort();
        return families.toArray();
    }

    public static String getMonoFontName() {
        return Toolkit.getMonoFont(12, 0).getName();
    }

    public static Font getMonoFont(int size, int style) {
        String fontFamilyMono = Language.text("font.family.mono");
        if (monoFont == null || monoBoldFont == null) {
            try {
                if ("Source Code Pro".equals(fontFamilyMono)) {
                    monoFont = Toolkit.initFont("SourceCodePro-Regular.ttf", size);
                    monoBoldFont = Toolkit.initFont("SourceCodePro-Bold.ttf", size);
                }
            }
            catch (Exception e) {
                Messages.err("Could not load mono font", e);
            }
        }
        if (monoFont == null || monoBoldFont == null) {
            monoFont = new Font(fontFamilyMono, 0, size);
            monoBoldFont = new Font(fontFamilyMono, 1, size);
        }
        if (style == 1) {
            if (size == monoBoldFont.getSize()) {
                return monoBoldFont;
            }
            return monoBoldFont.deriveFont((float)size);
        }
        if (size == monoFont.getSize()) {
            return monoFont;
        }
        return monoFont.deriveFont((float)size);
    }

    public static String getSansFontName() {
        return Toolkit.getSansFont(12, 0).getName();
    }

    public static Font getSansFont(int size, int style) {
        String fontFamilySans = Language.text("font.family.sans");
        if (sansFont == null || sansBoldFont == null) {
            try {
                if ("Processing Sans".equals(fontFamilySans)) {
                    sansFont = Toolkit.initFont("ProcessingSans-Regular.ttf", size);
                    sansBoldFont = Toolkit.initFont("ProcessingSans-Bold.ttf", size);
                }
            }
            catch (Exception e) {
                Messages.err("Could not load sans font", e);
            }
        }
        if (sansFont == null || sansBoldFont == null) {
            sansFont = new Font(fontFamilySans, 0, size);
            sansBoldFont = new Font(fontFamilySans, 1, size);
        }
        if (style == 1) {
            if (size == sansBoldFont.getSize() || size == 0) {
                return sansBoldFont;
            }
            return sansBoldFont.deriveFont((float)size);
        }
        if (size == sansFont.getSize() || size == 0) {
            return sansFont;
        }
        return sansFont.deriveFont((float)size);
    }

    private static Font initFont(String filename, int size) throws IOException, FontFormatException {
        File fontFile = Platform.getContentFile("lib/fonts/" + filename);
        if (fontFile == null || !fontFile.exists()) {
            Object msg = "Could not find required fonts. ";
            msg = Util.containsNonASCII(Platform.getJavaHome().getAbsolutePath()) ? (String)msg + "Trying moving Processing\nto a location with only ASCII characters in the path." : (String)msg + "Please reinstall Processing.";
            Messages.showError("Font Sadness", (String)msg, null);
        }
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(fontFile));
        Font font2 = Font.createFont(0, input);
        input.close();
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font2);
        return font2.deriveFont((float)size);
    }

    public static double getAscent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        FontRenderContext frc = g2.getFontRenderContext();
        return new TextLayout("H", g.getFont(), frc).getBounds().getHeight();
    }

    public static String formatMessage(String message) {
        String monoName = "Monospaced";
        try {
            monoName = Toolkit.getMonoFontName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "<html> <head> <style type=\"text/css\">tt { font: 12pt \"" + monoName + "\"; color: #888; }</style> </head>" + message.replaceAll("\n", "<br/>");
    }

    public static String formatMessage(String primary, String secondary) {
        return ("<html> <head> <style type=\"text/css\"></style> </head><b>" + primary + "</b>&nbsp;<p>" + secondary + "</p>").replaceAll("\n", "<br/>");
    }

    public static HTMLEditorKit createHtmlEditorKit() {
        return new HTMLEditorKit(){
            private StyleSheet style;

            @Override
            public StyleSheet getStyleSheet() {
                return this.style == null ? super.getStyleSheet() : this.style;
            }

            @Override
            public void setStyleSheet(StyleSheet s) {
                this.style = s;
            }

            public StyleSheet getDefaultStyleSheet() {
                return super.getStyleSheet();
            }

            public void setDefaultStyleSheet(StyleSheet s) {
                super.setStyleSheet(s);
            }
        };
    }

    static {
        zoom = 0.0f;
        zoomOptions = new StringList(new Object[]{"100%", "150%", "200%", "300%"});
    }
}

