/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import processing.app.Base;
import processing.app.Language;
import processing.app.Platform;
import processing.app.SketchReference;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;
import processing.app.ui.ZoomTreeCellRenderer;

public class SketchbookFrame
extends JFrame {
    protected Base base;

    public SketchbookFrame(Base base) {
        super(Language.text("sketchbook"));
        this.base = base;
        ActionListener listener = e -> this.setVisible(false);
        Toolkit.registerWindowCloseKeys(this.getRootPane(), listener);
        Toolkit.setIcon(this);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.updateCenterPanel();
        Box buttons = Box.createHorizontalBox();
        JButton addButton = new JButton("Show Folder");
        addButton.addActionListener(e -> Platform.openFolder(Base.getSketchbookFolder()));
        buttons.add(Box.createHorizontalGlue());
        buttons.add((Component)addButton, "West");
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(e -> base.rebuildSketchbook());
        buttons.add((Component)refreshButton, "East");
        buttons.add(Box.createHorizontalGlue());
        int high = addButton.getPreferredSize().height;
        int wide = 4 * Toolkit.getButtonWidth() / 3;
        addButton.setPreferredSize(new Dimension(wide, high));
        refreshButton.setPreferredSize(new Dimension(wide, high));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(buttons);
        pane.add((Component)buttonPanel, "South");
        this.pack();
    }

    private JTree rebuildTree() {
        final JTree tree = new JTree(this.base.buildSketchbookTree());
        tree.getSelectionModel().setSelectionMode(1);
        tree.setShowsRootHandles(true);
        tree.expandRow(0);
        tree.setRootVisible(false);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                    int selRow = tree.getRowForLocation(e.getX(), e.getY());
                    if (node != null && node.isLeaf() && selRow != -1) {
                        SketchReference sketch = (SketchReference)node.getUserObject();
                        SketchbookFrame.this.base.handleOpen(sketch.getPath());
                    }
                }
            }
        });
        tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SketchbookFrame.this.setVisible(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                DefaultMutableTreeNode node;
                if (e.getKeyChar() == '\n' && (node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent()) != null && node.isLeaf()) {
                    SketchReference sketch = (SketchReference)node.getUserObject();
                    SketchbookFrame.this.base.handleOpen(sketch.getPath());
                }
            }
        });
        int border = Toolkit.zoom(5);
        tree.setBorder(new EmptyBorder(border, border, border, border));
        if (Platform.isMacOS()) {
            tree.setToggleClickCount(2);
        } else {
            tree.setToggleClickCount(1);
        }
        tree.setCellRenderer(new ZoomTreeCellRenderer());
        return tree;
    }

    private void updateCenterPanel() {
        JComponent panel;
        JTree tree = this.rebuildTree();
        TreeModel treeModel = tree.getModel();
        if (treeModel.getChildCount(treeModel.getRoot()) != 0) {
            JScrollPane treePane = new JScrollPane(tree, 20, 31);
            treePane.setPreferredSize(Toolkit.zoom(250, 450));
            treePane.setBorder(new EmptyBorder(0, 0, 0, 0));
            panel = treePane;
        } else {
            JPanel emptyPanel = new JPanel();
            emptyPanel.setBackground(Color.WHITE);
            emptyPanel.setPreferredSize(Toolkit.zoom(250, 450));
            JLabel emptyLabel = new JLabel("Empty Sketchbook");
            emptyLabel.setForeground(Color.GRAY);
            emptyPanel.add(emptyLabel);
            panel = emptyPanel;
        }
        Container pane = this.getContentPane();
        BorderLayout layout = (BorderLayout)pane.getLayout();
        Component comp = layout.getLayoutComponent("Center");
        if (comp != null) {
            pane.remove(comp);
        }
        pane.add((Component)panel, "Center");
    }

    public void rebuild() {
        this.updateCenterPanel();
        this.getContentPane().validate();
    }

    public void setVisible() {
        EventQueue.invokeLater(() -> {
            int roughWidth = this.getWidth() + 20;
            Editor editor = this.base.getActiveEditor();
            if (editor == null) {
                this.setLocationRelativeTo(null);
            } else {
                Point p = editor.getLocation();
                if (p.x < roughWidth) {
                    this.setLocationRelativeTo(null);
                } else {
                    this.setLocation(p.x - roughWidth, p.y);
                }
            }
            this.setVisible(true);
        });
    }
}

