/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import processing.app.Messages;
import processing.app.ui.Editor;
import processing.app.ui.EditorButton;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

public class ModeSelector
extends JPanel {
    static final int RADIUS = Toolkit.zoom(3);
    String title;
    Font titleFont;
    Color titleColor;
    int titleAscent;
    int titleWidth;
    final int MODE_GAP_WIDTH = Toolkit.zoom(10);
    final int ARROW_GAP_WIDTH = Toolkit.zoom(6);
    final int ARROW_WIDTH = Toolkit.zoom(6);
    final int ARROW_TOP = Toolkit.zoom(16);
    final int ARROW_BOTTOM = Toolkit.zoom(22);
    int[] triangleX = new int[3];
    int[] triangleY = new int[]{this.ARROW_TOP, this.ARROW_TOP, this.ARROW_BOTTOM};
    Color backgroundColor;
    Color outlineColor;

    public ModeSelector(final Editor editor) {
        this.title = editor.getMode().getTitle();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                JPopupMenu popup = editor.getModePopup();
                popup.show(ModeSelector.this, event.getX(), event.getY());
            }
        });
        this.updateTheme();
    }

    public void updateTheme() {
        this.titleFont = Theme.getFont("mode.title.font");
        this.titleColor = Theme.getColor("mode.title.color");
        this.backgroundColor = Theme.getColor("mode.background.color");
        this.outlineColor = Theme.getColor("mode.outline.color");
    }

    @Override
    public void paintComponent(Graphics g) {
        int x;
        Graphics2D g2 = Toolkit.prepareGraphics(g);
        g.setFont(this.titleFont);
        if (this.titleAscent == 0) {
            this.titleAscent = (int)Toolkit.getAscent(g);
        }
        FontMetrics metrics = g.getFontMetrics();
        this.titleWidth = metrics.stringWidth(this.title);
        int width = this.getWidth();
        int height = this.getHeight();
        int inset = Toolkit.zoom(4);
        int outline = Toolkit.zoom(1);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, width, height);
        g.setColor(this.outlineColor);
        g2.draw(Toolkit.createRoundRect(outline, outline + inset, width - outline, height - outline - inset, RADIUS, RADIUS, RADIUS, RADIUS));
        g.setColor(this.titleColor);
        g.drawString(this.title, this.MODE_GAP_WIDTH, (height + this.titleAscent) / 2 + 1);
        this.triangleX[0] = x = this.MODE_GAP_WIDTH + this.titleWidth + this.ARROW_GAP_WIDTH;
        this.triangleX[1] = x + this.ARROW_WIDTH;
        this.triangleX[2] = x + this.ARROW_WIDTH / 2;
        g.fillPolygon(this.triangleX, this.triangleY, 3);
    }

    @Override
    public Dimension getPreferredSize() {
        int tempWidth = this.titleWidth;
        if (tempWidth == 0) {
            Graphics g = this.getGraphics();
            if (g != null) {
                tempWidth = this.getFontMetrics(this.titleFont).stringWidth(this.title);
            } else {
                Messages.err("null Graphics in EditorToolbar.getPreferredSize()");
            }
        }
        return new Dimension(this.MODE_GAP_WIDTH + tempWidth + this.ARROW_GAP_WIDTH + this.ARROW_WIDTH + this.MODE_GAP_WIDTH, EditorButton.DIM);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

