/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.platform.MacPlatform;
import processing.app.ui.ColorChooser;
import processing.app.ui.Editor;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public class ExportPrompt {
    static final String MACOS_EXPORT_WIKI = "https://github.com/processing/processing4/wiki/Exporting-Applications#macos";
    public static final String EXPORT_VARIANTS = "export.application.variants";
    public static final String JAVA_DOWNLOAD_URL = "https://adoptium.net/";
    final JButton exportButton = new JButton(Language.text("prompt.export"));
    final JButton cancelButton = new JButton(Language.text("prompt.cancel"));
    List<JCheckBox> variantButtons;
    final Editor editor;
    final Runnable callback;

    public ExportPrompt(Editor editor, Runnable callback) {
        this.editor = editor;
        this.callback = callback;
        String pref = Preferences.get(EXPORT_VARIANTS);
        if (pref == null) {
            pref = Platform.getVariant();
            Preferences.set(EXPORT_VARIANTS, pref);
        }
        StringList selectedVariants = new StringList(pref.split(","));
        this.variantButtons = new ArrayList<JCheckBox>();
        for (StringDict.Entry entry : Platform.getSupportedVariants().entries()) {
            String variant = entry.key;
            JCheckBox button = new JCheckBox(entry.value);
            if (variant.startsWith("macos") && !Platform.isMacOS()) {
                button.setEnabled(false);
            } else {
                button.setSelected(selectedVariants.hasValue(variant));
            }
            button.setActionCommand(variant);
            button.addActionListener(e -> this.updateVariants());
            this.variantButtons.add(button);
        }
    }

    protected void updateVariants() {
        StringList list = new StringList();
        for (JCheckBox button : this.variantButtons) {
            if (!button.isSelected()) continue;
            list.append(button.getActionCommand());
        }
        Preferences.set(EXPORT_VARIANTS, list.join(","));
        this.exportButton.setEnabled(this.anyExportButton());
    }

    protected boolean anyExportButton() {
        for (JCheckBox button : this.variantButtons) {
            if (!button.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void trigger() {
        final JDialog dialog = new JDialog(this.editor, Language.text("export"), true);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(6));
        JLabel label = new JLabel(Language.text("export.description"), 0);
        label.setBorder(new EmptyBorder(0, 8, 0, 0));
        panel.add(label);
        panel.add(Box.createVerticalStrut(12));
        JPanel platformPanel = new JPanel();
        int half = (this.variantButtons.size() + 1) / 2;
        Box leftPlatforms = Box.createVerticalBox();
        for (int i = 0; i < half; ++i) {
            leftPlatforms.add(this.variantButtons.get(i));
        }
        Box rightPlatforms = Box.createVerticalBox();
        for (int i = half; i < this.variantButtons.size(); ++i) {
            rightPlatforms.add(this.variantButtons.get(i));
        }
        platformPanel.add(leftPlatforms);
        platformPanel.add(rightPlatforms);
        platformPanel.setBorder(new TitledBorder(Language.text("export.platforms")));
        platformPanel.setAlignmentX(0.0f);
        panel.add(platformPanel);
        int divWidth = platformPanel.getPreferredSize().width;
        JCheckBox showStopButton = new JCheckBox(Language.text("export.options.show_stop_button"));
        showStopButton.setSelected(Preferences.getBoolean("export.application.stop"));
        showStopButton.addItemListener(e -> Preferences.setBoolean("export.application.stop", showStopButton.isSelected()));
        showStopButton.setEnabled(Preferences.getBoolean("export.application.present"));
        showStopButton.setBorder(new EmptyBorder(3, 13, 6, 13));
        JCheckBox presentButton = new JCheckBox(Language.text("export.options.present"));
        presentButton.setSelected(Preferences.getBoolean("export.application.present"));
        presentButton.addItemListener(e -> {
            boolean sal = presentButton.isSelected();
            Preferences.setBoolean("export.application.present", sal);
            showStopButton.setEnabled(sal);
        });
        presentButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        JPanel presentPanel = new JPanel();
        presentPanel.setLayout(new BoxLayout(presentPanel, 1));
        Box fullScreenBox = Box.createHorizontalBox();
        fullScreenBox.add(presentButton);
        fullScreenBox.add(new ColorPreference("run.present.bgcolor"));
        fullScreenBox.add(Box.createHorizontalStrut(10));
        fullScreenBox.add(Box.createHorizontalGlue());
        presentPanel.add(fullScreenBox);
        Box showStopBox = Box.createHorizontalBox();
        showStopBox.add(showStopButton);
        showStopBox.add(new ColorPreference("run.present.stop.color"));
        showStopBox.add(Box.createHorizontalStrut(10));
        showStopBox.add(Box.createHorizontalGlue());
        presentPanel.add(showStopBox);
        presentPanel.setBorder(new TitledBorder(Language.text("export.full_screen")));
        presentPanel.setAlignmentX(0.0f);
        panel.add(presentPanel);
        JPanel embedPanel = new JPanel();
        embedPanel.setLayout(new BoxLayout(embedPanel, 1));
        String platformName = null;
        if (Platform.isMacOS()) {
            platformName = "macOS";
        } else if (Platform.isWindows()) {
            platformName = "Windows";
        } else if (Platform.isLinux()) {
            platformName = "Linux";
        }
        boolean embed = Preferences.getBoolean("export.application.embed_java");
        String warning1 = "<html><div width=\"" + divWidth + "\">";
        String warning2a = "This option will make the " + platformName + " application larger, but it will be far more likely to work. Users on other platforms will need to ";
        String warning2b = "Users will need to ";
        String warning3 = "<a href=\"https://adoptium.net/\">install OpenJDK " + PApplet.javaPlatform + "</a>.";
        String embedWarning = warning1 + warning2a + warning3;
        String nopeWarning = warning1 + "Users will need to " + warning3;
        JLabel warningLabel = new JLabel(embed ? embedWarning : nopeWarning);
        warningLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Platform.openURL(ExportPrompt.JAVA_DOWNLOAD_URL);
            }
        });
        warningLabel.setBorder(new EmptyBorder(3, 13, 3, 13));
        JCheckBox embedJavaButton = new JCheckBox(Language.interpolate("export.include_java", Platform.getPrettyName()));
        embedJavaButton.setSelected(embed);
        embedJavaButton.addItemListener(e -> {
            boolean selected = embedJavaButton.isSelected();
            Preferences.setBoolean("export.application.embed_java", selected);
            if (selected) {
                warningLabel.setText(embedWarning);
            } else {
                warningLabel.setText(nopeWarning);
            }
            dialog.pack();
        });
        embedJavaButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        embedPanel.add(embedJavaButton);
        embedPanel.add(warningLabel);
        embedPanel.setBorder(new TitledBorder(Language.text("export.embed_java")));
        panel.add(embedPanel);
        if (Platform.isMacOS()) {
            JPanel signPanel = new JPanel();
            signPanel.setLayout(new BoxLayout(signPanel, 1));
            signPanel.setBorder(new TitledBorder(Language.text("export.code_signing")));
            Object thePain = "Applications on macOS must be \u201csigned\u201d and \u201cnotarized,\u201dor they will be reported as damaged or unsafe. ";
            thePain = MacPlatform.isXcodeInstalled() ? (String)thePain + "<br/>This application will be \u201cself-signed\u201d which means that macOS may complain that it comes from an unidentified developer. If the application will not run, try right-clicking the app and selecting Open from the pop-up menu. More details at the <a href=\"\">Exporting Applications</a> wiki page." : (String)thePain + "To create a working macOS application, <a href=\"\">click here</a> to install the Command Line Tools from Apple.";
            JLabel area = new JLabel("<html><div width=\"" + divWidth + "\">" + (String)thePain + "</div></html>");
            area.setBorder(new EmptyBorder(3, 13, 3, 13));
            signPanel.add(area);
            signPanel.setAlignmentX(0.0f);
            area.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    if (MacPlatform.isXcodeInstalled()) {
                        Platform.openURL(ExportPrompt.MACOS_EXPORT_WIKI);
                    } else {
                        PApplet.exec((String[])new String[]{"xcode-select", "--install"});
                        MacPlatform.resetXcodeInstalled();
                        dialog.setVisible(false);
                    }
                }
            });
            panel.add(signPanel);
        }
        Object[] options = new JButton[]{this.exportButton, this.cancelButton};
        JOptionPane optionPane = new JOptionPane(panel, -1, 0, null, options, this.exportButton);
        dialog.setContentPane(optionPane);
        this.exportButton.addActionListener(e -> optionPane.setValue(this.exportButton));
        this.cancelButton.addActionListener(e -> optionPane.setValue(this.cancelButton));
        optionPane.addPropertyChangeListener(e -> {
            String prop = e.getPropertyName();
            if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                dialog.setVisible(false);
            }
        });
        dialog.pack();
        dialog.setResizable(false);
        Rectangle bounds = this.editor.getBounds();
        dialog.setLocation(bounds.x + (bounds.width - dialog.getSize().width) / 2, bounds.y + (bounds.height - dialog.getSize().height) / 2);
        dialog.setVisible(true);
        Object value = optionPane.getValue();
        if (value.equals(this.exportButton)) {
            this.callback.run();
        } else if (value.equals(this.cancelButton) || value.equals(-1)) {
            this.editor.statusNotice(Language.text("export.notice.exporting.cancel"));
        }
    }

    class ColorPreference
    extends JPanel
    implements ActionListener {
        ColorChooser chooser;
        String prefName;

        public ColorPreference(String pref) {
            this.prefName = pref;
            this.setPreferredSize(new Dimension(30, 20));
            this.setMaximumSize(new Dimension(30, 20));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Color color = Preferences.getColor(ColorPreference.this.prefName);
                    ColorPreference.this.chooser = new ColorChooser(ExportPrompt.this.editor, true, color, Language.text("color_chooser.select"), ColorPreference.this);
                    ColorPreference.this.chooser.show();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(Preferences.getColor(this.prefName));
            Dimension size = this.getSize();
            g.fillRect(0, 0, size.width, size.height);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = this.chooser.getColor();
            Preferences.setColor(this.prefName, color);
            this.repaint();
            this.chooser.hide();
        }
    }
}

