/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.List;
import processing.app.Preferences;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;

public class EditorState {
    Rectangle editorBounds;
    int dividerLocation;
    boolean isMaximized;
    GraphicsConfiguration deviceConfig;
    static final int WINDOW_OFFSET = 28;
    static GraphicsConfiguration lastConfig;

    public static EditorState nextEditor(List<Editor> editors) {
        Component lastEditor = null;
        int editorCount = editors.size();
        if (editorCount > 0) {
            lastEditor = editors.get(editorCount - 1);
        }
        if (lastEditor != null) {
            lastConfig = lastEditor.getGraphicsConfiguration();
        }
        if (lastConfig == null) {
            lastConfig = EditorState.getDefaultConfig();
        }
        EditorState outgoing = new EditorState();
        outgoing.initLocation(lastConfig, (Editor)lastEditor);
        return outgoing;
    }

    public String toString() {
        return this.editorBounds.x + "," + this.editorBounds.y + "," + this.editorBounds.width + "," + this.editorBounds.height + "," + this.dividerLocation + "," + String.valueOf(this.deviceConfig);
    }

    public GraphicsConfiguration getConfig() {
        return this.deviceConfig;
    }

    static GraphicsConfiguration getDefaultConfig() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        return device.getDefaultConfiguration();
    }

    void initLocation(GraphicsConfiguration lastConfig, Editor lastOpened) {
        this.deviceConfig = lastConfig;
        Rectangle deviceBounds = this.deviceConfig.getBounds();
        int defaultWidth = Toolkit.zoom(Preferences.getInteger("editor.window.width.default"));
        int defaultHeight = Toolkit.zoom(Preferences.getInteger("editor.window.height.default"));
        defaultWidth = Math.min(defaultWidth, deviceBounds.width);
        defaultHeight = Math.min(defaultHeight, deviceBounds.height);
        if (lastOpened == null) {
            int editorX = deviceBounds.x + (deviceBounds.width - defaultWidth) / 2;
            int editorY = deviceBounds.y + (deviceBounds.height - defaultHeight) / 2;
            this.editorBounds = new Rectangle(editorX, editorY, defaultWidth, defaultHeight);
            this.dividerLocation = 0;
        } else {
            this.isMaximized = lastOpened.getExtendedState() == 6;
            this.editorBounds = lastOpened.getBounds();
            this.editorBounds.x += 28;
            this.editorBounds.y += 28;
            this.dividerLocation = lastOpened.getDividerLocation();
            if (!deviceBounds.contains(this.editorBounds)) {
                this.editorBounds.x = deviceBounds.x + (int)(Math.random() * (double)(deviceBounds.width - defaultWidth));
                this.editorBounds.y = deviceBounds.y + (int)(Math.random() * (double)(deviceBounds.height - defaultHeight));
            }
            if (this.isMaximized) {
                this.editorBounds.width = defaultWidth;
                this.editorBounds.height = defaultHeight;
            }
        }
    }

    void apply(Editor editor) {
        editor.setBounds(this.editorBounds);
        if (this.dividerLocation == 0) {
            this.dividerLocation = 2 * editor.getSize().height / 3;
        }
        editor.setDividerLocation(this.dividerLocation);
        if (this.isMaximized) {
            editor.setExtendedState(6);
        }
    }
}

