/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import com.formdev.flatlaf.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ParagraphView;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import processing.app.Base;
import processing.app.Formatter;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Problem;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.UpdateCheck;
import processing.app.contrib.ContributionManager;
import processing.app.laf.PdeMenuItemUI;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeInputHandler;
import processing.app.syntax.PdeTextArea;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.SyntaxDocument;
import processing.app.ui.ChangeDetector;
import processing.app.ui.EditorConsole;
import processing.app.ui.EditorException;
import processing.app.ui.EditorFooter;
import processing.app.ui.EditorHeader;
import processing.app.ui.EditorState;
import processing.app.ui.EditorStatus;
import processing.app.ui.EditorToolbar;
import processing.app.ui.ErrorTable;
import processing.app.ui.FindReplace;
import processing.app.ui.MarkerColumn;
import processing.app.ui.Recent;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;
import processing.core.PApplet;
import processing.utils.SketchException;

public abstract class Editor
extends JFrame
implements RunnerListener {
    protected Base base;
    protected EditorState state;
    protected Mode mode;
    public static final int LEFT_GUTTER = Toolkit.zoom(45);
    public static final int RIGHT_GUTTER = Toolkit.zoom(12);
    public static final int GUTTER_MARGIN = Toolkit.zoom(5);
    protected MarkerColumn errorColumn;
    protected static final String EMPTY = "                                                                                                                                                                                                               ";
    private PageFormat pageFormat;
    private PrinterJob printerJob;
    private JMenu fileMenu;
    private JMenu sketchMenu;
    protected JPanel spacer = new JPanel();
    protected EditorHeader header;
    protected EditorToolbar toolbar;
    protected JEditTextArea textarea;
    protected EditorStatus status;
    protected JSplitPane splitPane;
    protected EditorFooter footer;
    protected EditorConsole console;
    protected ErrorTable errorTable;
    protected Sketch sketch;
    private Point sketchWindowLocation;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected CutAction cutAction;
    protected CopyAction copyAction;
    protected CopyAsHtmlAction copyAsHtmlAction;
    protected PasteAction pasteAction;
    protected List<UpdatableAction> editMenuUpdatable = new ArrayList<UpdatableAction>();
    protected FindNextAction findNextAction;
    protected FindPreviousAction findPreviousAction;
    private UndoManager undo;
    private Stack<Integer> caretUndoStack = new Stack();
    private Stack<Integer> caretRedoStack = new Stack();
    private CompoundEdit compoundEdit;
    private final Timer timer;
    private TimerTask endUndoEvent;
    private boolean isInserting;
    private FindReplace find;
    JMenu toolsMenu;
    JMenu modePopup;
    JMenu developMenu;
    protected List<Problem> problems = Collections.emptyList();
    static Font toolTipFont;
    static String toolTipTextColor;
    static String toolTipWarningColor;
    static String toolTipErrorColor;

    protected Editor(final Base base, String path, EditorState state, final Mode mode) throws EditorException {
        super("Processing", state.getConfig());
        this.base = base;
        this.state = state;
        this.mode = mode;
        base.checkFirstEditor(this);
        Toolkit.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                base.handleClose(Editor.this, false);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                base.handleActivated(Editor.this);
                Editor.this.fileMenu.insert(Recent.getMenu(), 2);
                Toolkit.setMenuMnemsInside(Editor.this.fileMenu);
                mode.insertImportMenu(Editor.this.sketchMenu);
                Toolkit.setMenuMnemsInside(Editor.this.sketchMenu);
                mode.insertToolbarRecentMenu();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                Editor.this.fileMenu.remove(Recent.getMenu());
                mode.removeImportMenu(Editor.this.sketchMenu);
                mode.removeToolbarRecentMenu();
            }
        });
        this.timer = new Timer();
        this.buildMenuBar();
        JPanel contentPain = new JPanel();
        this.setContentPane(contentPain);
        contentPain.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        Box upper = Box.createVerticalBox();
        if (Platform.isMacOS() && SystemInfo.isMacFullWindowContentSupported) {
            this.getRootPane().putClientProperty("apple.awt.fullWindowContent", true);
            this.getRootPane().putClientProperty("apple.awt.transparentTitleBar", true);
            this.spacer.setPreferredSize(new Dimension(1, Toolkit.zoom(18)));
            this.spacer.setMinimumSize(new Dimension(1, Toolkit.zoom(18)));
            this.spacer.setAlignmentX(0.0f);
            box.add(this.spacer);
        }
        this.rebuildModePopup();
        this.toolbar = this.createToolbar();
        upper.add(this.toolbar);
        this.header = this.createHeader();
        upper.add(this.header);
        this.textarea = this.createTextArea();
        this.textarea.setRightClickPopup(new TextAreaPopup());
        this.textarea.setHorizontalOffset(6);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(111, Toolkit.SHORTCUT_KEY_MASK);
        String ACTION_KEY = "COMMENT_UNCOMMENT_ALT";
        this.textarea.getInputMap().put(keyStroke, "COMMENT_UNCOMMENT_ALT");
        this.textarea.getActionMap().put("COMMENT_UNCOMMENT_ALT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCommentUncomment();
            }
        });
        this.textarea.addCaretListener(e -> this.updateEditorStatus());
        this.footer = this.createFooter();
        JPanel editorPanel = new JPanel(new BorderLayout());
        this.errorColumn = new MarkerColumn(this, this.textarea.getMinimumSize().height);
        editorPanel.add((Component)this.errorColumn, "East");
        this.textarea.setBounds(0, 0, this.errorColumn.getX() - 1, this.textarea.getHeight());
        editorPanel.add(this.textarea);
        upper.add(editorPanel);
        this.splitPane = new JSplitPane(0, upper, this.footer);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setBorder(null);
        UIManager.getDefaults().put("SplitPane.border", BorderFactory.createEmptyBorder());
        this.splitPane.setDividerSize(EditorStatus.HIGH);
        this.splitPane.setUI(new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                Editor.this.status = new EditorStatus(this, Editor.this);
                return Editor.this.status;
            }

            @Override
            public void finishDraggingTo(int location) {
                super.finishDraggingTo(location);
                if (location > this.splitPane.getMaximumDividerLocation()) {
                    this.splitPane.setDividerLocation(this.splitPane.getMaximumDividerLocation());
                }
            }
        });
        box.add(this.splitPane);
        contentPain.add(box);
        this.textarea.addCaretListener(new CaretListener(){
            String lastText;
            {
                this.lastText = Editor.this.textarea.getText();
            }

            @Override
            public void caretUpdate(CaretEvent e) {
                String newText = Editor.this.textarea.getText();
                if (this.lastText.equals(newText) && Editor.this.isDirectEdit() && !Editor.this.textarea.isOverwriteEnabled()) {
                    Editor.this.endTextEditHistory();
                }
                this.lastText = newText;
            }
        });
        this.textarea.addKeyListener(this.toolbar);
        contentPain.setTransferHandler(new FileDropHandler());
        this.updateTheme();
        this.pack();
        state.apply(this);
        int minWidth = Toolkit.zoom(Preferences.getInteger("editor.window.width.min"));
        int minHeight = Toolkit.zoom(Preferences.getInteger("editor.window.height.min"));
        this.setMinimumSize(new Dimension(minWidth, minHeight));
        this.applyPreferences();
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                Editor.this.textarea.requestFocusInWindow();
            }
        });
        this.handleOpenInternal(path);
        this.addWindowFocusListener(new ChangeDetector(this));
        this.setResizable(true);
        KeyStroke moveUpKeyStroke = KeyStroke.getKeyStroke(38, 512);
        String MOVE_UP_ACTION_KEY = "moveLinesUp";
        this.textarea.getInputMap(0).put(moveUpKeyStroke, "moveLinesUp");
        this.textarea.getActionMap().put("moveLinesUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleMoveLines(true);
            }
        });
        KeyStroke moveDownKeyStroke = KeyStroke.getKeyStroke(40, 512);
        String MOVE_DOWN_ACTION_KEY = "moveLinesDown";
        this.textarea.getInputMap(0).put(moveDownKeyStroke, "moveLinesDown");
        this.textarea.getActionMap().put("moveLinesDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.handleMoveLines(false);
            }
        });
    }

    protected JEditTextArea createTextArea() {
        return new JEditTextArea(new PdeTextAreaDefaults(), new PdeInputHandler(this));
    }

    public EditorFooter createFooter() {
        EditorFooter ef = new EditorFooter(this);
        this.console = new EditorConsole(this);
        ef.addPanel(this.console, Language.text("editor.footer.console"), "/lib/footer/console");
        return ef;
    }

    public void addErrorTable(EditorFooter ef) {
        JScrollPane scrollPane = new JScrollPane();
        this.errorTable = new ErrorTable(this);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setViewportView(this.errorTable);
        ef.addPanel(scrollPane, Language.text("editor.footer.errors"), "/lib/footer/error");
    }

    public EditorState getEditorState() {
        return this.state;
    }

    public Base getBase() {
        return this.base;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void repaintHeader() {
        this.header.repaint();
    }

    public void rebuildHeader() {
        this.header.rebuild();
    }

    public void rebuildModePopup() {
        this.modePopup = new JMenu();
        ButtonGroup modeGroup = new ButtonGroup();
        for (Mode m : this.base.getModeList()) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(m.getTitle());
            item.addActionListener(e -> {
                if (!this.base.changeMode(m)) {
                    this.reselectMode();
                }
            });
            this.modePopup.add(item);
            modeGroup.add(item);
            if (this.mode != m) continue;
            item.setSelected(true);
        }
        this.modePopup.addSeparator();
        JMenuItem manageModes = new JMenuItem(Language.text("toolbar.manage_modes"));
        manageModes.addActionListener(e -> ContributionManager.openModes());
        this.modePopup.add(manageModes);
        Toolkit.setMenuMnemsInside(this.modePopup);
    }

    private void reselectMode() {
        for (Component c : this.getModePopup().getComponents()) {
            if (!(c instanceof JRadioButtonMenuItem) || !((JRadioButtonMenuItem)c).getText().equals(this.mode.getTitle())) continue;
            ((JRadioButtonMenuItem)c).setSelected(true);
            break;
        }
    }

    public JPopupMenu getModePopup() {
        return this.modePopup.getPopupMenu();
    }

    public EditorConsole getConsole() {
        return this.console;
    }

    public EditorHeader createHeader() {
        return new EditorHeader(this);
    }

    public abstract EditorToolbar createToolbar();

    public EditorToolbar getToolbar() {
        return this.toolbar;
    }

    public void rebuildToolbar() {
        this.toolbar.rebuild();
        this.toolbar.revalidate();
    }

    public abstract Formatter createFormatter();

    protected void setDividerLocation(int pos) {
        this.splitPane.setDividerLocation(pos);
    }

    protected int getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    public void applyPreferences() {
        this.updateTheme();
    }

    public void updateTheme() {
        this.header.updateTheme();
        this.toolbar.updateTheme();
        this.textarea.updateTheme();
        this.errorColumn.updateTheme();
        this.status.updateTheme();
        this.console.updateTheme();
        this.footer.updateTheme();
        if (this.errorTable != null) {
            this.errorTable.updateTheme();
        }
        Color color = Theme.getColor("toolbar.gradient.top");
        this.spacer.setBackground(color);
        toolTipFont = Toolkit.getSansFont(Toolkit.zoom(9), 0);
        toolTipTextColor = Theme.get("errors.selection.fgcolor");
        toolTipWarningColor = Theme.get("errors.selection.warning.bgcolor");
        toolTipErrorColor = Theme.get("errors.selection.error.bgcolor");
        UIManager.put("RootPane.background", color);
        UIManager.put("TitlePane.embeddedForeground", Theme.getColor("editor.fgcolor"));
        this.getRootPane().updateUI();
        UIManager.put("RootPane.background", null);
        JPopupMenu popup = this.modePopup.getPopupMenu();
        popup.setBorder(new EmptyBorder(3, 0, 3, 0));
        popup.setBackground(Theme.getColor("mode.popup.enabled.bgcolor"));
        for (Component comp : this.modePopup.getMenuComponents()) {
            if (comp instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)comp;
                if (item.getUI() instanceof PdeMenuItemUI) {
                    ((PdeMenuItemUI)item.getUI()).updateTheme();
                    continue;
                }
                item.setUI(new PdeMenuItemUI("mode.popup"));
                continue;
            }
            if (!(comp instanceof JPopupMenu.Separator)) continue;
            comp.setForeground(Theme.getColor("mode.popup.disabled.fgcolor"));
        }
        this.repaint();
    }

    protected void buildMenuBar() {
        JMenuBar menubar = new JMenuBar();
        this.fileMenu = this.buildFileMenu();
        menubar.add(this.fileMenu);
        menubar.add(this.buildEditMenu());
        menubar.add(this.buildSketchMenu());
        JMenu modeMenu = this.buildModeMenu();
        if (modeMenu != null) {
            menubar.add(modeMenu);
        }
        this.toolsMenu = new JMenu(Language.text("menu.tools"));
        this.base.populateToolsMenu(this.toolsMenu);
        menubar.add(this.toolsMenu);
        JMenu helpMenu = this.buildHelpMenu();
        if (Platform.isMacOS()) {
            helpMenu.setText(helpMenu.getText() + " ");
        }
        menubar.add(helpMenu);
        this.updateDevelopMenu(menubar);
        Toolkit.setMenuMnemonics(menubar);
        this.setJMenuBar(menubar);
    }

    public abstract JMenu buildFileMenu();

    protected JMenu buildFileMenu(JMenuItem[] exportItems) {
        JMenu fileMenu = new JMenu(Language.text("menu.file"));
        JMenuItem item = Toolkit.newJMenuItem(Language.text("menu.file.new"), 78);
        item.addActionListener(e -> this.base.handleNew());
        fileMenu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.file.open"), 79);
        item.addActionListener(e -> this.base.handleOpenPrompt());
        fileMenu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.sketchbook"), 75);
        item.addActionListener(e -> this.base.showSketchbookFrame());
        fileMenu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.examples"), 79);
        item.addActionListener(e -> this.mode.showExamplesFrame());
        fileMenu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.file.close"), 87);
        item.addActionListener(e -> this.base.handleClose(this, false));
        fileMenu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.file.save"), 83);
        item.addActionListener(e -> this.handleSave(false));
        fileMenu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.save_as"), 83);
        item.addActionListener(e -> this.handleSaveAs());
        fileMenu.add(item);
        if (exportItems != null) {
            for (JMenuItem ei : exportItems) {
                fileMenu.add(ei);
            }
        }
        fileMenu.addSeparator();
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.page_setup"), 80);
        item.addActionListener(e -> this.handlePageSetup());
        fileMenu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.file.print"), 80);
        item.addActionListener(e -> this.handlePrint());
        fileMenu.add(item);
        if (!Platform.isMacOS()) {
            fileMenu.addSeparator();
            item = Toolkit.newJMenuItem(Language.text("menu.file.preferences"), 44);
            item.addActionListener(e -> this.base.handlePrefs());
            fileMenu.add(item);
            fileMenu.addSeparator();
            item = Toolkit.newJMenuItem(Language.text("menu.file.quit"), 81);
            item.addActionListener(e -> this.base.handleQuit());
            fileMenu.add(item);
        }
        return fileMenu;
    }

    protected JMenu buildEditMenu() {
        JMenu menu = new JMenu(Language.text("menu.edit"));
        this.undoAction = new UndoAction();
        this.undoItem = Toolkit.newJMenuItem(this.undoAction, 90);
        menu.add(this.undoItem);
        this.redoAction = new RedoAction();
        this.redoItem = new JMenuItem(this.redoAction);
        this.redoItem.setAccelerator(Toolkit.getKeyStrokeExt("menu.edit.redo"));
        menu.add(this.redoItem);
        menu.addSeparator();
        this.cutAction = new CutAction();
        JMenuItem item = Toolkit.newJMenuItem(this.cutAction, 88);
        this.editMenuUpdatable.add(this.cutAction);
        menu.add(item);
        this.copyAction = new CopyAction();
        item = Toolkit.newJMenuItem(this.copyAction, 67);
        this.editMenuUpdatable.add(this.copyAction);
        menu.add(item);
        this.copyAsHtmlAction = new CopyAsHtmlAction();
        item = Toolkit.newJMenuItemShift(this.copyAsHtmlAction, 67);
        this.editMenuUpdatable.add(this.copyAsHtmlAction);
        menu.add(item);
        this.pasteAction = new PasteAction();
        item = Toolkit.newJMenuItem(this.pasteAction, 86);
        this.editMenuUpdatable.add(this.pasteAction);
        menu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.edit.select_all"), 65);
        item.addActionListener(e -> this.textarea.selectAll());
        menu.add(item);
        menu.addSeparator();
        item = Toolkit.newJMenuItem(Language.text("menu.edit.auto_format"), 84);
        item.addActionListener(e -> this.handleAutoFormat());
        menu.add(item);
        item = Toolkit.newJMenuItemExt("menu.edit.comment_uncomment");
        item.addActionListener(e -> this.handleCommentUncomment());
        menu.add(item);
        item = Toolkit.newJMenuItemExt("menu.edit.increase_indent");
        item.addActionListener(e -> this.handleIndentOutdent(true));
        menu.add(item);
        item = Toolkit.newJMenuItemExt("menu.edit.decrease_indent");
        item.addActionListener(e -> this.handleIndentOutdent(false));
        menu.add(item);
        item = Toolkit.newJMenuItemExt("menu.edit.increase_font");
        item.addActionListener(e -> this.modifyFontSize(true));
        menu.add(item);
        item = Toolkit.newJMenuItemExt("menu.edit.decrease_font");
        item.addActionListener(e -> this.modifyFontSize(false));
        menu.add(item);
        menu.addSeparator();
        item = Toolkit.newJMenuItem(Language.text("menu.edit.find"), 70);
        item.addActionListener(e -> {
            String selection;
            if (this.find == null) {
                this.find = new FindReplace(this);
            }
            if ((selection = this.getSelectedText()) != null && selection.length() != 0 && !selection.contains("\n")) {
                this.find.setFindText(selection);
            }
            this.find.setVisible(true);
        });
        menu.add(item);
        this.findNextAction = new FindNextAction();
        item = Toolkit.newJMenuItem(this.findNextAction, 71);
        this.editMenuUpdatable.add(this.findNextAction);
        menu.add(item);
        this.findPreviousAction = new FindPreviousAction();
        item = Toolkit.newJMenuItemShift(this.findPreviousAction, 71);
        this.editMenuUpdatable.add(this.findPreviousAction);
        menu.add(item);
        SelectionForFindAction action = new SelectionForFindAction();
        item = Toolkit.newJMenuItem(action, 69);
        this.editMenuUpdatable.add(action);
        menu.add(item);
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
                for (UpdatableAction a : Editor.this.editMenuUpdatable) {
                    a.setEnabled(true);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                for (UpdatableAction a : Editor.this.editMenuUpdatable) {
                    a.setEnabled(true);
                }
            }

            @Override
            public void menuSelected(MenuEvent e) {
                for (UpdatableAction a : Editor.this.editMenuUpdatable) {
                    a.updateState();
                }
            }
        });
        return menu;
    }

    protected void modifyFontSize(boolean increase) {
        int fontSize = Preferences.getInteger("editor.font.size");
        fontSize += increase ? 1 : -1;
        fontSize = Math.max(5, Math.min(72, fontSize));
        Preferences.setInteger("editor.font.size", fontSize);
        for (Editor editor : this.base.getEditors()) {
            editor.applyPreferences();
        }
        Preferences.save();
    }

    public abstract JMenu buildSketchMenu();

    protected JMenu buildSketchMenu(JMenuItem[] runItems) {
        this.sketchMenu = new JMenu(Language.text("menu.sketch"));
        for (JMenuItem mi : runItems) {
            this.sketchMenu.add(mi);
        }
        this.sketchMenu.addSeparator();
        this.sketchMenu.add(this.mode.getImportMenu());
        JMenuItem item = Toolkit.newJMenuItem(Language.text("menu.sketch.show_sketch_folder"), 75);
        item.addActionListener(e -> {
            if (this.sketch.isUntitled() || this.sketch.isReadOnly()) {
                Messages.showMessage("Save First", "Please first save the sketch.");
            } else {
                Platform.openFolder(this.sketch.getFolder());
            }
        });
        this.sketchMenu.add(item);
        item.setEnabled(Platform.openFolderAvailable());
        item = new JMenuItem(Language.text("menu.sketch.add_file"));
        item.addActionListener(e -> {
            if (this.sketch.isUntitled() || this.sketch.isReadOnly()) {
                Messages.showMessage("Save First", "Please first save the sketch.");
            } else {
                this.sketch.handleAddFile();
            }
        });
        this.sketchMenu.add(item);
        if (runItems != null && runItems.length != 0) {
            this.sketchMenu.addSeparator();
        }
        this.sketchMenu.addMenuListener(new MenuListener(){
            final Map<Sketch, JMenuItem> itemMap = new HashMap<Sketch, JMenuItem>();

            @Override
            public void menuSelected(MenuEvent event) {
                HashSet<JMenuItem> unseen = new HashSet<JMenuItem>(this.itemMap.values());
                for (Editor editor : Editor.this.base.getEditors()) {
                    Sketch sketch = editor.getSketch();
                    JMenuItem item = this.itemMap.get(sketch);
                    if (item != null) {
                        unseen.remove(item);
                    } else {
                        item = new JCheckBoxMenuItem();
                        Editor.this.sketchMenu.add(item);
                        this.itemMap.put(sketch, item);
                    }
                    item.setSelected(sketch.equals(Editor.this.getSketch()));
                    Object name = sketch.getName();
                    if (!editor.getMode().equals(Editor.this.base.getDefaultMode())) {
                        name = (String)name + " (" + editor.getMode().getTitle() + ")";
                    }
                    item.setText((String)name);
                    item.addActionListener(e -> {
                        editor.setState(0);
                        editor.setVisible(true);
                        editor.toFront();
                    });
                }
                for (JMenuItem item : unseen) {
                    Editor.this.sketchMenu.remove(item);
                    Sketch s = this.findSketch(item);
                    if (s == null) continue;
                    this.itemMap.remove(s);
                }
            }

            Sketch findSketch(JMenuItem item) {
                for (Map.Entry<Sketch, JMenuItem> e : this.itemMap.entrySet()) {
                    if (item != e.getValue()) continue;
                    return e.getKey();
                }
                return null;
            }

            @Override
            public void menuDeselected(MenuEvent event) {
            }

            @Override
            public void menuCanceled(MenuEvent event) {
            }
        });
        return this.sketchMenu;
    }

    public abstract void handleImportLibrary(String var1);

    public void librariesChanged() {
    }

    public void codeFolderChanged() {
    }

    public void sketchChanged() {
    }

    public JMenu getToolMenu() {
        return this.toolsMenu;
    }

    public void clearToolMenu() {
        this.toolsMenu.removeAll();
        System.gc();
    }

    public void setUpdatesAvailable(int count) {
        this.footer.setUpdateCount(count);
    }

    public JMenu buildModeMenu() {
        return null;
    }

    public abstract JMenu buildHelpMenu();

    public void buildDevelopMenu() {
        this.developMenu = new JMenu(Language.text("menu.develop"));
        JMenuItem updateTrigger = new JMenuItem(Language.text("menu.develop.check_for_updates"));
        updateTrigger.addActionListener(e -> {
            Preferences.unset("update.last");
            new UpdateCheck(this.base);
        });
        this.developMenu.add(updateTrigger);
    }

    public void updateDevelopMenu() {
        this.updateDevelopMenu(null);
    }

    void updateDevelopMenu(JMenuBar menu) {
        if (menu == null) {
            menu = this.getJMenuBar();
        }
        if (this.developMenu == null) {
            this.buildDevelopMenu();
        }
        if (Base.DEBUG) {
            menu.add(this.developMenu);
        } else {
            menu.remove(this.developMenu);
        }
    }

    public void showReference(String filename) {
        File file = new File(this.mode.getReferenceFolder(), filename);
        this.showReferenceFile(file);
    }

    public void showReferenceFile(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Platform.openURL(file.toURI().toString());
    }

    public static void showChanges() {
        if (!Base.isCommandLine()) {
            Platform.openURL("https://github.com/processing/processing4/wiki/Changes-in-4.0");
        }
    }

    public static int getProblemEditorLineStop(Problem problem, int lineStart, int lineStop) {
        int stopOffset = problem.getStopOffset();
        if (stopOffset == -1) {
            stopOffset = lineStop - lineStart;
        }
        return stopOffset;
    }

    public Sketch getSketch() {
        return this.sketch;
    }

    public JEditTextArea getTextArea() {
        return this.textarea;
    }

    public PdeTextArea getPdeTextArea() {
        return this.textarea instanceof PdeTextArea ? (PdeTextArea)this.textarea : null;
    }

    public String getText() {
        return this.textarea.getText();
    }

    public String getText(int start, int stop) {
        return this.textarea.getText(start, stop - start);
    }

    public void setText(String what) {
        this.startCompoundEdit();
        this.textarea.setText(what);
        this.stopCompoundEdit();
    }

    public void insertText(String what) {
        this.startCompoundEdit();
        int caret = this.getCaretOffset();
        this.setSelection(caret, caret);
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public String getSelectedText() {
        return this.textarea.getSelectedText();
    }

    public void setSelectedText(String what) {
        this.textarea.setSelectedText(what);
    }

    public void setSelectedText(String what, boolean ever) {
        this.textarea.setSelectedText(what, ever);
    }

    public void setSelection(int start, int stop) {
        start = PApplet.constrain((int)start, (int)0, (int)this.textarea.getDocumentLength());
        stop = PApplet.constrain((int)stop, (int)0, (int)this.textarea.getDocumentLength());
        this.textarea.select(start, stop);
    }

    public int getCaretOffset() {
        return this.textarea.getCaretPosition();
    }

    public boolean isSelectionActive() {
        return this.textarea.isSelectionActive();
    }

    public int getSelectionStart() {
        return this.textarea.getSelectionStart();
    }

    public int getSelectionStop() {
        return this.textarea.getSelectionStop();
    }

    public String getLineText(int line) {
        return this.textarea.getLineText(line);
    }

    public void setLineText(int line, String what) {
        this.startCompoundEdit();
        this.textarea.select(this.getLineStartOffset(line), this.getLineStopOffset(line));
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public int getLineStartOffset(int line) {
        return this.textarea.getLineStartOffset(line);
    }

    public int getLineStopOffset(int line) {
        return this.textarea.getLineStopOffset(line);
    }

    public int getLineCount() {
        return this.textarea.getLineCount();
    }

    public void startCompoundEdit() {
        this.endTextEditHistory();
        this.compoundEdit = new CompoundEdit();
        this.caretUndoStack.push(this.textarea.getCaretPosition());
        this.caretRedoStack.clear();
    }

    public void stopCompoundEdit() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.undo.addEdit(this.compoundEdit);
            this.undoAction.updateUndoState();
            this.redoAction.updateRedoState();
            this.compoundEdit = null;
        }
    }

    public int getScrollPosition() {
        return this.textarea.getVerticalScrollPosition();
    }

    public void setCode(SketchCode code) {
        SyntaxDocument document = (SyntaxDocument)code.getDocument();
        if (document == null) {
            document = new SyntaxDocument(){

                @Override
                public void beginCompoundEdit() {
                    if (Editor.this.compoundEdit == null) {
                        Editor.this.startCompoundEdit();
                    }
                    super.beginCompoundEdit();
                }

                @Override
                public void endCompoundEdit() {
                    Editor.this.stopCompoundEdit();
                    super.endCompoundEdit();
                }
            };
            code.setDocument(document);
            document.setTokenMarker(this.mode.getTokenMarker(code));
            try {
                document.insertString(0, code.getProgram(), null);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            document.addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    if (Editor.this.isInserting && Editor.this.isDirectEdit() && !Editor.this.textarea.isOverwriteEnabled()) {
                        Editor.this.endTextEditHistory();
                    }
                    Editor.this.isInserting = false;
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (!Editor.this.isInserting && !Editor.this.textarea.isOverwriteEnabled() && Editor.this.isDirectEdit()) {
                        Editor.this.endTextEditHistory();
                    }
                    if (!Editor.this.textarea.isOverwriteEnabled()) {
                        Editor.this.isInserting = true;
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    Editor.this.endTextEditHistory();
                }
            });
            document.addUndoableEditListener(e -> {
                if (this.endUndoEvent != null) {
                    this.endUndoEvent.cancel();
                    this.endUndoEvent = null;
                    this.startTimerEvent();
                }
                if (this.compoundEdit == null) {
                    this.startCompoundEdit();
                    this.startTimerEvent();
                }
                this.compoundEdit.addEdit(e.getEdit());
                this.undoAction.updateUndoState();
                this.redoAction.updateRedoState();
            });
        }
        this.textarea.setDocument(document, code.getSelectionStart(), code.getSelectionStop(), code.getScrollPosition());
        this.textarea.requestFocusInWindow();
        this.endTextEditHistory();
        this.undo = code.getUndo();
        this.caretUndoStack = code.getCaretUndoStack();
        this.caretRedoStack = code.getCaretRedoStack();
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    boolean isDirectEdit() {
        return this.endUndoEvent != null;
    }

    void startTimerEvent() {
        this.endUndoEvent = new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(Editor.this::endTextEditHistory);
            }
        };
        this.timer.schedule(this.endUndoEvent, 3000L);
        this.timer.purge();
    }

    void endTextEditHistory() {
        if (this.endUndoEvent != null) {
            this.endUndoEvent.cancel();
            this.endUndoEvent = null;
        }
        this.stopCompoundEdit();
    }

    @Override
    public void removeNotify() {
        this.timer.cancel();
        super.removeNotify();
    }

    public void handleCut() {
        this.textarea.cut();
        this.sketch.setModified(true);
    }

    public void handleCopy() {
        this.textarea.copy();
    }

    public void handleCopyAsHTML() {
        this.textarea.copyAsHTML();
        this.statusNotice(Language.text("editor.status.copy_as_html"));
    }

    public void handlePaste() {
        this.textarea.paste();
        this.sketch.setModified(true);
    }

    public void handleSelectAll() {
        this.textarea.selectAll();
    }

    public void handleAutoFormat() {
        String source = this.getText();
        try {
            String formattedText = this.createFormatter().format(source);
            int selectionEnd = this.getSelectionStop();
            if (formattedText.length() < selectionEnd - 1) {
                selectionEnd = formattedText.length() - 1;
            }
            if (formattedText.equals(source)) {
                this.statusNotice(Language.text("editor.status.autoformat.no_changes"));
            } else {
                this.startCompoundEdit();
                int scrollPos = this.textarea.getVerticalScrollPosition();
                this.textarea.setText(formattedText);
                this.setSelection(selectionEnd, selectionEnd);
                if (scrollPos != this.textarea.getVerticalScrollPosition()) {
                    this.textarea.setVerticalScrollPosition(scrollPos);
                }
                this.stopCompoundEdit();
                this.sketch.setModified(true);
                this.statusNotice(Language.text("editor.status.autoformat.finished"));
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
    }

    public abstract String getCommentPrefix();

    protected void handleCommentUncomment() {
        this.startCompoundEdit();
        String prefix = this.getCommentPrefix();
        int prefixLen = prefix.length();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        boolean commented = true;
        for (int i = startLine; commented && i <= stopLine; ++i) {
            String lineText = this.textarea.getLineText(i).trim();
            if (lineText.length() == 0) continue;
            commented = lineText.startsWith(prefix);
        }
        int lso = Math.abs(this.textarea.getLineStartNonWhiteSpaceOffset(startLine) - this.textarea.getLineStartOffset(startLine));
        if (!commented) {
            for (int line = startLine + 1; line <= stopLine; ++line) {
                String lineText = this.textarea.getLineText(line);
                if (lineText.trim().length() == 0) continue;
                int so = Math.abs(this.textarea.getLineStartNonWhiteSpaceOffset(line) - this.textarea.getLineStartOffset(line));
                lso = Math.min(lso, so);
            }
        }
        for (int line = startLine; line <= stopLine; ++line) {
            int location = this.textarea.getLineStartNonWhiteSpaceOffset(line);
            String lineText = this.textarea.getLineText(line);
            if (lineText.trim().length() == 0) continue;
            if (commented) {
                this.textarea.select(location, location + prefixLen);
                this.textarea.setSelectedText("");
                continue;
            }
            location = this.textarea.getLineStartOffset(line) + lso;
            this.textarea.select(location, location);
            this.textarea.setSelectedText(prefix);
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
        this.sketch.setModified(true);
    }

    public void handleIndent() {
        this.handleIndentOutdent(true);
    }

    public void handleOutdent() {
        this.handleIndentOutdent(false);
    }

    public void handleIndentOutdent(boolean indent) {
        int tabSize = Preferences.getInteger("editor.tabs.size");
        String tabString = EMPTY.substring(0, tabSize);
        this.startCompoundEdit();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        for (int line = startLine; line <= stopLine; ++line) {
            int location = this.textarea.getLineStartOffset(line);
            if (indent) {
                this.textarea.select(location, location);
                this.textarea.setSelectedText(tabString);
                continue;
            }
            int last = Math.min(location + tabSize, this.textarea.getDocumentLength());
            this.textarea.select(location, last);
            if (!tabString.equals(this.textarea.getSelectedText())) continue;
            this.textarea.setSelectedText("");
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
        this.sketch.setModified(true);
    }

    public void handleMoveLines(boolean moveUp) {
        int newSelectionEnd;
        int newSelectionStart;
        int replacedLine;
        int stopLine;
        this.startCompoundEdit();
        boolean isSelected = false;
        if (this.textarea.isSelectionActive()) {
            isSelected = true;
        }
        int caretPos = this.textarea.getCaretPosition();
        int currentLine = this.textarea.getCaretLine();
        int lineStart = this.textarea.getLineStartOffset(currentLine);
        int column = caretPos - lineStart;
        int startLine = this.textarea.getSelectionStartLine();
        if (startLine != (stopLine = this.textarea.getSelectionStopLine()) && this.textarea.getSelectionStop() == this.textarea.getLineStartOffset(stopLine)) {
            --stopLine;
        }
        int n = replacedLine = moveUp ? startLine - 1 : stopLine + 1;
        if (replacedLine < 0 || replacedLine >= this.textarea.getLineCount()) {
            this.stopCompoundEdit();
            return;
        }
        String source = this.textarea.getText();
        int replaceStart = this.textarea.getLineStartOffset(replacedLine);
        int replaceEnd = this.textarea.getLineStopOffset(replacedLine);
        if (replaceEnd > source.length()) {
            replaceEnd = source.length();
        }
        int selectionStart = this.textarea.getLineStartOffset(startLine);
        int selectionEnd = this.textarea.getLineStopOffset(stopLine);
        if (selectionEnd > source.length()) {
            selectionEnd = source.length();
        }
        Object replacedText = source.substring(replaceStart, replaceEnd);
        Object selectedText = source.substring(selectionStart, selectionEnd);
        if (replacedLine == this.textarea.getLineCount() - 1) {
            replacedText = (String)replacedText + "\n";
            selectedText = ((String)selectedText).substring(0, Math.max(0, ((String)selectedText).length() - 1));
        } else if (stopLine == this.textarea.getLineCount() - 1) {
            selectedText = (String)selectedText + "\n";
            replacedText = ((String)replacedText).substring(0, Math.max(0, ((String)replacedText).length() - 1));
        }
        if (moveUp) {
            this.textarea.select(selectionStart, selectionEnd);
            this.textarea.setSelectedText((String)replacedText);
            this.textarea.select(replaceStart, replaceEnd);
            this.textarea.setSelectedText((String)selectedText);
            newSelectionStart = this.textarea.getLineStartOffset(startLine - 1);
            newSelectionEnd = this.textarea.getLineStopOffset(stopLine - 1);
        } else {
            this.textarea.select(replaceStart, replaceEnd);
            this.textarea.setSelectedText((String)selectedText);
            this.textarea.select(selectionStart, selectionEnd);
            this.textarea.setSelectedText((String)replacedText);
            newSelectionStart = this.textarea.getLineStartOffset(startLine + 1);
            newSelectionEnd = stopLine + 1 < this.textarea.getLineCount() ? Math.min(this.textarea.getLineStopOffset(stopLine + 1), source.length()) : this.textarea.getLineStopOffset(stopLine);
        }
        this.stopCompoundEdit();
        if (isSelected) {
            SwingUtilities.invokeLater(() -> this.textarea.select(newSelectionStart, newSelectionEnd - 1));
        } else if (replacedLine >= 0 && replacedLine < this.textarea.getLineCount()) {
            int replacedLineStart = this.textarea.getLineStartOffset(replacedLine);
            int replacedLineEnd = this.textarea.getLineStopOffset(replacedLine);
            int newCaretPos = Math.min(replacedLineStart + column, replacedLineEnd - 1);
            SwingUtilities.invokeLater(() -> this.textarea.setCaretPosition(newCaretPos));
        }
    }

    public static boolean checkParen(char[] array2, int index, int stop) {
        block4: while (index < stop) {
            switch (array2[index]) {
                case '(': {
                    return true;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++index;
                    continue block4;
                }
            }
            return false;
        }
        return false;
    }

    protected boolean functionable(char c) {
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    protected String referenceCheck(boolean selectIfFound) {
        int start = this.textarea.getSelectionStart();
        int stop = this.textarea.getSelectionStop();
        if (stop < start) {
            int temp = stop;
            stop = start;
            start = temp;
        }
        char[] c = this.textarea.getText().toCharArray();
        if (start == stop) {
            while (start > 0 && this.functionable(c[start - 1])) {
                --start;
            }
            while (stop < c.length && this.functionable(c[stop])) {
                ++stop;
            }
        }
        Object text = new String(c, start, stop - start).trim();
        if (Editor.checkParen(c, stop, c.length)) {
            text = (String)text + "_";
        }
        String ref = this.mode.lookupReference((String)text);
        if (selectIfFound) {
            this.textarea.select(start, stop);
        }
        return ref;
    }

    protected void handleFindReference() {
        String ref = this.referenceCheck(true);
        if (ref != null) {
            this.showReference(ref + ".html");
        } else {
            String text = this.textarea.getSelectedText();
            if (text == null) {
                this.statusNotice(Language.text("editor.status.find_reference.select_word_first"));
            } else {
                this.statusNotice(Language.interpolate("editor.status.find_reference.not_available", text.trim()));
            }
        }
    }

    public void setSketchLocation(Point p) {
        this.sketchWindowLocation = p;
    }

    public Point getSketchLocation() {
        return this.sketchWindowLocation;
    }

    public boolean isDebuggerEnabled() {
        return false;
    }

    public void toggleBreakpoint(int lineIndex) {
    }

    public boolean checkModified() {
        if (!this.sketch.isModified()) {
            return true;
        }
        this.toFront();
        if (!Platform.isMacOS()) {
            String prompt = Language.interpolate("close.unsaved_changes", this.sketch.getName());
            int result = JOptionPane.showConfirmDialog(this, prompt, Language.text("menu.file.close"), 1, 3);
            if (result == 0) {
                return this.handleSave(true);
            }
            if (result == 1) {
                return true;
            }
            if (result == 2 || result == -1) {
                return false;
            }
            throw new IllegalStateException();
        }
        String tier1 = Language.interpolate("save.title", this.sketch.getName());
        String tier2 = Language.text("save.hint");
        JOptionPane pane = new JOptionPane(Toolkit.formatMessage(tier1, tier2), 3);
        Object[] options = new String[]{Language.text("save.btn.save"), Language.text("prompt.cancel"), Language.text("save.btn.dont_save")};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", 2);
        JDialog dialog = pane.createDialog(this, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return this.handleSave(true);
        }
        return result == options[2];
    }

    protected void handleOpenInternal(String path) throws EditorException {
        try {
            this.sketch = new Sketch(path, this);
        }
        catch (IOException e) {
            throw new EditorException("Could not create the sketch.", e);
        }
        this.header.rebuild();
        this.updateTitle();
    }

    public void updateTitle() {
        this.setTitle(this.sketch.getName());
        if (!this.sketch.isUntitled()) {
            this.getRootPane().putClientProperty("Window.documentFile", this.sketch.getFolder());
        } else {
            this.getRootPane().putClientProperty("Window.documentFile", null);
        }
    }

    public boolean handleSave(boolean immediately) {
        if (this.sketch.isUntitled()) {
            return this.handleSaveAs();
        }
        if (immediately) {
            this.handleSaveImpl();
        } else {
            EventQueue.invokeLater(this::handleSaveImpl);
        }
        return true;
    }

    protected void handleSaveImpl() {
        this.statusNotice(Language.text("editor.status.saving"));
        try {
            if (this.sketch.save()) {
                this.statusNotice(Language.text("editor.status.saving.done"));
            } else {
                this.statusEmpty();
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
    }

    public boolean handleSaveAs() {
        this.statusNotice(Language.text("editor.status.saving"));
        try {
            if (this.sketch.saveAs()) {
                return true;
            }
            this.statusNotice(Language.text("editor.status.saving.canceled"));
        }
        catch (Exception e) {
            this.statusError(e);
        }
        return false;
    }

    public void handlePageSetup() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void handlePrint() {
        this.statusNotice(Language.text("editor.status.printing"));
        StringBuilder html = new StringBuilder("<html><body>");
        for (SketchCode tab : this.sketch.getCode()) {
            html.append("<b>");
            html.append(tab.getPrettyName());
            html.append("</b><br>");
            html.append(this.textarea.getTextAsHtml((SyntaxDocument)tab.getDocument()));
            html.append("<br>");
        }
        html.setLength(html.length() - 4);
        html.append("</body></html>");
        JTextPane jtp = new JTextPane();
        jtp.setEditorKit(new HTMLEditorKit(){

            @Override
            public ViewFactory getViewFactory() {
                return new HTMLEditorKit.HTMLFactory(){

                    @Override
                    public View create(Element e) {
                        View v = super.create(e);
                        if (!(v instanceof ParagraphView)) {
                            return v;
                        }
                        return new ParagraphView(e){

                            @Override
                            protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
                                r = super.calculateMinorAxisRequirements(axis, r);
                                r.minimum = 1;
                                return r;
                            }
                        };
                    }
                };
            }
        });
        jtp.setFont(new Font(Preferences.get("editor.font.family"), 0, 10));
        jtp.setText(html.toString().replace("\n", "<br>").replaceAll("(?<!&nbsp;)&nbsp;", " "));
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat != null) {
            this.printerJob.setPrintable(jtp.getPrintable(null, null), this.pageFormat);
        } else {
            this.printerJob.setPrintable(jtp.getPrintable(null, null));
        }
        this.printerJob.setJobName(this.sketch.getCurrentCode().getPrettyName());
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
                this.statusNotice(Language.text("editor.status.printing.done"));
            }
            catch (PrinterException pe) {
                this.statusError(Language.text("editor.status.printing.error"));
                pe.printStackTrace();
            }
        } else {
            this.statusNotice(Language.text("editor.status.printing.canceled"));
        }
    }

    public void prepareRun() {
        this.internalCloseRunner();
        this.statusEmpty();
        int headPadding = Preferences.getInteger("console.head_padding");
        for (int i = 0; i < headPadding; ++i) {
            this.console.message("\n", false);
        }
        if (Preferences.getBoolean("console.auto_clear")) {
            this.console.clear();
        }
        this.sketch.ensureExistence();
        for (SketchCode sc : this.sketch.getCode()) {
            if (sc.getDocument() == null) continue;
            try {
                sc.setProgram(sc.getDocumentText());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public abstract void internalCloseRunner();

    public abstract void deactivateRun();

    public ErrorTable getErrorTable() {
        return this.errorTable;
    }

    public void errorTableClick(Object item) {
        this.highlight((Problem)item);
    }

    public void errorTableDoubleClick(Object item) {
    }

    public void updateErrorToggle(boolean hasErrors) {
        if (this.errorTable != null) {
            this.footer.setNotification(this.errorTable.getParent(), hasErrors);
        }
    }

    @Override
    public void statusError(String what) {
        this.status.error(what);
    }

    @Override
    public void statusError(Exception e) {
        String mess;
        if (e instanceof SketchException) {
            SketchException re = (SketchException)e;
            System.err.println(re.getMessage());
            if (re.hasCodeIndex()) {
                this.sketch.setCurrentCode(re.getCodeIndex());
            }
            if (re.hasCodeLine()) {
                int line = re.getCodeLine();
                if (line >= this.textarea.getLineCount() && this.textarea.getLineText(line = this.textarea.getLineCount() - 1).length() == 0) {
                    --line;
                }
                if (line < 0 || line >= this.textarea.getLineCount()) {
                    System.err.println("Bad error line: " + line);
                } else {
                    this.textarea.select(this.textarea.getLineStartOffset(line), this.textarea.getLineStopOffset(line) - 1);
                }
            }
        } else {
            e.printStackTrace();
        }
        if ((mess = e.getMessage()) != null) {
            String illState;
            String illString;
            String rxString;
            String javaLang = "java.lang.";
            if (mess.indexOf(javaLang) == 0) {
                mess = mess.substring(javaLang.length());
            }
            if (mess.startsWith(rxString = "RuntimeException: ")) {
                mess = mess.substring(rxString.length());
            }
            if (mess.startsWith(illString = "IllegalArgumentException: ")) {
                mess = mess.substring(illString.length());
            }
            if (mess.startsWith(illState = "IllegalStateException: ")) {
                mess = mess.substring(illState.length());
            }
            this.statusError(mess);
        }
    }

    @Override
    public void statusNotice(String msg) {
        if (msg == null) {
            new IllegalArgumentException("This code called statusNotice(null)").printStackTrace();
            msg = "";
        }
        this.status.notice(msg);
    }

    public void clearNotice(String msg) {
        if (this.status.message.equals(msg)) {
            this.statusEmpty();
        }
    }

    public String getStatusMessage() {
        return this.status.message;
    }

    public int getStatusMode() {
        return this.status.mode;
    }

    public void statusEmpty() {
        this.status.empty();
    }

    public void statusMessage(String message, int type) {
        if (EventQueue.isDispatchThread()) {
            this.status.message(message, type);
        } else {
            EventQueue.invokeLater(() -> this.statusMessage(message, type));
        }
    }

    @Override
    public void startIndeterminate() {
        this.status.startIndeterminate();
    }

    @Override
    public void stopIndeterminate() {
        this.status.stopIndeterminate();
    }

    @Override
    public void statusHalt() {
    }

    @Override
    public boolean isHalted() {
        return false;
    }

    public void setProblemList(List<Problem> problems) {
        this.problems = problems;
        boolean hasErrors = problems.stream().anyMatch(Problem::isError);
        this.updateErrorTable(problems);
        this.errorColumn.updateErrorPoints(problems);
        this.textarea.repaint();
        this.updateErrorToggle(hasErrors);
        this.updateEditorStatus();
    }

    public void updateErrorTable(List<Problem> problems) {
        if (this.errorTable != null) {
            this.errorTable.clearRows();
            for (Problem p : problems) {
                String message = p.getMessage();
                this.errorTable.addRow(p, message, this.sketch.getCode(p.getTabIndex()).getPrettyName(), Integer.toString(p.getLineNumber() + 1));
            }
        }
    }

    public void highlight(Problem p) {
        if (p == null) {
            return;
        }
        int tabIndex = p.getTabIndex();
        this.sketch.setCurrentCode(tabIndex);
        int lineNumber = p.getLineNumber();
        int lineStart = this.textarea.getLineStartOffset(lineNumber);
        int lineEnd = this.textarea.getLineStopOffset(lineNumber);
        int tabToStartOffset = lineStart + p.getStartOffset();
        int lineStopOffset = Editor.getProblemEditorLineStop(p, lineStart, lineEnd);
        int tabToStopOffset = lineStart + lineStopOffset;
        this.highlight(tabIndex, tabToStartOffset, tabToStopOffset);
    }

    public void highlight(int tabIndex, int startOffset, int stopOffset) {
        this.toFront();
        this.sketch.setCurrentCode(tabIndex);
        int length = this.textarea.getDocumentLength();
        startOffset = PApplet.constrain((int)startOffset, (int)0, (int)length);
        stopOffset = PApplet.constrain((int)stopOffset, (int)0, (int)length);
        this.textarea.select(startOffset, stopOffset);
        this.textarea.scrollToCaret();
        this.repaint();
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    public void updateEditorStatus() {
        Problem problem = this.findProblem(this.textarea.getCaretLine());
        if (problem != null) {
            int type = problem.isError() ? 2 : 4;
            this.statusMessage(problem.getMessage(), type);
        } else {
            switch (this.getStatusMode()) {
                case 2: 
                case 4: {
                    this.statusEmpty();
                }
            }
        }
    }

    protected Problem findProblem(int line) {
        List<Problem> problems = this.findProblems(line);
        for (Problem p : problems) {
            if (!p.isError()) continue;
            return p;
        }
        return problems.isEmpty() ? null : problems.get(0);
    }

    public List<Problem> findProblems(int line) {
        int currentTab = this.getSketch().getCurrentCodeIndex();
        return this.problems.stream().filter(p -> p.getTabIndex() == currentTab).filter(p -> {
            int pStartLine = p.getLineNumber();
            int lineOffset = this.textarea.getLineStartOffset(pStartLine);
            int stopOffset = p.getStopOffset();
            int pEndOffset = lineOffset + (stopOffset == -1 ? 0 : stopOffset);
            int pEndLine = this.textarea.getLineOfOffset(pEndOffset);
            return line >= pStartLine && line <= pEndLine;
        }).collect(Collectors.toList());
    }

    public void statusToolTip(JComponent comp, String message, boolean error) {
        int m = Toolkit.zoom(5);
        String css = "margin: 0 -3 0 -3;" + String.format("padding: %d %d %d %d; ", m, m * 2, m, m * 2) + "background: " + (error ? toolTipErrorColor : toolTipWarningColor) + ";color: " + toolTipTextColor + ";font-family: " + toolTipFont.getFontName() + ", sans-serif;font-size: " + toolTipFont.getSize() + "px;";
        String content = "<html> <div style='" + css + "'>" + message + "</div> </html>";
        comp.setToolTipText(content);
    }

    class TextAreaPopup
    extends JPopupMenu {
        JMenuItem cutItem = new JMenuItem(Language.text("menu.edit.cut"));
        JMenuItem copyItem;
        JMenuItem discourseItem;
        JMenuItem pasteItem;
        JMenuItem referenceItem;

        public TextAreaPopup() {
            this.cutItem.addActionListener(e -> Editor.this.handleCut());
            this.add(this.cutItem);
            this.copyItem = new JMenuItem(Language.text("menu.edit.copy"));
            this.copyItem.addActionListener(e -> Editor.this.handleCopy());
            this.add(this.copyItem);
            this.discourseItem = new JMenuItem(Language.text("menu.edit.copy_as_html"));
            this.discourseItem.addActionListener(e -> Editor.this.handleCopyAsHTML());
            this.add(this.discourseItem);
            this.pasteItem = new JMenuItem(Language.text("menu.edit.paste"));
            this.pasteItem.addActionListener(e -> Editor.this.handlePaste());
            this.add(this.pasteItem);
            JMenuItem item = new JMenuItem(Language.text("menu.edit.select_all"));
            item.addActionListener(e -> Editor.this.handleSelectAll());
            this.add(item);
            this.addSeparator();
            item = new JMenuItem(Language.text("menu.edit.comment_uncomment"));
            item.addActionListener(e -> Editor.this.handleCommentUncomment());
            this.add(item);
            item = new JMenuItem("\u2192 " + Language.text("menu.edit.increase_indent"));
            item.addActionListener(e -> Editor.this.handleIndentOutdent(true));
            this.add(item);
            item = new JMenuItem("\u2190 " + Language.text("menu.edit.decrease_indent"));
            item.addActionListener(e -> Editor.this.handleIndentOutdent(false));
            this.add(item);
            this.addSeparator();
            this.referenceItem = new JMenuItem(Language.text("find_in_reference"));
            this.referenceItem.addActionListener(e -> Editor.this.handleFindReference());
            this.add(this.referenceItem);
            Toolkit.setMenuMnemonics(this);
        }

        @Override
        public void show(Component component, int x, int y) {
            this.cutItem.setEnabled(Editor.this.cutAction.canDo());
            this.copyItem.setEnabled(Editor.this.copyAction.canDo());
            this.discourseItem.setEnabled(Editor.this.copyAsHtmlAction.canDo());
            this.pasteItem.setEnabled(Editor.this.pasteAction.canDo());
            this.referenceItem.setEnabled(Editor.this.referenceCheck(false) != null);
            super.show(component, x, y);
        }
    }

    class FileDropHandler
    extends TransferHandler {
        FileDropHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return !Editor.this.sketch.isReadOnly();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            int successful = 0;
            if (!this.canImport(support)) {
                return false;
            }
            try {
                Transferable transferable = support.getTransferable();
                DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (Object o : list) {
                        File file = (File)o;
                        if (!Editor.this.sketch.addFile(file)) continue;
                        ++successful;
                    }
                } else if (transferable.isDataFlavorSupported(uriListFlavor)) {
                    String[] pieces;
                    String data = (String)transferable.getTransferData(uriListFlavor);
                    for (String piece : pieces = PApplet.splitTokens((String)data, (String)"\r\n")) {
                        if (piece.startsWith("#")) continue;
                        String path = null;
                        if (piece.startsWith("file:///")) {
                            path = piece.substring(7);
                        } else if (piece.startsWith("file:/")) {
                            path = piece.substring(5);
                        }
                        if (path != null) {
                            if (!Editor.this.sketch.addFile(new File(path))) continue;
                            ++successful;
                            continue;
                        }
                        System.err.println("Path not found for: " + data);
                    }
                }
            }
            catch (Exception e) {
                Messages.showWarning("Drag & Drop Problem", "An error occurred while trying to add files to the sketch.", e);
                return false;
            }
            Editor.this.statusNotice(Language.pluralize("editor.status.drag_and_drop.files_added", successful));
            return true;
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(Language.text("menu.edit.undo"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.stopCompoundEdit();
            try {
                Integer caret = Editor.this.caretUndoStack.pop();
                Editor.this.caretRedoStack.push(caret);
                Editor.this.textarea.setCaretPosition(caret);
                Editor.this.textarea.scrollToCaret();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Editor.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.updateUndoState();
            Editor.this.redoAction.updateRedoState();
            if (Editor.this.sketch != null) {
                Editor.this.sketch.setModified(!Editor.this.getText().equals(Editor.this.sketch.getCurrentCode().getSavedProgram()));
                for (SketchCode sc : Editor.this.sketch.getCode()) {
                    if (sc.getDocument() == null) continue;
                    try {
                        sc.setModified(!sc.getDocumentText().equals(sc.getSavedProgram()));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                Editor.this.repaintHeader();
            }
        }

        protected void updateUndoState() {
            if (Editor.this.undo.canUndo() || Editor.this.compoundEdit != null && Editor.this.compoundEdit.isInProgress()) {
                this.setEnabled(true);
                Editor.this.undoItem.setEnabled(true);
                Object newUndoPresentationName = Language.text("menu.edit.undo");
                if (Editor.this.undo.getUndoPresentationName().equals("Undo addition")) {
                    newUndoPresentationName = (String)newUndoPresentationName + " " + Language.text("menu.edit.action.addition");
                } else if (Editor.this.undo.getUndoPresentationName().equals("Undo deletion")) {
                    newUndoPresentationName = (String)newUndoPresentationName + " " + Language.text("menu.edit.action.deletion");
                }
                Editor.this.undoItem.setText((String)newUndoPresentationName);
                this.putValue("Name", newUndoPresentationName);
            } else {
                this.setEnabled(false);
                Editor.this.undoItem.setEnabled(false);
                Editor.this.undoItem.setText(Language.text("menu.edit.undo"));
                this.putValue("Name", Language.text("menu.edit.undo"));
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(Language.text("menu.edit.redo"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.stopCompoundEdit();
            try {
                Editor.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            try {
                Integer caret = Editor.this.caretRedoStack.pop();
                Editor.this.caretUndoStack.push(caret);
                Editor.this.textarea.setCaretPosition(caret);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateRedoState();
            Editor.this.undoAction.updateUndoState();
            if (Editor.this.sketch != null) {
                Editor.this.sketch.setModified(!Editor.this.getText().equals(Editor.this.sketch.getCurrentCode().getSavedProgram()));
                for (SketchCode sc : Editor.this.sketch.getCode()) {
                    if (sc.getDocument() == null) continue;
                    try {
                        sc.setModified(!sc.getDocumentText().equals(sc.getSavedProgram()));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                Editor.this.repaintHeader();
            }
        }

        protected void updateRedoState() {
            if (Editor.this.undo.canRedo()) {
                Editor.this.redoItem.setEnabled(true);
                Object newRedoPresentationName = Language.text("menu.edit.redo");
                if (Editor.this.undo.getRedoPresentationName().equals("Redo addition")) {
                    newRedoPresentationName = (String)newRedoPresentationName + " " + Language.text("menu.edit.action.addition");
                } else if (Editor.this.undo.getRedoPresentationName().equals("Redo deletion")) {
                    newRedoPresentationName = (String)newRedoPresentationName + " " + Language.text("menu.edit.action.deletion");
                }
                Editor.this.redoItem.setText((String)newRedoPresentationName);
                this.putValue("Name", newRedoPresentationName);
            } else {
                this.setEnabled(false);
                Editor.this.redoItem.setEnabled(false);
                Editor.this.redoItem.setText(Language.text("menu.edit.redo"));
                this.putValue("Name", Language.text("menu.edit.redo"));
            }
        }
    }

    class CutAction
    extends UpdatableAction {
        public CutAction() {
            super(Language.text("menu.edit.cut"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.handleCut();
        }

        @Override
        public boolean canDo() {
            return Editor.this.textarea.isSelectionActive();
        }
    }

    class CopyAction
    extends UpdatableAction {
        public CopyAction() {
            super(Language.text("menu.edit.copy"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.handleCopy();
        }

        @Override
        public boolean canDo() {
            return Editor.this.textarea.isSelectionActive();
        }
    }

    class CopyAsHtmlAction
    extends UpdatableAction {
        public CopyAsHtmlAction() {
            super(Language.text("menu.edit.copy_as_html"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.handleCopyAsHTML();
        }

        @Override
        public boolean canDo() {
            return Editor.this.textarea.isSelectionActive();
        }
    }

    class PasteAction
    extends UpdatableAction {
        public PasteAction() {
            super(Language.text("menu.edit.paste"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Editor.this.textarea.paste();
            Editor.this.sketch.setModified(true);
        }

        @Override
        public boolean canDo() {
            return Editor.this.getToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
    }

    class FindNextAction
    extends UpdatableAction {
        public FindNextAction() {
            super(Language.text("menu.edit.find_next"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Editor.this.find != null) {
                Editor.this.find.findNext();
            }
        }

        @Override
        public boolean canDo() {
            return Editor.this.find != null && Editor.this.find.canFindNext();
        }
    }

    class FindPreviousAction
    extends UpdatableAction {
        public FindPreviousAction() {
            super(Language.text("menu.edit.find_previous"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Editor.this.find != null) {
                Editor.this.find.findPrevious();
            }
        }

        @Override
        public boolean canDo() {
            return Editor.this.find != null && Editor.this.find.canFindNext();
        }
    }

    class SelectionForFindAction
    extends UpdatableAction {
        public SelectionForFindAction() {
            super(Language.text("menu.edit.use_selection_for_find"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Editor.this.find == null) {
                Editor.this.find = new FindReplace(Editor.this);
            }
            Editor.this.find.setFindText(Editor.this.getSelectedText());
        }

        @Override
        public boolean canDo() {
            return Editor.this.textarea.isSelectionActive();
        }
    }

    static abstract class UpdatableAction
    extends AbstractAction {
        public UpdatableAction(String name) {
            super(name);
        }

        public abstract boolean canDo();

        public void updateState() {
            this.setEnabled(this.canDo());
        }
    }
}

