/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import processing.app.tools.CreateFont;

class SampleComponent
extends JComponent {
    String text = "Forsaking monastic tradition, twelve jovial friars gave up their vocation for a questionable existence on the flying trapeze.";
    int high = 80;
    CreateFont parent;

    public SampleComponent(CreateFont p) {
        this.parent = p;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                String input = (String)JOptionPane.showInputDialog(SampleComponent.this.parent, "Enter new sample text:", "Sample Text", -1, null, null, SampleComponent.this.text);
                if (input != null) {
                    SampleComponent.this.text = input;
                    SampleComponent.this.parent.repaint();
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.WHITE);
        Dimension dim = this.getSize();
        g2.fillRect(0, 0, dim.width, dim.height);
        g2.setColor(Color.BLACK);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.parent.smooth ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.parent.smooth ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.parent.smooth ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        Font font2 = this.getFont();
        int ascent = g2.getFontMetrics().getAscent();
        g2.setFont(font2);
        g2.drawString(this.text, 5, dim.height - (dim.height - ascent) / 2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, this.high);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(10000, this.high);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, this.high);
    }
}

