/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class WindowsRegistry {
    private static final HashMap<REGISTRY_ROOT_KEY, WinReg.HKEY> rootKeyMap = new HashMap();

    private static WinReg.HKEY getRegistryRootKey(REGISTRY_ROOT_KEY key) {
        Advapi32 advapi32 = Advapi32.INSTANCE;
        WinReg.HKEYByReference pHandle = new WinReg.HKEYByReference();
        WinReg.HKEY handle = null;
        if (advapi32.RegOpenKeyEx(rootKeyMap.get((Object)key), null, 0, 0, pHandle) == 0) {
            handle = pHandle.getValue();
        }
        return handle;
    }

    private static WinReg.HKEY openKey(REGISTRY_ROOT_KEY rootKey, String subKeyName, int access) {
        WinReg.HKEYByReference pHandle;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        WinReg.HKEY rootKeyHandle = WindowsRegistry.getRegistryRootKey(rootKey);
        if (advapi32.RegOpenKeyEx(rootKeyHandle, subKeyName, 0, access, pHandle = new WinReg.HKEYByReference()) == 0) {
            return pHandle.getValue();
        }
        return null;
    }

    private static String convertBufferToString(byte[] buf) throws UnsupportedEncodingException {
        return new String(buf, 0, buf.length - 2, "UTF-16LE");
    }

    private static int convertBufferToInt(byte[] buf) {
        return (buf[0] & 0xFF) + ((buf[1] & 0xFF) << 8) + ((buf[2] & 0xFF) << 16) + ((buf[3] & 0xFF) << 24);
    }

    public static String getStringValue(REGISTRY_ROOT_KEY rootKey, String subKeyName, String name) throws UnsupportedEncodingException {
        byte[] lpData = new byte[1];
        Advapi32 advapi32 = Advapi32.INSTANCE;
        IntByReference pType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        WinReg.HKEY handle = WindowsRegistry.openKey(rootKey, subKeyName, 131097);
        String ret = null;
        if (handle != null) {
            if (advapi32.RegQueryValueEx(handle, name, 0, pType, lpData, lpcbData) == 234 && advapi32.RegQueryValueEx(handle, name, 0, pType, lpData = new byte[lpcbData.getValue()], lpcbData) == 0) {
                ret = WindowsRegistry.convertBufferToString(lpData);
            }
            advapi32.RegCloseKey(handle);
        }
        return ret;
    }

    public static int getIntValue(REGISTRY_ROOT_KEY rootKey, String subKeyName, String name) {
        Advapi32 advapi32 = Advapi32.INSTANCE;
        IntByReference pType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        WinReg.HKEY handle = WindowsRegistry.openKey(rootKey, subKeyName, 131097);
        int ret = 0;
        byte[] lpData = new byte[1];
        if (handle != null) {
            if (advapi32.RegQueryValueEx(handle, name, 0, pType, lpData, lpcbData) == 234 && advapi32.RegQueryValueEx(handle, name, 0, pType, lpData = new byte[lpcbData.getValue()], lpcbData) == 0) {
                ret = WindowsRegistry.convertBufferToInt(lpData);
            }
            advapi32.RegCloseKey(handle);
        }
        return ret;
    }

    public static boolean deleteValue(REGISTRY_ROOT_KEY rootKey, String subKeyName, String name) {
        Advapi32 advapi32 = Advapi32.INSTANCE;
        WinReg.HKEY handle = WindowsRegistry.openKey(rootKey, subKeyName, 131103);
        boolean ret = true;
        if (handle != null) {
            if (advapi32.RegDeleteValue(handle, name) == 0) {
                ret = true;
            }
            advapi32.RegCloseKey(handle);
        }
        return ret;
    }

    public static boolean setStringValue(REGISTRY_ROOT_KEY rootKey, String subKeyName, String name, String value) throws UnsupportedEncodingException {
        byte[] data = new byte[value.length() * 2 + 2];
        byte[] src = value.getBytes("UTF-16LE");
        System.arraycopy(src, 0, data, 0, src.length);
        Advapi32 advapi32 = Advapi32.INSTANCE;
        WinReg.HKEY handle = WindowsRegistry.openKey(rootKey, subKeyName, 131103);
        boolean ret = false;
        if (handle != null) {
            if (advapi32.RegSetValueEx(handle, name, 0, 1, data, data.length) == 0) {
                ret = true;
            }
            advapi32.RegCloseKey(handle);
        }
        return ret;
    }

    public static boolean setIntValue(REGISTRY_ROOT_KEY rootKey, String subKeyName, String name, int value) {
        byte[] data = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        Advapi32 advapi32 = Advapi32.INSTANCE;
        WinReg.HKEY handle = WindowsRegistry.openKey(rootKey, subKeyName, 131103);
        boolean ret = false;
        if (handle != null) {
            if (advapi32.RegSetValueEx(handle, name, 0, 4, data, data.length) == 0) {
                ret = true;
            }
            advapi32.RegCloseKey(handle);
        }
        return ret;
    }

    public static boolean valueExists(REGISTRY_ROOT_KEY rootKey, String subKeyName, String name) {
        Advapi32 advapi32 = Advapi32.INSTANCE;
        IntByReference pType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        WinReg.HKEY handle = WindowsRegistry.openKey(rootKey, subKeyName, 131097);
        byte[] lpData = new byte[1];
        boolean ret = false;
        if (handle != null) {
            ret = advapi32.RegQueryValueEx(handle, name, 0, pType, lpData, lpcbData) != 2;
            advapi32.RegCloseKey(handle);
        }
        return ret;
    }

    public static boolean createKey(REGISTRY_ROOT_KEY rootKey, String parent, String name) {
        Advapi32 advapi32 = Advapi32.INSTANCE;
        WinReg.HKEYByReference hkResult = new WinReg.HKEYByReference();
        IntByReference dwDisposition = new IntByReference();
        WinReg.HKEY handle = WindowsRegistry.openKey(rootKey, parent, 131097);
        boolean ret = false;
        if (handle != null) {
            if (advapi32.RegCreateKeyEx(handle, name, 0, null, 0, 131097, null, hkResult, dwDisposition) == 0) {
                ret = true;
                advapi32.RegCloseKey(hkResult.getValue());
            } else {
                ret = false;
            }
            advapi32.RegCloseKey(handle);
        }
        return ret;
    }

    public static boolean deleteKey(REGISTRY_ROOT_KEY rootKey, String parent, String name) {
        Advapi32 advapi32 = Advapi32.INSTANCE;
        WinReg.HKEY handle = WindowsRegistry.openKey(rootKey, parent, 131097);
        boolean ret = false;
        if (handle != null) {
            ret = advapi32.RegDeleteKey(handle, name) == 0;
            advapi32.RegCloseKey(handle);
        }
        return ret;
    }

    public static String[] getSubKeys(REGISTRY_ROOT_KEY rootKey, String parent) {
        TreeSet<String> subKeys = new TreeSet<String>();
        Advapi32 advapi32 = Advapi32.INSTANCE;
        WinReg.HKEY handle = WindowsRegistry.openKey(rootKey, parent, 131097);
        char[] lpName = new char[256];
        IntByReference lpcName = new IntByReference(256);
        WinBase.FILETIME lpftLastWriteTime = new WinBase.FILETIME();
        if (handle != null) {
            int dwIndex = 0;
            while (advapi32.RegEnumKeyEx(handle, dwIndex, lpName, lpcName, null, null, null, lpftLastWriteTime) == 0) {
                subKeys.add(new String(lpName, 0, lpcName.getValue()));
                lpcName.setValue(256);
                ++dwIndex;
            }
            advapi32.RegCloseKey(handle);
        }
        return subKeys.toArray(new String[0]);
    }

    public static TreeMap<String, Object> getValues(REGISTRY_ROOT_KEY rootKey, String key) throws UnsupportedEncodingException {
        TreeMap<String, Object> values = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        Advapi32 advapi32 = Advapi32.INSTANCE;
        WinReg.HKEY handle = WindowsRegistry.openKey(rootKey, key, 131097);
        char[] lpValueName = new char[16384];
        IntByReference lpcchValueName = new IntByReference(16384);
        IntByReference lpType = new IntByReference();
        byte[] lpData = new byte[1];
        IntByReference lpcbData = new IntByReference();
        if (handle != null) {
            int dwIndex = 0;
            int result = 0;
            do {
                lpcbData.setValue(0);
                result = advapi32.RegEnumValue(handle, dwIndex, lpValueName, lpcchValueName, null, lpType, lpData, lpcbData);
                if (result == 234 && (result = advapi32.RegEnumValue(handle, dwIndex, lpValueName, lpcchValueName = new IntByReference(16384), null, lpType, lpData = new byte[lpcbData.getValue()], lpcbData)) == 0) {
                    String name = new String(lpValueName, 0, lpcchValueName.getValue());
                    switch (lpType.getValue()) {
                        case 1: {
                            values.put(name, WindowsRegistry.convertBufferToString(lpData));
                            break;
                        }
                        case 4: {
                            values.put(name, WindowsRegistry.convertBufferToInt(lpData));
                            break;
                        }
                    }
                }
                ++dwIndex;
            } while (result == 0);
            advapi32.RegCloseKey(handle);
        }
        return values;
    }

    static {
        rootKeyMap.put(REGISTRY_ROOT_KEY.CLASSES_ROOT, WinReg.HKEY_CLASSES_ROOT);
        rootKeyMap.put(REGISTRY_ROOT_KEY.CURRENT_USER, WinReg.HKEY_CURRENT_USER);
        rootKeyMap.put(REGISTRY_ROOT_KEY.LOCAL_MACHINE, WinReg.HKEY_LOCAL_MACHINE);
        rootKeyMap.put(REGISTRY_ROOT_KEY.USERS, WinReg.HKEY_USERS);
    }

    public static enum REGISTRY_ROOT_KEY {
        CLASSES_ROOT,
        CURRENT_USER,
        LOCAL_MACHINE,
        USERS;

    }
}

