/*
 * Decompiled with CFR 0.152.
 */
package processing.app.laf;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import processing.app.laf.SwingUtilities2;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

public class PdeButtonUI
extends BasicButtonUI {
    final String prefix;
    Color enabledFgColor;
    Color enabledBgColor;
    Color pressedFgColor;
    Color pressedBgColor;
    Color disabledFgColor;
    Color disabledBgColor;

    public PdeButtonUI(String prefix) {
        this.prefix = prefix;
        this.updateTheme();
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setBorder(new EmptyBorder(2, 14, 2, 14));
        b.setOpaque(false);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        ButtonModel model = ((AbstractButton)c).getModel();
        if (model.isPressed()) {
            g.setColor(this.pressedBgColor);
        } else if (model.isEnabled()) {
            g.setColor(this.enabledBgColor);
        } else {
            g.setColor(this.disabledBgColor);
        }
        Toolkit.prepareGraphics(g);
        g.fillRoundRect(0, 0, c.getWidth(), c.getHeight(), 8, 8);
        this.paint(g, c);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g);
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isPressed()) {
            g.setColor(this.pressedFgColor);
        } else if (model.isEnabled()) {
            g.setColor(this.enabledFgColor);
        } else {
            g.setColor(this.disabledFgColor);
        }
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
    }

    public void updateTheme() {
        this.enabledFgColor = Theme.getColor(this.prefix + ".enabled.text.color");
        this.enabledBgColor = Theme.getColor(this.prefix + ".enabled.background.color");
        this.pressedFgColor = Theme.getColor(this.prefix + ".pressed.text.color");
        this.pressedBgColor = Theme.getColor(this.prefix + ".pressed.background.color");
        this.disabledFgColor = Theme.getColor(this.prefix + ".disabled.text.color");
        this.disabledBgColor = Theme.getColor(this.prefix + ".disabled.background.color");
    }
}

