/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import javax.swing.table.TableColumnModel;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.ListPanel;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.StatusDetail;
import processing.app.contrib.UpdateStatusPanel;

public class UpdateListPanel
extends ListPanel {
    Contribution.Filter contribFilter;

    public UpdateListPanel(ContributionTab contributionTab, Contribution.Filter contribFilter) {
        super(contributionTab, contribFilter, true, ListPanel.ContributionColumn.STATUS_NO_HEADER, ListPanel.ContributionColumn.NAME, ListPanel.ContributionColumn.AUTHOR, ListPanel.ContributionColumn.INSTALLED_VERSION, ListPanel.ContributionColumn.AVAILABLE_VERSION);
        TableColumnModel tcm = this.table.getColumnModel();
        tcm.getColumn(3).setMaxWidth(ManagerFrame.VERSION_WIDTH);
        tcm.getColumn(4).setMaxWidth(ManagerFrame.VERSION_WIDTH);
        this.contribFilter = contribFilter;
        this.table.getTableHeader().setEnabled(false);
    }

    @Override
    public void contributionChanged(Contribution oldContrib, Contribution newContrib) {
        if (this.contribFilter.matches(newContrib)) {
            StatusDetail detail = (StatusDetail)this.detailForContrib.get(oldContrib);
            if (detail == null) {
                this.contributionAdded(newContrib);
            } else if (newContrib.isInstalled()) {
                this.detailForContrib.remove(oldContrib);
            }
        }
    }

    @Override
    protected void updateModel() {
        super.updateModel();
        boolean anyRows = this.sorter.getViewRowCount() > 0;
        ((UpdateStatusPanel)this.contributionTab.statusPanel).setUpdateEnabled(anyRows);
    }
}

