/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.Util;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgress;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.IgnorableException;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.StatusDetail;
import processing.app.contrib.StatusPanel;
import processing.app.contrib.ToolContribution;
import processing.app.ui.Editor;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public abstract class LocalContribution
extends Contribution {
    public static final String DELETION_FLAG = "marked_for_deletion";
    public static final String UPDATE_FLAGGED = "marked_for_update";
    protected String id;
    protected File folder;
    protected StringDict properties;
    protected ClassLoader loader;

    public LocalContribution(File folder) {
        this.folder = folder;
        File propertiesFile = new File(folder, this.getTypeName() + ".properties");
        if (propertiesFile.exists()) {
            this.properties = Util.readSettings(propertiesFile, false);
            if (this.properties != null) {
                String maxRev;
                this.name = this.properties.get("name");
                this.id = this.properties.get("id");
                this.categories = LocalContribution.parseCategories(this.properties);
                this.imports = LocalContribution.parseImports(this.properties, "imports");
                this.exports = LocalContribution.parseImports(this.properties, "exports");
                if (this.name == null) {
                    this.name = folder.getName();
                }
                this.authors = this.properties.get("authors");
                this.url = this.properties.get("url");
                this.sentence = this.properties.get("sentence");
                this.paragraph = this.properties.get("paragraph");
                try {
                    this.version = Integer.parseInt(this.properties.get("version"));
                }
                catch (NumberFormatException e) {
                    System.err.println("The version number for the \u201c" + this.name + "\u201d library is not a number.");
                    System.err.println("Please contact the library author to fix it according to the guidelines.");
                }
                this.setPrettyVersion(this.properties.get("prettyVersion"));
                try {
                    this.lastUpdated = Long.parseLong(this.properties.get("lastUpdated"));
                }
                catch (NumberFormatException e) {
                    this.lastUpdated = 0L;
                }
                String minRev = this.properties.get("minRevision");
                if (minRev != null) {
                    this.minRevision = PApplet.parseInt((String)minRev, (int)0);
                }
                if ((maxRev = this.properties.get("maxRevision")) != null) {
                    this.maxRevision = PApplet.parseInt((String)maxRev, (int)0);
                }
            } else {
                Messages.log("Could not read " + propertiesFile.getAbsolutePath());
            }
        } else {
            Messages.log("No properties file at " + propertiesFile.getAbsolutePath());
        }
        if (this.name == null) {
            this.name = folder.getName();
            this.categories = new StringList(new Object[]{"Unknown"});
        }
    }

    public String initLoader(String className) throws Exception {
        File modeDirectory = new File(this.folder, this.getTypeName());
        if (modeDirectory.exists()) {
            File[] archives;
            Messages.log("checking mode folder regarding " + className);
            if (className == null) {
                String shortName = this.folder.getName();
                File mainJar = new File(modeDirectory, shortName + ".jar");
                if (!mainJar.exists()) {
                    throw new IgnorableException(mainJar.getAbsolutePath() + " does not exist.");
                }
                className = LocalContribution.findClassInZipFile(shortName, mainJar);
                if (className == null) {
                    throw new IgnorableException("Could not find " + shortName + " class inside " + mainJar.getAbsolutePath());
                }
            }
            if ((archives = Util.listJarFiles(modeDirectory)) != null && archives.length > 0) {
                URL[] urlList = new URL[archives.length];
                for (int j = 0; j < urlList.length; ++j) {
                    Messages.log("Found archive " + String.valueOf(archives[j]) + " for " + this.getName());
                    urlList[j] = archives[j].toURI().toURL();
                }
                this.loader = new URLClassLoader(urlList);
                Messages.log("loading above JARs with loader " + String.valueOf(this.loader));
            }
        }
        if (this.loader == null) {
            this.loader = Thread.currentThread().getContextClassLoader();
        }
        return className;
    }

    LocalContribution copyAndLoad(Base base, StatusPanel status) {
        String contribFolderName = this.getFolder().getName();
        File contribTypeFolder = this.getType().getSketchbookFolder();
        File contribFolder = new File(contribTypeFolder, contribFolderName);
        if (status != null) {
            Editor editor = base.getActiveEditor();
            List<LocalContribution> oldContribs = this.getType().listContributions(base, editor);
            if (contribFolder.exists() && !contribFolder.isDirectory()) {
                contribFolder.delete();
                contribFolder = new File(contribTypeFolder, contribFolderName);
            }
            for (LocalContribution oldContrib : oldContribs) {
                boolean doBackup;
                if ((!oldContrib.getFolder().exists() || !oldContrib.getFolder().equals(contribFolder)) && (oldContrib.getId() == null || !oldContrib.getId().equals(this.getId())) || !(oldContrib.getType().requiresRestart() ? !oldContrib.backup(false, status) : (doBackup = Preferences.getBoolean("contribution.backup.on_install")) && !oldContrib.backup(true, status) || !doBackup && !oldContrib.getFolder().delete())) continue;
                return null;
            }
            if (contribFolder.exists()) {
                try {
                    Platform.deleteFile(contribFolder);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (contribFolder.exists() && contribFolder.isDirectory()) {
            try {
                Platform.deleteFile(contribFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (contribFolder.exists()) {
            contribFolder.delete();
            contribFolder = new File(contribTypeFolder, contribFolderName);
        }
        File oldFolder = this.getFolder();
        try {
            Util.copyDir(oldFolder, contribFolder);
        }
        catch (IOException e) {
            status.setErrorMessage("Could not copy " + this.getTypeName() + " \"" + this.getName() + "\" to the sketchbook.");
            e.printStackTrace();
            return null;
        }
        return this.getType().load(base, contribFolder);
    }

    boolean backup(boolean deleteOriginal, StatusPanel status) {
        File backupFolder = this.getType().createBackupFolder(status);
        boolean success = false;
        if (backupFolder != null) {
            String libFolderName = this.getFolder().getName();
            String prefix = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            String backupName = prefix + " " + libFolderName;
            File backupSubFolder = ContributionManager.getUniqueName(backupFolder, backupName);
            if (deleteOriginal) {
                success = this.getFolder().renameTo(backupSubFolder);
            } else {
                try {
                    Util.copyDir(this.getFolder(), backupSubFolder);
                    success = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!success) {
                status.setErrorMessage("Could not move contribution to backup folder.");
            }
        }
        return success;
    }

    protected void removeContribution(Base base, ContribProgress pm, StatusPanel status, boolean updating) {
        new Thread(() -> {
            boolean success;
            boolean doBackup;
            pm.startTask("Removing");
            if (this.getType() == ContributionType.MODE) {
                if (!this.removeMode(base, updating)) {
                    pm.cancel();
                    return;
                }
            } else if (this.getType() == ContributionType.TOOL) {
                base.clearToolMenus();
                ((ToolContribution)this).clearClassLoader();
            }
            if (doBackup = Preferences.getBoolean("contribution.backup.on_remove")) {
                success = this.backup(true, status);
            } else {
                try {
                    success = Platform.deleteFile(this.getFolder());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    success = false;
                }
            }
            if (success) {
                try {
                    EventQueue.invokeAndWait(() -> {
                        ContributionListing cl = ContributionListing.getInstance();
                        AvailableContribution advertisedVersion = cl.findAvailableContribution(this);
                        if (advertisedVersion == null) {
                            cl.removeContribution(this);
                        } else {
                            cl.replaceContribution(this, advertisedVersion);
                        }
                        cl.updateTableModels();
                        base.refreshContribs(this.getType());
                        base.tallyUpdatesAvailable();
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    cause.printStackTrace();
                }
            } else if (!doBackup || this.backup(false, status)) {
                if (this.setDeletionFlag(true)) {
                    try {
                        EventQueue.invokeAndWait(() -> {
                            ContributionListing cl = ContributionListing.getInstance();
                            cl.replaceContribution(this, this);
                            cl.updateTableModels();
                            base.refreshContribs(this.getType());
                            base.tallyUpdatesAvailable();
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        cause.printStackTrace();
                    }
                }
            } else {
                status.setErrorMessage("Could not delete the contribution's files");
            }
            if (success) {
                pm.finished();
            } else {
                pm.cancel();
            }
        }, "Contribution Uninstaller").start();
    }

    private boolean removeMode(Base base, boolean updating) {
        ArrayList<Editor> editors = new ArrayList<Editor>();
        ModeContribution m = (ModeContribution)this;
        for (Editor editor : base.getEditors()) {
            if (!editor.getMode().equals(m.getMode())) continue;
            Sketch sketch = editor.getSketch();
            if (sketch.isModified()) {
                editor.toFront();
                Messages.showMessage("Save Sketch", "Please first save \u201c" + sketch.getName() + "\u201d.");
                return false;
            }
            editors.add(editor);
        }
        for (Editor editor : editors) {
            StatusDetail.storeSketchPath(editor.getSketch().getMainPath());
            base.handleClose(editor, true);
        }
        editors.clear();
        m.clearClassLoader(base);
        if (!updating) {
            base.modeRemoved(m.getMode());
            if (base.getEditors().size() == 0) {
                base.handleNew();
            }
        }
        return true;
    }

    public File getFolder() {
        return this.folder;
    }

    @Override
    public boolean isInstalled() {
        return this.folder != null;
    }

    public String getId() {
        return this.id;
    }

    boolean setDeletionFlag(boolean flag) {
        return this.setFlag(DELETION_FLAG, flag);
    }

    @Override
    boolean isDeletionFlagged() {
        return LocalContribution.isDeletionFlagged(this.getFolder());
    }

    static boolean isDeletionFlagged(File folder) {
        return LocalContribution.isFlagged(folder, DELETION_FLAG);
    }

    boolean setUpdateFlag() {
        return this.setFlag(UPDATE_FLAGGED, true);
    }

    @Override
    boolean isUpdateFlagged() {
        return LocalContribution.isUpdateFlagged(this.getFolder());
    }

    static boolean isUpdateFlagged(File folder) {
        return LocalContribution.isFlagged(folder, UPDATE_FLAGGED);
    }

    private boolean setFlag(String flagFilename, boolean flag) {
        if (flag) {
            try {
                new File(this.getFolder(), flagFilename).createNewFile();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return new File(this.getFolder(), flagFilename).delete();
    }

    private static boolean isFlagged(File folder, String flagFilename) {
        return new File(folder, flagFilename).exists();
    }

    protected static String findClassInZipFile(String base, File file) {
        String classFileName = "/" + base + ".class";
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(classFileName)) continue;
                zipFile.close();
                return name.substring(0, name.length() - 6).replace('/', '.');
            }
            zipFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

