/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import processing.app.Util;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.StatusDetail;
import processing.app.laf.PdeScrollBarUI;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

public class ListPanel
extends JPanel
implements Scrollable {
    ContributionTab contributionTab;
    Map<Contribution, StatusDetail> detailForContrib = new ConcurrentHashMap<Contribution, StatusDetail>();
    private final Contribution.Filter filter;
    private StatusDetail selectedDetail;
    protected ContributionRowFilter rowFilter;
    protected JTable table;
    protected TableRowSorter<ContributionTableModel> sorter;
    protected ContributionTableModel model;
    static final int ICON_SIZE = 16;
    Icon upToDateIcon;
    Icon updateAvailableIcon;
    Icon incompatibleIcon;
    Icon downloadingIcon;
    Icon foundationIcon;
    Color headerFgColor;
    Color headerBgColor;
    Color sectionColor;
    Color rowColor;
    Color textColor;
    Color selectionColor;
    Color textColorIncompatible;
    Color selectionColorIncompatible;
    JScrollPane scrollPane;
    static final SectionHeaderContribution[] sectionHeaders = new SectionHeaderContribution[]{new SectionHeaderContribution(ContributionType.LIBRARY), new SectionHeaderContribution(ContributionType.MODE), new SectionHeaderContribution(ContributionType.TOOL), new SectionHeaderContribution(ContributionType.EXAMPLES)};

    public ListPanel(ContributionTab contributionTab, Contribution.Filter filter, boolean enableSections, ContributionColumn ... columns) {
        this.contributionTab = contributionTab;
        this.filter = filter;
        this.model = new ContributionTableModel(columns);
        this.model.enableSections(enableSections);
        this.table = new JTable(this.model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                Object rowValue = this.getValueAt(row, column);
                if (rowValue instanceof SectionHeaderContribution) {
                    c.setBackground(ListPanel.this.sectionColor);
                } else if (this.isRowSelected(row)) {
                    if (((Contribution)rowValue).isCompatible()) {
                        c.setBackground(ListPanel.this.selectionColor);
                    } else {
                        c.setBackground(ListPanel.this.selectionColorIncompatible);
                    }
                } else {
                    c.setBackground(ListPanel.this.rowColor);
                }
                return c;
            }

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                if (!(this.getValueAt(rowIndex, columnIndex) instanceof SectionHeaderContribution)) {
                    super.changeSelection(rowIndex, columnIndex, toggle, extend);
                }
            }
        };
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.getVerticalScrollBar().setUI(new PdeScrollBarUI("manager.scrollbar"));
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Contribution.class, new ContribCellRenderer());
        this.table.setRowHeight(Toolkit.zoom(28));
        this.table.setRowMargin(Toolkit.zoom(6));
        TableColumnModel tcm = this.table.getColumnModel();
        tcm.setColumnMargin(0);
        tcm.getColumn(0).setMaxWidth(ManagerFrame.STATUS_WIDTH);
        tcm.getColumn(2).setMinWidth(ManagerFrame.AUTHOR_WIDTH);
        tcm.getColumn(2).setMaxWidth(ManagerFrame.AUTHOR_WIDTH);
        this.table.setShowGrid(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setAutoCreateRowSorter(false);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(event -> {
            int row = this.table.getSelectedRow();
            if (row != -1) {
                Contribution contrib = (Contribution)this.table.getValueAt(row, 0);
                this.setSelectedDetail(this.detailForContrib.get(contrib));
                if (!contributionTab.filterHasFocus()) {
                    this.table.requestFocusInWindow();
                }
            }
        });
        this.sorter = new TableRowSorter<ContributionTableModel>(this.model);
        this.table.setRowSorter(this.sorter);
        this.rowFilter = new ContributionRowFilter(filter);
        this.sorter.setRowFilter(this.rowFilter);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            if (this.model.columns[i] == ContributionColumn.NAME) {
                this.sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(i, SortOrder.ASCENDING)));
            }
            this.sorter.setComparator(i, this.model.columns[i].getComparator());
        }
        this.table.getTableHeader().setDefaultRenderer(new ContribHeaderRenderer());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setResizingAllowed(true);
        this.table.setVisible(true);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    protected void updateTheme() {
        this.headerFgColor = Theme.getColor("manager.list.header.fgcolor");
        this.headerBgColor = Theme.getColor("manager.list.header.bgcolor");
        this.sectionColor = Theme.getColor("manager.list.section.color");
        this.textColor = Theme.getColor("manager.list.text.color");
        this.selectionColor = Theme.getColor("manager.list.selection.color");
        this.textColorIncompatible = Theme.getColor("manager.list.incompatible.text.color");
        this.selectionColorIncompatible = Theme.getColor("manager.list.incompatible.selection.color");
        this.rowColor = Theme.getColor("manager.list.background.color");
        this.table.setBackground(this.rowColor);
        this.foundationIcon = Toolkit.renderIcon("manager/foundation", Theme.get("manager.list.foundation.color"), 16);
        this.upToDateIcon = Toolkit.renderIcon("manager/list-up-to-date", Theme.get("manager.list.icon.color"), 16);
        this.updateAvailableIcon = Toolkit.renderIcon("manager/list-update-available", Theme.get("manager.list.icon.color"), 16);
        this.incompatibleIcon = Toolkit.renderIcon("manager/list-incompatible", Theme.get("manager.list.icon.color"), 16);
        this.downloadingIcon = Toolkit.renderIcon("manager/list-downloading", Theme.get("manager.list.icon.color"), 16);
        ((PdeScrollBarUI)this.scrollPane.getVerticalScrollBar().getUI()).updateTheme();
    }

    Icon renderProgressIcon(float amount, int hash) {
        float FFS_JAVA2D = 14.5f;
        int dim = 16 * (Toolkit.highResImages() ? 2 : 1);
        BufferedImage image = new BufferedImage(dim, dim, 2);
        Graphics2D g2 = Toolkit.prepareGraphics(image);
        g2.translate(0.5, 0.5);
        g2.setStroke(new BasicStroke(1.5f, 1, 1));
        Color iconColor = Theme.getColor("manager.list.icon.color");
        g2.setColor(iconColor);
        Ellipse2D.Float circle = new Ellipse2D.Float(0.0f, 0.0f, 14.5f, 14.5f);
        if (amount != -1.0f) {
            g2.draw(circle);
            int theta = (int)(360.0f * amount);
            Arc2D.Float wedge = new Arc2D.Float(0.0f, 0.0f, 14.5f, 14.5f, 90.0f, -theta, 2);
            g2.fill(wedge);
        } else {
            g2.fill(circle);
            g2.translate(7.25, 7.25);
            long EPOCH = 1500000000000L + Math.abs((long)hash);
            int angle = (int)((System.currentTimeMillis() - EPOCH) / 20L) % 360;
            g2.rotate(angle);
            g2.setColor(this.rowColor);
            float lineRadius = 4.3500004f;
            g2.draw(new Line2D.Float(-lineRadius, 0.0f, lineRadius, 0.0f));
        }
        g2.dispose();
        return Toolkit.wrapIcon(image);
    }

    protected int getScrollBarWidth() {
        return this.scrollPane.getVerticalScrollBar().getPreferredSize().width;
    }

    private static int getContributionStatusRank(Contribution c) {
        int pos = 4;
        if (c.isInstalled()) {
            pos = 1;
            if (ContributionListing.getInstance().hasUpdates(c)) {
                pos = 2;
            }
            if (!c.isCompatible()) {
                pos = 3;
            }
        }
        return pos;
    }

    protected static boolean matches(Contribution contrib, String typed) {
        String search = ".*" + typed.toLowerCase() + ".*";
        return ListPanel.matchField(contrib.getName(), search) || ListPanel.matchField(contrib.getSentence(), search) || ListPanel.matchField(contrib.getAuthorList(), search) || ListPanel.matchField(contrib.getParagraph(), search);
    }

    private static boolean matchField(String field, String regex) {
        return field != null && field.toLowerCase().matches(regex);
    }

    protected void contributionAdded(Contribution contribution) {
        if (this.filter.matches(contribution) && !this.detailForContrib.containsKey(contribution)) {
            StatusDetail newPanel = this.contributionTab.createStatusDetail();
            this.detailForContrib.put(contribution, newPanel);
            newPanel.setContrib(contribution);
        }
    }

    protected void contributionRemoved(Contribution contribution) {
        StatusDetail panel;
        if (this.filter.matches(contribution) && (panel = this.detailForContrib.get(contribution)) != null) {
            this.detailForContrib.remove(contribution);
        }
    }

    protected void contributionChanged(Contribution oldContrib, Contribution newContrib) {
        if (this.filter.matches(oldContrib)) {
            StatusDetail detail = this.detailForContrib.get(oldContrib);
            this.detailForContrib.remove(oldContrib);
            detail.setContrib(newContrib);
            this.detailForContrib.put(newContrib, detail);
        }
    }

    protected void updateFilter(String category, List<String> filters) {
        this.rowFilter.setCategoryFilter(category);
        this.rowFilter.setStringFilters(filters);
        this.updateModel();
    }

    protected void updateModel() {
        this.model.fireTableDataChanged();
    }

    private void setSelectedDetail(StatusDetail contribDetail) {
        this.contributionTab.applyDetail(contribDetail);
        if (this.selectedDetail != contribDetail) {
            this.selectedDetail = contribDetail;
            this.requestFocusInWindow();
        }
    }

    protected StatusDetail getSelectedDetail() {
        return this.selectedDetail;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int blockAmount = visibleRect.height;
            visibleRect.y = direction > 0 ? (visibleRect.y += blockAmount) : (visibleRect.y -= blockAmount);
            return blockAmount += this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 0;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        int lastHeight = 0;
        int height = 0;
        int bottomOfScrollArea = visibleRect.y + visibleRect.height;
        for (Component c : this.getComponents()) {
            Dimension d = c.getPreferredSize();
            int nextHeight = height + d.height;
            if (direction > 0) {
                if (nextHeight > bottomOfScrollArea) {
                    return nextHeight - bottomOfScrollArea;
                }
            } else if (nextHeight > visibleRect.y) {
                if (visibleRect.y != height) {
                    return visibleRect.y - height;
                }
                return visibleRect.y - lastHeight;
            }
            lastHeight = height;
            height = nextHeight;
        }
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    static class ContributionTableModel
    extends AbstractTableModel {
        ContributionColumn[] columns = new ContributionColumn[]{ContributionColumn.STATUS, ContributionColumn.NAME, ContributionColumn.AUTHOR};
        boolean sectionsEnabled;

        ContributionTableModel(ContributionColumn ... columns) {
            if (columns.length > 0) {
                this.columns = columns;
            }
        }

        @Override
        public int getRowCount() {
            return ContributionListing.getAllContribs().size() + (this.sectionsEnabled ? 4 : 0);
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            if (column < 0 || column > this.columns.length) {
                return "";
            }
            return this.columns[column].name;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Contribution.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Set<Contribution> allContribs = ContributionListing.getAllContribs();
            if (rowIndex >= allContribs.size()) {
                return sectionHeaders[rowIndex - allContribs.size()];
            }
            return allContribs.stream().skip(rowIndex).findFirst().orElse(null);
        }

        public void enableSections(boolean enable) {
            this.sectionsEnabled = enable;
        }
    }

    protected static enum ContributionColumn {
        STATUS(" Status"),
        NAME("Name"),
        AUTHOR("Author"),
        INSTALLED_VERSION("Installed"),
        AVAILABLE_VERSION("Available"),
        STATUS_NO_HEADER("");

        final String name;

        private ContributionColumn(String name) {
            this.name = name;
        }

        Comparator<Contribution> getComparator() {
            Comparator<Contribution> comparator = Comparator.comparing(Contribution::getType).thenComparingInt(contribution -> contribution instanceof SectionHeaderContribution ? 0 : 1);
            if (this == STATUS || this == STATUS_NO_HEADER) {
                return comparator.thenComparingInt(ListPanel::getContributionStatusRank);
            }
            if (this == AUTHOR) {
                return comparator.thenComparing(contribution -> Util.removeMarkDownLinks(contribution.getAuthorList()));
            }
            return comparator.thenComparing(Contribution::getName, String.CASE_INSENSITIVE_ORDER);
        }
    }

    private class ContribCellRenderer
    extends DefaultTableCellRenderer {
        private ContribCellRenderer() {
        }

        @Override
        public void setVerticalAlignment(int alignment) {
            super.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Contribution contribution = (Contribution)value;
            JLabel label = new JLabel();
            ContributionColumn col = ListPanel.this.model.columns[column];
            label.setOpaque(true);
            if (value instanceof SectionHeaderContribution && col != ContributionColumn.NAME) {
                return label;
            }
            switch (col) {
                case STATUS: 
                case STATUS_NO_HEADER: {
                    this.configureStatusColumnLabel(label, contribution);
                    break;
                }
                case NAME: {
                    this.configureNameColumnLabel(table, label, contribution);
                    break;
                }
                case AUTHOR: {
                    this.configureAuthorsColumnLabel(label, contribution);
                    break;
                }
                case INSTALLED_VERSION: {
                    label.setText(contribution.getBenignVersion());
                    break;
                }
                case AVAILABLE_VERSION: {
                    label.setText(ContributionListing.getInstance().getLatestPrettyVersion(contribution));
                }
            }
            if (contribution instanceof SectionHeaderContribution) {
                label.setForeground(ListPanel.this.textColorIncompatible);
            } else if (contribution.isCompatible()) {
                label.setForeground(ListPanel.this.textColor);
            } else {
                label.setForeground(ListPanel.this.textColorIncompatible);
            }
            return label;
        }

        private void configureStatusColumnLabel(JLabel label, Contribution contribution) {
            Icon icon = null;
            StatusDetail detail = ListPanel.this.detailForContrib.get(contribution);
            if (detail != null && (detail.updateInProgress || detail.installInProgress)) {
                icon = ListPanel.this.renderProgressIcon(detail.getProgressAmount(), contribution.hashCode());
            } else if (contribution.isInstalled()) {
                icon = !contribution.isCompatible() ? ListPanel.this.incompatibleIcon : (ContributionListing.getInstance().hasUpdates(contribution) ? ListPanel.this.updateAvailableIcon : (detail != null && (detail.installInProgress || detail.updateInProgress) ? ListPanel.this.downloadingIcon : ListPanel.this.upToDateIcon));
            }
            label.setIcon(icon);
            label.setHorizontalAlignment(0);
        }

        private void configureNameColumnLabel(JTable table, JLabel label, Contribution contribution) {
            Font boldFont = Theme.getFont("manager.list.heavy.font");
            FontMetrics fontMetrics = table.getFontMetrics(boldFont);
            int colSize = table.getColumnModel().getColumn(1).getWidth();
            int currentWidth = fontMetrics.stringWidth(contribution.getName() + " | \u2026");
            String sentence = Util.removeMarkDownLinks(contribution.getSentence());
            StringBuilder text = new StringBuilder("<html><body><font face=\"").append(boldFont.getName()).append("\">").append(contribution.getName());
            if (sentence.length() == 0) {
                text.append("</font>");
            } else {
                int index;
                for (index = 0; index < sentence.length() && (currentWidth += fontMetrics.charWidth(sentence.charAt(index))) < colSize; ++index) {
                }
                text.append(" | </font>").append(sentence, 0, index);
                if (index != sentence.length()) {
                    text.append("\u2026");
                }
            }
            text.append("</body></html>");
            label.setText(text.toString());
        }

        private void configureAuthorsColumnLabel(JLabel label, Contribution contribution) {
            if (contribution.isFoundation()) {
                label.setIcon(ListPanel.this.foundationIcon);
            }
            String authorList = contribution.getAuthorList();
            String name = Util.removeMarkDownLinks(authorList);
            label.setText(name);
            label.setHorizontalAlignment(2);
            label.setForeground(Color.BLACK);
            label.setFont(Theme.getFont("manager.list.heavy.font"));
        }
    }

    static class ContributionRowFilter
    extends RowFilter<ContributionTableModel, Integer> {
        Contribution.Filter contributionFilter;
        String categoryFilter;
        List<String> stringFilters = Collections.emptyList();

        ContributionRowFilter(Contribution.Filter contributionFilter) {
            this.contributionFilter = contributionFilter;
        }

        public void setCategoryFilter(String categoryFilter) {
            this.categoryFilter = categoryFilter;
        }

        public void setStringFilters(List<String> filters) {
            this.stringFilters = filters;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends ContributionTableModel, ? extends Integer> entry) {
            Contribution contribution = (Contribution)entry.getValue(0);
            if (contribution instanceof SectionHeaderContribution) {
                return this.includeSection((SectionHeaderContribution)contribution);
            }
            return this.includeContribution(contribution);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean includeContribution(Contribution contribution) {
            if (!this.contributionFilter.matches(contribution)) return false;
            if (Optional.ofNullable(this.categoryFilter).map(contribution::hasCategory).orElse(true) == false) return false;
            if (!this.stringFilters.stream().allMatch(pattern -> ListPanel.matches(contribution, pattern))) return false;
            return true;
        }

        private boolean includeSection(SectionHeaderContribution section) {
            return ContributionListing.getAllContribs().stream().filter(contribution -> contribution.getType() == section.getType()).anyMatch(this::includeContribution);
        }
    }

    class ContribHeaderRenderer
    extends DefaultTableCellRenderer {
        public ContribHeaderRenderer() {
            this.setHorizontalTextPosition(2);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(ListPanel.this.headerFgColor);
            this.setText(this.getText() + this.getSortText(table, column));
            this.putClientProperty("FlatLaf.styleClass", "small");
            this.setBackground(ListPanel.this.headerBgColor);
            this.setBorder(null);
            return this;
        }

        private String getSortText(JTable table, int column) {
            RowSorter.SortKey sortKey = this.getSortKey(table);
            if (sortKey != null && table.convertColumnIndexToView(sortKey.getColumn()) == column) {
                switch (sortKey.getSortOrder()) {
                    case ASCENDING: {
                        return "  \u2193";
                    }
                    case DESCENDING: {
                        return "  \u2191";
                    }
                }
            }
            return "";
        }

        protected RowSorter.SortKey getSortKey(JTable table) {
            return Optional.ofNullable(table.getRowSorter()).map(RowSorter::getSortKeys).map(columns -> columns.isEmpty() ? null : (RowSorter.SortKey)columns.get(0)).orElse(null);
        }
    }

    static class SectionHeaderContribution
    extends Contribution {
        ContributionType type;

        SectionHeaderContribution(ContributionType type) {
            this.type = type;
            switch (type) {
                case LIBRARY: {
                    this.name = "Libraries";
                    break;
                }
                case MODE: {
                    this.name = "Modes";
                    break;
                }
                case TOOL: {
                    this.name = "Tools";
                    break;
                }
                case EXAMPLES: {
                    this.name = "Examples";
                }
            }
        }

        @Override
        public ContributionType getType() {
            return this.type;
        }

        @Override
        public boolean isInstalled() {
            return false;
        }
    }
}

