/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.core.PApplet;

public class SingleInstance {
    static final String SERVER_PORT = "instance_server.port";
    static final String SERVER_KEY = "instance_server.key";

    static boolean alreadyRunning(String[] args) {
        return Preferences.get(SERVER_PORT) != null && SingleInstance.sendArguments(args);
    }

    public static void clearRunning() {
        Preferences.unset(SERVER_PORT);
        Preferences.save();
    }

    static void startServer(final Base base) {
        try {
            Messages.log("Opening SingleInstance socket");
            final ServerSocket ss = new ServerSocket(0, 0, InetAddress.getLoopbackAddress());
            Preferences.set(SERVER_PORT, "" + ss.getLocalPort());
            final String key = "" + Math.random();
            Preferences.set(SERVER_KEY, key);
            Preferences.save();
            Messages.log("Starting SingleInstance thread");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Socket s = ss.accept();
                                final BufferedReader reader = PApplet.createReader((InputStream)s.getInputStream());
                                String receivedKey = reader.readLine();
                                Messages.log(this, "key is " + key + ", received is " + receivedKey);
                                if (key.equals(receivedKey)) {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                Messages.log(this, "about to read line");
                                                String path = reader.readLine();
                                                if (path == null) {
                                                    Messages.log(this, "opening new empty sketch");
                                                    base.handleNew();
                                                } else {
                                                    do {
                                                        Messages.log(this, "calling open with " + path);
                                                        base.handleOpen(path);
                                                    } while ((path = reader.readLine()) != null);
                                                }
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                    continue;
                                }
                                Messages.log(this, "keys do not match");
                            }
                        }
                        catch (IOException e) {
                            Messages.err("SingleInstance error while listening", e);
                            continue;
                        }
                        break;
                    }
                }
            }, "SingleInstance Server").start();
        }
        catch (IOException e) {
            Messages.err("Could not create single instance server.", e);
        }
    }

    static boolean sendArguments(String[] args) {
        try {
            Messages.log("Checking to see if Processing is already running");
            int port = Preferences.getInteger(SERVER_PORT);
            String key = Preferences.get(SERVER_KEY);
            Socket socket = null;
            try {
                socket = new Socket(InetAddress.getLoopbackAddress(), port);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (socket != null) {
                Messages.log("Processing is already running, sending command line");
                PrintWriter writer = PApplet.createWriter((OutputStream)socket.getOutputStream());
                writer.println(key);
                for (String arg : args) {
                    writer.println(arg);
                }
                writer.flush();
                writer.close();
                return true;
            }
        }
        catch (IOException e) {
            Messages.err("Error sending commands to other instance", e);
        }
        Messages.log("Processing is not already running (or could not connect)");
        return false;
    }
}

