/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.flavours.commonmark.CommonMarkMarkerProcessor;
import org.intellij.markdown.flavours.gfm.GFMConstraints;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerProvider;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.CommonMarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J$\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fR\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/intellij/markdown/flavours/gfm/GFMMarkerProcessor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkMarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "constraintsBase", "Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "(Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;)V", "markerBlockProviders", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "getMarkerBlockProviders", "populateConstraintsTokens", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "Factory", "markdown"})
public final class GFMMarkerProcessor
extends CommonMarkMarkerProcessor {
    @NotNull
    private final List<MarkerBlockProvider<MarkerProcessor.StateInfo>> markerBlockProviders;

    public GFMMarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull CommonMarkdownConstraints constraintsBase) {
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)constraintsBase, (String)"constraintsBase");
        super(productionHolder, constraintsBase);
        this.markerBlockProviders = CollectionsKt.plus((Collection)super.getMarkerBlockProviders(), (Iterable)CollectionsKt.listOf((Object)new GitHubTableMarkerProvider()));
    }

    @Override
    @NotNull
    protected List<MarkerBlockProvider<MarkerProcessor.StateInfo>> getMarkerBlockProviders() {
        return this.markerBlockProviders;
    }

    @Override
    protected void populateConstraintsTokens(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder) {
        IElementType iElementType;
        Character c;
        int offset;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        if (!(constraints instanceof GFMConstraints) || !((GFMConstraints)constraints).hasCheckbox()) {
            super.populateConstraintsTokens(pos, constraints, productionHolder);
            return;
        }
        String line = pos.getCurrentLine();
        for (offset = pos.getOffsetInCurrentLine(); offset < line.length() && line.charAt(offset) != '['; ++offset) {
        }
        if (offset == line.length()) {
            super.populateConstraintsTokens(pos, constraints, productionHolder);
            return;
        }
        Character c2 = c = ArraysKt.lastOrNull((char[])constraints.getTypes());
        char c3 = '>';
        if (c2 != null && c2.charValue() == c3) {
            iElementType = MarkdownTokenTypes.BLOCK_QUOTE;
        } else {
            boolean bl;
            Character c4 = c;
            c3 = '.';
            if (c4 != null && c4.charValue() == c3) {
                bl = true;
            } else {
                Character c5 = c;
                c3 = ')';
                bl = c5 != null && c5.charValue() == c3;
            }
            iElementType = bl ? MarkdownTokenTypes.LIST_NUMBER : MarkdownTokenTypes.LIST_BULLET;
        }
        IElementType type = iElementType;
        int middleOffset = pos.getOffset() - pos.getOffsetInCurrentLine() + offset;
        int endOffset = Math.min(pos.getOffset() - pos.getOffsetInCurrentLine() + MarkdownConstraintsKt.getCharsEaten(constraints, pos.getCurrentLine()), pos.getNextLineOrEofOffset());
        Object[] objectArray = new SequentialParser.Node[]{new SequentialParser.Node(new IntRange(pos.getOffset(), middleOffset), type), new SequentialParser.Node(new IntRange(middleOffset, endOffset), GFMTokenTypes.CHECK_BOX)};
        productionHolder.addProduction(CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/markdown/flavours/gfm/GFMMarkerProcessor$Factory;", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "()V", "createMarkerProcessor", "Lorg/intellij/markdown/parser/MarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "markdown"})
    public static final class Factory
    implements MarkerProcessorFactory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @NotNull
        public MarkerProcessor<?> createMarkerProcessor(@NotNull ProductionHolder productionHolder) {
            Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
            return new GFMMarkerProcessor(productionHolder, GFMConstraints.Companion.getBASE());
        }
    }
}

