/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal.terminalinterface.nativeimage;

import com.github.ajalt.mordant.rendering.Size;
import com.github.ajalt.mordant.terminal.terminalinterface.TerminalInterfaceWindows;
import com.github.ajalt.mordant.terminal.terminalinterface.nativeimage.WinKernel32Lib;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.UShort;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Platforms(value={Platform.WINDOWS.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u000f\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/mordant/terminal/terminalinterface/nativeimage/TerminalInterfaceNativeImageWindows;", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfaceWindows;", "<init>", "()V", "stdoutInteractive", "", "stdinInteractive", "getTerminalSize", "Lcom/github/ajalt/mordant/rendering/Size;", "getStdinConsoleMode", "Lkotlin/UInt;", "getStdinConsoleMode-pVg5ArA", "()I", "setStdinConsoleMode", "", "dwMode", "setStdinConsoleMode-WZ4Q5Ns", "(I)V", "readRawEvent", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfaceWindows$EventRecord;", "dwMilliseconds", "", "mordant-jvm-graal-ffi"})
public final class TerminalInterfaceNativeImageWindows
extends TerminalInterfaceWindows {
    public boolean stdoutInteractive() {
        PointerBase handle = WinKernel32Lib.INSTANCE.GetStdHandle(WinKernel32Lib.INSTANCE.STD_OUTPUT_HANDLE());
        return WinKernel32Lib.INSTANCE.GetConsoleMode(handle, (CIntPointer)StackValue.get(CIntPointer.class));
    }

    public boolean stdinInteractive() {
        PointerBase handle = WinKernel32Lib.INSTANCE.GetStdHandle(WinKernel32Lib.INSTANCE.STD_INPUT_HANDLE());
        return WinKernel32Lib.INSTANCE.GetConsoleMode(handle, (CIntPointer)StackValue.get(CIntPointer.class));
    }

    @Nullable
    public Size getTerminalSize() {
        WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO csbi = (WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO)StackValue.get(WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO.class);
        PointerBase handle = WinKernel32Lib.INSTANCE.GetStdHandle(WinKernel32Lib.INSTANCE.STD_OUTPUT_HANDLE());
        return !WinKernel32Lib.INSTANCE.GetConsoleScreenBufferInfo(handle, csbi.rawValue()) ? null : new Size(csbi.getRight() - csbi.getLeft() + 1, csbi.getBottom() - csbi.getTop() + 1);
    }

    protected int getStdinConsoleMode-pVg5ArA() {
        CIntPointer lpMode;
        PointerBase stdinHandle = WinKernel32Lib.INSTANCE.GetStdHandle(WinKernel32Lib.INSTANCE.STD_INPUT_HANDLE());
        if (!WinKernel32Lib.INSTANCE.GetConsoleMode(stdinHandle, lpMode = (CIntPointer)StackValue.get(CIntPointer.class))) {
            throw new RuntimeException("Error reading console mode");
        }
        return UInt.constructor-impl((int)lpMode.read());
    }

    protected void setStdinConsoleMode-WZ4Q5Ns(int dwMode) {
        PointerBase stdinHandle = WinKernel32Lib.INSTANCE.GetStdHandle(WinKernel32Lib.INSTANCE.STD_INPUT_HANDLE());
        if (!WinKernel32Lib.INSTANCE.SetConsoleMode(stdinHandle, dwMode)) {
            throw new RuntimeException("Error setting console mode");
        }
    }

    @Nullable
    protected TerminalInterfaceWindows.EventRecord readRawEvent(int dwMilliseconds) {
        PointerBase stdinHandle = WinKernel32Lib.INSTANCE.GetStdHandle(WinKernel32Lib.INSTANCE.STD_INPUT_HANDLE());
        int waitResult = WinKernel32Lib.INSTANCE.WaitForSingleObject(stdinHandle, dwMilliseconds);
        if (waitResult != 0) {
            throw new RuntimeException("Error reading from console input: waitResult=" + waitResult);
        }
        Pointer inputEvents = (Pointer)StackValue.get((int)20);
        CIntPointer eventsRead = (CIntPointer)StackValue.get(CIntPointer.class);
        WinKernel32Lib.INSTANCE.ReadConsoleInputW(stdinHandle, inputEvents, 1, eventsRead);
        if (eventsRead.read() == 0) {
            throw new RuntimeException("Error reading from console input");
        }
        WinKernel32Lib.InputRecord inputRecord = new WinKernel32Lib.InputRecord(inputEvents);
        WinKernel32Lib.EventUnion event = inputRecord.getEvent();
        return event instanceof WinKernel32Lib.EventUnion.KeyEvent ? (TerminalInterfaceWindows.EventRecord)new TerminalInterfaceWindows.EventRecord.Key(((WinKernel32Lib.EventUnion.KeyEvent)event).getBKeyDown(), UShort.constructor-impl((short)((WinKernel32Lib.EventUnion.KeyEvent)event).getWVirtualKeyCode()), ((WinKernel32Lib.EventUnion.KeyEvent)event).getUChar(), UInt.constructor-impl((int)((WinKernel32Lib.EventUnion.KeyEvent)event).getDwControlKeyState()), null) : (event instanceof WinKernel32Lib.EventUnion.MouseEvent ? (TerminalInterfaceWindows.EventRecord)new TerminalInterfaceWindows.EventRecord.Mouse(((WinKernel32Lib.EventUnion.MouseEvent)event).getDwMousePosition().getX(), ((WinKernel32Lib.EventUnion.MouseEvent)event).getDwMousePosition().getY(), UInt.constructor-impl((int)((WinKernel32Lib.EventUnion.MouseEvent)event).getDwButtonState()), UInt.constructor-impl((int)((WinKernel32Lib.EventUnion.MouseEvent)event).getDwControlKeyState()), UInt.constructor-impl((int)((WinKernel32Lib.EventUnion.MouseEvent)event).getDwEventFlags()), null) : null);
    }
}

