/*
 * Decompiled with CFR 0.152.
 */
package com.google.classpath;

import com.google.classpath.ClassPath;
import com.google.classpath.ResourceFilter;
import com.google.classpath.ResourceFinder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class DirectoryClassPath
implements ClassPath {
    private final File rootDirectory;

    public DirectoryClassPath(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public boolean isResource(String resource) {
        return !resource.endsWith("/") && this.getFile(resource).isFile();
    }

    public boolean isPackage(String packageName) {
        return this.getFile(packageName).isDirectory();
    }

    private File getFile(String path) {
        return new File(this.rootDirectory, path);
    }

    public String[] listPackages(String packageName) {
        return this.listNames(packageName, new DirectoryFilter());
    }

    private String[] listNames(String packageName, FileFilter filter) {
        File packageFile = this.getFile(packageName);
        File[] directories = packageFile.listFiles(filter);
        if (directories == null) {
            directories = new File[]{};
        }
        String[] names = new String[directories.length];
        for (int i = 0; i < directories.length; ++i) {
            names[i] = directories[i].getName();
        }
        return names;
    }

    public String[] listResources(String packageName) {
        return this.listNames(packageName, new FileFileFilter());
    }

    public InputStream getResourceAsStream(String resource) {
        if (this.isResource(resource)) {
            try {
                return new FileInputStream(this.getFile(resource));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String[] findResources(String rootPackageName, ResourceFilter resourceFilter) {
        return new ResourceFinder(this).findResources(rootPackageName, resourceFilter);
    }

    public static class FileFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            return file.isFile();
        }
    }

    public static class DirectoryFilter
    implements FileFilter {
        public boolean accept(File dir) {
            return dir.isDirectory() && !dir.getName().equals(".svn");
        }
    }
}

