/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BG\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eBG\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u001c\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J<\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0002J&\u0010$\u001a\u00020%2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J&\u0010'\u001a\u00020%2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J&\u0010(\u001a\u00020%2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J,\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0!2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010*\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0012\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006+"}, d2={"Lcom/github/ajalt/mordant/widgets/Text;", "Lcom/github/ajalt/mordant/rendering/Widget;", "lines", "Lcom/github/ajalt/mordant/rendering/Lines;", "whitespace", "Lcom/github/ajalt/mordant/rendering/Whitespace;", "align", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "overflowWrap", "Lcom/github/ajalt/mordant/rendering/OverflowWrap;", "width", "", "tabWidth", "<init>", "(Lcom/github/ajalt/mordant/rendering/Lines;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;Ljava/lang/Integer;)V", "text", "", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "withAlign", "withAlign$mordant", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "render", "wrap", "wrapWidth", "lastNonWhitespace", "line", "", "Lcom/github/ajalt/mordant/rendering/Span;", "alignLine", "", "endStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "alignLineLeft", "", "extraWidth", "alignLineRight", "alignLineCenter", "justifyLine", "toString", "mordant"})
@SourceDebugExtension(value={"SMAP\nText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Text.kt\ncom/github/ajalt/mordant/widgets/Text\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1#2:265\n1863#3,2:266\n388#3,7:268\n1782#3,4:275\n*S KotlinDebug\n*F\n+ 1 Text.kt\ncom/github/ajalt/mordant/widgets/Text\n*L\n163#1:266,2\n192#1:268,7\n235#1:275,4\n*E\n"})
public final class Text
implements Widget {
    @NotNull
    private final Lines lines;
    @NotNull
    private final Whitespace whitespace;
    @NotNull
    private final TextAlign align;
    @NotNull
    private final OverflowWrap overflowWrap;
    @Nullable
    private final Integer width;
    @Nullable
    private final Integer tabWidth;

    public Text(@NotNull Lines lines, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap, @Nullable Integer width, @Nullable Integer tabWidth) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap), (String)"overflowWrap");
        this.lines = lines;
        this.whitespace = whitespace;
        this.align = align;
        this.overflowWrap = overflowWrap;
        this.width = width;
        this.tabWidth = tabWidth;
        if (!(this.width == null || this.width >= 0)) {
            boolean $i$a$-require-Text$32 = false;
            String $i$a$-require-Text$32 = "width cannot be negative";
            throw new IllegalArgumentException($i$a$-require-Text$32.toString());
        }
        if (!(this.tabWidth == null || this.tabWidth >= 0)) {
            boolean bl = false;
            String string = "tab width cannot be negative";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Text(Lines lines, Whitespace whitespace, TextAlign textAlign, OverflowWrap overflowWrap, Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            whitespace = Whitespace.PRE;
        }
        if ((n3 & 4) != 0) {
            textAlign = TextAlign.NONE;
        }
        if ((n3 & 8) != 0) {
            overflowWrap = OverflowWrap.NORMAL;
        }
        if ((n3 & 0x10) != 0) {
            n = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        this(lines, whitespace, textAlign, overflowWrap, n, n2);
    }

    public Text(@NotNull String text2, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap, @Nullable Integer width, @Nullable Integer tabWidth) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap), (String)"overflowWrap");
        this(ParsingKt.parseText(text2, ConstantsKt.getDEFAULT_STYLE()), whitespace, align, overflowWrap, width, tabWidth);
    }

    public /* synthetic */ Text(String string, Whitespace whitespace, TextAlign textAlign, OverflowWrap overflowWrap, Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            whitespace = Whitespace.PRE;
        }
        if ((n3 & 4) != 0) {
            textAlign = TextAlign.NONE;
        }
        if ((n3 & 8) != 0) {
            overflowWrap = OverflowWrap.NORMAL;
        }
        if ((n3 & 0x10) != 0) {
            n = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        this(string, whitespace, textAlign, overflowWrap, n, n2);
    }

    @NotNull
    public final Text withAlign$mordant(@NotNull TextAlign align, @Nullable OverflowWrap overflowWrap) {
        Text text2;
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        if (align == this.align && (overflowWrap == null || overflowWrap == this.overflowWrap)) {
            text2 = this;
        } else {
            OverflowWrap overflowWrap2 = overflowWrap;
            if (overflowWrap2 == null) {
                overflowWrap2 = this.overflowWrap;
            }
            text2 = new Text(this.lines, this.whitespace, align, overflowWrap2, this.width, this.tabWidth);
        }
        return text2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        int n;
        Iterator iterator;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Integer n2 = this.width;
        Integer n3 = this.tabWidth;
        Lines lines = this.wrap(n2 != null ? n2 : width, n3 != null ? n3.intValue() : t.getTabWidth(), TextAlign.NONE, OverflowWrap.NORMAL);
        Iterator iterator3 = ((Iterable)lines.getLines()).iterator();
        if (!iterator3.hasNext()) {
            iterator2 = null;
        } else {
            Line l = (Line)iterator3.next();
            boolean bl = false;
            Iterable iterable = l;
            int n4 = 0;
            for (Object object : iterable) {
                Object it;
                Span span = (Span)object;
                int n5 = n4;
                boolean bl2 = false;
                int n6 = ((Span)it).getCellWidth$mordant();
                n4 = n5 + n6;
            }
            iterator = n4;
            while (iterator3.hasNext()) {
                Object l2 = (Line)iterator3.next();
                $i$a$-maxOfOrNull-Text$measure$max$1 = false;
                Iterable iterable2 = (Iterable)l2;
                int n7 = 0;
                for (Object it : iterable2) {
                    void it2;
                    Span span = (Span)it;
                    int n8 = n7;
                    boolean bl3 = false;
                    int n9 = it2.getCellWidth$mordant();
                    n7 = n8 + n9;
                }
                l2 = n7;
                if (iterator.compareTo(l2) >= 0) continue;
                iterator = l2;
            }
            iterator2 = iterator;
        }
        Integer n10 = (Integer)((Object)iterator2);
        int max = n10 != null ? n10 : 0;
        if (this.whitespace.getWrap()) {
            Comparable comparable;
            iterator = ((Iterable)lines.getLines()).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                Iterator<Object> iterator4;
                Iterator<Object> iterator5;
                Line l = (Line)iterator.next();
                boolean bl = false;
                Iterator iterator6 = ((Iterable)l).iterator();
                if (!iterator6.hasNext()) {
                    iterator5 = null;
                } else {
                    Span it = (Span)iterator6.next();
                    boolean bl4 = false;
                    iterator4 = it.getCellWidth$mordant();
                    while (iterator6.hasNext()) {
                        Object it3 = (Span)iterator6.next();
                        $i$a$-maxOfOrNull-Text$measure$min$1$1 = false;
                        if (iterator4.compareTo((Object)(it3 = (Comparable)Integer.valueOf(((Span)it3).getCellWidth$mordant()))) >= 0) continue;
                        iterator4 = it3;
                    }
                    iterator5 = iterator4;
                }
                Integer n11 = (Integer)((Object)iterator5);
                Comparable comparable2 = Integer.valueOf(n11 != null ? n11 : 0);
                while (iterator.hasNext()) {
                    Comparable comparable3;
                    Line l3 = (Line)iterator.next();
                    $i$a$-maxOfOrNull-Text$measure$min$1 = false;
                    iterator4 = ((Iterable)l3).iterator();
                    if (!iterator4.hasNext()) {
                        comparable3 = null;
                    } else {
                        Span it = (Span)iterator4.next();
                        boolean bl5 = false;
                        Comparable comparable4 = Integer.valueOf(it.getCellWidth$mordant());
                        while (iterator4.hasNext()) {
                            Span it4 = (Span)iterator4.next();
                            $i$a$-maxOfOrNull-Text$measure$min$1$1 = false;
                            Comparable comparable5 = Integer.valueOf(it4.getCellWidth$mordant());
                            if (comparable4.compareTo(comparable5) >= 0) continue;
                            comparable4 = comparable5;
                        }
                        comparable3 = comparable4;
                    }
                    Integer n12 = (Integer)comparable3;
                    Comparable comparable6 = Integer.valueOf(n12 != null ? n12 : 0);
                    if (comparable2.compareTo(comparable6) >= 0) continue;
                    comparable2 = comparable6;
                }
                comparable = comparable2;
            }
            Integer n13 = (Integer)comparable;
            n = n13 != null ? n13 : 0;
        } else {
            n = max;
        }
        int min = n;
        return new WidthRange(min, max);
    }

    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Integer n = this.width;
        Integer n2 = this.tabWidth;
        return this.wrap(n != null ? n : width, n2 != null ? n2.intValue() : t.getTabWidth(), this.align, this.overflowWrap);
    }

    private final Lines wrap(int wrapWidth, int tabWidth, TextAlign align, OverflowWrap overflowWrap) {
        if (wrapWidth <= 0 && overflowWrap != OverflowWrap.NORMAL) {
            return ConstantsKt.getEMPTY_LINES();
        }
        List lines = new ArrayList();
        Ref.ObjectRef line = new Ref.ObjectRef();
        line.element = new ArrayList();
        Ref.ObjectRef endStyle = new Ref.ObjectRef();
        endStyle.element = ConstantsKt.getDEFAULT_STYLE();
        Ref.IntRef width = new Ref.IntRef();
        Ref.BooleanRef lastPieceWasWhitespace = new Ref.BooleanRef();
        lastPieceWasWhitespace.element = true;
        for (Line oldLine : this.lines.getLines()) {
            int lastNonWhitespace = this.lastNonWhitespace(oldLine, align);
            endStyle.element = oldLine.getEndStyle();
            Iterator iterator = ((Iterable)oldLine).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Span span;
                boolean pieceIsWhitespace;
                int i = n++;
                Span piece = (Span)iterator.next();
                if (Intrinsics.areEqual((Object)piece.getText(), (Object)"\u0085") || Intrinsics.areEqual((Object)piece.getText(), (Object)"\u2028")) {
                    Text.wrap$breakLine(this, align, (Ref.ObjectRef<List<Span>>)line, width, wrapWidth, (Ref.ObjectRef<TextStyle>)endStyle, lines, lastPieceWasWhitespace);
                    continue;
                }
                if (this.whitespace.getTrimEol() || align == TextAlign.JUSTIFY) {
                    if (0 <= lastNonWhitespace ? lastNonWhitespace < i : false) continue;
                }
                if (i == 0 && !lastPieceWasWhitespace.element) {
                    Span span2 = (Span)CollectionsKt.firstOrNull((List)oldLine);
                    TextStyle style = Intrinsics.areEqual((Object)((Span)CollectionsKt.last((List)((List)line.element))).getStyle(), (Object)(span2 != null ? span2.getStyle() : null)) ? ((Span)CollectionsKt.last((List)((List)line.element))).getStyle() : ConstantsKt.getDEFAULT_STYLE();
                    ((List)line.element).add(Span.Companion.word(" ", style));
                    lastPieceWasWhitespace.element = true;
                    ++width.element;
                }
                if ((pieceIsWhitespace = piece.isWhitespace$mordant()) && lastPieceWasWhitespace.element && this.whitespace.getCollapseSpaces()) continue;
                Span span3 = null;
                if (pieceIsWhitespace && this.whitespace.getCollapseSpaces()) {
                    span = Span.Companion.space(1, piece.getStyle());
                } else if (piece.isTab$mordant()) {
                    if (tabWidth <= 0) continue;
                    span = Span.Companion.space(tabWidth - width.element % tabWidth, piece.getStyle());
                } else {
                    span = piece;
                }
                span3 = span;
                int cellWidth = span3.getCellWidth$mordant();
                if (this.whitespace.getWrap() && width.element > 0 && width.element + cellWidth > wrapWidth) {
                    Text.wrap$breakLine(this, align, (Ref.ObjectRef<List<Span>>)line, width, wrapWidth, (Ref.ObjectRef<TextStyle>)endStyle, lines, lastPieceWasWhitespace);
                    if (pieceIsWhitespace) continue;
                }
                if (this.whitespace.getWrap() && cellWidth > wrapWidth) {
                    switch (WhenMappings.$EnumSwitchMapping$0[overflowWrap.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            span3 = Span.Companion.word(StringsKt.take((String)span3.getText(), (int)wrapWidth), span3.getStyle());
                            break;
                        }
                        case 3: {
                            span3 = Span.Companion.word(StringsKt.take((String)span3.getText(), (int)(wrapWidth - 1)) + '\u2026', span3.getStyle());
                            break;
                        }
                        case 4: {
                            Iterable $this$forEach$iv = StringsKt.chunked((CharSequence)span3.getText(), (int)wrapWidth);
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String it = (String)element$iv;
                                boolean bl = false;
                                if (it.length() == wrapWidth) {
                                    ((Collection)lines).add(new Line(CollectionsKt.listOf((Object)Span.Companion.word(it, span3.getStyle()))));
                                    continue;
                                }
                                span3 = Span.Companion.word(it, span3.getStyle());
                            }
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                width.element += span3.getCellWidth$mordant();
                ((List)line.element).add(span3);
                lastPieceWasWhitespace.element = pieceIsWhitespace;
            }
            if (this.whitespace.getCollapseNewlines()) continue;
            Text.wrap$breakLine(this, align, (Ref.ObjectRef<List<Span>>)line, width, wrapWidth, (Ref.ObjectRef<TextStyle>)endStyle, lines, lastPieceWasWhitespace);
        }
        if (!((Collection)line.element).isEmpty()) {
            Text.wrap$breakLine(this, align, (Ref.ObjectRef<List<Span>>)line, width, wrapWidth, (Ref.ObjectRef<TextStyle>)endStyle, lines, lastPieceWasWhitespace);
        }
        return new Lines(lines);
    }

    private final int lastNonWhitespace(List<Span> line, TextAlign align) {
        int n;
        block3: {
            if (this.whitespace.getTrimEol() || align == TextAlign.JUSTIFY) {
                List<Span> $this$indexOfLast$iv = line;
                boolean $i$f$indexOfLast = false;
                ListIterator<Span> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Span it = iterator$iv.previous();
                    boolean bl = false;
                    if (!(!it.isWhitespace$mordant())) continue;
                    n = iterator$iv.nextIndex();
                    break block3;
                }
                n = -1;
            } else {
                n = -1;
            }
        }
        return n;
    }

    private final List<Span> alignLine(List<Span> line, int wrapWidth, int width, TextAlign align, TextStyle endStyle) {
        int extraWidth = wrapWidth - width;
        switch (WhenMappings.$EnumSwitchMapping$1[align.ordinal()]) {
            case 1: {
                this.alignLineLeft(line, extraWidth, endStyle);
                break;
            }
            case 2: {
                this.alignLineRight(line, extraWidth, endStyle);
                break;
            }
            case 3: {
                this.alignLineCenter(line, extraWidth, endStyle);
                break;
            }
            case 4: {
                return this.justifyLine(line, extraWidth, endStyle);
            }
            case 5: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return line;
    }

    private final void alignLineLeft(List<Span> line, int extraWidth, TextStyle endStyle) {
        Object object = (Span)CollectionsKt.lastOrNull(line);
        if (object == null || (object = ((Span)object).getStyle()) == null) {
            object = endStyle;
        }
        line.add(Span.Companion.space(extraWidth, (TextStyle)object));
    }

    private final void alignLineRight(List<Span> line, int extraWidth, TextStyle endStyle) {
        Object object = (Span)CollectionsKt.firstOrNull(line);
        if (object == null || (object = ((Span)object).getStyle()) == null) {
            object = endStyle;
        }
        line.add(0, Span.Companion.space(extraWidth, (TextStyle)object));
    }

    private final void alignLineCenter(List<Span> line, int extraWidth, TextStyle endStyle) {
        int halfExtra = extraWidth / 2;
        this.alignLineLeft(line, halfExtra + extraWidth % 2, endStyle);
        if (halfExtra > 0) {
            this.alignLineRight(line, halfExtra, endStyle);
        }
    }

    private final List<Span> justifyLine(List<Span> line, int extraWidth, TextStyle endStyle) {
        int spaceCount;
        int n;
        Iterable $this$count$iv = line;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Span it = (Span)element$iv;
                boolean bl = false;
                if (!it.isWhitespace$mordant() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = spaceCount = count$iv;
        }
        if (spaceCount == 0) {
            this.alignLineCenter(line, extraWidth, endStyle);
            return line;
        }
        int spaceSize = extraWidth / spaceCount;
        int skipRemainder = spaceCount - extraWidth % spaceCount;
        ArrayList justifiedLine = new ArrayList(line.size() + skipRemainder + (spaceSize > 0 ? spaceCount : 0));
        for (Span span : line) {
            ((Collection)justifiedLine).add(span);
            if (!span.isWhitespace$mordant() || skipRemainder-- > 0 && spaceSize == 0) continue;
            ((Collection)justifiedLine).add(Span.Companion.space(spaceSize + (skipRemainder < 0 ? 1 : 0), span.getStyle()));
        }
        return justifiedLine;
    }

    @NotNull
    public String toString() {
        String plain = CollectionsKt.joinToString$default((Iterable)CollectionsKt.flatten((Iterable)this.lines.getLines()), (CharSequence)"", null, null, (int)0, null, Text::toString$lambda$10, (int)30, null);
        return "Text(" + StringsKt.take((String)plain, (int)25) + (plain.length() > 25 ? "\u2026" : "") + ')';
    }

    private static final void wrap$breakLine(Text this$0, TextAlign $align, Ref.ObjectRef<List<Span>> line, Ref.IntRef width, int $wrapWidth, Ref.ObjectRef<TextStyle> endStyle, List<Line> lines, Ref.BooleanRef lastPieceWasWhitespace) {
        int lastNonWhitespace;
        if ((this$0.whitespace.getTrimEol() || $align == TextAlign.JUSTIFY) && (lastNonWhitespace = this$0.lastNonWhitespace((List)line.element, $align)) >= 0) {
            int n = CollectionsKt.getLastIndex((List)((List)line.element)) - lastNonWhitespace;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                ((List)line.element).remove(CollectionsKt.getLastIndex((List)((List)line.element)));
            }
        }
        if (width.element < $wrapWidth) {
            line.element = this$0.alignLine((List)line.element, $wrapWidth, width.element, $align, (TextStyle)endStyle.element);
        }
        Collection collection = lines;
        List list = (List)line.element;
        Object object = (Span)CollectionsKt.lastOrNull((List)((List)line.element));
        if (object == null || (object = ((Span)object).getStyle()) == null) {
            object = (TextStyle)endStyle.element;
        }
        collection.add(new Line(list, (TextStyle)object));
        line.element = new ArrayList();
        width.element = 0;
        lastPieceWasWhitespace.element = true;
    }

    private static final CharSequence toString$lambda$10(Span it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OverflowWrap.values().length];
            try {
                nArray[OverflowWrap.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverflowWrap.TRUNCATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverflowWrap.ELLIPSES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverflowWrap.BREAK_WORD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextAlign.values().length];
            try {
                nArray[TextAlign.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.JUSTIFY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.NONE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

