/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.rendering.WidthRangeKt;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.widgets.Padding;
import com.github.ajalt.mordant.widgets.PaddingKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/github/ajalt/mordant/widgets/DefinitionList;", "Lcom/github/ajalt/mordant/rendering/Widget;", "entries", "", "Lkotlin/Pair;", "inline", "", "descriptionSpacing", "", "entrySpacing", "<init>", "(Ljava/util/List;ZII)V", "keys", "getKeys", "()Ljava/util/List;", "values", "getValues", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "width", "measureDescriptions", "render", "Lcom/github/ajalt/mordant/rendering/Lines;", "mordant"})
@SourceDebugExtension(value={"SMAP\nDefinitionList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefinitionList.kt\ncom/github/ajalt/mordant/widgets/DefinitionList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 WidthRange.kt\ncom/github/ajalt/mordant/rendering/WidthRangeKt\n*L\n1#1,188:1\n1#2:189\n1557#3:190\n1628#3,3:191\n1557#3:194\n1628#3,3:195\n1557#3:210\n1628#3,3:211\n774#3:214\n865#3,2:215\n1628#3,3:229\n1628#3,3:232\n1557#3:235\n1628#3,3:236\n28#4,12:198\n28#4,12:217\n*S KotlinDebug\n*F\n+ 1 DefinitionList.kt\ncom/github/ajalt/mordant/widgets/DefinitionList\n*L\n19#1:190\n19#1:191,3\n20#1:194\n20#1:195,3\n37#1:210\n37#1:211,3\n40#1:214\n40#1:215,2\n63#1:229,3\n71#1:232,3\n77#1:235\n77#1:236,3\n28#1:198,12\n42#1:217,12\n*E\n"})
final class DefinitionList
implements Widget {
    @NotNull
    private final List<Pair<Widget, Widget>> entries;
    private final boolean inline;
    private final int descriptionSpacing;
    private final int entrySpacing;

    public DefinitionList(@NotNull List<? extends Pair<? extends Widget, ? extends Widget>> entries, boolean inline, int descriptionSpacing, int entrySpacing) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.entries = entries;
        this.inline = inline;
        this.descriptionSpacing = descriptionSpacing;
        this.entrySpacing = entrySpacing;
        if (!(this.descriptionSpacing >= 0)) {
            boolean bl = false;
            String string = "Spacing cannot be negative";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Widget> getKeys() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.entries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Widget)it.getFirst());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Widget> getValues() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.entries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Widget)it.getSecond());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        WidthRange widthRange;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        WidthRange termMeasurement = WidthRangeKt.maxWidthRange$default(this.getKeys(), t, width, 0, 4, null);
        WidthRange descMeasurement = this.measureDescriptions(t, width);
        if (this.inline) {
            widthRange = termMeasurement.plus(descMeasurement).plus(this.descriptionSpacing);
        } else {
            Object[] objectArray = new WidthRange[]{termMeasurement, descMeasurement};
            Iterable $this$maxWidthRange_u24default$iv = CollectionsKt.listOf((Object[])objectArray);
            int paddingWidth$iv = 0;
            boolean $i$f$maxWidthRange = false;
            int max$iv = 0;
            int min$iv = 0;
            for (Object it$iv : $this$maxWidthRange_u24default$iv) {
                WidthRange range$iv;
                WidthRange it = (WidthRange)it$iv;
                boolean bl = false;
                if (it == null) continue;
                max$iv = Math.max(max$iv, range$iv.getMax());
                min$iv = Math.max(min$iv, range$iv.getMin());
            }
            widthRange = new WidthRange(min$iv + paddingWidth$iv, max$iv + paddingWidth$iv);
        }
        return widthRange;
    }

    private final WidthRange measureDescriptions(Terminal t, int width) {
        return WidthRangeKt.maxWidthRange$default(this.getValues(), t, width, 0, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        void $this$mapTo$iv$iv;
        void $this$maxWidthRange_u24default$iv;
        WidthRange it;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (width == 0) {
            return ConstantsKt.getEMPTY_LINES();
        }
        Iterable $this$map$iv = this.getKeys();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            Widget widget = (Widget)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.measure(t, width));
        }
        List termMeasurements = (List)destination$iv$iv;
        int maxInlineTermWidth = (int)((double)width / 2.5);
        int maxDescWidth = this.measureDescriptions(t, width).getMax();
        Iterable $this$filter$iv = termMeasurements;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WidthRange)element$iv$iv;
            boolean bl = false;
            if (!(it.getMax() <= maxInlineTermWidth || this.inline && it.getMax() + this.descriptionSpacing + maxDescWidth <= width)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        int paddingWidth$iv = 0;
        boolean $i$f$maxWidthRange22 = false;
        int max$iv = 0;
        int min$iv = 0;
        for (Object it$iv : $this$maxWidthRange_u24default$iv) {
            WidthRange range$iv;
            it = (WidthRange)it$iv;
            boolean bl = false;
            if (it == null) continue;
            max$iv = Math.max(max$iv, range$iv.getMax());
            min$iv = Math.max(min$iv, range$iv.getMin());
        }
        int termWidth = new WidthRange(min$iv + paddingWidth$iv, max$iv + paddingWidth$iv).getMax();
        int descOffset = RangesKt.coerceAtLeast((int)(termWidth + this.descriptionSpacing), (int)4);
        List lines = new ArrayList();
        Iterator $i$f$maxWidthRange22 = ((Iterable)this.entries).iterator();
        max$iv = 0;
        while ($i$f$maxWidthRange22.hasNext()) {
            int n;
            int i = max$iv++;
            Pair entry = (Pair)$i$f$maxWidthRange22.next();
            if (i > 0) {
                int it$iv = this.entrySpacing;
                int range$iv = 0;
                while (range$iv < it$iv) {
                    int it3 = range$iv++;
                    n = 0;
                    ((Collection)lines).add(CollectionsKt.emptyList());
                }
            }
            Widget term = (Widget)entry.component1();
            Widget desc = (Widget)entry.component2();
            if (!this.inline) {
                CollectionsKt.addAll((Collection)lines, (Iterable)term.render(t, width).getLines());
                int it3 = this.descriptionSpacing;
                n = 0;
                while (n < it3) {
                    int it4 = n++;
                    boolean bl = false;
                    ((Collection)lines).add(CollectionsKt.emptyList());
                }
                CollectionsKt.addAll((Collection)lines, (Iterable)desc.render(t, width).getLines());
                continue;
            }
            if (((WidthRange)termMeasurements.get(i)).getMax() > termWidth) {
                CollectionsKt.addAll((Collection)lines, (Iterable)term.render(t, width).getLines());
                CollectionsKt.addAll((Collection)lines, (Iterable)PaddingKt.withPadding$default(desc, false, arg_0 -> DefinitionList.render$lambda$9(descOffset, arg_0), 1, null).render(t, width).getLines());
                continue;
            }
            List<Line> termLines = term.render(t, termWidth).getLines();
            List<Line> descLines = desc.render(t, RangesKt.coerceAtLeast((int)(width - termWidth - this.descriptionSpacing), (int)0)).getLines();
            Iterable $this$mapTo$iv = CollectionsKt.zip((Iterable)termLines, (Iterable)descLines);
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                Pair pair = (Pair)item$iv;
                collection = lines;
                boolean bl = false;
                Line t2 = (Line)pair.component1();
                Line d = (Line)pair.component2();
                Object[] objectArray = new Object[]{t2, Span.Companion.space$default(Span.Companion, this.descriptionSpacing + termWidth - LinesKt.getLineWidth(t2), null, 2, null), d};
                collection.add(LinesKt.flatLine(objectArray));
            }
            if (termLines.size() > descLines.size()) {
                CollectionsKt.addAll((Collection)lines, (Iterable)CollectionsKt.drop((Iterable)termLines, (int)descLines.size()));
                continue;
            }
            if (descLines.size() <= termLines.size()) continue;
            List paddingLeft = descOffset > 0 ? CollectionsKt.listOf((Object)Span.Companion.space$default(Span.Companion, descOffset, null, 2, null)) : (List)ConstantsKt.getEMPTY_LINE();
            Iterable $this$mapTo$iv2 = CollectionsKt.drop((Iterable)descLines, (int)termLines.size());
            boolean $i$f$mapTo3 = false;
            for (Object item$iv : $this$mapTo$iv2) {
                void it5;
                Line bl = (Line)item$iv;
                collection = lines;
                boolean bl2 = false;
                collection.add(it5.isEmpty() ? it5 : new Line(CollectionsKt.plus((Collection)paddingLeft, (Iterable)((Iterable)it5))));
            }
        }
        Iterable $this$map$iv2 = lines;
        boolean $i$f$map2 = false;
        Iterable i = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it6;
            List descLines = (List)item$iv$iv;
            Collection collection2 = destination$iv$iv3;
            boolean bl = false;
            collection2.add(new Line((List<Span>)it6));
        }
        List list = (List)destination$iv$iv3;
        return new Lines(list);
    }

    private static final Unit render$lambda$9(int $descOffset, Padding.Builder $this$withPadding) {
        Intrinsics.checkNotNullParameter((Object)$this$withPadding, (String)"$this$withPadding");
        $this$withPadding.setLeft($descOffset);
        return Unit.INSTANCE;
    }
}

