/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.lsp;

import java.io.File;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.services.LanguageClient;
import org.jsoup.Jsoup;
import processing.app.Base;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Problem;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.contrib.ModeContribution;
import processing.mode.java.AutoFormat;
import processing.mode.java.CompletionCandidate;
import processing.mode.java.CompletionGenerator;
import processing.mode.java.ErrorChecker;
import processing.mode.java.JavaMode;
import processing.mode.java.JavaTextArea;
import processing.mode.java.PreprocService;
import processing.mode.java.PreprocSketch;

class PdeAdapter {
    File rootPath;
    LanguageClient client;
    JavaMode javaMode;
    File pdeFile;
    Sketch sketch;
    CompletionGenerator completionGenerator;
    PreprocService preprocService;
    ErrorChecker errorChecker;
    CompletableFuture<PreprocSketch> cps;
    CompletionGenerator suggestionGenerator;
    Set<URI> prevDiagnosticReportUris = new HashSet<URI>();
    PreprocSketch ps;

    PdeAdapter(File rootPath, LanguageClient client) {
        this.rootPath = rootPath;
        this.client = client;
        Base.locateSketchbookFolder();
        File location = Platform.getContentFile((String)"modes/java");
        ModeContribution mc = ModeContribution.load(null, (File)location, (String)JavaMode.class.getName());
        if (mc == null) {
            throw new RuntimeException("Could not load Java Mode from " + String.valueOf(location));
        }
        this.javaMode = (JavaMode)mc.getMode();
        this.pdeFile = new File(rootPath, rootPath.getName() + ".pde");
        this.sketch = new Sketch(this.pdeFile.toString(), (Mode)this.javaMode);
        this.completionGenerator = new CompletionGenerator(this.javaMode);
        this.preprocService = new PreprocService(this.javaMode, this.sketch);
        this.errorChecker = new ErrorChecker(this::updateProblems, this.preprocService);
        this.cps = CompletableFutures.computeAsync(_x -> {
            throw new RuntimeException("unreachable");
        });
        this.suggestionGenerator = new CompletionGenerator(this.javaMode);
        this.notifySketchChanged();
    }

    static Optional<File> uriToPath(URI uri) {
        try {
            return Optional.of(new File(uri));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    static URI pathToUri(File path) {
        return path.toURI();
    }

    static Offset toLineCol(String s, int offset) {
        int line = (int)s.substring(0, offset).chars().filter(c -> c == 10).count();
        int col = offset - s.substring(0, offset).lastIndexOf(10);
        return new Offset(line, col);
    }

    static Offset toLineEndCol(String s, int offset) {
        Offset before = PdeAdapter.toLineCol(s, offset);
        return new Offset(before.line, Integer.MAX_VALUE);
    }

    static Position toPosition(String program, int tabOffset) {
        Offset offset = PdeAdapter.toLineCol(program, tabOffset);
        return new Position(offset.line, offset.col - 1);
    }

    static Location toLocation(String program, int startTabOffset, int stopTabOffset, URI uri) {
        Position startPos = PdeAdapter.toPosition(program, startTabOffset);
        Position stopPos = PdeAdapter.toPosition(program, stopTabOffset);
        Range range = new Range(startPos, stopPos);
        return new Location(uri.toString(), range);
    }

    static void init() {
        Base.setCommandLine();
        Platform.init();
        Preferences.init();
    }

    void notifySketchChanged() {
        CompletableFuture cps = new CompletableFuture();
        this.cps = cps;
        this.preprocService.notifySketchChanged();
        this.errorChecker.notifySketchChanged();
        this.preprocService.whenDone(cps::complete);
        try {
            this.ps = (PreprocSketch)cps.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    Optional<SketchCode> findCodeByUri(URI uri) {
        return PdeAdapter.uriToPath(uri).flatMap(path -> Arrays.stream(this.sketch.getCode()).filter(code -> code.getFile().equals(path)).findFirst());
    }

    public Optional<Integer> findTabIndex(SketchCode code) {
        int tabsCount = this.sketch.getCodeCount();
        OptionalInt optionalTabIndex = IntStream.range(0, tabsCount).filter(i -> this.sketch.getCode(i).equals(code)).findFirst();
        if (optionalTabIndex.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(optionalTabIndex.getAsInt());
    }

    public Optional<Integer> findJavaOffset(URI uri, int line, int col) {
        Optional<SketchCode> optionalCode = this.findCodeByUri(uri);
        if (optionalCode.isEmpty()) {
            System.out.println("couldn't find sketch code");
            return Optional.empty();
        }
        SketchCode code = optionalCode.get();
        Optional<Integer> optionalTabIndex = this.findTabIndex(code);
        if (optionalTabIndex.isEmpty()) {
            System.out.println("couldn't find tab index");
            return Optional.empty();
        }
        int tabIndex = optionalTabIndex.get();
        CharSequence[] codeLines = Arrays.copyOfRange(code.getProgram().split("\n"), 0, line);
        String codeString = String.join((CharSequence)"\n", codeLines);
        int tabOffset = codeString.length() + col;
        return Optional.of(this.ps.tabOffsetToJavaOffset(tabIndex, tabOffset));
    }

    void updateProblems(List<Problem> problems) {
        PublishDiagnosticsParams params;
        Map dias = problems.stream().map(prob -> {
            SketchCode code = this.sketch.getCode(prob.getTabIndex());
            int startOffset = prob.getStartOffset();
            int endOffset = prob.getStopOffset();
            Position startPosition = new Position(prob.getLineNumber(), PdeAdapter.toLineCol((String)code.getProgram(), (int)startOffset).col - 1);
            Position stopPosition = endOffset == -1 ? new Position(prob.getLineNumber(), PdeAdapter.toLineEndCol((String)code.getProgram(), (int)startOffset).col - 1) : new Position(prob.getLineNumber(), PdeAdapter.toLineCol((String)code.getProgram(), (int)endOffset).col - 1);
            Diagnostic dia = new Diagnostic(new Range(startPosition, stopPosition), prob.getMessage());
            dia.setSeverity(prob.isError() ? DiagnosticSeverity.Error : DiagnosticSeverity.Warning);
            return new AbstractMap.SimpleEntry<URI, Diagnostic>(PdeAdapter.pathToUri(code.getFile()), dia);
        }).collect(Collectors.groupingBy(AbstractMap.SimpleEntry::getKey, Collectors.mapping(AbstractMap.SimpleEntry::getValue, Collectors.toList())));
        for (Map.Entry entry : dias.entrySet()) {
            params = new PublishDiagnosticsParams();
            params.setUri(entry.getKey().toString());
            params.setDiagnostics(entry.getValue());
            this.client.publishDiagnostics(params);
        }
        for (URI uri : this.prevDiagnosticReportUris) {
            if (dias.containsKey(uri)) continue;
            params = new PublishDiagnosticsParams();
            params.setUri(uri.toString());
            params.setDiagnostics(Collections.emptyList());
            this.client.publishDiagnostics(params);
        }
        this.prevDiagnosticReportUris = dias.keySet();
    }

    CompletionItem convertCompletionCandidate(CompletionCandidate c) {
        CompletionItem item = new CompletionItem();
        item.setLabel(c.getElementName());
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        String insert = c.getCompletionString();
        if (insert.contains("( )")) {
            insert = insert.replace("( )", "($1)");
        } else if (insert.contains(",")) {
            int n = 1;
            char[] chs = insert.replace("(,", "($1,").toCharArray();
            StringBuilder newInsert = new StringBuilder();
            for (char ch : chs) {
                if (ch == ',') {
                    newInsert.append(",$").append(++n);
                }
                newInsert.append(ch);
            }
            insert = newInsert.toString();
        }
        item.setInsertText(insert);
        CompletionItemKind kind = switch (c.getType()) {
            case 0 -> CompletionItemKind.Class;
            case 1 -> CompletionItemKind.Constant;
            case 2 -> CompletionItemKind.Function;
            case 3 -> CompletionItemKind.Class;
            case 4 -> CompletionItemKind.Method;
            case 5 -> CompletionItemKind.Field;
            case 6 -> CompletionItemKind.Variable;
            default -> throw new IllegalArgumentException("Unknown completion type: " + c.getType());
        };
        item.setKind(kind);
        item.setDetail(Jsoup.parse((String)c.getLabel()).text());
        return item;
    }

    Optional<String> parsePhrase(String text) {
        return Optional.ofNullable(JavaTextArea.parsePhrase(text));
    }

    List<CompletionCandidate> filterPredictions(List<CompletionCandidate> candidates) {
        return Collections.list(CompletionGenerator.filterPredictions(candidates).elements());
    }

    CompletableFuture<List<CompletionItem>> generateCompletion(URI uri, int line, int col) {
        return this.cps.thenApply(ps -> {
            Optional result = this.findCodeByUri(uri).flatMap(code -> {
                int codeIndex = IntStream.range(0, this.sketch.getCodeCount()).filter(i -> this.sketch.getCode(i).equals(code)).findFirst().getAsInt();
                int lineStartOffset = String.join((CharSequence)"\n", Arrays.copyOfRange(code.getProgram().split("\n"), 0, line + 1)).length();
                int lineNumber = ps.tabOffsetToJavaLine(codeIndex, lineStartOffset);
                String text = code.getProgram().split("\n")[line].substring(0, col);
                return this.parsePhrase(text).map(phrase -> {
                    System.out.println("phrase: " + phrase);
                    System.out.println("lineNumber: " + lineNumber);
                    return Optional.ofNullable(this.suggestionGenerator.preparePredictions((PreprocSketch)ps, (String)phrase, lineNumber)).filter(x -> !x.isEmpty()).map(candidates -> {
                        Collections.sort(candidates);
                        System.out.println("candidates: " + String.valueOf(candidates));
                        List<CompletionCandidate> filtered = this.filterPredictions((List<CompletionCandidate>)candidates);
                        System.out.println("filtered: " + String.valueOf(filtered));
                        return filtered.stream().map(this::convertCompletionCandidate).collect(Collectors.toList());
                    });
                }).orElse(Optional.empty());
            });
            return result.orElse(Collections.emptyList());
        });
    }

    void onChange(URI uri, String text) {
        this.findCodeByUri(uri).ifPresent(code -> {
            code.setProgram(text);
            this.notifySketchChanged();
        });
    }

    Optional<TextEdit> format(URI uri) {
        return this.findCodeByUri(uri).map(SketchCode::getProgram).map(code -> {
            String newCode = new AutoFormat().format((String)code);
            Offset end = PdeAdapter.toLineCol(code, code.length());
            return new TextEdit(new Range(new Position(0, 0), new Position(end.line, end.col)), newCode);
        });
    }

    static class Offset {
        int line;
        int col;

        Offset(int line, int col) {
            this.line = line;
            this.col = col;
        }
    }
}

