/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.debug;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.BreakpointRequest;
import java.util.List;
import processing.app.Messages;
import processing.mode.java.debug.ClassLoadListener;
import processing.mode.java.debug.Debugger;
import processing.mode.java.debug.LineID;

public class LineBreakpoint
implements ClassLoadListener {
    protected Debugger dbg;
    protected LineID line;
    protected BreakpointRequest bpr;
    protected String className;

    public LineBreakpoint(LineID line, Debugger dbg) {
        this.line = line;
        line.startTracking(dbg.getEditor().getTab(line.fileName()).getDocument());
        this.dbg = dbg;
        this.className = this.className();
        this.set();
        Messages.log((String)("LBP Created " + this.toString() + " class: " + this.className));
    }

    public LineBreakpoint(int lineIdx, Debugger dbg) {
        this(dbg.getEditor().getLineIDInCurrentTab(lineIdx), dbg);
    }

    public LineID lineID() {
        return this.line;
    }

    public boolean isOnLine(LineID testLine) {
        return this.line.equals(testLine);
    }

    protected boolean attach(ReferenceType theClass) {
        if (theClass == null || this.className == null || !this.className.equals(LineBreakpoint.parseTopLevelClassName(theClass.name()))) {
            return false;
        }
        this.log("trying to attach: " + this.line.fileName + ":" + this.line.lineIdx + " to " + theClass.name(), new Object[0]);
        if (!this.dbg.isPaused()) {
            this.log("can't attach breakpoint, debugger not paused", new Object[0]);
            return false;
        }
        LineID javaLine = this.dbg.sketchToJavaLine(this.line);
        if (javaLine == null) {
            this.log("couldn't find line " + String.valueOf(this.line) + " in the java code", new Object[0]);
            return false;
        }
        try {
            this.log("BPs of class: " + String.valueOf(theClass) + ", line " + (javaLine.lineIdx() + 1), new Object[0]);
            List<Location> locations = theClass.locationsOfLine(javaLine.lineIdx() + 1);
            if (locations.isEmpty()) {
                this.log("no location found for line " + String.valueOf(this.line) + " -> " + String.valueOf(javaLine), new Object[0]);
                return false;
            }
            this.bpr = this.dbg.vm().eventRequestManager().createBreakpointRequest(locations.get(0));
            this.bpr.enable();
            this.log("attached breakpoint to " + String.valueOf(this.line) + " -> " + String.valueOf(javaLine), new Object[0]);
            return true;
        }
        catch (AbsentInformationException ex) {
            Messages.err(null, (Throwable)ex);
            return false;
        }
    }

    protected boolean isAttached() {
        return this.bpr != null;
    }

    public void detach() {
        if (this.bpr != null) {
            try {
                this.dbg.vm().eventRequestManager().deleteEventRequest(this.bpr);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
            this.bpr = null;
        }
    }

    protected void set() {
        this.dbg.addClassLoadListener(this);
        this.dbg.getEditor().addBreakpointedLine(this.line);
        if (this.className != null && this.dbg.isPaused()) {
            for (ReferenceType rt : this.dbg.getClasses()) {
                if (this.attach(rt)) break;
            }
        }
        if (this.dbg.getEditor().isInCurrentTab(this.line)) {
            this.dbg.getEditor().getSketch().setModified(true);
        }
    }

    public void remove() {
        this.dbg.removeClassLoadListener(this);
        this.dbg.getEditor().removeBreakpointedLine(this.line.lineIdx());
        if (this.dbg.isPaused()) {
            this.detach();
        }
        this.line.stopTracking();
        if (this.dbg.getEditor().isInCurrentTab(this.line)) {
            this.dbg.getEditor().getSketch().setModified(true);
        }
    }

    public String toString() {
        return this.line.toString();
    }

    protected String className() {
        if (this.line.fileName().endsWith(".pde")) {
            return this.line.fileName().substring(0, this.line.fileName().lastIndexOf(".pde"));
        }
        if (this.line.fileName().endsWith(".java")) {
            return this.line.fileName().substring(0, this.line.fileName().lastIndexOf(".java"));
        }
        return null;
    }

    @Override
    public void classLoaded(ReferenceType theClass) {
        if (!this.isAttached()) {
            this.attach(theClass);
        }
    }

    public static String parseTopLevelClassName(String name) {
        int dollar = name.indexOf(36);
        return dollar == -1 ? name : name.substring(0, dollar);
    }

    private void log(String msg, Object ... args) {
        if (args != null && args.length != 0) {
            Messages.logf((String)(this.getClass().getName() + " " + msg), (Object[])args);
        } else {
            Messages.log((String)(this.getClass().getName() + " " + msg));
        }
    }
}

