/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.syntax.JEditTextArea;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;
import processing.mode.java.CompletionCandidate;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaTextArea;

public class CompletionPanel {
    static final int MAX_HEIGHT = 300;
    static final int ICON_SIZE = 16;
    private final JList<CompletionCandidate> completionList;
    private final JPopupMenu popupMenu;
    private final String subWord;
    private final int caretPos;
    private final JScrollPane scrollPane;
    protected JavaEditor editor;
    protected static final int MOUSE_COMPLETION = 10;
    protected static final int KEYBOARD_COMPLETION = 20;
    public static ImageIcon classIcon;
    public static ImageIcon fieldIcon;
    public static ImageIcon methodIcon;
    public static ImageIcon localIcon;
    private static final Map<String, String> iconColors;
    private static final Map<String, ImageIcon> iconCache;
    static Color selectionBgColor;
    static Color textColor;

    public CompletionPanel(JavaEditor editor, int caret, String subWord, DefaultListModel<CompletionCandidate> items, Point location) {
        this.editor = editor;
        this.caretPos = caret;
        this.subWord = subWord.indexOf(46) != -1 && subWord.indexOf(46) != subWord.length() - 1 ? subWord.substring(subWord.lastIndexOf(46) + 1) : subWord;
        this.updateTheme();
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setOpaque(false);
        this.popupMenu.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scrollPane = new JScrollPane();
        this.completionList = new JList<CompletionCandidate>(items){
            {
                this.setSelectionMode(0);
                this.setSelectedIndex(0);
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            CompletionPanel.this.insertSelection(10);
                            CompletionPanel.this.setInvisible();
                        }
                    }
                });
                this.setCellRenderer(new CustomListRenderer());
                this.setFocusable(false);
                this.setFont(Toolkit.getSansFont((int)12, (int)0));
            }
        };
        this.scrollPane.setViewportView(this.completionList);
        this.scrollPane.setBorder(null);
        this.popupMenu.add((Component)this.scrollPane, "Center");
        Dimension pref = this.completionList.getPreferredSize();
        this.popupMenu.setPopupSize(pref.width + classIcon.getIconWidth(), Math.min(pref.height + 2, 300));
        this.popupMenu.setFocusable(false);
        JavaTextArea textarea = editor.getJavaTextArea();
        this.popupMenu.show((Component)((Object)textarea), location.x, textarea.getBaseline(0, 0) + location.y);
    }

    private static ImageIcon renderIcon(File dir, String word) {
        String cacheColor;
        String hexColor = Theme.get((String)("editor.completion." + word + ".color"));
        if (!hexColor.equals(cacheColor = (String)iconColors.getOrDefault(word, null))) {
            ImageIcon icon = Toolkit.renderIcon((File)new File(dir, word + ".svg"), (String)hexColor, (int)16);
            iconColors.put(word, hexColor);
            iconCache.put(word, icon);
        }
        return iconCache.get(word);
    }

    private void updateTheme() {
        Mode mode = this.editor.getMode();
        File dir = new File(mode.getFolder(), "theme/completion");
        classIcon = CompletionPanel.renderIcon(dir, "class");
        fieldIcon = CompletionPanel.renderIcon(dir, "field");
        localIcon = CompletionPanel.renderIcon(dir, "local");
        methodIcon = CompletionPanel.renderIcon(dir, "method");
        selectionBgColor = new Color(-986896);
        textColor = new Color(-14540254);
    }

    public boolean isVisible() {
        return this.popupMenu.isVisible();
    }

    public void setInvisible() {
        this.popupMenu.setVisible(false);
    }

    protected boolean insertSelection(int completionSource) {
        if (this.completionList.getSelectedValue() != null) {
            try {
                String currentSubWord = this.fetchCurrentSubWord();
                int currentSubWordLen = currentSubWord == null ? 0 : currentSubWord.length();
                String selectedSuggestion = this.completionList.getSelectedValue().getCompletionString();
                if (currentSubWord != null) {
                    selectedSuggestion = selectedSuggestion.substring(currentSubWordLen);
                } else {
                    currentSubWord = "";
                }
                Object completionString = this.completionList.getSelectedValue().getCompletionString();
                if (selectedSuggestion.endsWith(" )") && ((String)completionString).endsWith(" )")) {
                    completionString = ((String)completionString).substring(0, ((String)completionString).length() - 2) + ")";
                }
                boolean mouseClickOnOverloadedMethods = false;
                if (completionSource == 10 && ((String)completionString).endsWith("(")) {
                    mouseClickOnOverloadedMethods = true;
                }
                JavaTextArea textArea = this.editor.getJavaTextArea();
                Messages.err((String)(this.subWord + " <= sub word, Inserting suggestion=> " + selectedSuggestion + " Current sub: " + currentSubWord));
                if (currentSubWord.length() > 0) {
                    textArea.getDocument().remove(this.caretPos - currentSubWordLen, currentSubWordLen);
                }
                textArea.getDocument().insertString(this.caretPos - currentSubWordLen, (String)completionString, null);
                if (selectedSuggestion.endsWith(")") && !selectedSuggestion.endsWith("()")) {
                    int x = selectedSuggestion.indexOf(44);
                    if (x == -1) {
                        textArea.setCaretPosition(textArea.getCaretPosition() - 1);
                    } else {
                        textArea.setCaretPosition(this.caretPos + x);
                    }
                }
                if (!this.completionList.getSelectedValue().getLabel().contains("...")) {
                    this.setInvisible();
                }
                if (mouseClickOnOverloadedMethods) {
                    ((JavaTextArea)this.editor.getTextArea()).fetchPhrase();
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setInvisible();
            }
        }
        return false;
    }

    private String fetchCurrentSubWord() {
        JEditTextArea ta = this.editor.getTextArea();
        int off = ta.getCaretPosition();
        if (off < 0) {
            return null;
        }
        int line = ta.getCaretLine();
        if (line < 0) {
            return null;
        }
        String s = ta.getLineText(line);
        int x = ta.getCaretPosition() - ta.getLineStartOffset(line) - 1;
        int x1 = x - 1;
        if (x >= s.length() || x < 0) {
            return null;
        }
        Messages.log((String)(" x char: " + s.charAt(x)));
        Object word = String.valueOf(s.charAt(x));
        if (s.trim().length() == 1) {
            if (((String)(word = ((String)word).trim())).endsWith(".")) {
                word = ((String)word).substring(0, ((String)word).length() - 1);
            }
            return word;
        }
        if (((String)word).equals(".")) {
            return null;
        }
        int i = 0;
        do {
            ++i;
            if (x1 < 0 || !Character.isLetterOrDigit(s.charAt(x1)) && s.charAt(x1) != '_') break;
            word = s.charAt(x1--) + (String)word;
        } while (i <= 200);
        if (Character.isDigit(((String)word).charAt(0))) {
            return null;
        }
        if (((String)(word = ((String)word).trim())).endsWith(".")) {
            word = ((String)word).substring(0, ((String)word).length() - 1);
        }
        return word;
    }

    protected void moveUp() {
        if (this.completionList.getSelectedIndex() == 0) {
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
            this.selectIndex(this.completionList.getModel().getSize() - 1);
        } else {
            int index = Math.max(this.completionList.getSelectedIndex() - 1, 0);
            this.selectIndex(index);
            int step = this.scrollPane.getVerticalScrollBar().getMaximum() / this.completionList.getModel().getSize();
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getValue() - step);
        }
    }

    protected void moveDown() {
        if (this.completionList.getSelectedIndex() == this.completionList.getModel().getSize() - 1) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
            this.selectIndex(0);
        } else {
            int index = Math.min(this.completionList.getSelectedIndex() + 1, this.completionList.getModel().getSize() - 1);
            this.selectIndex(index);
            int step = this.scrollPane.getVerticalScrollBar().getMaximum() / this.completionList.getModel().getSize();
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getValue() + step);
        }
    }

    private void selectIndex(int index) {
        this.completionList.setSelectedIndex(index);
    }

    static {
        iconColors = new HashMap<String, String>();
        iconCache = new HashMap<String, ImageIcon>();
    }

    private static class CustomListRenderer
    extends DefaultListCellRenderer {
        private CustomListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                label.setBackground(selectionBgColor);
            }
            label.setForeground(textColor);
            if (value instanceof CompletionCandidate) {
                CompletionCandidate cc = (CompletionCandidate)value;
                switch (cc.getType()) {
                    case 6: {
                        label.setIcon(localIcon);
                        break;
                    }
                    case 1: 
                    case 5: {
                        label.setIcon(fieldIcon);
                        break;
                    }
                    case 2: 
                    case 4: {
                        label.setIcon(methodIcon);
                        break;
                    }
                    case 0: 
                    case 3: {
                        label.setIcon(classIcon);
                        break;
                    }
                    default: {
                        Messages.log((String)("(CustomListRenderer)Unknown CompletionCandidate type " + cc.getType()));
                        break;
                    }
                }
            } else {
                Messages.log((String)("(CustomListRenderer)Unknown CompletionCandidate object " + String.valueOf(value)));
            }
            return label;
        }
    }
}

