/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import processing.app.Problem;
import processing.mode.java.SyntaxProblem;
import processing.mode.java.TabLine;
import processing.mode.java.preproc.PdePreprocessIssue;

public class ProblemFactory {
    public static Problem build(PdePreprocessIssue pdePreprocessIssue, List<Integer> tabStarts) {
        int line = pdePreprocessIssue.getLine();
        TabLine tabLine = ProblemFactory.getTab(tabStarts, line);
        int tab = tabLine.getTab();
        int localLine = tabLine.getLineInTab();
        int col = pdePreprocessIssue.getCharPositionInLine();
        String message = pdePreprocessIssue.getMsg();
        if (col == 0) {
            col = 1;
        }
        return new SyntaxProblem(tab, localLine, message, 0, col);
    }

    protected static TabLine getTab(List<Integer> tabStarts, int line) {
        OptionalInt tabMaybe = IntStream.range(0, tabStarts.size()).filter(index -> line >= (Integer)tabStarts.get(index)).max();
        int tab = tabMaybe.orElse(0);
        int localLine = line - tabStarts.get(tab);
        return new TabLine(tab, line, localLine);
    }
}

