/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal.terminalinterface.jna;

import com.github.ajalt.mordant.rendering.Size;
import com.github.ajalt.mordant.terminal.terminalinterface.TerminalInterfaceJvmPosix;
import com.github.ajalt.mordant.terminal.terminalinterface.TerminalInterfacePosix;
import com.github.ajalt.mordant.terminal.terminalinterface.jna.MacosLibC;
import com.github.ajalt.mordant.terminal.terminalinterface.jna.TerminalInterface_jna_macosKt;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/ajalt/mordant/terminal/terminalinterface/jna/TerminalInterfaceJnaMacos;", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfaceJvmPosix;", "<init>", "()V", "termiosConstants", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfacePosix$TermiosConstants;", "getTermiosConstants", "()Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfacePosix$TermiosConstants;", "TCSANOW", "", "TIOCGWINSZ", "", "libC", "Lcom/github/ajalt/mordant/terminal/terminalinterface/jna/MacosLibC;", "isatty", "", "fd", "getTerminalSize", "Lcom/github/ajalt/mordant/rendering/Size;", "getStdinTermios", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfacePosix$Termios;", "setStdinTermios", "", "termios", "shouldAutoUpdateSize", "mordant-jvm-jna"})
public final class TerminalInterfaceJnaMacos
extends TerminalInterfaceJvmPosix {
    private final int TCSANOW;
    private final long TIOCGWINSZ = Platform.isMIPS() || Platform.isPPC() || Platform.isSPARC() ? 1074295912L : 21523L;
    @NotNull
    private final MacosLibC libC;

    public TerminalInterfaceJnaMacos() {
        Library library = Native.load((String)Platform.C_LIBRARY_NAME, MacosLibC.class);
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
        this.libC = (MacosLibC)library;
    }

    @NotNull
    public TerminalInterfacePosix.TermiosConstants getTermiosConstants() {
        return TerminalInterfacePosix.Companion.getMacosTermiosConstants();
    }

    protected boolean isatty(int fd) {
        return this.libC.isatty(fd) != 0;
    }

    @Nullable
    public Size getTerminalSize() {
        return TerminalInterface_jna_macosKt.access$getSttySize(100L);
    }

    @NotNull
    public TerminalInterfacePosix.Termios getStdinTermios() {
        MacosLibC.termios termios2 = new MacosLibC.termios();
        this.libC.tcgetattr(0, termios2);
        int n = UInt.constructor-impl((int)termios2.c_iflag.intValue());
        int n2 = UInt.constructor-impl((int)termios2.c_oflag.intValue());
        int n3 = UInt.constructor-impl((int)termios2.c_cflag.intValue());
        int n4 = UInt.constructor-impl((int)termios2.c_lflag.intValue());
        byte[] byArray = Arrays.copyOf(termios2.c_cc, termios2.c_cc.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return new TerminalInterfacePosix.Termios(n, n2, n3, n4, byArray, null);
    }

    public void setStdinTermios(@NotNull TerminalInterfacePosix.Termios termios2) {
        Intrinsics.checkNotNullParameter((Object)termios2, (String)"termios");
        MacosLibC.termios nativeTermios = new MacosLibC.termios();
        this.libC.tcgetattr(0, nativeTermios);
        nativeTermios.c_iflag.setValue((long)termios2.getIflag-pVg5ArA() & 0xFFFFFFFFL);
        nativeTermios.c_oflag.setValue((long)termios2.getOflag-pVg5ArA() & 0xFFFFFFFFL);
        nativeTermios.c_cflag.setValue((long)termios2.getCflag-pVg5ArA() & 0xFFFFFFFFL);
        nativeTermios.c_lflag.setValue((long)termios2.getLflag-pVg5ArA() & 0xFFFFFFFFL);
        ArraysKt.copyInto$default((byte[])termios2.getCc(), (byte[])nativeTermios.c_cc, (int)0, (int)0, (int)0, (int)14, null);
        this.libC.tcsetattr(0, this.TCSANOW, nativeTermios);
    }

    public boolean shouldAutoUpdateSize() {
        return false;
    }
}

