/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.snakeyaml.engine.kmp.exceptions;

import it.krzeminski.snakeyaml.engine.kmp.common.CharConstants;
import it.krzeminski.snakeyaml.engine.kmp.internal.utils.AppendableExtensionsKt;
import it.krzeminski.snakeyaml.engine.kmp.internal.utils.CharSequenceExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'BA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fB;\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\u000fB;\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\u0012J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u001c\u0010#\u001a\u00020\u00032\b\b\u0002\u0010$\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\u0005H\u0007J\b\u0010&\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u001a\u0010\u0010\u001a\u00020\u00118FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/exceptions/Mark;", "", "name", "", "index", "", "line", "column", "codepoints", "", "pointer", "<init>", "(Ljava/lang/String;IIILjava/util/List;I)V", "str", "", "(Ljava/lang/String;IIILjava/lang/CharSequence;I)V", "buffer", "", "(Ljava/lang/String;III[II)V", "getName", "()Ljava/lang/String;", "getIndex", "()I", "getLine", "getColumn", "getCodepoints", "()Ljava/util/List;", "getPointer", "getBuffer$annotations", "()V", "getBuffer", "()[I", "isLineBreak", "", "c", "createSnippet", "indentSize", "maxLength", "toString", "Companion", "snakeyaml-engine-kmp"})
@SourceDebugExtension(value={"SMAP\nMark.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mark.kt\nit/krzeminski/snakeyaml/engine/kmp/exceptions/Mark\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n944#2,15:168\n967#2,7:183\n*S KotlinDebug\n*F\n+ 1 Mark.kt\nit/krzeminski/snakeyaml/engine/kmp/exceptions/Mark\n*L\n122#1:168,15\n127#1:183,7\n*E\n"})
public final class Mark {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final int index;
    private final int line;
    private final int column;
    @NotNull
    private final List<Integer> codepoints;
    private final int pointer;
    @NotNull
    private static final String SNIPPET_OVERFLOW = " ... ";

    @JvmOverloads
    public Mark(@NotNull String name, int index, int line, int column, @NotNull List<Integer> codepoints, int pointer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(codepoints, (String)"codepoints");
        this.name = name;
        this.index = index;
        this.line = line;
        this.column = column;
        this.codepoints = codepoints;
        this.pointer = pointer;
    }

    public /* synthetic */ Mark(String string, int n, int n2, int n3, List list, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x20) != 0) {
            n4 = 0;
        }
        this(string, n, n2, n3, list, n4);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    @NotNull
    public final List<Integer> getCodepoints() {
        return this.codepoints;
    }

    public final int getPointer() {
        return this.pointer;
    }

    @NotNull
    public final int[] getBuffer() {
        return CollectionsKt.toIntArray((Collection)this.codepoints);
    }

    @Deprecated(message="Converted to a List<Int>, replace with `codepoints` (may change semantics)", replaceWith=@ReplaceWith(expression="codepoints", imports={}))
    public static /* synthetic */ void getBuffer$annotations() {
    }

    @Deprecated(message="No longer used - please convert CharSequence to codepoints")
    @JvmOverloads
    public Mark(@NotNull String name, int index, int line, int column, @NotNull CharSequence str, int pointer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(name, index, line, column, CharSequenceExtensionsKt.toCodePoints(str), pointer);
    }

    public /* synthetic */ Mark(String string, int n, int n2, int n3, CharSequence charSequence, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x20) != 0) {
            n4 = 0;
        }
        this(string, n, n2, n3, charSequence, n4);
    }

    @Deprecated(message="No longer used - please use a List<Int> instead of IntArray")
    @JvmOverloads
    public Mark(@NotNull String name, int index, int line, int column, @NotNull int[] buffer, int pointer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this(name, index, line, column, ArraysKt.toList((int[])buffer), pointer);
    }

    public /* synthetic */ Mark(String string, int n, int n2, int n3, int[] nArray, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x20) != 0) {
            n4 = 0;
        }
        this(string, n, n2, n3, nArray, n4);
    }

    private final boolean isLineBreak(int c) {
        return CharConstants.NULL_OR_LINEBR.has(c);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String createSnippet(int indentSize, int maxLength) {
        void $this$takeWhile$iv;
        List list;
        int halfMaxLength;
        block7: {
            void $this$takeLastWhile$iv;
            halfMaxLength = maxLength / 2;
            List list2 = CollectionsKt.take((Iterable)this.codepoints, (int)this.pointer);
            boolean $i$f$takeLastWhile = false;
            if ($this$takeLastWhile$iv.isEmpty()) {
                list = CollectionsKt.emptyList();
            } else {
                ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    int it = ((Number)iterator$iv.previous()).intValue();
                    boolean bl = false;
                    if (!this.isLineBreak(it)) continue;
                    iterator$iv.next();
                    int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                    if (expectedSize$iv == 0) {
                        list = CollectionsKt.emptyList();
                    } else {
                        ArrayList arrayList;
                        ArrayList $this$takeLastWhile_u24lambda_u248$iv = arrayList = new ArrayList(expectedSize$iv);
                        boolean bl2 = false;
                        while (iterator$iv.hasNext()) {
                            $this$takeLastWhile_u24lambda_u248$iv.add(iterator$iv.next());
                        }
                        list = arrayList;
                    }
                    break block7;
                }
                list = CollectionsKt.toList((Iterable)((Iterable)$this$takeLastWhile$iv));
            }
        }
        String lineBeforePointer = AppendableExtensionsKt.joinCodepointsToString(list);
        Iterable $i$f$takeLastWhile = CollectionsKt.drop((Iterable)this.codepoints, (int)this.pointer);
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        Object object = $this$takeWhile$iv.iterator();
        while (object.hasNext()) {
            Object item$iv = object.next();
            int it = ((Number)item$iv).intValue();
            boolean bl = false;
            if (!(!this.isLineBreak(it))) break;
            list$iv.add(item$iv);
        }
        String lineAfterPointer = AppendableExtensionsKt.joinCodepointsToString(list$iv);
        String head = lineBeforePointer.length() > halfMaxLength ? SNIPPET_OVERFLOW + StringsKt.drop((String)StringsKt.takeLast((String)lineBeforePointer, (int)halfMaxLength), (int)5) : lineBeforePointer;
        String tail = lineAfterPointer.length() > halfMaxLength ? StringsKt.dropLast((String)StringsKt.take((String)lineAfterPointer, (int)halfMaxLength), (int)5) + SNIPPET_OVERFLOW : lineAfterPointer;
        String indent = StringsKt.repeat((CharSequence)" ", (int)indentSize);
        Object $this$createSnippet_u24lambda_u242 = object = new StringBuilder();
        boolean bl = false;
        ((StringBuilder)$this$createSnippet_u24lambda_u242).append(indent);
        ((StringBuilder)$this$createSnippet_u24lambda_u242).append(head);
        ((StringBuilder)$this$createSnippet_u24lambda_u242).append(tail);
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$createSnippet_u24lambda_u242).append('\n'), (String)"append(...)");
        ((StringBuilder)$this$createSnippet_u24lambda_u242).append(indent);
        ((StringBuilder)$this$createSnippet_u24lambda_u242).append(StringsKt.repeat((CharSequence)" ", (int)head.length()));
        ((StringBuilder)$this$createSnippet_u24lambda_u242).append("^");
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String createSnippet$default(Mark mark, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 4;
        }
        if ((n3 & 2) != 0) {
            n2 = 75;
        }
        return mark.createSnippet(n, n2);
    }

    @NotNull
    public String toString() {
        String snippet = Mark.createSnippet$default(this, 0, 0, 3, null);
        return StringsKt.trimMargin$default((String)("\n            | in " + ((Object)StringsKt.trim((CharSequence)this.name)).toString() + ", line " + (this.line + 1) + ", column " + (this.column + 1) + ":\n            |" + snippet + "\n        "), null, (int)1, null);
    }

    @JvmOverloads
    public Mark(@NotNull String name, int index, int line, int column, @NotNull List<Integer> codepoints) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(codepoints, (String)"codepoints");
        this(name, index, line, column, codepoints, 0, 32, null);
    }

    @Deprecated(message="No longer used - please convert CharSequence to codepoints")
    @JvmOverloads
    public Mark(@NotNull String name, int index, int line, int column, @NotNull CharSequence str) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(name, index, line, column, str, 0, 32, null);
    }

    @Deprecated(message="No longer used - please use a List<Int> instead of IntArray")
    @JvmOverloads
    public Mark(@NotNull String name, int index, int line, int column, @NotNull int[] buffer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this(name, index, line, column, buffer, 0, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final String createSnippet(int indentSize) {
        return Mark.createSnippet$default(this, indentSize, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String createSnippet() {
        return Mark.createSnippet$default(this, 0, 0, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/exceptions/Mark$Companion;", "", "<init>", "()V", "SNIPPET_OVERFLOW", "", "snakeyaml-engine-kmp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

