/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import processing.app.Base;
import processing.app.Language;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.ui.Editor;
import processing.core.PApplet;

public class Recent {
    static final String FILENAME = "recent.txt";
    static final String VERSION = "2";
    static Base base;
    static File file;
    static List<Record> records;
    static JMenu mainMenu;
    static JMenu toolbarMenu;

    public static void init(Base b) {
        base = b;
        file = Base.getSettingsFile(FILENAME);
        mainMenu = new JMenu(Language.text("menu.file.recent"));
        toolbarMenu = new JMenu(Language.text("menu.file.open"));
        try {
            Recent.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void load() throws IOException {
        records = new ArrayList<Record>();
        if (file.exists()) {
            BufferedReader reader = PApplet.createReader((File)file);
            String version = reader.readLine();
            if (version != null && version.equals(VERSION)) {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (new File(line).exists()) {
                        records.add(new Record(line));
                        continue;
                    }
                    Messages.log("Ghost file found in recent: " + line);
                }
            }
            reader.close();
        }
        Recent.updateMenu(mainMenu);
        Recent.updateMenu(toolbarMenu);
    }

    protected static void save() {
        if (file.exists() && !file.canWrite() && !file.setWritable(true, false)) {
            System.err.println("Warning: could not set " + String.valueOf(file) + " to writable");
        }
        PrintWriter writer = PApplet.createWriter((File)file);
        writer.println(VERSION);
        for (Record record : records) {
            writer.println(record.path);
        }
        writer.flush();
        writer.close();
        Recent.updateMenu(mainMenu);
        Recent.updateMenu(toolbarMenu);
    }

    public static JMenu getMenu() {
        return mainMenu;
    }

    public static JMenu getToolbarMenu() {
        return toolbarMenu;
    }

    private static void updateMenu(JMenu menu) {
        menu.removeAll();
        String sketchbookPath = Base.getSketchbookFolder().getAbsolutePath();
        for (Record rec : records) {
            Recent.updateMenuRecord(menu, rec, sketchbookPath);
        }
    }

    private static void updateMenuRecord(JMenu menu, Record rec, String sketchbookPath) {
        try {
            String recPath = new File(rec.getPath()).getParent();
            Object purtyPath = null;
            if (recPath.startsWith(sketchbookPath)) {
                purtyPath = "sketchbook \u2192 " + recPath.substring(sketchbookPath.length() + 1);
            } else {
                List<Mode> modes = base.getModeList();
                block2: for (Mode mode : modes) {
                    File examplesFolder = mode.getExamplesFolder();
                    String examplesPath = examplesFolder.getAbsolutePath();
                    if (recPath.startsWith(examplesPath)) {
                        Object modePrefix = mode.getTitle() + " ";
                        if (mode.getTitle().equals("Standard")) {
                            modePrefix = "";
                        }
                        purtyPath = (String)modePrefix + "examples \u2192 " + recPath.substring(examplesPath.length() + 1);
                        break;
                    }
                    if (mode.coreLibraries != null) {
                        for (Library lib : mode.coreLibraries) {
                            examplesFolder = lib.getExamplesFolder();
                            examplesPath = examplesFolder.getAbsolutePath();
                            if (!recPath.startsWith(examplesPath)) continue;
                            purtyPath = lib.getName() + " examples \u2192 " + recPath.substring(examplesPath.length() + 1);
                            break;
                        }
                    }
                    if (mode.contribLibraries == null) continue;
                    for (Library lib : mode.contribLibraries) {
                        examplesFolder = lib.getExamplesFolder();
                        examplesPath = examplesFolder.getAbsolutePath();
                        if (!recPath.startsWith(examplesPath)) continue;
                        purtyPath = lib.getName() + " examples \u2192 " + recPath.substring(examplesPath.length() + 1);
                        continue block2;
                    }
                }
            }
            if (purtyPath == null) {
                String homePath = System.getProperty("user.home");
                if (recPath.startsWith(homePath)) {
                    String desktopPath = homePath + File.separator + "Desktop";
                    if (recPath.startsWith(desktopPath)) {
                        purtyPath = "Desktop \u2192 " + recPath.substring(desktopPath.length() + 1);
                    } else {
                        String userName = new File(homePath).getName();
                        purtyPath = userName + " \u2192 " + recPath.substring(homePath.length() + 1);
                    }
                } else {
                    purtyPath = recPath;
                }
            }
            JMenuItem item = new JMenuItem((String)purtyPath);
            item.addActionListener(e -> base.handleOpen(rec.path));
            menu.insert(item, 0);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static synchronized void remove(Editor editor) {
        int index = Recent.findRecord(editor.getSketch().getMainPath());
        if (index != -1) {
            records.remove(index);
        }
    }

    public static synchronized void append(Editor editor) {
        if (!editor.getSketch().isUntitled()) {
            Recent.remove(editor);
            if (records.size() == Preferences.getInteger("recent.count")) {
                records.remove(0);
            }
            records.add(new Record(editor));
            Recent.save();
        }
    }

    public static synchronized void rename(Editor editor, String oldPath) {
        int index;
        if (records.size() == Preferences.getInteger("recent.count")) {
            records.remove(0);
        }
        if ((index = Recent.findRecord(oldPath)) != -1) {
            records.remove(index);
        }
        records.add(new Record(editor));
        Recent.save();
    }

    static int findRecord(String path) {
        for (int i = 0; i < records.size(); ++i) {
            if (!path.equals(Recent.records.get((int)i).path)) continue;
            return i;
        }
        return -1;
    }

    static class Record {
        String path;

        Record(String path) {
            this.path = path;
        }

        Record(Editor editor) {
            this(editor.getSketch().getMainPath());
        }

        String getPath() {
            return this.path;
        }
    }
}

