/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import processing.app.Base;
import processing.app.Language;
import processing.app.Mode;
import processing.app.ui.Editor;
import processing.app.ui.EditorButton;
import processing.app.ui.ModeSelector;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

public abstract class EditorToolbar
extends JPanel
implements KeyListener {
    static final int HIGH = Toolkit.zoom(56);
    static final int GAP = Toolkit.zoom(9);
    protected Editor editor;
    protected Base base;
    protected Mode mode;
    protected EditorButton runButton;
    protected EditorButton stopButton;
    protected EditorButton rolloverButton;
    protected JLabel rolloverLabel;
    protected ModeSelector modeSelector;
    protected Box box;
    protected Image gradient;

    public EditorToolbar(Editor editor) {
        this.editor = editor;
        this.base = editor.getBase();
        this.mode = editor.getMode();
        this.rebuild();
    }

    public void rebuild() {
        this.removeAll();
        List<EditorButton> buttons = this.createButtons();
        this.box = Box.createHorizontalBox();
        this.box.add(Box.createHorizontalStrut(Editor.LEFT_GUTTER));
        this.rolloverLabel = new JLabel();
        for (EditorButton button : buttons) {
            this.box.add(button);
            this.box.add(Box.createHorizontalStrut(GAP));
        }
        this.box.add(this.rolloverLabel);
        this.box.add(Box.createHorizontalGlue());
        this.addModeButtons(this.box, this.rolloverLabel);
        this.modeSelector = new ModeSelector(this.editor);
        this.box.add(this.modeSelector);
        this.box.add(Box.createHorizontalStrut(Editor.RIGHT_GUTTER));
        this.setLayout(new BorderLayout());
        this.add((Component)this.box, "Center");
        this.updateTheme();
    }

    public void updateTheme() {
        this.gradient = Theme.makeGradient("toolbar", Toolkit.zoom(400), HIGH);
        this.rolloverLabel.setFont(Theme.getFont("toolbar.rollover.font"));
        this.rolloverLabel.setForeground(Theme.getColor("toolbar.rollover.color"));
        for (Component c : this.box.getComponents()) {
            if (!(c instanceof EditorButton)) continue;
            ((EditorButton)c).updateTheme();
        }
        this.modeSelector.updateTheme();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        g.drawImage(this.gradient, 0, 0, size.width, size.height, this);
    }

    public List<EditorButton> createButtons() {
        this.runButton = new EditorButton(this, "/lib/toolbar/run", Language.text("toolbar.run"), Language.text("toolbar.present")){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorToolbar.this.handleRun(e.getModifiers());
            }
        };
        this.stopButton = new EditorButton(this, "/lib/toolbar/stop", Language.text("toolbar.stop")){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorToolbar.this.handleStop();
            }
        };
        return new ArrayList<EditorButton>(Arrays.asList(this.runButton, this.stopButton));
    }

    public void addModeButtons(Box box, JLabel label) {
    }

    public void addGap(Box box) {
        box.add(Box.createHorizontalStrut(GAP));
    }

    public void activateRun() {
        this.runButton.setSelected(true);
        this.repaint();
    }

    public void deactivateRun() {
        this.runButton.setSelected(false);
        this.repaint();
    }

    public void activateStop() {
        this.stopButton.setSelected(true);
        this.repaint();
    }

    public void deactivateStop() {
        this.stopButton.setSelected(false);
        this.repaint();
    }

    public abstract void handleRun(int var1);

    public abstract void handleStop();

    void setRollover(EditorButton button, InputEvent e) {
        this.rolloverButton = button;
        this.updateRollover(e);
    }

    void updateRollover(InputEvent e) {
        if (this.rolloverButton == null) {
            this.rolloverLabel.setText("");
        } else {
            this.rolloverLabel.setText(this.rolloverButton.getRolloverText(e));
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateRollover(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.updateRollover(e);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, HIGH);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(super.getMinimumSize().width, HIGH);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, HIGH);
    }
}

