/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.WinDef;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.Util;
import processing.app.platform.DefaultPlatform;
import processing.app.platform.WindowsRegistry;
import processing.core.PApplet;

public class WindowsPlatform
extends DefaultPlatform {
    static final String APP_NAME = "Processing";
    static final Association[] ASSOCIATIONS = new Association[]{new Association(".pde", "Processing Source Code", "Processing.Document", "pde.ico"), new Association(".pyde", "Processing Python Source Code", "Processing.Document", "pde.ico"), new Association(".pdez", "Processing Sketch Bundle", "Processing.Sketch.Document", "pdez.ico"), new Association(".pdex", "Processing Contribution Bundle", "Processing.Contribution.Document", "pdex.ico")};
    static final String REG_APP_DIR = System.getProperty("user.dir").replace('/', '\\');
    static final String REG_OPEN_COMMAND = REG_APP_DIR + "\\" + "Processing".toLowerCase() + ".exe \"%1\"";
    static final String[] APP_SCHEMES = new String[]{"pde"};
    static final String AUTO_ASSOCIATE_PREF = "platform.auto_file_type_associations";
    private static final float RESOLUTION_AT_NO_SCALE = 96.0f;
    private Float cachedDisplayScaling;
    static WinLibC clib;

    @Override
    public void initBase(Base base) {
        super.initBase(base);
        this.checkAssociations();
        this.checkSchemes();
        this.checkPath();
    }

    protected void checkAssociations() {
        try {
            if (Preferences.getBoolean(AUTO_ASSOCIATE_PREF)) {
                for (Association assoc : ASSOCIATIONS) {
                    String knownCommand = WindowsRegistry.getStringValue(WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER, "Software\\Classes\\" + assoc.doc + "\\shell\\open\\command", "");
                    if (knownCommand == null || !knownCommand.equals(REG_OPEN_COMMAND)) {
                        this.setAssociations();
                    }
                    if (WindowsRegistry.valueExists(WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER, "Software\\Classes", assoc.extension) && WindowsRegistry.valueExists(WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER, "Software\\Classes\\" + assoc.doc, "DefaultIcon")) continue;
                    this.setAssociations();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void checkSchemes() {
        try {
            for (String extension : APP_SCHEMES) {
                if (WindowsRegistry.valueExists(WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER, "Software\\Classes", extension)) continue;
                this.setSchemes();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setAssociations() throws UnsupportedEncodingException {
        for (Association assoc : ASSOCIATIONS) {
            if (assoc.register()) continue;
            Messages.log("Could not associate " + assoc.extension + "files, turning off auto-associate pref.");
            Preferences.setBoolean(AUTO_ASSOCIATE_PREF, false);
        }
    }

    protected void setSchemes() throws UnsupportedEncodingException {
        for (String scheme : APP_SCHEMES) {
            if (this.registerScheme(scheme)) continue;
            Messages.log("Error while trying to associate " + scheme + ":// URLs.");
        }
    }

    private static boolean registerOpen(WindowsRegistry.REGISTRY_ROOT_KEY rootKey, String prefix) throws UnsupportedEncodingException {
        return WindowsRegistry.createKey(rootKey, prefix, "shell") && WindowsRegistry.createKey(rootKey, prefix + "\\shell", "open") && WindowsRegistry.createKey(rootKey, prefix + "\\shell\\open", "command") && WindowsRegistry.setStringValue(rootKey, prefix + "\\shell\\open\\command", "", REG_OPEN_COMMAND);
    }

    private boolean registerScheme(String scheme) throws UnsupportedEncodingException {
        WindowsRegistry.REGISTRY_ROOT_KEY rootKey = WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER;
        String prefix = "Software\\Classes\\" + scheme;
        return WindowsRegistry.createKey(rootKey, "Software\\Classes", scheme) && WindowsRegistry.setStringValue(rootKey, prefix, "", "URL:" + scheme + " Protocol") && WindowsRegistry.setStringValue(rootKey, prefix, "URL Protocol", "") && WindowsPlatform.registerOpen(rootKey, prefix);
    }

    protected void checkPath() {
        String path = System.getProperty("java.library.path");
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        String[] legit = new String[pieces.length];
        int legitCount = 0;
        for (String item : pieces) {
            File directory;
            if (item.startsWith("\"")) {
                item = item.substring(1);
            }
            if (item.endsWith("\"")) {
                item = item.substring(0, item.length() - 1);
            }
            if (item.endsWith(File.separator)) {
                item = item.substring(0, item.length() - File.separator.length());
            }
            if (!(directory = new File(item)).exists() || item.trim().length() == 0) continue;
            legit[legitCount++] = item;
        }
        String newPath = PApplet.join((String[])(legit = PApplet.subset((String[])legit, (int)0, (int)legitCount)), (String)File.pathSeparator);
        if (!newPath.equals(path)) {
            System.setProperty("java.library.path", newPath);
        }
    }

    @Override
    public File getSettingsFolder() throws Exception {
        File override = Base.getSettingsOverride();
        if (override != null) {
            return override;
        }
        try {
            File settingsFolder;
            File settingsFolder2;
            String appDataRoaming = WindowsPlatform.getAppDataPath();
            if (appDataRoaming != null && ((settingsFolder2 = new File(appDataRoaming, APP_NAME)).exists() || settingsFolder2.mkdirs())) {
                return settingsFolder2;
            }
            String appDataLocal = WindowsPlatform.getLocalAppDataPath();
            if (appDataLocal != null && ((settingsFolder = new File(appDataLocal, APP_NAME)).exists() || settingsFolder.mkdirs())) {
                return settingsFolder;
            }
            if (appDataRoaming == null && appDataLocal == null) {
                throw new IOException("Could not get the AppData folder");
            }
            throw new IOException("Permissions error: make sure that " + appDataRoaming + " or " + appDataLocal + " is writable.");
        }
        catch (UnsatisfiedLinkError ule) {
            String path = new File("lib").getCanonicalPath();
            String msg = Util.containsNonASCII(path) ? "  Please move Processing to a location with only\n  ASCII characters in the path and try again.\n  https://github.com/processing/processing/issues/3543\n" : "Could not find JNA support files, please reinstall Processing.";
            Messages.showError("Windows JNA Problem", msg, ule);
            return null;
        }
    }

    private static String getAppDataPath() {
        return Shell32Util.getSpecialFolderPath((int)26, (boolean)true);
    }

    private static String getLocalAppDataPath() {
        return Shell32Util.getSpecialFolderPath((int)28, (boolean)true);
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        String documentsPath = WindowsPlatform.getDocumentsPath();
        if (documentsPath != null) {
            return new File(documentsPath, APP_NAME);
        }
        return null;
    }

    private static String getDocumentsPath() {
        return Shell32Util.getSpecialFolderPath((int)5, (boolean)true);
    }

    static WinLibC getLibC() {
        if (clib == null) {
            try {
                clib = (WinLibC)Native.load((String)"msvcrt", WinLibC.class);
            }
            catch (UnsatisfiedLinkError ule) {
                Messages.showTrace("JNA Error", "JNA could not be loaded. Please report here:\nhttp://github.com/processing/processing/issues/new", ule, true);
            }
        }
        return clib;
    }

    public void setenv(String variable, String value) {
        WindowsPlatform.getLibC()._putenv(variable + "=" + value);
    }

    public String getenv(String variable) {
        return System.getenv(variable);
    }

    public int unsetenv(String variable) {
        return WindowsPlatform.getLibC()._putenv(variable + "=");
    }

    @Override
    public float getSystemZoom() {
        if (this.cachedDisplayScaling == null) {
            this.cachedDisplayScaling = Float.valueOf(this.calculateSystemZoom());
        }
        return this.cachedDisplayScaling.floatValue();
    }

    private float calculateSystemZoom() {
        WinDef.HDC hdc = GDI32.INSTANCE.CreateCompatibleDC(null);
        if (hdc == null) {
            float resolution = Toolkit.getDefaultToolkit().getScreenResolution();
            return resolution / 96.0f;
        }
        int VERTRES = 10;
        int DESKTOPVERTRES = 117;
        float virtualResolution = GDI32.INSTANCE.GetDeviceCaps(hdc, 10);
        float logicalResolution = GDI32.INSTANCE.GetDeviceCaps(hdc, 117);
        GDI32.INSTANCE.DeleteDC(hdc);
        return logicalResolution / virtualResolution;
    }

    static class Association {
        String extension;
        String title;
        String doc;
        String icon;

        Association(String extension, String title, String doc, String icon) {
            this.extension = extension;
            this.title = title;
            this.doc = doc;
            this.icon = icon;
        }

        boolean register() throws UnsupportedEncodingException {
            WindowsRegistry.REGISTRY_ROOT_KEY rootKey = WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER;
            String iconPath = REG_APP_DIR + "\\lib\\" + this.icon;
            return WindowsRegistry.createKey(rootKey, "Software\\Classes", this.extension) && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\" + this.extension, "", this.doc) && WindowsRegistry.createKey(rootKey, "Software\\Classes", this.doc) && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\" + this.doc, "", this.title) && WindowsRegistry.createKey(rootKey, "Software\\Classes\\" + this.doc, "DefaultIcon") && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\" + this.doc + "\\DefaultIcon", "", iconPath) && WindowsPlatform.registerOpen(rootKey, "Software\\Classes\\" + this.doc);
        }
    }

    public static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

