/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.Desktop;
import java.awt.Font;
import java.io.File;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.ui.Toolkit;
import processing.awt.ShimAWT;
import processing.core.PApplet;

public class DefaultPlatform {
    private final String[] FONT_SCALING_WIDGETS = new String[]{"Button", "CheckBox", "CheckBoxMenuItem", "ComboBox", "Label", "List", "Menu", "MenuBar", "MenuItem", "OptionPane", "Panel", "PopupMenu", "ProgressBar", "RadioButton", "RadioButtonMenuItem", "ScrollPane", "TabbedPane", "Table", "TableHeader", "TextArea", "TextField", "TextPane", "TitledBorder", "ToggleButton", "ToolBar", "ToolTip", "Tree", "Viewport"};
    Base base;

    public void initBase(Base base) {
        this.base = base;
    }

    public void setLookAndFeel() throws Exception {
        Font defaultFont = Toolkit.getSansFont(14, 0);
        UIManager.put("defaultFont", defaultFont);
        FlatLaf.registerCustomDefaultsSource((String)"processing.app.laf");
        UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
        UIManager.put("ToolTip.border", new EmptyBorder(0, 0, 0, 0));
    }

    public void setInterfaceZoom() throws Exception {
        if (!Preferences.getBoolean("editor.zoom.auto")) {
            for (String widgetName : this.FONT_SCALING_WIDGETS) {
                this.scaleDefaultFont(widgetName);
            }
        }
    }

    public void saveLanguage(String languageCode) {
    }

    public File getSettingsFolder() throws Exception {
        File override = Base.getSettingsOverride();
        if (override != null) {
            return override;
        }
        File home2 = new File(System.getProperty("user.home"));
        return new File(home2, ".processing");
    }

    public File getDefaultSketchbookFolder() throws Exception {
        return new File(System.getProperty("user.home"), "sketchbook");
    }

    public void openURL(String url) throws Exception {
        if (!ShimAWT.openLink((String)url)) {
            PApplet.launch((String[])new String[]{url});
        }
    }

    public boolean openFolderAvailable() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    public void openFolder(File file) throws Exception {
        Desktop.getDesktop().open(file);
    }

    public float getSystemZoom() {
        return 1.0f;
    }

    private void scaleDefaultFont(String name) {
        String fontPropertyName = name + ".font";
        Font currentFont = (Font)UIManager.get(fontPropertyName);
        float newSize = Toolkit.zoom(currentFont.getSize());
        Font newFont = currentFont.deriveFont(newSize);
        UIManager.put(fontPropertyName, newFont);
    }
}

