/*
 * Decompiled with CFR 0.152.
 */
package processing.app.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import processing.app.Console;

public class StreamRedirectThread
extends Thread {
    private final Reader in;
    private final Writer out;
    private static final int BUFFER_SIZE = 2048;

    public StreamRedirectThread(String name, InputStream in, OutputStream out) {
        super(name);
        this.in = new InputStreamReader(in);
        this.out = new OutputStreamWriter(out);
        this.setPriority(9);
    }

    public StreamRedirectThread(String name, Reader in, Writer out) {
        super(name);
        this.in = in;
        this.out = out;
        this.setPriority(9);
    }

    @Override
    public void run() {
        try {
            int count;
            char[] cbuf = new char[2048];
            while ((count = this.in.read(cbuf, 0, 2048)) >= 0) {
                this.out.write(cbuf, 0, count);
                this.out.flush();
            }
            this.out.flush();
        }
        catch (IOException exc) {
            Console.systemErr("Child I/O Transfer - " + String.valueOf(exc));
        }
    }
}

