/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

public class ManagerTabs
extends Box {
    static final int HIGH = Toolkit.zoom(31);
    static final int BORDER = Toolkit.zoom(8);
    static final int CURVE_RADIUS = Toolkit.zoom(6);
    static final int TAB_BETWEEN = Toolkit.zoom(2);
    static final int MARGIN = Toolkit.zoom(13);
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    Color[] textColor = new Color[2];
    Color[] tabColor = new Color[2];
    List<Tab> tabList = new ArrayList<Tab>();
    Font font;
    int fontAscent;
    Image gradient;
    JPanel cardPanel;
    CardLayout cardLayout;
    Controller controller;
    Component currentPanel;

    public ManagerTabs() {
        super(1);
        this.updateTheme();
        this.setBorder(new EmptyBorder(BORDER, BORDER, BORDER, BORDER));
        this.controller = new Controller();
        this.add(this.controller);
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.add(this.cardPanel);
    }

    protected void updateTheme() {
        this.textColor[1] = Theme.getColor("manager.tab.text.selected.color");
        this.textColor[0] = Theme.getColor("manager.tab.text.unselected.color");
        this.font = Theme.getFont("manager.tab.text.font");
        this.tabColor[1] = Theme.getColor("manager.tab.selected.color");
        this.tabColor[0] = Theme.getColor("manager.tab.unselected.color");
        this.gradient = Theme.makeGradient("manager.tab", Toolkit.zoom(400), HIGH);
        this.repaint();
    }

    public void addPanel(Component comp, String name) {
        if (this.tabList.isEmpty()) {
            this.currentPanel = comp;
        }
        this.tabList.add(new Tab(comp, name));
        this.cardPanel.add(name, comp);
    }

    public void setPanel(Component comp) {
        for (Tab tab : this.tabList) {
            if (tab.comp != comp) continue;
            this.currentPanel = comp;
            this.cardLayout.show(this.cardPanel, tab.name);
            this.repaint();
        }
    }

    public Component getPanel() {
        return this.currentPanel;
    }

    class Controller
    extends JComponent {
        Controller() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int x = e.getX();
                    for (Tab tab : ManagerTabs.this.tabList) {
                        if (!tab.contains(x)) continue;
                        ManagerTabs.this.setPanel(tab.comp);
                        Controller.this.repaint();
                    }
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            if (g == null) {
                return;
            }
            g.setFont(ManagerTabs.this.font);
            if (ManagerTabs.this.fontAscent == 0) {
                ManagerTabs.this.fontAscent = (int)Toolkit.getAscent(g);
            }
            Graphics2D g2 = Toolkit.prepareGraphics(g);
            g.drawImage(ManagerTabs.this.gradient, 0, 0, this.getWidth(), this.getHeight(), this);
            for (Tab tab : ManagerTabs.this.tabList) {
                tab.textWidth = (int)ManagerTabs.this.font.getStringBounds(tab.name, g2.getFontRenderContext()).getWidth();
            }
            this.placeTabs();
            this.drawTabs(g2);
        }

        private void placeTabs() {
            int x = 0;
            for (Tab tab : ManagerTabs.this.tabList) {
                tab.left = x;
                x += MARGIN;
                tab.right = x += tab.textWidth + MARGIN;
                x += TAB_BETWEEN;
            }
            Tab lastTab = ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 1);
            int offset = this.getWidth() - lastTab.right;
            lastTab.left += offset;
            lastTab.right += offset;
        }

        private void drawTabs(Graphics2D g) {
            for (Tab tab : ManagerTabs.this.tabList) {
                tab.draw(g);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(300, HIGH);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, HIGH);
        }
    }

    class Tab {
        String name;
        Component comp;
        boolean notification;
        int left;
        int right;
        int textWidth;

        Tab(Component comp, String name) {
            this.comp = comp;
            this.name = name;
        }

        boolean contains(int x) {
            return x >= this.left && x <= this.right;
        }

        boolean isCurrent() {
            return this.comp.isVisible();
        }

        boolean hasLeftNotch() {
            return ManagerTabs.this.tabList.get(0) == this || ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 1) == this;
        }

        boolean hasRightNotch() {
            return ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 1) == this || ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 2) == this;
        }

        int getTextLeft() {
            return this.left + (this.right - this.left - this.textWidth) / 2;
        }

        void draw(Graphics g) {
            int state = this.isCurrent() ? 1 : 0;
            g.setColor(ManagerTabs.this.tabColor[state]);
            Graphics2D g2 = (Graphics2D)g;
            g2.fill(Toolkit.createRoundRect(this.left, 0.0f, this.right, HIGH, this.hasLeftNotch() ? (float)CURVE_RADIUS : 0.0f, this.hasRightNotch() ? (float)CURVE_RADIUS : 0.0f, 0.0f, 0.0f));
            int textLeft = this.getTextLeft();
            if (this.notification && state == 0) {
                g.setColor(ManagerTabs.this.textColor[1]);
            } else {
                g.setColor(ManagerTabs.this.textColor[state]);
            }
            int baseline = (HIGH + ManagerTabs.this.fontAscent) / 2;
            g.drawString(this.name, textLeft, baseline);
        }
    }
}

