/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class Settings {
    Map<String, String> defaults;
    Map<String, String> table = new HashMap<String, String>();
    File file;

    public Settings(File file) throws IOException {
        this.file = file;
        if (file.exists()) {
            this.load();
        }
        this.defaults = new HashMap<String, String>(this.table);
    }

    public void load() {
        this.load(this.file);
    }

    public void load(File additions) {
        String[] lines = PApplet.loadStrings((File)additions);
        if (lines != null) {
            for (String line : lines) {
                int equals;
                if (line.length() == 0 || line.charAt(0) == '#' || (equals = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, equals).trim();
                String value = line.substring(equals + 1).trim();
                this.table.put(key, value);
            }
        } else {
            Messages.err(String.valueOf(additions) + " could not be read");
        }
        String platformExt = "." + Platform.getName();
        int platformExtLength = platformExt.length();
        for (String key : this.table.keySet()) {
            if (!key.endsWith(platformExt)) continue;
            String actualKey = key.substring(0, key.length() - platformExtLength);
            String value = this.get(key);
            this.table.put(actualKey, value);
        }
    }

    public void save() {
        this.save(this.file);
    }

    public void save(File outputFile) {
        PrintWriter writer = PApplet.createWriter((File)outputFile);
        String[] keyList = this.table.keySet().toArray(new String[0]);
        for (String key : keyList = PApplet.sort((String[])keyList)) {
            writer.println(key + "=" + this.table.get(key));
        }
        writer.flush();
        writer.close();
    }

    public String get(String attribute) {
        return this.table.get(attribute);
    }

    public String getDefault(String attribute) {
        return this.defaults.get(attribute);
    }

    public void set(String attribute, String value) {
        this.table.put(attribute, value);
    }

    public boolean getBoolean(String attribute) {
        String value = this.get(attribute);
        if (value == null) {
            System.err.println("Boolean not found: " + attribute);
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public void setBoolean(String attribute, boolean value) {
        this.set(attribute, value ? "true" : "false");
    }

    public int getInteger(String attribute) {
        String value = this.get(attribute);
        if (value == null) {
            System.err.println("Integer not found: " + attribute);
            return 0;
        }
        return Integer.parseInt(value);
    }

    public void setInteger(String key, int value) {
        this.set(key, String.valueOf(value));
    }

    public Color getColor(String attribute) {
        Color outgoing = null;
        String s = this.get(attribute);
        if (s != null) {
            try {
                if (s.startsWith("#")) {
                    outgoing = new Color(Integer.parseInt(s.substring(1), 16));
                } else if (s.startsWith("0x")) {
                    int v = Integer.parseInt(s.substring(2), 16);
                    outgoing = new Color(v, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (outgoing == null) {
            System.err.println("Could not parse color " + s + " for " + attribute);
        }
        return outgoing;
    }

    public void setColor(String attr, Color what) {
        this.set(attr, "#" + PApplet.hex((int)(what.getRGB() & 0xFFFFFF), (int)6));
    }

    public Font getFont(String attr) {
        try {
            String[] pieces;
            boolean replace = false;
            String value = this.get(attr);
            if (value == null) {
                value = this.getDefault(attr);
                replace = true;
            }
            if ((pieces = PApplet.split((String)value, (char)',')).length != 3) {
                value = this.getDefault(attr);
                pieces = PApplet.split((String)value, (char)',');
                replace = true;
            }
            String name = pieces[0];
            int style = 0;
            if (pieces[1].contains("bold")) {
                style |= 1;
            }
            if (pieces[1].contains("italic")) {
                style |= 2;
            }
            int size = PApplet.parseInt((String)pieces[2], (int)12);
            size = Toolkit.zoom(size);
            if (replace) {
                this.set(attr, value);
            }
            if (!name.startsWith("processing.")) {
                return new Font(name, style, size);
            }
            if (pieces[0].equals("processing.sans")) {
                return Toolkit.getSansFont(size, style);
            }
            if (pieces[0].equals("processing.mono")) {
                return Toolkit.getMonoFont(size, style);
            }
        }
        catch (Exception e) {
            Messages.log("Error with font " + this.get(attr) + " for attribute " + attr);
        }
        return new Font("Dialog", 0, 12);
    }

    public String remove(String key) {
        return this.table.remove(key);
    }

    public void reckon() {
        if (this.table.isEmpty()) {
            if (this.file.exists() && !this.file.delete()) {
                System.err.println("Could not remove empty " + String.valueOf(this.file));
            }
        } else {
            this.save();
        }
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public void print() {
        Object[] keys = this.table.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            System.out.println((String)key + " = " + this.table.get(key));
        }
    }

    public Map<String, String> getMap() {
        return this.table;
    }
}

