/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.Messages;

public class ReferenceServer {
    private final HttpServer server;
    private final ZipFile zip;
    private final Map<String, ZipEntry> entries;
    private final int port;
    static final Map<String, String> contentTypes = new ConcurrentHashMap<String, String>();

    public ReferenceServer(File zipFile, int port) throws IOException {
        this.zip = new ZipFile(zipFile);
        this.port = port;
        this.entries = new HashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> en = this.zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            this.entries.put(entry.getName(), entry);
        }
        this.server = HttpServer.create(new InetSocketAddress(port), 0);
        this.server.createContext("/", new ReferenceHandler());
        this.server.setExecutor(Executors.newFixedThreadPool(10));
        this.server.start();
        Messages.log("Reference server started on port " + port);
    }

    public String getPrefix() {
        return "http://localhost:" + this.port + "/";
    }

    public void stop() {
        this.server.stop(0);
        try {
            this.zip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            new ReferenceServer(new File(args[0]), 8053);
            System.out.println("Server running at http://localhost:8053/");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        contentTypes.put("", "content/unknown");
        contentTypes.put(".css", "text/css");
        contentTypes.put(".csv", "text/csv");
        contentTypes.put(".eot", "application/vnd.ms-fontobject");
        contentTypes.put(".gif", "image/gif");
        contentTypes.put(".html", "text/html");
        contentTypes.put(".ico", "image/x-icon");
        contentTypes.put(".jpeg", "image/jpeg");
        contentTypes.put(".jpg", "image/jpeg");
        contentTypes.put(".js", "text/javascript");
        contentTypes.put(".json", "application/json");
        contentTypes.put(".md", "text/markdown");
        contentTypes.put(".mdx", "text/mdx");
        contentTypes.put(".mtl", "text/plain");
        contentTypes.put(".obj", "text/plain");
        contentTypes.put(".otf", "font/otf");
        contentTypes.put(".pde", "text/plain");
        contentTypes.put(".png", "image/png");
        contentTypes.put(".svg", "image/svg+xml");
        contentTypes.put(".tsv", "text/tab-separated-values");
        contentTypes.put(".ttf", "font/ttf");
        contentTypes.put(".txt", "text/plain");
        contentTypes.put(".vlw", "application/octet-stream");
        contentTypes.put(".woff", "font/woff");
        contentTypes.put(".woff2", "font/woff2");
        contentTypes.put(".xml", "application/xml");
        contentTypes.put(".yml", "text/yaml");
        contentTypes.put(".zip", "application/zip");
    }

    class ReferenceHandler
    implements HttpHandler {
        ReferenceHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            ZipEntry entry;
            Object path = exchange.getRequestURI().getPath();
            if (((String)path).startsWith("/")) {
                path = ((String)path).substring(1);
            }
            if (((String)path).isEmpty() || ((String)path).endsWith("/")) {
                path = (String)path + "index.html";
            }
            if ((entry = ReferenceServer.this.entries.get(path)) != null) {
                String contentType = "application/octet-stream";
                int dotIndex = ((String)path).lastIndexOf(46);
                if (dotIndex > 0) {
                    String extension = ((String)path).substring(dotIndex);
                    contentType = contentTypes.getOrDefault(extension, "application/octet-stream");
                }
                exchange.getResponseHeaders().set("Content-Type", contentType);
                exchange.getResponseHeaders().set("Content-Length", String.valueOf(entry.getSize()));
                exchange.sendResponseHeaders(200, entry.getSize());
                try (OutputStream os = exchange.getResponseBody();
                     InputStream is = ReferenceServer.this.zip.getInputStream(entry);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                }
                Messages.log("Serving: " + (String)path + " (" + contentType + ")");
            } else {
                String response = "<html><body><h1>404 Not Found</h1><p>The requested resource was not found.</p></body></html>";
                exchange.getResponseHeaders().set("Content-Type", "text/html");
                exchange.sendResponseHeaders(404, response.length());
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(response.getBytes());
                }
                Messages.log("404 Not Found: " + (String)path);
            }
        }
    }
}

