/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.github.ajalt.clikt.command.CoreSuspendingCliktCommand;
import com.github.ajalt.clikt.command.CoreSuspendingCliktCommandKt;
import com.github.ajalt.clikt.core.BaseCliktCommand;
import com.github.ajalt.clikt.core.BaseCliktCommandKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.RunSuspendKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import processing.app.Base;
import processing.app.LSP;
import processing.app.LegacyCLI;
import processing.app.Processing;
import processing.app.api.Contributions;
import processing.app.api.SketchCommand;
import processing.app.api.Sketchbook;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0005\u001a\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateInstallLocations", "app"})
@SourceDebugExtension(value={"SMAP\nProcessing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Processing.kt\nprocessing/app/ProcessingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n739#2,9:148\n774#2:157\n865#2,2:158\n*S KotlinDebug\n*F\n+ 1 Processing.kt\nprocessing/app/ProcessingKt\n*L\n106#1:148,9\n107#1:157\n107#1:158,2\n*E\n"})
public final class ProcessingKt {
    @Nullable
    public static final Object main(@NotNull String[] args, @NotNull Continuation<? super Unit> $completion) {
        CoreSuspendingCliktCommand[] coreSuspendingCliktCommandArray = new CoreSuspendingCliktCommand[]{new LSP(), new LegacyCLI(args), new Contributions(), new Sketchbook(), new SketchCommand()};
        Object object = CoreSuspendingCliktCommandKt.main((CoreSuspendingCliktCommand)((CoreSuspendingCliktCommand)BaseCliktCommandKt.subcommands((BaseCliktCommand)((BaseCliktCommand)new Processing()), (BaseCliktCommand[])((BaseCliktCommand[])coreSuspendingCliktCommandArray))), (String[])args, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateInstallLocations() {
        void $this$filterTo$iv$iv;
        List list;
        Object iterator$iv;
        Preferences preferences = Preferences.userRoot().node("org/processing/app");
        String string2 = preferences.get("installLocations", "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        String[] stringArray = new String[]{","};
        List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        iterator$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            String install = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                String[] stringArray2 = new String[]{"^"};
                List list2 = StringsKt.split$default((CharSequence)install, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                String path = (String)list2.get(0);
                String version = (String)list2.get(1);
                File file = new File(path);
                if (!file.exists() || file.isDirectory()) {
                    bl = false;
                } else {
                    String[] stringArray3 = new String[]{path, "--version"};
                    Process process = new ProcessBuilder(stringArray3).redirectErrorStream(true).start();
                    int exitCode = process.waitFor();
                    if (exitCode != 0) {
                        bl = false;
                    } else {
                        InputStream inputStream;
                        Intrinsics.checkNotNullExpressionValue((Object)process.getInputStream(), (String)"getInputStream(...)");
                        Charset charset = Charsets.UTF_8;
                        Reader reader = new InputStreamReader(inputStream, charset);
                        int n = 8192;
                        String output = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                        bl = StringsKt.contains$default((CharSequence)output, (CharSequence)version, (boolean)false, (int)2, null);
                    }
                }
            }
            catch (Exception e) {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List installLocations = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Optional<String> command = ProcessHandle.current().info().command();
        if (command.isEmpty()) {
            return;
        }
        String installLocation = command.get() + "^" + Base.getVersionName();
        if (installLocations.contains(installLocation)) {
            return;
        }
        installLocations.add(installLocation);
        preferences.put("installLocations", String.join((CharSequence)",", installLocations));
    }

    public static /* synthetic */ void main(String[] args) {
        RunSuspendKt.runSuspend((Function1)((Function1)new Function1<Object>(args){
            private /* synthetic */ String[] args;

            @Nullable
            public final Object invoke(@NotNull Continuation<Object> $completion) {
                return ProcessingKt.main(this.args, $completion);
            }
            {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                super(1);
                this.args = args;
            }
        }));
    }
}

