/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.ui.Editor;

public class ChangeDetector
implements WindowFocusListener {
    private final Sketch sketch;
    private final Editor editor;
    private final List<SketchCode> ignoredRemovals = new ArrayList<SketchCode>();
    private final List<SketchCode> ignoredModifications = new ArrayList<SketchCode>();
    private static final int MODIFICATION_WINDOW_MILLIS = Preferences.getInteger("editor.watcher.window");
    private static final boolean DEBUG = Preferences.getBoolean("editor.watcher.debug");

    public ChangeDetector(Editor editor) {
        this.sketch = editor.sketch;
        this.editor = editor;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        if (Preferences.getBoolean("editor.watcher") && this.sketch != null) {
            this.sketch.ensureExistence();
            this.checkFiles();
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    private void checkFiles() {
        boolean ask;
        ArrayList<String> filenames = new ArrayList<String>();
        ArrayList<String> extensions = new ArrayList<String>();
        this.sketch.getSketchCodeFiles(filenames, extensions);
        SketchCode[] codes = this.sketch.getCode();
        Map<Boolean, List<SketchCode>> existsMap = Arrays.stream(codes).collect(Collectors.groupingBy(code -> filenames.contains(code.getFileName())));
        List codeFilenames = Arrays.stream(codes).map(SketchCode::getFileName).collect(Collectors.toList());
        List addedFilenames = filenames.stream().filter(f -> !codeFilenames.contains(f)).collect(Collectors.toList());
        boolean added = !addedFilenames.isEmpty();
        List removedCodes = Optional.ofNullable(existsMap.get(Boolean.FALSE)).orElse(Collections.emptyList());
        List<SketchCode> removedCodesFinal = removedCodes.stream().filter(code -> !this.ignoredRemovals.contains(code)).collect(Collectors.toList());
        boolean removed = !removedCodesFinal.isEmpty();
        List modifiedCodes = existsMap.getOrDefault(Boolean.TRUE, Collections.emptyList());
        ArrayList<SketchCode> modifiedCodesFinal = new ArrayList<SketchCode>();
        for (SketchCode code2 : modifiedCodes) {
            if (this.ignoredModifications.contains(code2)) continue;
            long fileLastModified = code2.getFile().lastModified();
            long codeLastModified = code2.getLastModified();
            long diff = fileLastModified - codeLastModified;
            if (fileLastModified != 0L && diff <= (long)MODIFICATION_WINDOW_MILLIS) continue;
            modifiedCodesFinal.add(code2);
        }
        boolean modified = !modifiedCodesFinal.isEmpty();
        this.ignoredModifications.retainAll(modifiedCodes);
        this.ignoredRemovals.retainAll(removedCodes);
        boolean changes = added || removed || modified;
        List<SketchCode> mergeConflicts = modifiedCodesFinal.stream().filter(SketchCode::isModified).collect(Collectors.toList());
        boolean bl = ask = !mergeConflicts.isEmpty() || removed;
        if (DEBUG) {
            System.out.println("ask: " + ask + "\nmerge conflicts: " + String.valueOf(mergeConflicts) + ",\nadded filenames: " + String.valueOf(addedFilenames) + ",\nremoved codes: " + String.valueOf(removedCodes) + ",\nignored removed: " + String.valueOf(this.ignoredRemovals) + ",\nmodified codes: " + String.valueOf(modifiedCodesFinal) + "\n");
        }
        if (changes) {
            for (int i = 0; i < filenames.size(); ++i) {
                for (String addedTab : addedFilenames) {
                    if (!((String)filenames.get(i)).equals(addedTab)) continue;
                    this.sketch.loadNewTab((String)filenames.get(i), (String)extensions.get(i), true);
                }
            }
            for (SketchCode modifiedCode : modifiedCodesFinal) {
                if (mergeConflicts.contains(modifiedCode)) continue;
                this.sketch.loadNewTab(modifiedCode.getFileName(), modifiedCode.getExtension(), false);
            }
            if (ask) {
                this.sketch.updateSketchCodes();
                this.showReloadPrompt(mergeConflicts, removedCodesFinal, scReload -> {
                    try {
                        File file = scReload.getFile();
                        File autosave = File.createTempFile(scReload.getPrettyName(), ".autosave", file.getParentFile());
                        scReload.copyTo(autosave);
                    }
                    catch (IOException e) {
                        Messages.showWarning("Could not autosave modified tab", "Your changes to " + scReload.getPrettyName() + " have not been saved, so we won't load the new version.", e);
                        scReload.setModified(true);
                        this.ignoredModifications.add((SketchCode)scReload);
                        return;
                    }
                    this.sketch.loadNewTab(scReload.getFileName(), scReload.getExtension(), false);
                }, scKeep -> {
                    scKeep.setLastModified();
                    scKeep.setModified(true);
                }, this.sketch::removeCode, scResave -> {
                    try {
                        scResave.save();
                    }
                    catch (IOException e) {
                        if (this.sketch.getCode(0).equals(scResave)) {
                            Messages.showWarning(scResave.getFileName() + " deleted and not re-saved", "Your main tab was deleted, and Processing couldn't resave it.\nYour sketch won't work without the main tab.", e);
                        } else {
                            Messages.showWarning("Could not re-save deleted tab", "Your copy of " + scResave.getPrettyName() + " will stay in the editor.", e);
                        }
                        this.ignoredRemovals.add((SketchCode)scResave);
                        scResave.setModified(true);
                    }
                });
            }
            this.editor.rebuildHeader();
            this.sketch.setCurrentCode(this.sketch.getCurrentCodeIndex());
            this.editor.repaintHeader();
            this.editor.sketchChanged();
        }
    }

    private void showReloadPrompt(List<SketchCode> mergeConflict, List<SketchCode> removed, Consumer<SketchCode> modifiedReload, Consumer<SketchCode> modifiedKeep, Consumer<SketchCode> delete2, Consumer<SketchCode> deletedResave) {
        for (SketchCode sc : mergeConflict) {
            if (1 == Messages.showCustomQuestion(this.editor, Language.text("change_detect.reload.title"), Language.interpolate("change_detect.reload.question", sc.getFileName()), Language.text("change_detect.reload.comment"), 0, Language.text("change_detect.button.keep"), Language.text("change_detect.button.load_new"))) {
                modifiedReload.accept(sc);
                continue;
            }
            modifiedKeep.accept(sc);
        }
        for (SketchCode sc : removed) {
            if (!this.sketch.getCode(0).equals(sc) && 1 == Messages.showCustomQuestion(this.editor, Language.text("change_detect.delete.title"), Language.interpolate("change_detect.delete.question", sc.getFileName()), Language.text("change_detect.delete.comment"), 0, Language.text("change_detect.button.resave"), Language.text("change_detect.button.discard"))) {
                delete2.accept(sc);
                continue;
            }
            deletedResave.accept(sc);
        }
    }
}

