/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import processing.app.Base;
import processing.app.Messages;
import processing.app.platform.DefaultPlatform;
import processing.app.ui.About;
import processing.core.PApplet;
import processing.data.StringList;

public class MacPlatform
extends DefaultPlatform {
    private static Boolean xcodeInstalled;

    @Override
    public void saveLanguage(String language) {
        String[] cmdarray = new String[]{"defaults", "write", System.getProperty("user.home") + "/Library/Preferences/org.processing.app", "AppleLanguages", "-array", language};
        try {
            Runtime.getRuntime().exec(cmdarray);
        }
        catch (IOException e) {
            Messages.log("Error saving platform language: " + e.getMessage());
        }
    }

    @Override
    public void initBase(Base base) {
        super.initBase(base);
        Desktop desktop = Desktop.getDesktop();
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        JMenuBar defaultMenuBar = new JMenuBar();
        JMenu fileMenu = base.initDefaultFileMenu();
        defaultMenuBar.add(fileMenu);
        desktop.setDefaultMenuBar(defaultMenuBar);
        desktop.setAboutHandler(event -> new About(null));
        desktop.setPreferencesHandler(event -> base.handlePrefs());
        desktop.setOpenFileHandler(event -> {
            for (File file : event.getFiles()) {
                base.handleOpen(file.getAbsolutePath());
            }
        });
        desktop.setPrintFileHandler(event -> {});
        desktop.setQuitHandler((event, quitResponse) -> {
            if (base.handleQuit()) {
                quitResponse.performQuit();
            } else {
                quitResponse.cancelQuit();
            }
        });
        desktop.setOpenURIHandler(event -> base.handleScheme(event.getURI().toString()));
        desktop.addAppEventListener(e -> {
            if (base.getEditors().isEmpty()) {
                base.handleNew();
            }
        });
    }

    @Override
    public File getSettingsFolder() throws Exception {
        File override = Base.getSettingsOverride();
        if (override != null) {
            return override;
        }
        return new File(this.getLibraryFolder(), "Processing");
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        return new File(this.getDocumentsFolder(), "Processing");
    }

    @Override
    public void openURL(String url) throws Exception {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e) {
            if (e.getMessage().contains("Error code: -600")) {
                throw new RuntimeException("Could not open the sketch, please restart your browser or computer");
            }
            throw e;
        }
    }

    protected String getLibraryFolder() throws FileNotFoundException {
        File folder = new File(System.getProperty("user.home"), "Library");
        if (!folder.exists()) {
            throw new FileNotFoundException("Folder missing: " + String.valueOf(folder));
        }
        return folder.getAbsolutePath();
    }

    protected String getDocumentsFolder() throws FileNotFoundException {
        File folder = new File(System.getProperty("user.home"), "Documents");
        if (!folder.exists()) {
            throw new FileNotFoundException("Folder missing: " + String.valueOf(folder));
        }
        return folder.getAbsolutePath();
    }

    public static boolean isXcodeInstalled() {
        if (xcodeInstalled == null) {
            StringList stdout = new StringList();
            StringList stderr = new StringList();
            int result = PApplet.exec((StringList)stdout, (StringList)stderr, (String[])new String[]{"/usr/bin/xcode-select", "-p"});
            xcodeInstalled = result == 0;
        }
        return xcodeInstalled;
    }

    public static void resetXcodeInstalled() {
        xcodeInstalled = null;
    }
}

