/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JProgressBar;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgress;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ListPanel;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.StatusPanel;
import processing.app.laf.PdeProgressBarUI;

class StatusDetail {
    private final Base base;
    private final StatusPanel statusPanel;
    private Contribution contrib;
    private JProgressBar progressBar;
    boolean updateInProgress;
    boolean installInProgress;
    boolean removeInProgress;
    static AbstractQueue<String> restoreQueue = new ConcurrentLinkedQueue<String>();

    StatusDetail(Base base, StatusPanel statusPanel) {
        this.base = base;
        this.statusPanel = statusPanel;
    }

    protected Contribution getContrib() {
        return this.contrib;
    }

    private LocalContribution getLocalContrib() {
        return (LocalContribution)this.contrib;
    }

    protected void setContrib(Contribution contrib) {
        this.contrib = contrib;
    }

    protected void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    protected float getProgressAmount() {
        if (this.progressBar.isIndeterminate()) {
            return -1.0f;
        }
        return (float)this.progressBar.getValue() / (float)this.progressBar.getMaximum();
    }

    private void finishInstall(boolean error) {
        this.statusPanel.resetProgressBar();
        if (error) {
            this.statusPanel.setErrorMessage(Language.text("contrib.download_error"));
        }
        this.installInProgress = false;
        if (this.updateInProgress) {
            this.updateInProgress = false;
        }
        this.statusPanel.contributionTab.repaint();
    }

    private void installContribution(AvailableContribution ad, ListPanel listPanel) {
        try {
            URL downloadUrl = new URL(ad.link);
            this.progressBar.setVisible(true);
            final StatusAnimator spinner = new StatusAnimator(listPanel);
            ContribProgress downloadProgress = new ContribProgress(this.progressBar){

                @Override
                public void finishedAction() {
                }

                @Override
                public void cancelAction() {
                    StatusDetail.this.finishInstall(false);
                }
            };
            ContribProgress installProgress = new ContribProgress(this.progressBar){

                @Override
                public void finishedAction() {
                    StatusDetail.this.finishInstall(this.isException());
                    StatusDetail.this.restoreSketches();
                    spinner.stop();
                }

                @Override
                public void cancelAction() {
                    this.finishedAction();
                }
            };
            ContributionManager.downloadAndInstall(this.base, downloadUrl, ad, downloadProgress, installProgress, this.statusPanel);
        }
        catch (MalformedURLException e) {
            Messages.showWarning(Language.text("contrib.errors.install_failed"), Language.text("contrib.errors.malformed_url"), e);
        }
    }

    protected void installContrib(ListPanel listPanel) {
        this.statusPanel.clearMessage();
        this.installInProgress = true;
        Contribution contribution = this.contrib;
        if (contribution instanceof AvailableContribution) {
            AvailableContribution info = (AvailableContribution)contribution;
            if (info.link == null) {
                this.statusPanel.setErrorMessage(Language.interpolate("contrib.missing_link", new Object[]{info.getType()}));
            } else {
                this.installContribution(info, listPanel);
                ContributionListing listing = ContributionListing.getInstance();
                listing.replaceContribution(this.contrib, this.contrib);
                listing.updateTableModels();
            }
        }
    }

    protected void updateContrib(final ListPanel listPanel) {
        this.statusPanel.clearMessage();
        this.updateInProgress = true;
        final ContributionListing contribListing = ContributionListing.getInstance();
        if (this.contrib.getType().requiresRestart()) {
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
            ContribProgress progress = new ContribProgress(this.progressBar){

                @Override
                public void finishedAction() {
                    StatusDetail.this.statusPanel.resetProgressBar();
                    AvailableContribution available = contribListing.findAvailableContribution(StatusDetail.this.contrib);
                    StatusDetail.this.installContribution(available, listPanel);
                }

                @Override
                public void cancelAction() {
                    StatusDetail.this.statusPanel.resetProgressBar();
                    StatusDetail.this.statusPanel.clearMessage();
                    StatusDetail.this.updateInProgress = false;
                    if (StatusDetail.this.contrib.isDeletionFlagged()) {
                        StatusDetail.this.getLocalContrib().setUpdateFlag();
                        StatusDetail.this.getLocalContrib().setDeletionFlag(false);
                        contribListing.replaceContribution(StatusDetail.this.contrib, StatusDetail.this.contrib);
                        contribListing.updateTableModels();
                    }
                }
            };
            this.getLocalContrib().removeContribution(this.base, progress, this.statusPanel, true);
        } else {
            AvailableContribution available = contribListing.findAvailableContribution(this.contrib);
            this.installContribution(available, listPanel);
        }
    }

    protected void removeContrib() {
        this.statusPanel.clearMessage();
        if (this.contrib.isInstalled() && this.contrib instanceof LocalContribution) {
            this.removeInProgress = true;
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
            ContribProgress progress = new ContribProgress(this.progressBar){

                @Override
                public void finishedAction() {
                    StatusDetail.this.statusPanel.resetProgressBar();
                    StatusDetail.this.removeInProgress = false;
                }

                @Override
                public void cancelAction() {
                    StatusDetail.this.statusPanel.resetProgressBar();
                    StatusDetail.this.removeInProgress = false;
                }
            };
            this.getLocalContrib().removeContribution(this.base, progress, this.statusPanel, false);
        }
    }

    protected void updateTheme() {
        if (this.progressBar != null) {
            if (this.progressBar.getUI() instanceof PdeProgressBarUI) {
                ((PdeProgressBarUI)this.progressBar.getUI()).updateTheme();
            } else {
                this.progressBar.setUI(new PdeProgressBarUI("manager.progress"));
            }
        }
    }

    protected static void storeSketchPath(String path) {
        restoreQueue.add(path);
    }

    protected void restoreSketches() {
        while (!restoreQueue.isEmpty()) {
            String path = restoreQueue.remove();
            this.base.handleOpen(path);
        }
    }

    static class StatusAnimator {
        Thread thread = new Thread(() -> {
            while (Thread.currentThread() == this.thread) {
                listPanel.repaint();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });

        StatusAnimator(ListPanel listPanel) {
            this.thread.start();
        }

        void stop() {
            this.thread = null;
        }
    }
}

