/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import processing.app.Base;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ListPanel;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.StatusDetail;
import processing.app.contrib.StatusPanel;
import processing.app.laf.PdeComboBoxUI;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

public class ContributionTab
extends JPanel {
    Base base;
    ContributionType contribType;
    ManagerFrame managerFrame;
    Contribution.Filter filter;
    JComboBox<String> categoryChooser;
    ListPanel listPanel;
    StatusPanel statusPanel;
    FilterField filterField;
    String category;

    public ContributionTab(ManagerFrame dialog) {
        this.managerFrame = dialog;
        this.base = dialog.base;
    }

    public ContributionTab(ManagerFrame frame, ContributionType type) {
        this(frame);
        this.contribType = type;
        this.filter = contrib -> contrib.getType() == this.contribType;
        this.listPanel = new ListPanel(this, this.filter, false, new ListPanel.ContributionColumn[0]);
        this.statusPanel = new StatusPanel(this);
        this.initLayout();
        ContributionListing.getInstance().addListPanel(this.listPanel);
    }

    @Override
    public String getName() {
        return this.contribType == null ? "updates" : this.contribType.toString();
    }

    protected void updateTheme() {
        this.setBackground(Theme.getColor("manager.list.background.color"));
        if (this.filterField != null) {
            this.filterField.updateTheme();
        }
        this.listPanel.updateTheme();
        this.statusPanel.updateTheme();
    }

    protected void initLayout() {
        if (this.categoryChooser == null) {
            this.createComponents();
        }
        int scrollBarWidth = this.listPanel.getScrollBarWidth();
        int filterWidth = Toolkit.zoom(180);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGap(ManagerFrame.STATUS_WIDTH).addComponent(this.filterField, filterWidth, filterWidth, filterWidth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.categoryChooser, ManagerFrame.AUTHOR_WIDTH, ManagerFrame.AUTHOR_WIDTH, ManagerFrame.AUTHOR_WIDTH).addGap(scrollBarWidth)).addComponent(this.listPanel).addComponent(this.statusPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.categoryChooser).addComponent(this.filterField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.listPanel)).addComponent(this.statusPanel, -2, -1, -2));
        layout.linkSize(1, this.categoryChooser, this.filterField);
        layout.setHonorsVisibility(this.listPanel, false);
        layout.setHonorsVisibility(this.categoryChooser, false);
        this.setBorder(null);
    }

    private void createComponents() {
        this.categoryChooser = new JComboBox();
        this.categoryChooser.setMaximumRowCount(20);
        this.updateCategoryChooser();
        this.categoryChooser.addItemListener(e -> {
            this.category = (String)this.categoryChooser.getSelectedItem();
            if (ManagerFrame.ANY_CATEGORY.equals(this.category)) {
                this.category = null;
            }
            this.updateFilter();
        });
        this.filterField = new FilterField();
    }

    private Set<String> listCategories() {
        HashSet<String> categories = new HashSet<String>();
        for (Contribution c : ContributionListing.getAllContribs()) {
            if (!this.filter.matches(c)) continue;
            for (String category : c.getCategories()) {
                categories.add(category);
            }
        }
        return categories;
    }

    protected void updateCategoryChooser() {
        if (this.categoryChooser != null) {
            this.categoryChooser.removeAllItems();
            Set<String> categories = this.listCategories();
            if (categories.isEmpty() || this.contribType != ContributionType.LIBRARY) {
                this.categoryChooser.addItem("NULL");
                this.categoryChooser.setVisible(false);
            } else {
                this.categoryChooser.addItem(ManagerFrame.ANY_CATEGORY);
                Object[] list = (String[])categories.toArray(String[]::new);
                Arrays.sort(list);
                for (Object category : list) {
                    this.categoryChooser.addItem((String)category);
                }
                this.categoryChooser.setVisible(true);
            }
        }
    }

    protected void updateFilter() {
        this.listPanel.updateFilter(this.category, this.filterField.filterWords);
    }

    protected boolean filterHasFocus() {
        return this.filterField != null && this.filterField.hasFocus();
    }

    protected StatusDetail createStatusDetail() {
        return new StatusDetail(this.base, this.statusPanel);
    }

    protected void applyDetail(StatusDetail detail) {
        this.statusPanel.applyDetail(detail);
    }

    class FilterField
    extends JTextField {
        List<String> filterWords = new ArrayList<String>();
        JLabel placeholderLabel = new JLabel("Filter");
        JButton resetButton;

        FilterField() {
            this.placeholderLabel.setOpaque(false);
            this.resetButton = new JButton();
            this.resetButton.setBorder(new EmptyBorder(0, 0, 0, 2));
            this.resetButton.setBorderPainted(false);
            this.resetButton.setContentAreaFilled(false);
            this.resetButton.setCursor(Cursor.getDefaultCursor());
            this.resetButton.addActionListener(e -> {
                this.setText("");
                this.requestFocusInWindow();
            });
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(3, 7, 3, 7));
            GroupLayout fl = new GroupLayout(this);
            this.setLayout(fl);
            fl.setHorizontalGroup(fl.createSequentialGroup().addComponent(this.placeholderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.resetButton));
            fl.setVerticalGroup(fl.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(fl.createParallelGroup().addComponent(this.placeholderLabel).addComponent(this.resetButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE));
            this.resetButton.setVisible(false);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (FilterField.this.getText().isEmpty()) {
                        FilterField.this.placeholderLabel.setVisible(true);
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    FilterField.this.placeholderLabel.setVisible(false);
                }
            });
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FilterField.this.resetButton.setVisible(!FilterField.this.getText().isEmpty());
                    FilterField.this.applyFilter();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FilterField.this.resetButton.setVisible(!FilterField.this.getText().isEmpty());
                    FilterField.this.applyFilter();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FilterField.this.resetButton.setVisible(!FilterField.this.getText().isEmpty());
                    FilterField.this.applyFilter();
                }
            });
            this.updateTheme();
        }

        private void applyFilter() {
            String filter = this.getText().toLowerCase();
            this.filterWords = Arrays.asList(filter.split(" "));
            ContributionTab.this.updateFilter();
        }

        protected void updateTheme() {
            this.placeholderLabel.setForeground(Theme.getColor("manager.search.placeholder.color"));
            this.placeholderLabel.setIcon(Toolkit.renderIcon("manager/search", Theme.get("manager.search.icon.color"), 16));
            this.resetButton.setIcon(Toolkit.renderIcon("manager/search-reset", Theme.get("manager.search.icon.color"), 16));
            this.setBackground(Theme.getColor("manager.search.background.color"));
            this.setForeground(Theme.getColor("manager.search.text.color"));
            this.setSelectionColor(Theme.getColor("manager.search.selection.background.color"));
            this.setSelectedTextColor(Theme.getColor("manager.search.selection.text.color"));
            this.setCaretColor(Theme.getColor("manager.search.caret.color"));
            if (ContributionTab.this.categoryChooser.getUI() instanceof PdeComboBoxUI) {
                ((PdeComboBoxUI)ContributionTab.this.categoryChooser.getUI()).updateTheme();
            } else {
                ContributionTab.this.categoryChooser.setUI(new PdeComboBoxUI("manager.categories"));
            }
        }
    }
}

