/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import processing.app.Console;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Schema;
import processing.app.Settings;
import processing.app.SingleInstance;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchName;
import processing.app.SketchReference;
import processing.app.UpdateCheck;
import processing.app.Util;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgress;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ExamplesContribution;
import processing.app.contrib.IgnorableException;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.ToolContribution;
import processing.app.tools.Archiver;
import processing.app.tools.ColorSelector;
import processing.app.tools.CreateFont;
import processing.app.tools.InstallCommander;
import processing.app.tools.ThemeSelector;
import processing.app.tools.Tool;
import processing.app.ui.Editor;
import processing.app.ui.EditorConsole;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;
import processing.app.ui.PreferencesFrame;
import processing.app.ui.Recent;
import processing.app.ui.SketchbookFrame;
import processing.app.ui.Splash;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;
import processing.app.ui.Welcome;
import processing.core.PApplet;
import processing.data.StringList;

public class Base {
    private static final int REVISION = Integer.parseInt(System.getProperty("processing.revision", "1295"));
    private static String VERSION_NAME = System.getProperty("processing.version", "1295");
    public static final String SKETCH_BUNDLE_EXT = ".pdez";
    public static final String CONTRIB_BUNDLE_EXT = ".pdex";
    public static boolean DEBUG = Boolean.parseBoolean(System.getenv().getOrDefault("DEBUG", "false"));
    private static boolean commandLine;
    private static File settingsOverride;
    PreferencesFrame preferencesFrame;
    static File untitledFolder;
    protected final List<Editor> editors = Collections.synchronizedList(new ArrayList());
    protected Editor activeEditor;
    protected JMenu defaultFileMenu;
    private Mode nextMode;
    private Mode coreMode;
    private List<ModeContribution> contribModes;
    private List<ExamplesContribution> contribExamples;
    private List<Tool> internalTools;
    private List<ToolContribution> coreTools;
    private List<ToolContribution> contribTools;
    private int updatesAvailable = 0;
    private JFileChooser openChooser;
    protected static File sketchbookFolder;
    protected SketchbookFrame sketchbookFrame;

    public static void main(String[] args) {
        Messages.log("Starting Processing version" + VERSION_NAME + " revision " + REVISION);
        EventQueue.invokeLater(() -> {
            try {
                Base.createAndShowGUI(args);
            }
            catch (Throwable t) {
                if (Platform.isWindows()) {
                    String mess = t.getMessage();
                    String missing = null;
                    if (mess.contains("Could not initialize class com.sun.jna.Native")) {
                        missing = "jnidispatch.dll";
                    } else if (t instanceof NoClassDefFoundError && mess.contains("processing/core/PApplet")) {
                        missing = "core.jar";
                    }
                    if (missing != null) {
                        Messages.showError("Necessary files are missing", "A file required by Processing (" + missing + ") is missing.\n\nMake sure that you're not trying to run Processing from inside\nthe .zip file you downloaded, and check that Windows Defender\nhas not removed files from the Processing folder.\n\n(Defender sometimes flags parts of Processing as malware.\nIt is not, but Microsoft has ignored our pleas for help.)", t);
                    }
                }
                Messages.showTrace("Unknown Problem", "A serious error happened during startup. Please report:\nhttp://github.com/processing/processing4/issues/new", t, true);
            }
        });
    }

    private static void createAndShowGUI(String[] args) {
        boolean createNewInstance;
        File settingsFile;
        String[] lines;
        File versionFile = Platform.getContentFile("lib/version.txt");
        if (versionFile != null && versionFile.exists() && (lines = PApplet.loadStrings((File)versionFile)) != null && lines.length > 0 && !VERSION_NAME.equals(lines[0])) {
            VERSION_NAME = lines[0];
        }
        if ((settingsFile = Platform.getContentFile("lib/settings.txt")) != null && settingsFile.exists()) {
            try {
                Settings portable = new Settings(settingsFile);
                String path = portable.get("settings.path");
                File folder = new File(path);
                boolean success = true;
                if (!folder.exists() && !(success = folder.mkdirs())) {
                    Messages.err("Could not create " + String.valueOf(folder) + " to store settings.");
                }
                if (success) {
                    if (!folder.canRead()) {
                        Messages.err("Cannot read from " + String.valueOf(folder));
                    } else if (!folder.canWrite()) {
                        Messages.err("Cannot write to " + String.valueOf(folder));
                    } else {
                        settingsOverride = folder.getAbsoluteFile();
                    }
                }
            }
            catch (IOException e) {
                Messages.err("Error while reading the settings.txt file", e);
            }
        }
        Platform.init();
        Console.startup();
        File debugFile = Base.getSettingsFile("debug");
        if (debugFile.exists() && debugFile.isFile()) {
            DEBUG = true;
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        Language.init();
        Preferences.init();
        boolean bl = createNewInstance = DEBUG || !SingleInstance.alreadyRunning(args);
        if (!createNewInstance) {
            System.exit(0);
            return;
        }
        if (createNewInstance) {
            try {
                Platform.setLookAndFeel();
                Platform.setInterfaceZoom();
            }
            catch (Exception e) {
                Messages.err("Error while setting up the interface", e);
            }
            Base.locateSketchbookFolder();
            Theme.init();
            try {
                String uuid = UUID.randomUUID().toString();
                untitledFolder = new File(Util.getProcessingTemp(), uuid);
            }
            catch (IOException e) {
                Messages.showError("Trouble without a name", "Could not create a place to store untitled sketches.\nThat's gonna prevent us from continuing.", e);
            }
            Messages.log("About to create Base...");
            try {
                Base base = new Base(args);
                base.updateTheme();
                Messages.log("Base() constructor succeeded");
                SingleInstance.startServer(base);
                Base.handleWelcomeScreen(base);
                Base.handleCrustyDisplay();
                Base.handleTempCleaning();
            }
            catch (Throwable t) {
                Throwable err = t;
                if (t.getCause() != null) {
                    err = t.getCause();
                }
                Messages.showTrace("We're off on the wrong foot", "An error occurred during startup.", err, true);
            }
            Messages.log("Done creating Base...");
        }
    }

    public void updateTheme() {
        try {
            FlatDarkLaf laf = "dark".equals(Theme.get("laf.mode")) ? new FlatDarkLaf() : new FlatLightLaf();
            laf.setExtraDefaults(Collections.singletonMap("@accentColor", Theme.get("laf.accent.color")));
            FlatLaf.setup((LookAndFeel)laf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.preferencesFrame != null) {
            this.preferencesFrame.updateTheme();
        }
        ContributionManager.updateTheme();
        for (Editor editor : this.getEditors()) {
            editor.updateTheme();
        }
    }

    private static void handleWelcomeScreen(Base base) {
        if (Preferences.getBoolean("welcome.four.show")) {
            try {
                new Welcome(base);
            }
            catch (IOException e) {
                Messages.showTrace("Unwelcoming", "Please report this error to\nhttps://github.com/processing/processing4/issues", e, false);
            }
        }
    }

    private static void handleCrustyDisplay() {
        int res;
        if (Platform.isWindows() && !Toolkit.isRetina() && !Splash.getDisableHiDPI() && (res = java.awt.Toolkit.getDefaultToolkit().getScreenResolution()) % 96 != 0) {
            System.out.println("If the editor cursor is in the wrong place or the interface is blocky or fuzzy,");
            System.out.println("open Preferences and select the \u201cDisable HiDPI Scaling\u201d option to fix it.");
        }
    }

    private static void handleTempCleaning() {
        new Thread(() -> {
            Console.cleanTempFiles();
            Base.cleanTempFolders();
        }).start();
    }

    public static void cleanTempFolders() {
        try {
            long diff;
            long now;
            File[] expiredFiles;
            File tempDir = Util.getProcessingTemp();
            int days = Preferences.getInteger("temp.days");
            if (days > 0 && (expiredFiles = tempDir.listFiles(arg_0 -> Base.lambda$cleanTempFolders$2(now = new Date().getTime(), diff = (long)(days * 24 * 60 * 60) * 1000L, arg_0))) != null) {
                for (File file : expiredFiles) {
                    try {
                        Platform.deleteFile(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getRevision() {
        return REVISION;
    }

    public static String getVersionName() {
        return VERSION_NAME;
    }

    public static void setCommandLine() {
        commandLine = true;
    }

    public static boolean isCommandLine() {
        return commandLine;
    }

    public Base(String[] args) throws Exception {
        long t1 = System.currentTimeMillis();
        ContributionManager.init(this);
        long t2 = System.currentTimeMillis();
        this.buildCoreModes();
        long t2b = System.currentTimeMillis();
        this.rebuildContribModes();
        long t2c = System.currentTimeMillis();
        this.rebuildContribExamples();
        long t3 = System.currentTimeMillis();
        Recent.init(this);
        long t4 = System.currentTimeMillis();
        String lastModeIdentifier = Preferences.get("mode.last");
        if (lastModeIdentifier == null) {
            this.nextMode = this.getDefaultMode();
            Messages.log("Nothing set for last.sketch.mode, using default.");
        } else {
            for (Mode m : this.getModeList()) {
                if (!m.getIdentifier().equals(lastModeIdentifier)) continue;
                Messages.logf("Setting next mode to %s.", lastModeIdentifier);
                this.nextMode = m;
            }
            if (this.nextMode == null) {
                this.nextMode = this.getDefaultMode();
                Messages.logf("Could not find mode %s, using default.", lastModeIdentifier);
            }
        }
        long t5 = System.currentTimeMillis();
        this.nextMode.rebuildLibraryList();
        Platform.initBase(this);
        long t6 = System.currentTimeMillis();
        boolean opened = false;
        for (int i = 0; i < args.length; ++i) {
            Messages.logf("Parsing command line... args[%d] = '%s'", i, args[i]);
            String path = args[i];
            if (Platform.isWindows()) {
                try {
                    File file = new File(args[i]);
                    path = file.getCanonicalPath();
                    Messages.logf("Changing %s to canonical %s", i, args[i], path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.handleOpen(path) == null) continue;
            opened = true;
        }
        long t7 = System.currentTimeMillis();
        if (!opened) {
            Messages.log("Calling handleNew() to open a new window");
            this.handleNew();
        } else {
            Messages.log("No handleNew(), something passed on the command line");
        }
        long t8 = System.currentTimeMillis();
        new UpdateCheck(this);
        ContributionListing cl = ContributionListing.getInstance();
        cl.downloadAvailableList(this, new ContribProgress(null));
        long t9 = System.currentTimeMillis();
        Messages.log("core modes: " + (t2b - t2) + ", contrib modes: " + (t2c - t2b) + ", contrib ex: " + (t2c - t2b));
        Messages.log("base took " + (t2 - t1) + " " + (t3 - t2) + " " + (t4 - t3) + " " + (t5 - t4) + " t6-t5=" + (t6 - t5) + " " + (t7 - t6) + " handleNew=" + (t8 - t7) + " " + (t9 - t8) + " ms");
    }

    public JMenu initDefaultFileMenu() {
        this.defaultFileMenu = new JMenu(Language.text("menu.file"));
        JMenuItem item = Toolkit.newJMenuItem(Language.text("menu.file.new"), 78);
        item.addActionListener(e -> this.handleNew());
        this.defaultFileMenu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.file.open"), 79);
        item.addActionListener(e -> this.handleOpenPrompt());
        this.defaultFileMenu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.sketchbook"), 75);
        item.addActionListener(e -> this.showSketchbookFrame());
        this.defaultFileMenu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.examples"), 79);
        item.addActionListener(e -> this.thinkDifferentExamples());
        this.defaultFileMenu.add(item);
        return this.defaultFileMenu;
    }

    public void checkFirstEditor(Editor editor) {
        if (this.activeEditor == null) {
            this.activeEditor = editor;
        }
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    public List<Editor> getEditors() {
        return this.editors;
    }

    public void handleActivated(Editor whichEditor) {
        this.activeEditor = whichEditor;
        EditorConsole.setEditor(this.activeEditor);
        this.nextMode = whichEditor.getMode();
        Preferences.set("mode.last", this.nextMode.getIdentifier());
    }

    public void refreshContribs(ContributionType ct) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (ct != ContributionType.LIBRARY) break block4;
                        for (Mode m : this.getModeList()) {
                            m.rebuildImportMenu();
                        }
                        break block5;
                    }
                    if (ct != ContributionType.MODE) break block6;
                    this.rebuildContribModes();
                    for (Editor editor : this.editors) {
                        editor.rebuildModePopup();
                    }
                    break block5;
                }
                if (ct != ContributionType.TOOL) break block7;
                this.rebuildToolList();
                for (Editor editor : this.editors) {
                    this.populateToolsMenu(editor.getToolMenu());
                }
                break block5;
            }
            if (ct != ContributionType.EXAMPLES) break block5;
            this.rebuildContribExamples();
            for (Mode m : this.getModeList()) {
                m.rebuildExamplesFrame();
            }
        }
    }

    public Set<Contribution> getInstalledContribs() {
        List<ModeContribution> modeContribs = this.getContribModes();
        HashSet<Contribution> contributions = new HashSet<Contribution>(modeContribs);
        for (ModeContribution modeContrib : modeContribs) {
            Mode mode = modeContrib.getMode();
            contributions.addAll(mode.contribLibraries);
            contributions.addAll(mode.foundationLibraries);
        }
        contributions.addAll(this.getContribTools());
        contributions.addAll(this.getContribExamples());
        return contributions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tallyUpdatesAvailable() {
        Set<Contribution> installed = this.getInstalledContribs();
        ContributionListing listing = ContributionListing.getInstance();
        int newCount = 0;
        for (Contribution contrib : installed) {
            if (!listing.hasUpdates(contrib)) continue;
            ++newCount;
        }
        this.updatesAvailable = newCount;
        List<Editor> list = this.editors;
        synchronized (list) {
            for (Editor editor : this.editors) {
                editor.setUpdatesAvailable(this.updatesAvailable);
            }
        }
    }

    public List<Mode> getModeList() {
        ArrayList<Mode> outgoing = new ArrayList<Mode>();
        outgoing.add(this.coreMode);
        if (this.contribModes != null) {
            for (ModeContribution contrib : this.contribModes) {
                outgoing.add(contrib.getMode());
            }
        }
        return outgoing;
    }

    void buildCoreModes() {
        ModeContribution javaModeContrib = ModeContribution.load(this, Platform.getContentFile("modes/java"), this.getDefaultModeIdentifier());
        if (javaModeContrib == null) {
            Messages.showError("Startup Error", "Could not load Java Mode, please reinstall Processing.", new Exception("ModeContribution.load() was null"));
        } else {
            this.coreMode = javaModeContrib.getMode();
        }
    }

    public List<ModeContribution> getContribModes() {
        return this.contribModes;
    }

    void rebuildContribModes() {
        String string2;
        if (this.contribModes == null) {
            this.contribModes = new ArrayList<ModeContribution>();
        }
        File modesFolder = Base.getSketchbookModesFolder();
        HashMap<File, ModeContribution> known = new HashMap<File, ModeContribution>();
        for (ModeContribution modeContribution : this.getContribModes()) {
            known.put(modeContribution.getFolder(), modeContribution);
        }
        File[] potential = ContributionType.MODE.listCandidates(modesFolder);
        if (potential != null) {
            for (File folder : potential) {
                if (!known.containsKey(folder)) {
                    try {
                        this.contribModes.add(new ModeContribution(this, folder, null));
                    }
                    catch (NoClassDefFoundError | NoSuchMethodError ne) {
                        System.err.println(folder.getName() + " is not compatible with this version of Processing");
                        if (!DEBUG) continue;
                        ne.printStackTrace();
                    }
                    catch (InvocationTargetException ite) {
                        System.err.println(folder.getName() + " could not be loaded and may not compatible with this version of Processing");
                        if (!DEBUG) continue;
                        ite.printStackTrace();
                    }
                    catch (IgnorableException ig) {
                        Messages.log(ig.getMessage());
                        if (!DEBUG) continue;
                        ig.printStackTrace();
                    }
                    catch (Throwable e) {
                        System.err.println("Could not load Mode from " + String.valueOf(folder));
                        e.printStackTrace();
                    }
                    continue;
                }
                known.remove(folder);
            }
        }
        if ((string2 = System.getProperty("usemode")) != null) {
            String[] modeInfo = string2.split(":", 2);
            String modeClass = modeInfo[0];
            String modeResourcePath = modeInfo[1];
            System.out.println("Attempting to load " + modeClass + " with resources at " + modeResourcePath);
            ModeContribution mc = ModeContribution.load(this, new File(modeResourcePath), modeClass);
            this.contribModes.add(mc);
            File key = Base.getModeContribFile(mc, known);
            if (key != null) {
                known.remove(key);
            }
        }
        if (known.size() != 0) {
            for (ModeContribution mc : known.values()) {
                System.out.println("Extraneous Mode entry: " + mc.getName());
            }
        }
    }

    private static File getModeContribFile(ModeContribution contrib, Map<File, ModeContribution> known) {
        for (Map.Entry<File, ModeContribution> entry : known.entrySet()) {
            if (entry.getValue() != contrib) continue;
            return entry.getKey();
        }
        return null;
    }

    public List<ToolContribution> getCoreTools() {
        return this.coreTools;
    }

    public List<ToolContribution> getContribTools() {
        return this.contribTools;
    }

    public void rebuildToolList() {
        if (this.internalTools == null) {
            this.internalTools = new ArrayList<Tool>();
            this.initInternalTool(Archiver.class);
            this.initInternalTool(ColorSelector.class);
            this.initInternalTool(CreateFont.class);
            if (Platform.isMacOS()) {
                this.initInternalTool(InstallCommander.class);
            }
            this.initInternalTool(ThemeSelector.class);
        }
        if (this.coreTools == null) {
            this.coreTools = ToolContribution.loadAll(Base.getToolsFolder());
            for (Tool tool : this.coreTools) {
                tool.init(this);
            }
        }
        this.contribTools = ToolContribution.loadAll(Base.getSketchbookToolsFolder());
        for (Tool tool : this.contribTools) {
            try {
                tool.init(this);
            }
            catch (AbstractMethodError | VerifyError ve) {
                System.err.println("\"" + tool.getMenuTitle() + "\" is not compatible with this version of Processing");
                Messages.err("Incompatible Tool found during tool.init()", ve);
            }
            catch (NoSuchMethodError nsme) {
                System.err.println("\"" + tool.getMenuTitle() + "\" is not compatible with this version of Processing");
                System.err.println("The " + nsme.getMessage() + " method no longer exists.");
                Messages.err("Incompatible Tool found during tool.init()", nsme);
            }
            catch (NoClassDefFoundError ncdfe) {
                System.err.println("\"" + tool.getMenuTitle() + "\" is not compatible with this version of Processing");
                System.err.println("The " + ncdfe.getMessage() + " class is no longer available.");
                Messages.err("Incompatible Tool found during tool.init()", ncdfe);
            }
            catch (Error | Exception e) {
                System.err.println("An error occurred inside \"" + tool.getMenuTitle() + "\"");
                e.printStackTrace();
            }
        }
    }

    protected void initInternalTool(Class<?> toolClass) {
        try {
            Tool tool = (Tool)toolClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            tool.init(this);
            this.internalTools.add(tool);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearToolMenus() {
        for (Editor ed : this.editors) {
            ed.clearToolMenu();
        }
    }

    public void populateToolsMenu(JMenu toolsMenu) {
        if (this.internalTools == null) {
            this.rebuildToolList();
        }
        toolsMenu.removeAll();
        for (Tool tool : this.internalTools) {
            toolsMenu.add(this.createToolItem(tool));
        }
        toolsMenu.addSeparator();
        if (!this.coreTools.isEmpty()) {
            for (Tool tool : this.coreTools) {
                toolsMenu.add(this.createToolItem(tool));
            }
            toolsMenu.addSeparator();
        }
        if (!this.contribTools.isEmpty()) {
            for (Tool tool : this.contribTools) {
                toolsMenu.add(this.createToolItem(tool));
            }
            toolsMenu.addSeparator();
        }
        JMenuItem manageTools = new JMenuItem(Language.text("menu.tools.manage_tools"));
        manageTools.addActionListener(e -> ContributionManager.openTools());
        toolsMenu.add(manageTools);
    }

    JMenuItem createToolItem(Tool tool) {
        String title = tool.getMenuTitle();
        JMenuItem item = new JMenuItem(title);
        item.addActionListener(e -> {
            try {
                tool.run();
            }
            catch (NoClassDefFoundError | NoSuchMethodError ne) {
                Messages.showWarning("Tool out of date", tool.getMenuTitle() + " is not compatible with this version of Processing.\nTry updating the Mode or contact its author for a new version.", ne);
                Messages.err("Incompatible tool found during tool.run()", ne);
                item.setEnabled(false);
            }
            catch (Exception ex) {
                this.activeEditor.statusError("An error occurred inside \"" + tool.getMenuTitle() + "\"");
                ex.printStackTrace();
                item.setEnabled(false);
            }
        });
        return item;
    }

    void rebuildContribExamples() {
        this.contribExamples = ExamplesContribution.loadAll(Base.getSketchbookExamplesFolder());
    }

    public List<ExamplesContribution> getContribExamples() {
        return this.contribExamples;
    }

    String getDefaultModeIdentifier() {
        return "processing.mode.java.JavaMode";
    }

    public Mode getDefaultMode() {
        return this.coreMode;
    }

    public boolean changeMode(Mode mode) {
        Mode oldMode = this.activeEditor.getMode();
        if (oldMode != mode) {
            Sketch sketch = this.activeEditor.getSketch();
            this.nextMode = mode;
            if (sketch.isModified()) {
                this.handleNew();
                return false;
            }
            if (sketch.isUntitled()) {
                this.handleClose(this.activeEditor, true);
                this.handleNew();
            } else if (mode.canEdit(sketch)) {
                sketch.updateModeProperties(this.nextMode, this.getDefaultMode());
                this.handleClose(this.activeEditor, true);
                Editor editor = this.handleOpen(sketch.getMainPath());
                if (editor == null) {
                    sketch.updateModeProperties(oldMode, this.getDefaultMode());
                    this.handleOpen(sketch.getMainPath());
                    return false;
                }
            } else {
                this.handleNew();
                return false;
            }
        }
        return true;
    }

    protected Mode findMode(String id) {
        for (Mode mode : this.getModeList()) {
            if (!mode.getIdentifier().equals(id)) continue;
            return mode;
        }
        return null;
    }

    public void modeRemoved(Mode mode) {
        if (this.nextMode == mode) {
            this.nextMode = this.getDefaultMode();
        }
    }

    public void handleNew() {
        try {
            File newbieDir = SketchName.nextFolder(untitledFolder);
            if (newbieDir == null) {
                return;
            }
            if (!newbieDir.mkdirs()) {
                throw new IOException("Could not create directory " + String.valueOf(newbieDir));
            }
            String newbieName = newbieDir.getName();
            File newbieFile = this.nextMode.addTemplateFiles(newbieDir, newbieName);
            if (!this.nextMode.equals(this.getDefaultMode())) {
                Sketch.updateModeProperties(newbieDir, this.nextMode, this.getDefaultMode());
            }
            String path = newbieFile.getAbsolutePath();
            this.handleOpenUntitled(path);
        }
        catch (IOException e) {
            Messages.showTrace("That's new to me", "A strange and unexplainable error occurred\nwhile trying to create a new sketch.", e, false);
        }
    }

    public void handleOpenPrompt() {
        final StringList extensions = new StringList();
        extensions.append(SKETCH_BUNDLE_EXT);
        for (Mode mode : this.getModeList()) {
            extensions.append(mode.getDefaultExtension());
        }
        String prompt = Language.text("open");
        if (Preferences.getBoolean("chooser.files.native")) {
            FileDialog openDialog = new FileDialog((Frame)this.activeEditor, prompt, 0);
            openDialog.setFilenameFilter((dir, name) -> {
                for (String ext : extensions) {
                    if (!name.toLowerCase().endsWith("." + ext)) continue;
                    return true;
                }
                return false;
            });
            openDialog.setVisible(true);
            String directory = openDialog.getDirectory();
            String filename = openDialog.getFile();
            if (filename != null) {
                File inputFile = new File(directory, filename);
                this.handleOpen(inputFile.getAbsolutePath());
            }
        } else {
            if (this.openChooser == null) {
                this.openChooser = new JFileChooser();
                this.openChooser.setDialogTitle(prompt);
            }
            this.openChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    for (String ext : extensions) {
                        if (!file.getName().toLowerCase().endsWith("." + ext)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return "Processing Sketch";
                }
            });
            if (this.openChooser.showOpenDialog(this.activeEditor) == 0) {
                this.handleOpen(this.openChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private Editor openSketchBundle(String path) {
        File zipFile = new File(path);
        try {
            untitledFolder.mkdirs();
            File destFolder = File.createTempFile("zip", "tmp", untitledFolder);
            if (!destFolder.delete() || !destFolder.mkdirs()) {
                System.err.println("Could not create temporary folder " + String.valueOf(destFolder));
                return null;
            }
            Util.unzip(zipFile, destFolder);
            File[] fileList = destFolder.listFiles(File::isDirectory);
            if (fileList != null) {
                if (fileList.length == 1) {
                    File sketchFile = Sketch.findMain(fileList[0], this.getModeList());
                    if (sketchFile != null) {
                        return this.handleOpenUntitled(sketchFile.getAbsolutePath());
                    }
                } else {
                    System.err.println("Expecting one folder inside .pdez file, found " + fileList.length + ".");
                }
            } else {
                System.err.println("Could not read " + String.valueOf(destFolder));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void openContribBundle(String path) {
        EventQueue.invokeLater(() -> {
            Editor editor = this.getActiveEditor();
            if (editor == null) {
                Messages.showWarning("Failure is the only option", "Please open an Editor window before installing an extension.");
            } else {
                File contribFile = new File(path);
                String baseName = contribFile.getName();
                int result = Messages.showYesNoQuestion(editor, "How to Handle .pdex", "Install " + (baseName = baseName.substring(0, baseName.length() - CONTRIB_BUNDLE_EXT.length())) + "?", "Libraries, Modes, and Tools should<br>only be installed from trusted sources.");
                if (result == 0) {
                    editor.statusNotice("Installing " + baseName + "...");
                    editor.startIndeterminate();
                    new Thread(() -> {
                        try {
                            LocalContribution contrib = AvailableContribution.install(this, new File(path));
                            EventQueue.invokeLater(() -> {
                                editor.stopIndeterminate();
                                if (contrib != null) {
                                    editor.statusEmpty();
                                } else {
                                    editor.statusError("Could not install " + path);
                                }
                            });
                        }
                        catch (IOException e) {
                            EventQueue.invokeLater(() -> Messages.showWarning("Exception During Installation", "Could not install contrib from " + path, e));
                        }
                    }).start();
                }
            }
        });
    }

    private boolean smellsLikeSketchFolder(File folder) {
        File[] files = folder.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            String name = file.getName();
            if ((name.startsWith(".") || name.toLowerCase().endsWith(".pde")) && (!file.isDirectory() || !name.equals("data"))) continue;
            return false;
        }
        return true;
    }

    private File moveLikeSketchFolder(File pdeFile, String baseName) throws IOException {
        Object[] options = new Object[]{"Keep", "Move", "Cancel"};
        String prompt = "Would you like to keep \u201c" + pdeFile.getParentFile().getName() + "\u201d as the sketch folder,\nor move \u201c" + pdeFile.getName() + "\u201d to its own folder?\n(Usually, \u201c" + pdeFile.getName() + "\u201d would be stored inside a\nsketch folder named \u201c" + baseName + "\u201d.)";
        int result = JOptionPane.showOptionDialog(null, prompt, "Keep it? Move it?", 1, 3, null, options, options[0]);
        if (result == 0) {
            return pdeFile;
        }
        if (result == 1) {
            File properFolder = new File(pdeFile.getParent(), baseName);
            if (properFolder.exists()) {
                throw new IOException("A folder named \"" + baseName + "\" already exists. Cannot open sketch.");
            }
            if (!properFolder.mkdirs()) {
                throw new IOException("Could not create the sketch folder.");
            }
            File properPdeFile = new File(properFolder, pdeFile.getName());
            Util.copyFile(pdeFile, properPdeFile);
            if (!pdeFile.delete()) {
                Messages.err("Could not delete " + String.valueOf(pdeFile));
            }
            return properPdeFile;
        }
        return null;
    }

    public Editor handleScheme(String schemeUri) {
        Editor result = Schema.handleSchema(schemeUri, this);
        if (result != null) {
            return result;
        }
        String location = schemeUri.substring(6);
        if (location.length() > 0) {
            if (location.charAt(0) == '/') {
                File file = new File(location);
                if (file.exists()) {
                    this.handleOpen(location);
                } else {
                    System.err.println(String.valueOf(file) + " does not exist.");
                }
            } else {
                String url = "https://" + location;
                if (location.toLowerCase().endsWith(SKETCH_BUNDLE_EXT) || location.toLowerCase().endsWith(CONTRIB_BUNDLE_EXT)) {
                    String extension = location.substring(location.length() - 5);
                    try {
                        File tempFile = File.createTempFile("scheme", extension);
                        if (PApplet.saveStream((File)tempFile, (InputStream)Util.createInput(url))) {
                            return this.handleOpen(tempFile.getAbsolutePath());
                        }
                        System.err.println("Could not open " + String.valueOf(tempFile));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public Editor handleOpen(String path) {
        if (path.startsWith("pde://")) {
            return this.handleScheme(path);
        }
        if (path.endsWith(SKETCH_BUNDLE_EXT)) {
            return this.openSketchBundle(path);
        }
        if (path.endsWith(CONTRIB_BUNDLE_EXT)) {
            this.openContribBundle(path);
            return null;
        }
        File pdeFile = new File(path);
        if (!pdeFile.exists()) {
            System.err.println(path + " does not exist");
            return null;
        }
        for (Editor editor : this.editors) {
            for (SketchCode tab : editor.getSketch().getCode()) {
                if (!tab.getFile().equals(pdeFile)) continue;
                editor.toFront();
                Recent.append(editor);
                return editor;
            }
        }
        File parentFolder = pdeFile.getParentFile();
        try {
            Settings props = Sketch.loadProperties(parentFolder);
            if (!props.isEmpty()) {
                String main2;
                String modeIdentifier = props.get("mode.id");
                if (modeIdentifier != null) {
                    if (modeIdentifier.equals("galsasson.mode.tweak.TweakMode")) {
                        this.nextMode = this.getDefaultMode();
                        props.remove("mode");
                        props.remove("mode.id");
                        props.reckon();
                    } else {
                        Mode mode = this.findMode(modeIdentifier);
                        if (mode != null) {
                            this.nextMode = mode;
                        } else {
                            ContributionManager.openModes();
                            Messages.showWarning("Missing Mode", "You must first install " + props.get("mode") + " Mode to use this sketch.");
                            return null;
                        }
                    }
                }
                if ((main2 = props.get("main")) != null) {
                    String mainPath = new File(parentFolder, main2).getAbsolutePath();
                    if (!path.equals(mainPath)) {
                        System.out.println(path + " selected, but main is " + mainPath);
                    }
                    return this.handleOpenInternal(mainPath, false);
                }
            } else {
                this.nextMode = this.getDefaultMode();
            }
            if (!Sketch.isSanitaryName(pdeFile.getName())) {
                Messages.showWarning("You're tricky, but not tricky enough", pdeFile.getName() + " is not a valid name for sketch code.\nBetter to stick to ASCII, no spaces, and make sure\nit doesn't start with a number.", null);
                return null;
            }
            String baseName = pdeFile.getName();
            int dot = baseName.lastIndexOf(46);
            if (dot == -1) {
                System.err.println(String.valueOf(pdeFile) + " does not have an extension.");
                return null;
            }
            if (!(baseName = baseName.substring(0, dot)).equals(parentFolder.getName())) {
                String filename = parentFolder.getName() + "." + this.nextMode.getDefaultExtension();
                File mainFile = new File(parentFolder, filename);
                if (mainFile.exists()) {
                    pdeFile = mainFile;
                } else if (this.smellsLikeSketchFolder(parentFolder)) {
                    props.set("main", pdeFile.getName());
                    props.save();
                } else {
                    File newFile = this.moveLikeSketchFolder(pdeFile, baseName);
                    if (newFile == pdeFile) {
                        props.set("main", newFile.getName());
                        props.save();
                    } else {
                        if (newFile == null) {
                            return null;
                        }
                        pdeFile = newFile;
                    }
                }
            }
            return this.handleOpenInternal(pdeFile.getAbsolutePath(), false);
        }
        catch (IOException e) {
            Messages.showWarning("sketch.properties", "Error while reading sketch.properties from\n" + String.valueOf(parentFolder), e);
            return null;
        }
    }

    public Editor handleOpenExample(String path, Mode mode) {
        this.nextMode = mode;
        return this.handleOpenInternal(path, true);
    }

    protected Editor handleOpenUntitled(String path) {
        return this.handleOpenInternal(path, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Editor handleOpenInternal(String path, boolean untitled) {
        try {
            EditorState state = EditorState.nextEditor(this.editors);
            Editor editor = this.nextMode.createEditor(this, path, state);
            editor.setUpdatesAvailable(this.updatesAvailable);
            editor.getSketch().setUntitled(untitled);
            this.editors.add(editor);
            Recent.append(editor);
            editor.setVisible(true);
            return editor;
        }
        catch (EditorException ee) {
            try {
                block9: {
                    if (ee.getMessage() != null) {
                        Messages.showWarning("Error opening sketch", ee.getMessage(), ee);
                    }
                    break block9;
                    catch (NoSuchMethodError me) {
                        Messages.showWarning("Mode out of date", this.nextMode.getTitle() + " is not compatible with this version of Processing.\nTry updating the Mode or contact its author for a new version.", me);
                        break block9;
                    }
                    catch (Throwable t) {
                        if (this.nextMode.equals(this.getDefaultMode())) {
                            Messages.showTrace("Serious Problem", "An unexpected, unknown, and unrecoverable error occurred\nwhile opening a new editor window. Please report this.", t, true);
                            break block9;
                        }
                        Messages.showTrace("Mode Problems", "A nasty error occurred while trying to use \u201c" + this.nextMode.getTitle() + "\u201d.\nIt may not be compatible with this version of Processing.\nTry updating the Mode or contact its author for a new version.", t, false);
                    }
                }
                if (!this.editors.isEmpty()) return null;
                Mode defaultMode = this.getDefaultMode();
                if (this.nextMode == defaultMode) {
                    Messages.showError("Editor Problems", "An error occurred while trying to change modes.\nWe'll have to quit for now because it's an\nunfortunate bit of indigestion with the default Mode.\n", null);
                    return null;
                }
                if (!untitled) return null;
                this.nextMode = defaultMode;
                this.handleNew();
                return null;
            }
            catch (Throwable t) {
                Messages.showTrace("Terrible News", "A serious error occurred while trying to create a new editor window.", t, this.nextMode == this.getDefaultMode());
                this.nextMode = this.getDefaultMode();
            }
        }
        return null;
    }

    public boolean handleClose(Editor editor, boolean preventQuit) {
        if (!editor.checkModified()) {
            return false;
        }
        editor.internalCloseRunner();
        if (this.editors.size() == 1) {
            if (Platform.isMacOS() && this.defaultFileMenu == null) {
                Object[] options = new Object[]{Language.text("prompt.ok"), Language.text("prompt.cancel")};
                int result = JOptionPane.showOptionDialog(editor, Toolkit.formatMessage("Are you sure you want to Quit?", "Closing the last open sketch will quit Processing."), "Quit", 0, 3, null, options, options[0]);
                if (result == 1 || result == -1) {
                    return false;
                }
            }
            if (this.defaultFileMenu == null) {
                if (preventQuit) {
                    editor.setVisible(false);
                    editor.dispose();
                    this.activeEditor = null;
                    this.editors.remove(editor);
                } else {
                    System.exit(0);
                }
            } else {
                editor.setVisible(false);
                editor.dispose();
                this.defaultFileMenu.insert(Recent.getMenu(), 2);
                this.activeEditor = null;
                this.editors.remove(editor);
            }
        } else {
            editor.setVisible(false);
            editor.dispose();
            this.editors.remove(editor);
        }
        return true;
    }

    public boolean handleQuit() {
        if (this.handleQuitEach()) {
            for (Editor editor : this.editors) {
                editor.internalCloseRunner();
            }
            Preferences.save();
            Console.shutdown();
            if (!Platform.isMacOS()) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    protected boolean handleQuitEach() {
        for (Editor editor : this.editors) {
            if (editor.checkModified()) continue;
            return false;
        }
        return true;
    }

    public void handleRestart() {
        File app = Platform.getProcessingApp();
        System.out.println(app);
        if (app.exists()) {
            if (this.handleQuitEach()) {
                SingleInstance.clearRunning();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        System.out.println("launching");
                        Process p = Platform.isMacOS() ? Runtime.getRuntime().exec(new String[]{"open", "-n", "-a", app.getAbsolutePath()}) : (Platform.isLinux() ? Runtime.getRuntime().exec(new String[]{app.getAbsolutePath()}) : Runtime.getRuntime().exec(new String[]{"cmd", "/c", app.getAbsolutePath()}));
                        System.out.println("launched with result " + p.waitFor());
                        System.out.flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }));
                this.handleQuit();
                if (Platform.isMacOS()) {
                    System.exit(0);
                }
            }
        } else {
            Messages.showWarning("Cannot Restart", "Cannot automatically restart because the Processing\napplication has been renamed. Please quit and then restart manually.");
        }
    }

    public void thinkDifferentExamples() {
        this.nextMode.showExamplesFrame();
    }

    public DefaultMutableTreeNode buildSketchbookTree() {
        DefaultMutableTreeNode sbNode = new DefaultMutableTreeNode(Language.text("sketchbook.tree"));
        try {
            this.addSketches(sbNode, Base.getSketchbookFolder(), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sbNode;
    }

    public void rebuildSketchbookFrame() {
        if (this.sketchbookFrame != null) {
            this.sketchbookFrame.rebuild();
        }
    }

    public void showSketchbookFrame() {
        if (this.sketchbookFrame == null) {
            this.sketchbookFrame = new SketchbookFrame(this);
        }
        this.sketchbookFrame.setVisible();
    }

    public void rebuildSketchbook() {
        for (Mode mode : this.getModeList()) {
            mode.rebuildImportMenu();
            mode.rebuildToolbarMenu();
            mode.rebuildExamplesFrame();
        }
        this.rebuildSketchbookFrame();
    }

    public void populateSketchbookMenu(JMenu menu) {
        new Thread(() -> {
            boolean found = false;
            try {
                found = this.addSketches(menu, sketchbookFolder);
            }
            catch (Exception e) {
                Messages.showWarning("Sketchbook Menu Error", "An error occurred while trying to list the sketchbook.", e);
            }
            if (!found) {
                JMenuItem empty = new JMenuItem(Language.text("menu.file.sketchbook.empty"));
                empty.setEnabled(false);
                menu.add(empty);
            }
        }).start();
    }

    protected boolean addSketches(JMenu menu, File folder) {
        String[] list;
        Messages.log("scanning " + folder.getAbsolutePath());
        if (!folder.isDirectory()) {
            return false;
        }
        if (folder.getName().equals("android")) {
            return false;
        }
        if (folder.getName().equals("libraries")) {
            return false;
        }
        if (folder.getName().equals("sdk")) {
            File suspectSDKPath = new File(folder.getParent(), folder.getName());
            File expectedSDKPath = new File(sketchbookFolder, "android" + File.separator + "sdk");
            if (expectedSDKPath.getAbsolutePath().equals(suspectSDKPath.getAbsolutePath())) {
                return false;
            }
        }
        if ((list = folder.list()) == null) {
            return false;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        ActionListener listener = e -> {
            String path = e.getActionCommand();
            if (new File(path).exists()) {
                this.handleOpen(path);
            } else {
                Messages.showWarning("Sketch Disappeared", "The selected sketch no longer exists.\nYou may need to restart Processing to update\nthe sketchbook menu.", null);
            }
        };
        boolean found = false;
        for (String name : list) {
            JMenu submenu;
            boolean anything;
            if (name.charAt(0) == '.' || name.equals("old")) continue;
            File entry = new File(folder, name);
            File sketchFile = null;
            if (entry.isDirectory()) {
                sketchFile = Sketch.findMain(entry, this.getModeList());
            } else if (name.toLowerCase().endsWith(SKETCH_BUNDLE_EXT)) {
                name = name.substring(0, name.length() - SKETCH_BUNDLE_EXT.length());
                sketchFile = entry;
            }
            if (sketchFile != null) {
                JMenuItem item = new JMenuItem(name);
                item.addActionListener(listener);
                item.setActionCommand(sketchFile.getAbsolutePath());
                menu.add(item);
                found = true;
                continue;
            }
            if (!entry.isDirectory() || !(anything = this.addSketches(submenu = new JMenu(name), entry))) continue;
            menu.add(submenu);
            found = true;
        }
        return found;
    }

    public boolean addSketches(DefaultMutableTreeNode node, File folder, boolean examples) throws IOException {
        Messages.log("scanning " + folder.getAbsolutePath());
        if (!folder.isDirectory()) {
            return false;
        }
        String folderName = folder.getName();
        if (folderName.equals("android")) {
            return false;
        }
        if (folderName.equals("libraries")) {
            return false;
        }
        if (!examples && folderName.equals("examples")) {
            return false;
        }
        String[] fileList = folder.list();
        if (fileList == null) {
            return false;
        }
        Arrays.sort(fileList, String.CASE_INSENSITIVE_ORDER);
        boolean found = false;
        for (String name : fileList) {
            DefaultMutableTreeNode subNode;
            boolean anything;
            if (name.charAt(0) == '.') continue;
            File entry = new File(folder, name);
            File sketchFile = null;
            if (entry.isDirectory()) {
                sketchFile = Sketch.findMain(entry, this.getModeList());
            } else if (name.toLowerCase().endsWith(SKETCH_BUNDLE_EXT)) {
                name = name.substring(0, name.length() - SKETCH_BUNDLE_EXT.length());
                sketchFile = entry;
            }
            if (sketchFile != null) {
                DefaultMutableTreeNode item = new DefaultMutableTreeNode(new SketchReference(name, sketchFile));
                node.add(item);
                found = true;
                continue;
            }
            if (!entry.isDirectory() || !(anything = this.addSketches(subNode = new DefaultMutableTreeNode(name), entry, examples))) continue;
            node.add(subNode);
            found = true;
        }
        return found;
    }

    public void handlePrefs() {
        if (this.preferencesFrame == null) {
            this.preferencesFrame = new PreferencesFrame(this);
        }
        this.preferencesFrame.showFrame();
    }

    public static File getLibFile(String filename) throws IOException {
        return new File(Platform.getContentFile("lib"), filename);
    }

    public static InputStream getLibStream(String filename) throws IOException {
        return new FileInputStream(Base.getLibFile(filename));
    }

    public static File getSettingsFolder() {
        File settingsFolder = null;
        try {
            settingsFolder = Platform.getSettingsFolder();
            if (!settingsFolder.exists() && !settingsFolder.mkdirs()) {
                Messages.showError("Settings issues", "Processing cannot run because it could not\ncreate a folder to store your settings at\n" + String.valueOf(settingsFolder), null);
            }
        }
        catch (Exception e) {
            Messages.showTrace("An rare and unknowable thing happened", "Could not get the settings folder. Please report:\nhttp://github.com/processing/processing/issues/new", e, true);
        }
        return settingsFolder;
    }

    public static File getSettingsOverride() {
        return settingsOverride;
    }

    public static File getSettingsFile(String filename) {
        return new File(Base.getSettingsFolder(), filename);
    }

    public static File getToolsFolder() {
        return Platform.getContentFile("tools");
    }

    public static void locateSketchbookFolder() {
        String sketchbookPath = Preferences.getSketchbookPath();
        if (sketchbookPath != null && !(sketchbookFolder = new File(sketchbookPath)).exists()) {
            Messages.showWarning("Sketchbook folder disappeared", "The sketchbook folder no longer exists.\nProcessing will switch to the default sketchbook\nlocation, and create a new sketchbook folder if\nnecessary. Processing will then stop talking\nabout itself in the third person.", null);
            sketchbookFolder = null;
        }
        if (sketchbookFolder == null) {
            sketchbookFolder = Base.getDefaultSketchbookFolder();
            Preferences.setSketchbookPath(sketchbookFolder.getAbsolutePath());
            if (!sketchbookFolder.exists() && !sketchbookFolder.mkdirs()) {
                Messages.showError("Could not create sketchbook", "Unable to create a sketchbook folder at\n" + String.valueOf(sketchbookFolder) + "\nTry creating a folder at that path and restart Processing.", null);
            }
        }
        Base.makeSketchbookSubfolders();
    }

    public void setSketchbookFolder(File folder) {
        sketchbookFolder = folder;
        Preferences.setSketchbookPath(folder.getAbsolutePath());
        this.rebuildSketchbook();
        Base.makeSketchbookSubfolders();
    }

    protected static void makeSketchbookSubfolders() {
        Base.getSketchbookLibrariesFolder().mkdirs();
        Base.getSketchbookToolsFolder().mkdirs();
        Base.getSketchbookModesFolder().mkdirs();
        Base.getSketchbookExamplesFolder().mkdirs();
        Base.getSketchbookTemplatesFolder().mkdirs();
    }

    public static File getSketchbookFolder() {
        return sketchbookFolder;
    }

    public static File getSketchbookLibrariesFolder() {
        return new File(sketchbookFolder, "libraries");
    }

    public static File getSketchbookToolsFolder() {
        return new File(sketchbookFolder, "tools");
    }

    public static File getSketchbookModesFolder() {
        return new File(sketchbookFolder, "modes");
    }

    public static File getSketchbookExamplesFolder() {
        return new File(sketchbookFolder, "examples");
    }

    public static File getSketchbookTemplatesFolder() {
        return new File(sketchbookFolder, "templates");
    }

    protected static File getDefaultSketchbookFolder() {
        File sketchbookFolder = null;
        try {
            sketchbookFolder = Platform.getDefaultSketchbookFolder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sketchbookFolder == null) {
            Messages.showError("No sketchbook", "Problem while trying to get the sketchbook", null);
        } else {
            boolean result = true;
            if (!sketchbookFolder.exists()) {
                result = sketchbookFolder.mkdirs();
            }
            if (!result) {
                Messages.showError("You forgot your sketchbook", "Processing cannot run because it could not\ncreate a folder to store your sketchbook.", null);
            }
        }
        return sketchbookFolder;
    }

    private static /* synthetic */ boolean lambda$cleanTempFolders$2(long now, long diff, File file) {
        return now - file.lastModified() > diff;
    }
}

