/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0080\u0001\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002Jv\u0010+\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010)\u001a\u00020*2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u001a2\b\u0010,\u001a\u0004\u0018\u00010\u00132\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J&\u0010-\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJd\u0010.\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u001a2\b\b\u0002\u0010/\u001a\u00020\u000f2\b\b\u0002\u00100\u001a\u00020\u000f2\b\b\u0002\u0010\u001e\u001a\u00020\u000f2\b\b\u0002\u0010\u001f\u001a\u00020\u000f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0018\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0018\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;)V", "bufferedImage", "Ljava/awt/image/BufferedImage;", "bufferedImageGraphics", "Ljava/awt/Graphics2D;", "volatileImage", "Ljava/awt/image/VolatileImage;", "createImageFromBytes", "bytes", "", "width", "", "height", "dirtyRectangles", "", "Ljava/awt/Rectangle;", "createVolatileImage", "image", "doDraw", "", "op", "Ljava/awt/image/BufferedImageOp;", "Ljava/awt/Image;", "invG", "hasDestinationSize", "", "dw", "dh", "sourceBounds", "userWidth", "userHeight", "g", "Ljava/awt/Graphics;", "dx", "dy", "observer", "Ljava/awt/image/ImageObserver;", "scale", "", "doDrawHiDpi", "srcBounds", "draw", "drawImage", "x", "y", "drawVolatileImage", "vi", "scaleSize", "size", "skiko"})
@SourceDebugExtension(value={"SMAP\nSwingOffscreenDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingOffscreenDrawer.kt\norg/jetbrains/skiko/swing/SwingOffscreenDrawer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n1#2:289\n*E\n"})
public final class SwingOffscreenDrawer {
    @NotNull
    private final SwingLayerProperties swingLayerProperties;
    @Nullable
    private volatile VolatileImage volatileImage;
    @Nullable
    private BufferedImage bufferedImage;
    @Nullable
    private Graphics2D bufferedImageGraphics;

    public SwingOffscreenDrawer(@NotNull SwingLayerProperties swingLayerProperties2) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        this.swingLayerProperties = swingLayerProperties2;
    }

    public final void draw(@NotNull Graphics2D g, @NotNull byte[] bytes, int width2, int height2) {
        VolatileImage volatileImage;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        List dirtyRectangles = CollectionsKt.listOf((Object)new Rectangle(0, 0, width2, height2));
        BufferedImage image = this.createImageFromBytes(bytes, width2, height2, dirtyRectangles);
        VolatileImage vi = this.volatileImage;
        do {
            if (vi == null || vi.getWidth() != this.swingLayerProperties.getWidth() || vi.getHeight() != this.swingLayerProperties.getHeight()) {
                vi = this.createVolatileImage(image);
            }
            this.drawVolatileImage(vi, image);
            switch (vi.validate(this.swingLayerProperties.getGraphicsConfiguration())) {
                case 1: {
                    this.drawVolatileImage(vi, image);
                    break;
                }
                case 2: {
                    vi = this.createVolatileImage(image);
                }
            }
            g.drawImage(vi, 0, 0, null);
            volatileImage = vi;
            Intrinsics.checkNotNull((Object)volatileImage);
        } while (volatileImage.contentsLost());
        this.volatileImage = vi;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final BufferedImage createImageFromBytes(byte[] bytes, int width, int height, List<? extends Rectangle> dirtyRectangles) {
        src = ByteBuffer.wrap(bytes);
        if (this.bufferedImage == null) ** GOTO lbl-1000
        v0 = this.bufferedImage;
        v1 = v0 != null ? v0.getWidth() == width : false;
        if (!v1) ** GOTO lbl-1000
        v2 = this.bufferedImage;
        if (!(v2 != null ? v2.getHeight() == height : false)) lbl-1000:
        // 3 sources

        {
            v3 = this.bufferedImage;
            if (v3 != null) {
                v3.flush();
            }
            v4 = this.bufferedImage = new BufferedImage(width, height, 3);
            this.bufferedImageGraphics = v4 != null ? v4.createGraphics() : null;
        } else {
            v5 = this.bufferedImageGraphics;
            if (v5 != null) {
                v5.clearRect(0, 0, width, height);
            }
        }
        v6 = this.bufferedImage;
        Intrinsics.checkNotNull((Object)v6);
        image = v6;
        v7 = image.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
        dstData = ((DataBufferInt)v7).getData();
        v8 = src.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"asIntBuffer(...)");
        srcData = v8;
        for (Rectangle rect : dirtyRectangles) {
            if (rect.width < image.getWidth()) {
                var12_12 = rect.y + rect.height;
                for (line = rect.y; line < var12_12; ++line) {
                    offset = line * image.getWidth() + rect.x;
                    srcData.position(offset).get(dstData, offset, (int)Math.min((double)rect.width, (double)(src.capacity() - offset)));
                }
                continue;
            }
            offset = rect.y * image.getWidth();
            srcData.position(offset).get(dstData, offset, (int)Math.min((double)(rect.height * image.getWidth()), (double)(src.capacity() - offset)));
        }
        return image;
    }

    private final VolatileImage createVolatileImage(BufferedImage image) {
        VolatileImage vi = this.swingLayerProperties.getGraphicsConfiguration().createCompatibleVolatileImage(this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight(), 3);
        Intrinsics.checkNotNull((Object)vi);
        this.drawVolatileImage(vi, image);
        return vi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drawVolatileImage(VolatileImage vi, BufferedImage image) {
        Graphics graphics = vi.getGraphics().create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g = (Graphics2D)graphics;
        try {
            g.setBackground(new Color(0, 0, 0, 0));
            g.setComposite(AlphaComposite.Src);
            g.clearRect(0, 0, this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight());
            Rectangle imageClipRectangle = new Rectangle(0, 0, this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight());
            SwingOffscreenDrawer.drawImage$default(this, g, image, 0, 0, 0, 0, imageClipRectangle, null, null, 444, null);
        }
        finally {
            g.dispose();
        }
    }

    private final void drawImage(Graphics g, Image image, int x2, int y2, int dw, int dh, Rectangle sourceBounds, BufferedImageOp op, ImageObserver observer) {
        boolean hasDestinationSize = dw >= 0 && dh >= 0;
        this.doDrawHiDpi(this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight(), g, SwingLayerPropertiesKt.getScale(this.swingLayerProperties), x2, y2, dw, dh, hasDestinationSize, op, image, sourceBounds, observer);
    }

    static /* synthetic */ void drawImage$default(SwingOffscreenDrawer swingOffscreenDrawer, Graphics graphics, Image image, int n, int n2, int n3, int n4, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n = 0;
        }
        if ((n5 & 8) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n3 = -1;
        }
        if ((n5 & 0x20) != 0) {
            n4 = -1;
        }
        if ((n5 & 0x40) != 0) {
            rectangle = null;
        }
        if ((n5 & 0x80) != 0) {
            bufferedImageOp = null;
        }
        if ((n5 & 0x100) != 0) {
            imageObserver = null;
        }
        swingOffscreenDrawer.drawImage(graphics, image, n, n2, n3, n4, rectangle, bufferedImageOp, imageObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doDrawHiDpi(int userWidth, int userHeight, Graphics g, double scale, int dx, int dy, int dw, int dh, boolean hasDestinationSize, BufferedImageOp op, Image image, Rectangle srcBounds, ImageObserver observer) {
        Graphics g1 = g;
        double scale1 = scale;
        int dx1 = dx;
        int dy1 = dy;
        double delta = 0.0;
        int maxSize = Math.max(userWidth, userHeight);
        if (maxSize < 0x3FFFFFFF) {
            int dotAccuracy = 1;
            double pow = 0.0;
            while (true) {
                void it;
                double d;
                double d2 = d = Math.pow(10.0, dotAccuracy);
                double d3 = maxSize;
                boolean bl = false;
                pow = it;
                Unit unit = Unit.INSTANCE;
                if (!(d3 > d)) break;
                ++dotAccuracy;
            }
            delta = 1.0 / pow;
        }
        Graphics graphics = g1;
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        AffineTransform tx = ((Graphics2D)graphics).getTransform();
        Graphics invG = null;
        if ((tx.getType() & 0x18) == 0 && Math.abs(scale1 - tx.getScaleX()) <= delta) {
            scale1 = tx.getScaleX();
            double gScaleX = tx.getScaleX();
            double gScaleY = tx.getScaleY();
            tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
            tx.translate((double)dx1 * gScaleX, (double)dy1 * gScaleY);
            dy1 = 0;
            dx1 = 0;
            Graphics graphics2 = g1.create();
            Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            g1 = invG = (Graphics2D)graphics2;
            ((Graphics2D)invG).setTransform(tx);
        }
        try {
            int dw2 = dw;
            int dh2 = dh;
            if (invG != null && hasDestinationSize) {
                dw2 = this.scaleSize(dw2, scale1);
                dh2 = this.scaleSize(dh2, scale1);
            }
            this.doDraw(op, image, (Graphics2D)invG, hasDestinationSize, dw2, dh2, srcBounds, userWidth, userHeight, g1, dx1, dy1, observer, scale1);
        }
        finally {
            Graphics graphics3 = invG;
            if (graphics3 != null) {
                graphics3.dispose();
            }
        }
    }

    private final int scaleSize(int size2, double scale) {
        return MathKt.roundToInt((double)((double)size2 * scale));
    }

    private final void doDraw(BufferedImageOp op, Image image, Graphics2D invG, boolean hasDestinationSize, int dw, int dh, Rectangle sourceBounds, int userWidth, int userHeight, Graphics g, int dx, int dy, ImageObserver observer, double scale) {
        Image image2 = image;
        if (op != null && image2 instanceof BufferedImage) {
            BufferedImage bufferedImage = op.filter((BufferedImage)image2, null);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"filter(...)");
            image2 = bufferedImage;
        }
        if (sourceBounds != null) {
            int sx = SwingOffscreenDrawer.doDraw$size(this, scale, sourceBounds.x);
            int sy = SwingOffscreenDrawer.doDraw$size(this, scale, sourceBounds.y);
            int sw = sourceBounds.width >= 0 ? SwingOffscreenDrawer.doDraw$size(this, scale, sourceBounds.width) : SwingOffscreenDrawer.doDraw$size(this, scale, userWidth) - sx;
            int sh = sourceBounds.height >= 0 ? SwingOffscreenDrawer.doDraw$size(this, scale, sourceBounds.height) : SwingOffscreenDrawer.doDraw$size(this, scale, userHeight) - sy;
            int dw2 = dw;
            int dh2 = dh;
            if (!hasDestinationSize) {
                dw2 = SwingOffscreenDrawer.doDraw$size(this, scale, userWidth);
                dh2 = SwingOffscreenDrawer.doDraw$size(this, scale, userHeight);
            }
            g.drawImage(image2, dx, dy, dx + dw2, dy + dh2, sx, sy, sx + sw, sy + sh, observer);
        } else if (hasDestinationSize) {
            g.drawImage(image2, dx, dy, dw, dh, observer);
        } else if (invG == null) {
            g.drawImage(image2, dx, dy, userWidth, userHeight, observer);
        } else {
            g.drawImage(image2, dx, dy, observer);
        }
    }

    private static final int doDraw$size(SwingOffscreenDrawer this$0, double $scale, int size2) {
        return this$0.scaleSize(size2, $scale);
    }
}

