/*
 * Decompiled with CFR 0.152.
 */
package processing.io;

import processing.core.PApplet;
import processing.io.GPIO;
import processing.io.NativeInterface;

public class SoftwareServo {
    public static final int DEFAULT_MIN_PULSE = 544;
    public static final int DEFAULT_MAX_PULSE = 2400;
    protected int pin = -1;
    protected long handle = -1L;
    protected int period = 20000;
    protected int minPulse = 0;
    protected int maxPulse = 0;
    protected int pulse = 0;

    public SoftwareServo(PApplet pApplet) {
        NativeInterface.loadLibrary();
    }

    public void close() {
        this.detach();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void attach(int n) {
        this.detach();
        this.pin = n;
        this.minPulse = 544;
        this.maxPulse = 2400;
    }

    public void attach(int n, int n2, int n3) {
        this.detach();
        this.pin = n;
        this.minPulse = n2;
        this.maxPulse = n3;
    }

    public void write(float f) {
        if (!this.attached()) {
            System.err.println("You need to call attach(pin) before write(angle).");
            throw new RuntimeException("Servo is not attached");
        }
        if (f < 0.0f || 180.0f < f) {
            System.err.println("Only degree values between 0 and 180 can be used.");
            throw new IllegalArgumentException("Illegal value");
        }
        this.pulse = (int)((double)this.minPulse + (double)f / 180.0 * (double)(this.maxPulse - this.minPulse));
        if (this.handle < 0L) {
            GPIO.pinMode(this.pin, 1);
            if (NativeInterface.isSimulated()) {
                return;
            }
            this.handle = NativeInterface.servoStartThread(this.pin, this.pulse, this.period);
            if (this.handle < 0L) {
                throw new RuntimeException(NativeInterface.getError((int)this.handle));
            }
        } else {
            int n = NativeInterface.servoUpdateThread(this.handle, this.pulse, this.period);
            if (n < 0) {
                throw new RuntimeException(NativeInterface.getError(n));
            }
        }
    }

    public boolean attached() {
        return this.pin != -1;
    }

    public void detach() {
        if (0L <= this.handle) {
            int n = NativeInterface.servoStopThread(this.handle);
            GPIO.pinMode(this.pin, 0);
            this.handle = -1L;
            this.pin = -1;
            if (n < 0) {
                throw new RuntimeException(NativeInterface.getError(n));
            }
        }
    }
}

