/*
 * Decompiled with CFR 0.152.
 */
package processing.io;

public class NativeInterface {
    protected static boolean loaded = false;
    protected static boolean alwaysSimulate = false;

    public static void loadLibrary() {
        if (!loaded) {
            if (NativeInterface.isSimulated()) {
                System.err.println("The Processing I/O library is not supported on this platform. Instead of values from actual hardware ports, your sketch will only receive stand-in values that allow you to test the remainder of its functionality.");
            } else {
                System.loadLibrary("processing-io");
            }
            loaded = true;
        }
    }

    public static void alwaysSimulate() {
        alwaysSimulate = true;
    }

    public static boolean isSimulated() {
        return alwaysSimulate || !"Linux".equals(System.getProperty("os.name"));
    }

    public static native int openDevice(String var0);

    public static native String getError(int var0);

    public static native int closeDevice(int var0);

    public static native int readFile(String var0, byte[] var1);

    public static native int writeFile(String var0, byte[] var1);

    public static int writeFile(String string, String string2) {
        return NativeInterface.writeFile(string, string2.getBytes());
    }

    public static native int raspbianGpioMemRead(int var0);

    public static native int raspbianGpioMemWrite(int var0, int var1, int var2);

    public static native int raspbianGpioMemSetPinBias(int var0, int var1);

    public static native int pollDevice(String var0, int var1);

    public static native int transferI2c(int var0, int var1, byte[] var2, byte[] var3);

    public static native long servoStartThread(int var0, int var1, int var2);

    public static native int servoUpdateThread(long var0, int var2, int var3);

    public static native int servoStopThread(long var0);

    public static native int setSpiSettings(int var0, int var1, int var2, int var3);

    public static native int transferSpi(int var0, byte[] var1, byte[] var2);
}

