/*
 * Decompiled with CFR 0.152.
 */
package processing.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import processing.io.NativeInterface;

public class LED {
    protected String dev;
    protected int maxBrightness;
    protected int prevBrightness;
    protected String prevTrigger;

    public LED(String string) {
        String string2;
        Object object;
        NativeInterface.loadLibrary();
        this.dev = string;
        if (NativeInterface.isSimulated()) {
            return;
        }
        try {
            object = Paths.get("/sys/class/leds/" + string + "/max_brightness", new String[0]);
            string2 = new String(Files.readAllBytes((Path)object));
            this.maxBrightness = Integer.parseInt(string2.trim());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            throw new RuntimeException("Unable to read maximum brightness");
        }
        try {
            object = Paths.get("/sys/class/leds/" + string + "/trigger", new String[0]);
            string2 = new String(Files.readAllBytes((Path)object));
            int n = string2.indexOf(91);
            int n2 = string2.indexOf(93, n);
            if (n != -1 && n2 != -1) {
                this.prevTrigger = string2.substring(n + 1, n2);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            throw new RuntimeException("Unable to read trigger setting");
        }
        try {
            object = Paths.get("/sys/class/leds/" + string + "/brightness", new String[0]);
            string2 = new String(Files.readAllBytes((Path)object));
            this.prevBrightness = Integer.parseInt(string2.trim());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            throw new RuntimeException("Unable to read current brightness");
        }
        object = "/sys/class/leds/" + string + "/trigger";
        int n = NativeInterface.writeFile((String)object, "none");
        if (n < 0) {
            if (n == -13) {
                System.err.println("You might need to install a custom udev rule to allow regular users to modify /sys/class/leds/*.");
            }
            throw new RuntimeException(NativeInterface.getError(n));
        }
    }

    public void brightness(float f) {
        if ((double)f < 0.0 || 1.0 < (double)f) {
            System.err.println("Brightness must be between 0.0 and 1.0.");
            throw new IllegalArgumentException("Illegal argument");
        }
        if (NativeInterface.isSimulated()) {
            return;
        }
        String string = "/sys/class/leds/" + this.dev + "/brightness";
        int n = NativeInterface.writeFile(string, Integer.toString((int)(f * (float)this.maxBrightness)));
        if (n < 0) {
            throw new RuntimeException(string + ": " + NativeInterface.getError(n));
        }
    }

    public void close() {
        if (NativeInterface.isSimulated()) {
            return;
        }
        String string = "/sys/class/leds/" + this.dev + "/brightness";
        int n = NativeInterface.writeFile(string, Integer.toString(this.prevBrightness));
        if (n < 0) {
            throw new RuntimeException(string + ": " + NativeInterface.getError(n));
        }
        string = "/sys/class/leds/" + this.dev + "/trigger";
        n = NativeInterface.writeFile(string, this.prevTrigger);
        if (n < 0) {
            throw new RuntimeException(string + ": " + NativeInterface.getError(n));
        }
    }

    public static String[] list() {
        if (NativeInterface.isSimulated()) {
            return new String[]{"led0", "led1"};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File("/sys/class/leds");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                arrayList.add(file2.getName());
            }
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }
}

